/*
 *  circbuf.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  circbuf.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#ifndef CIRCBUF_DOT_H
#define CIRCBUF_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProArith/hrdarth.h"
#include "ObjProGen/newaloc.h"

#include "ObjProUsr/buffer.h"
#include "ObjProGui/bufstate.h"

class CircBuf: public Buffer {
	int32 Size ;
	int32 CurrentRead ;     // Index of next word to read
				// for reader that is furthest back.
	int32 CurrentWrite ;	// Index of next word to write
				// for writer.
	int  NoReaders ;	// Number of readers.
	int32 * CurrentReads ;	// Array of pointers for all readers.
	BufferState * TheReaderState ;
	MachWord * Base;	// Base address of buffer
	MachWord * End ;	// Physical end of buffer
	void ReadIndexCheck(int, char *) ;
	void ResetStateAfterWrite() ;
	void ResetStateAfterRead(int Channel) ;
	int IsFull(int ReadChannel)
		{return TheReaderState[ReadChannel]==BufferStateFull;}
	int GetReadIndexOfFullestBuffer() ;
public:
	CircBuf(int32 Sz, int NumReaders);
	virtual ~CircBuf();
 	CxMachWord ReadCxWord(int Channel);
 	void WriteCxWord(CxMachWord value) ;
		// read and write a complex word

	void WriteWord (MachWord ) ;
	void WriteBinary (BinMachWord ) ;
	MachWord ReadWord ( int RdIx );
	BinMachWord ReadBinary ( int RdIx );
		// read or write a word

	int32 GetSpace() ;		// give space available for write
	int32 GetAvailableData(int) ;	// give space available for read

	int32 GetContiguousSpace() ;	// give space for continuous write
	int32 GetContiguousAvailableData(int) ;// give space for continuous read

	void CheckValidRead(int ReadIndex) ;
	void CheckValidWrite() ;

	void UpdateRead(int32 Size, int chan);
					// Add Size words to read pointer
	void UpdateWrite(int32 Size);	// Add Size words to write pointer

	const MachWord * GetReadPtr(int chan) ;

	MachWord * GetWritePtr()	      { return Base + CurrentWrite ; }

	MachWord * GetBase() {return Base;}
	MachWord * GetEnd() {return End;}
			// Get top and bottom of buffer
	int GetNoReaders() {return NoReaders ;}
	ErrCode Reset() ;
};
	
#endif
