/*
 *  pack.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  pack.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */

#ifndef PACK_DOT_H
#define PACK_DOT_H

#include "ObjProShare/shared.h"

typedef const char (*StringMap)(int); 

struct PackDesc {
	int NumBytes ; // 0 for strings
	int NumItems ; // -1 for scalars
	StringMap Map ;
	PackDesc(int bytes, int items) {NumBytes = bytes; NumItems = items;
		Map =0;}
};


class PackAndSend {
	char * Buf ;
	int NextByte ;
	PacketHeader Head ;
	void AddBytes(char * Pt, int N);
	void SendPacket();
public:
	PackAndSend(PacketHeader& head)
		{Buf = new char [MaxPacketSize]; NextByte=0; Head = head;}
	void AddItem(PackDesc& Desc, const void * Item);
	void PackageComplete() {SendPacket();}
};


#endif /* #ifdef PACK_DOT_H */
