/*
 *  netdesc.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "ObjProDSP/portable.h"
#include "ObjProGen/elinlist.h"

class Int_LinearList ;

class DfNode ;
class ProcessNet;
union GenericArrayElementObject {
	enum {not_set= -1, end_of_values = -2};
	const char * string ;
	int32 val ;
	const char ** list ;
	int * int_list ;
	GenericArrayElementObject(const char *s):string(s){}
	GenericArrayElementObject(int32 v):val(v){}
	GenericArrayElementObject(const char **l):list(l){}
	GenericArrayElementObject(int *l):int_list(l){}
	GenericArrayElementObject(String_LinearList&);
	GenericArrayElementObject(Int_LinearList&);
};

struct GenericArrayElement {
	enum ElementType {string,integer,list,int_list,list_terminator,
		int_list_terminator,terminator,window_size} the_type;
	union GenericArrayElementObject object ;
	GenericArrayElement(const char * str);
	GenericArrayElement(int32 v);
	GenericArrayElement(const char ** l);
	GenericArrayElement(int * l);
	GenericArrayElement(String_LinearList& l):the_type(list),object(l){}
	GenericArrayElement(Int_LinearList& l):the_type(list),object(l){}
	GenericArrayElement(ElementType type, const char *);
	GenericArrayElement();
	int object_size() const ; // returns -1 for list
	int is_terminator() const {return the_type == terminator;}
	ElementType type() const {return the_type;}
	const char * ptr_object() const ;
	const char ** get_list() const ;
	int * get_int_list() const ;
};

declareLinearList(GenericArrayElement)

#define NetNodeDescriptionMembers \
	const_char(class_name) \
	const_char(element_name) \
	int_value(input_channels) \
	int_value(output_channels)  \
	const_char_list(driver_names) \
	int_value(unlinked_flag)

#define const_char(obj) const char * obj ;
#define const_char_list(obj) const char ** obj ;
#define int_list(obj) int * obj ;
#define int_value(obj) int32 obj ;

struct NetNodeDescription {
	NetNodeDescriptionMembers 
	NetNodeDescription(GenericArrayElement *);
	NetNodeDescription(GenericArrayElement_LinearList *);
	NetNodeDescription(DfNode& node);
	NetNodeDescription(const char * class_name, const char * node_name,
		int inputs, int outputs);
	virtual ~NetNodeDescription();
	GenericArrayElement * get_array() const ;
	// const char * class_name ;
	// const char * element_name ;
	// int input_channels ;
	// int output_channels ;
	// const char ** driver_names ;
};

#define NetBufferDescriptionMembers \
	int_value(driver_channel) \
	const_char(driver_name) \
	int_value(number_outputs) \
	const_char_list(destination_names) \
	int_list(destination_input_channels)

struct NetBufferDescription {
	NetBufferDescriptionMembers
	NetBufferDescription(GenericArrayElement_LinearList *);
	NetBufferDescription(GenericArrayElement *);
	NetBufferDescription(DfNode& node, int chan);
	NetBufferDescription(int drv_chan,const char * drv_nm);
	virtual ~NetBufferDescription();
	GenericArrayElement * get_array() const ;
	// int driver_channel ;
	// const char * driver_name ;
	// int number_outputs ;
	// const char ** destination_names ;
};

#define NetworkDescriptionMembers \
	const_char(name) \
	const_char(controller_name) 

struct NetworkDescription {
	NetworkDescriptionMembers
	NetworkDescription(GenericArrayElement_LinearList *);
	NetworkDescription(GenericArrayElement *);
	NetworkDescription(ProcessNet& net);
	NetworkDescription(const char * nm, const char * cntrl);
	virtual ~NetworkDescription();
	GenericArrayElement * get_array() const ;
	// const char * name ;
	// const char * controller_name ;
};

#include "ObjProComGui/net_nd_undef.h"

class CommunicateNetworkDescription {
protected:
	enum StructType {none,node,buffer,network,network_terminator} ;
	CommunicateNetworkDescription(){}
};
