/*
 *  outtok.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef OUTTOK_DOT_H
#define OUTTOK_DOT_H
/*  outtok.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include <stream.h>
#include <strstream.h>
#include <string.h>
#include "ObjProGen/specopt.h"

#include "ObjProGen/baseio.h"

class OutCon ;
class SpecialOptions ;
class OutTokens {
	ostream * out ;
	enum OutputType Out ;
	int LineOut ;
	const char * LineTerminator ;
	int LineWidth ;
	const char * Separator ;
	const char * Initator ;
	int LineCount ;
	int LinesInScreen ;
	int TokenBufSize ;
	char * TheToken ;
	char LastCharOut ;
	SpecialOptions * Options ;
public :
	enum ReturnOption {ReturnWait, ReturnQuitOption, ReturnIgnore,ReturnPage};
	int ReturnOr(int next = 0) ;
private:
	ReturnOption QuitOption ;
	void Init(OutputType typ, OutCon * o = 0) ;
	void CommonInit() ;
	void Check(ostream * o) ;
	void AllocateTheToken() ;
	int page_number ;
public :
	OutTokens (
		ostream * o,
		int init=0,
		const char *ter=" \\",
		const char *sep = " ",
		const char * inis = "   " ,
		int lw =80 ,
		int lh = 24,
		ReturnOption quit = ReturnWait,
		SpecialOptions * Spec = 0 );
	OutTokens (
		enum OutputType Type ,
		int init=0,
		const char *ter=" \\",
		const char *sep = " ",
		const char * inis = "   " ,
		int lw =80 ,
		int lh = 24,
		ReturnOption quit = ReturnWait,
		SpecialOptions * Spec = 0);
	OutTokens (
		OutCon * o ,
		enum OutputType Type ,
		int init=0,
		const char *ter=" \\",
		const char *sep = " ",
		const char * inis = "   " ,
		int lw =80 ,
		int lh = 24,
		ReturnOption quit = ReturnWait,
		SpecialOptions * Spec = 0);
	~OutTokens() ;
	void Flush();
	int NewLine() ;
	void InitiateLine() ;
	int TerminateLine() ;
	int FlushLine();			
	int NewPage() ;
	int NextOut (const char * o) ;
	int NextOut(int Val) ;
	int NextOut(double Val) ;
	int NextConcat(int Val) ;
	int NextConcat (const char * o) ; // no line break and no separtator
	int NextConcatCond(char C) ; // concatenate but do not repeat
	int NextWrite (const char *o); // no separator
	int NextFillOut(const char * o, int ConcatFlat=0) ;
					// allow line break at space or tab
	int NextFillOutConcat(const char * o) {return NextFillOut(o,1);}
	int NextQuoteOut(const char * o) ; // string surrounded with `'
	int NextDblQuoteOut(const char * o) ; // above with \"
	int NextTeXDblQuoteOut(const char * o) ; // above with \"
	int NextTeXOut(const char * o) ; // \tt TeX format
	int NextTeXttOut(const char * o) ; // \tt TeX format
	int NextTeXitOut(const char * o) ; // \it TeX format
	int NextTeXbfOut(const char * o) ; // \bf TeX format
	int NextTeXOut(const char * o, const char * TeXType) ;
	int TeXIndexEntry(const char *) ;
	void NextConcatToken(const char * o); // build a token in parts
	void NextConcatToken(int Val); // build a token in parts
	int NextConcatCondToken(char C) ; // concatentate if differnt from last
	int NextOutToken(const char * o=0);   // output built up token (NextOut)
	void SetCharactersInLine(int Char) {LineOut=Char;}
	ostream * GetStream() const {return out;}
	SpecialOptions * GetSpecialOptions() {return Options;}
	void SetSpecialOptions(SpecialOptions * Opt) {Options = Opt;}
} ;


#endif /* #ifdef OUTTOK_DOT_H */
