/*
 *  environ.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef ENVIRON_DOT_H
#define ENVIRON_DOT_H
struct EnvironVar {
	const char * Name ;
	const char * DefaultValue ;
	const char * Description ;
	const char * DefaultDescription ;
	const char ** Options ;
	int LocalFlag ;
};

class Environment{
protected:
	const EnvironVar * TheVariables ;
public:
	Environment(const EnvironVar * var):TheVariables(var){}
	void Set();
	void Display();
	static const char * expand_file_name(const char * name);
	// name exists in a bufer that is reused on the next call
	static const char * get(const char * name);
	static EnvironVar OPD_standard[] ;
};


#endif /* #ifdef ENVIRON_DOT_H */
