/*
 *  arthnm.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef ARTHNM_DOT_H
#define ARTHNM_DOT_H
#include "ObjProDSP/arthtyp.h"
#include <float.h>
#include "ObjProDSP/portable.h"

#ifndef TI_C30
const char * ArithType::target_sub_dir[MaxArithTypes+1] = {
	0,
	"tardbl",
	"tarint",
	"tarint32",
	"tarflt",
};

const char * ArithType::CppNames[] = {
	0,
	"double",
	"int16",
	"int32",
	"float",
	0
};


const double ArithType::Accuracy[ArithType::MaxArithTypes+1] =
{
	DBL_EPSILON, 1./(((long)1)<<15), .5/(((long)1)<<30),FLT_EPSILON
};

const char * ArithType::CapabilityNames[ArithType::MaxArithCapabilities+2] =
{
	"ArithTypeUndefined",
	"ArithDouble",
	"ArithInt16",
	"ArithInt32",
	"ArithFloat",
	"ArithCapabilityFixed", // thus it is one of the ArithTypes options
	"ArithCapabilityAnyInt",
	"ArithCapabilityAny",
	0
};

const char * ArithType::ClassSuffix[ArithType::MaxArithCapabilities+2] =
{
	"illegal",
	"db",
	"16",
	"32",
	"ft",
	"not used",
	"ai",
	"ay",
	0
};

const int ArithType::SizeInBytes[MaxArithTypes+1] = 
	{ 0, sizeof(double), sizeof(int16), sizeof(int32), sizeof(float) };

#endif

#endif /* #ifdef ARTHNM_DOT_H */
