/*
 *  impulse.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef IMPULSE_DOT_H
#define IMPULSE_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/sigbase.h"

class CxImp: public Signal {
	int32  CurrentIndex;
	int32  SampleWidth;
	int32  NextTransition;
	CxMachWord  PeakSignal;
	CxMachWord  NullSignal;
	CxMachWord  CurrentSignal;
	CxMachWord  ExchSignal;
	int32  CurrentPeriodLength;
	int32  ExchPeriodLength;
	int32  Period_1;
	double  Phase_2;
	double  Amplitude_3;
	double  Width_4;
	int32  Transition_5;
public:
	CxImp (const char * Name, int32 Period, double Phase, double Amplitude, 
		double Width, int32 Transition);
	virtual ~CxImp();
	int32 GetPeriod() const {return Period_1;}
	double GetPhase() const {return Phase_2;}
	double GetAmplitude() const {return Amplitude_3;}
	double GetWidth() const {return Width_4;}
	int32 GetTransition() const {return Transition_5;}
	virtual int CheckSafeDelete() ;
	int32 GetCurrentIndex() const { return CurrentIndex;}
	int32 GetSampleWidth() const { return SampleWidth;}
	int32 GetNextTransition() const { return NextTransition;}
	CxMachWord GetPeakSignal() const { return PeakSignal;}
	CxMachWord GetNullSignal() const { return NullSignal;}
	CxMachWord GetCurrentSignal() const { return CurrentSignal;}
	CxMachWord GetExchSignal() const { return ExchSignal;}
	int32 GetCurrentPeriodLength() const { return CurrentPeriodLength;}
	int32 GetExchPeriodLength() const { return ExchPeriodLength;}
	virtual ErrCode DoNode(int32);
	void Describe(OutTokens& Out, ListEntity Option);
	virtual int CppList(OutTokens& Out, CppListCmds Cmd);
	virtual double TimeFirst(DfNodeInLink *,DfNodeOutLink *);
};

extern CxImp * CxImpDef;


#endif /* #ifdef IMPULSE_DOT_H */
