/*
 *  fndtail.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef FNDTAIL_DOT_H
#define FNDTAIL_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/procstr.h"

class FindStartTail: public ProcessNodeStr {
#line 84 "../fndtail.usr"
 
	int TailFound ;
	int DataToSkip ;
#ifdef INTERACTIVE
    int InitAfterLinked();
#endif
#line 27 "/dist/opd_2/opd-0.2/src/include/ObjProDSPint/ObjProUsr/fndtail.h"
	int binary_read_flag ;
	virtual ErrCode EmitStaticInit(OutTokens& Out);
	virtual ErrCode EmitStaticCtorParameters(OutTokens& Out);
	double  LowerBound_1;
	double  UpperBound_2;
	int16  Flags_3;
	int32  Skip_4;
public:
	FindStartTail (const char * Name, double LowerBound, double UpperBound, 
		int16 Flags, int32 Skip);
	virtual ~FindStartTail();
	double GetLowerBound() const {return LowerBound_1;}
	double GetUpperBound() const {return UpperBound_2;}
	int16 GetFlags() const {return Flags_3;}
	int32 GetSkip() const {return Skip_4;}
	virtual int CheckSafeDelete() ;
	virtual ErrCode DoNode(int32);
	void Describe(OutTokens& Out, ListEntity Option);
	virtual int CppList(OutTokens& Out, CppListCmds Cmd);
};

extern FindStartTail * FindStartTailDef;


#endif /* #ifdef FNDTAIL_DOT_H */
