/*
 *  cos.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef COS_DOT_H
#define COS_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/sigbase.h"

class Cos: public Signal {
	int  CurrentIndex;
	double  Frequency_1;
	double  Phase_2;
	double  Amplitude_3;
public:
	Cos (const char * Name, double Frequency, double Phase, double Amplitude);
	virtual ~Cos();
	double GetFrequency() const {return Frequency_1;}
	double GetPhase() const {return Phase_2;}
	double GetAmplitude() const {return Amplitude_3;}
	virtual int CheckSafeDelete() ;
	int GetCurrentIndex() const { return CurrentIndex;}
	virtual ErrCode DoNode(int32);
	void Describe(OutTokens& Out, ListEntity Option);
	virtual int CppList(OutTokens& Out, CppListCmds Cmd);
	virtual double TimeFirst(DfNodeInLink *,DfNodeOutLink *);
	void SetFrequency(double  Frequency) { Frequency_1 = Frequency; parameter_changed(); }
	void SetPhase(double  Phase) { Phase_2 = Phase; parameter_changed(); }
	void SetAmplitude(double  Amplitude) { Amplitude_3 = Amplitude; parameter_changed(); }
};

extern Cos * CosDef;


#endif /* #ifdef COS_DOT_H */
