/*
 *  cbuf.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef CBUF_DOT_H
#define CBUF_DOT_H
#include "ObjProGui/circbuf.h"

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/buffer.h"

class CircBufDes: public BufferDescript {
#line 118 "../cbuf.usr"
 
	virtual BufferStatus * GetBufferStatus();
#line 24 "/dist/opd_2/opd-0.2/src/include/ObjProDSPint/ObjProUsr/cbuf.h"
	int32  Size_1;
	int32  TargetSize_2;
	int16  TargetSizeGoal_3;
	int16  TargetControlGoal_4;
	int32  MaxTargetSize_5;
	int32  MinTargetSize_6;
public:
	CircBufDes (const char * Name, int32 Size, int32 TargetSize, 
		int16 TargetSizeGoal, int16 TargetControlGoal, 
		int32 MaxTargetSize, int32 MinTargetSize);
	virtual ~CircBufDes();
	int32 GetSize() const {return Size_1;}
	int32 GetTargetSize() const {return TargetSize_2;}
	int16 GetTargetSizeGoal() const {return TargetSizeGoal_3;}
	int16 GetTargetControlGoal() const {return TargetControlGoal_4;}
	int32 GetMaxTargetSize() const {return MaxTargetSize_5;}
	int32 GetMinTargetSize() const {return MinTargetSize_6;}
	virtual int CheckSafeDelete() ;
	void Describe(OutTokens& Out, ListEntity Option);
	virtual int CppList(OutTokens& Out, CppListCmds Cmd);
	void SetTargetSize(int32  TargetSize) { TargetSize_2 = TargetSize; parameter_changed(); }
	void SetTargetSizeGoal(int16  TargetSizeGoal) { TargetSizeGoal_3 = TargetSizeGoal; parameter_changed(); }
	void SetTargetControlGoal(int16  TargetControlGoal) { TargetControlGoal_4 = TargetControlGoal; parameter_changed(); }
	void SetMaxTargetSize(int32  MaxTargetSize) { MaxTargetSize_5 = MaxTargetSize; parameter_changed(); }
	void SetMinTargetSize(int32  MinTargetSize) { MinTargetSize_6 = MinTargetSize; parameter_changed(); }
	void AssignToEdit ();
#line 121 "../cbuf.usr"
	CircBufDes(const char * Name, int32 Size);
#line 53 "/dist/opd_2/opd-0.2/src/include/ObjProDSPint/ObjProUsr/cbuf.h"
};

extern CircBufDes * CircBufDesDef;


#endif /* #ifdef CBUF_DOT_H */
