/*
 *  rlfirk.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  rlfirk.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include "ObjProGen/errcode.h"
#include "ObjProDSP/portable.h"
#include "ObjProArith/hrdarth.h"

typedef MachWord (*ReadWordRoutine)(void *) ;
typedef ErrCode (*WriteWordRoutine)(void *, MachWord Val) ;
class TargetNode ;

class RealFilter {
	int FilterLength ;
	int Resample ;
	int ZeroPad ;
	int CoeffLength ;
	int Odd ;
	MachWord * Coeff ;

	MachWord * DataBuf ;
	int32 DataBufSize ;

	int32 NextSampleToWrite ;
	int32 ValidData ;
	int32 ZeroPadIndex ;

	TargetNode * NetworkIntfc ;
public:
	RealFilter(int length, int resample, int zero_pad,
		MachWord * coeff, TargetNode * network_intfc) ;
	~RealFilter();
	void Reset();
	ErrCode ExecuteKernel(int k);
};

