/*
 *  blckwrt.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "hrdarth.h"
#include "tarnod.h"
#include "hrdarth.h"

class ReadWriteSingleChannel {
protected:
	TargetNode& TheNode ;
	int ComplexIn ;
	int ComplexOut ;


	const MachWord * ReadPtr ;
	const MachWord * ReadBase ;
	const MachWord * ReadEnd ;

	MachWord * WritePtr ;
	MachWord * WriteBase ;
	MachWord * WriteEnd ;
public:
	ReadWriteSingleChannel(TargetNode& node, int cx_in=0, int cx_out=0);
	void InitPtr() ;
	int32 GetCount(int32 MaxCount) ;
	int32 Update(int32 CountToExecute) ;

	const MachWord * GetReadPtr() const { return ReadPtr ;}
	MachWord * GetWritePtr() const { return WritePtr ;}

	void CheckRead() {if (ReadPtr > (ReadEnd-1)) ReadPtr = ReadBase;}
	void CheckWrite() {if (WritePtr > (WriteEnd-1)) WritePtr = WriteBase;} 

	MachWord NextRead() {return *ReadPtr++;}
	void NextWrite(MachWord& wrd) {*WritePtr++ = wrd ;}

	void ReadBlock(int32 TooMove, MachWord * InputBuffer) ;
	void WriteBlock(int32 TooMove, const MachWord * OutputBuffer) ;
	void WriteBinaryBlock(int32 TooMove, const BinMachWord * OutputBuffer) ;
	MachWord * GetInputBuffer();
	MachWord * GetOutputBuffer();
};


class ReadWriteBlock: public ReadWriteSingleChannel {

	const MachWord * ReadPtrB ;
	const MachWord * ReadBaseB ;
	const MachWord * ReadEndB ;

	MachWord * WritePtrB ;
	MachWord * WriteBaseB ;
	MachWord * WriteEndB ;

public:
	ReadWriteBlock(TargetNode& node, int cx_in=0, int cx_out=0);
	void InitPtr() ;
	void InitPtrBase() ;
	void CheckReadB() {if (ReadPtrB > (ReadEndB-1)) ReadPtrB = ReadBaseB;} 
	void CheckWriteB()
		{if (WritePtrB > (WriteEndB-1)) WritePtrB = WriteBaseB;} 
	void CheckReadBoth() {CheckRead(); CheckReadB();}
	void CheckWriteBoth() {CheckWrite(); CheckWriteB();}
	MachWord NextReadB() {return *ReadPtrB++;}
	void NextWriteB(MachWord& wrd) {*WritePtrB++ = wrd ;}

	const MachWord * GetReadPtrB() const { return ReadPtrB ;}

	MachWord * GetWritePtrB() const { return WritePtrB ;}

	int32 GetCount(int32 MaxCount) ;
	int32 Update(int32 CountToExecute) ;
};



	
