#!/bin/sh
#  distribution_create.sh from ObjectProDSP 0.2
#  Copyright (C) 1994 1995, Mountain Math Software. All rights reserved.
#  
#  This file is part of ObjectProDSP, a tool for Digital Signal
#  Processing design, development and implementation. It is free
#  software provided you use and distribute it under the terms of
#  version 2 of the GNU General Public License as published
#  by the Free Software Foundation. You may NOT distribute it or
#  works derived from it or code that it generates under ANY
#  OTHER terms.  In particular NONE of the ObjectProDSP system is
#  licensed for use under the GNU General Public LIBRARY License.
#  Mountain Math Software plans to offer a commercial version of
#  ObjectProDSP for a fee. That version will allow redistribution
#  of generated code under standard commercial terms.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#  GNU General Public License for more details.
#  
#  You should have received a copy of version 2 of the GNU General
#  Public License along with this program. See file COPYING. If not
#  or if you wish information on commercial versions and licensing
#  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
#  USA, or send us e-mail at: support@mtnmath.com.
#  
#  You may also obtain the GNU General Public License by writing the
#  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
#  USA.  However if you received a copy of this program without the
#  file COPYING or without a copyright notice attached to all text
#  files, libraries and executables please inform Mountain Math Software.
#  
#  ObjectProDSP is a trademark of Mountain Math Software.
#  
OPD_NEW_ROOT_BASE=dist
OPD_DIST=$OPD_ROOT/$OPD_NEW_ROOT_BASE
#COPY="cp -p"
COPY="$OPD_ROOT/bin/cp_update_legal -m -l $OPD_DIST/log"

DID_COMMON=
SOURCE=SOURCE
BINARY=BINARY
DOCUMENTATION=DOCUMENTATION
TEST_DATA=TEST_DATA
FULL=FULL

function abort() {
    echo "Distribution build aborted, error code $1."
    exit
}


function convert_dir() {
	OPD_DEST_NOW=$OPD_DEST/${1#$OPD_STRIP/} ;
}

function check_exist_literal_dirs() {
	for i in $* ; do
		if [ ! -d $i ] ;then mkdir $i ;fi
	done
}

function check_exist_dir() {
	OPD_BASE=${OPD_DEST_NOW#$OPD_STRIP}
	OPD_BASE=${OPD_BASE#/}
	DIR_SEQ="$NEW_ROOT_BASE $NEW_ROOT"
	TO_CHECK=$OPD_ROOT 
	while [ -n "$OPD_BASE" ] ;do
		OPD_BASE_SAVE=$OPD_BASE
		#echo save $OPD_BASE_SAVE ;
		OPD_LEV=${OPD_BASE%%/*/*}
		#echo opd_base test $OPD_LEV
		if [ "$OPD_LEV" = "$OPD_BASE_SAVE" ] ;then 
			OPD_LEV=${OPD_BASE%%/*}
			#echo opd_lev2 $OPD_LEV 
		fi
		OPD_BASE=${OPD_BASE#$OPD_LEV}
		OPD_BASE=${OPD_BASE#/}
		DIR_SEQ="$DIR_SEQ $OPD_LEV"
		TO_CHECK=$TO_CHECK/$OPD_LEV
		if [ ! -d $TO_CHECK ] ;then mkdir $TO_CHECK ;fi
		#echo opd_lev $OPD_LEV
		#echo opd_base $OPD_BASE
		#echo dir_seq $DIR_SEQ
	done
}

function copy_h() {
	local ii
	TO_MOVE="$1/*.h"
	for ii in $TO_MOVE ;do
		#echo copy_c_h_y_l checking $ii to $2
		if [ -e $ii ] ;then $COPY $ii $2 ; fi
	done
}

function copy_c_h_y_l() {
	local ii
	TO_MOVE="$1/*.cxx $1/*.h $1/*.l $1/*.y"
	for ii in $TO_MOVE ;do
		#echo copy_c_h_y_l checking $ii to $2
		if [ -e $ii ] ;then $COPY $ii $2 ; fi
	done
}

function copy_usr() {
	local ii
	TO_MOVE="$1*.usr"
	for ii in $TO_MOVE ;do
		if [ -e $ii ] ;then $COPY $ii $2 ; fi
	done
}

function check_create_dir_root() {
	OPD_SRC_DIR=$1
    convert_dir $OPD_SRC_DIR
    check_exist_dir $OPD_DEST_NOW
}

function check_create_dir() {
	OPD_SRC_DIR=$OPD_ROOT/$1
    convert_dir $OPD_SRC_DIR
    check_exist_dir $OPD_DEST_NOW
}

function copy_dir() {
	check_create_dir $1
	$COPY $OPD_SRC_DIR/* $OPD_DEST_NOW
}



function copy_all_usr() {
	local i
	local j
	for i in $OPD_USR $OPD_USR_16 $OPD_USR_32 ;do
		#echo $i
		check_create_dir_root $i/
		copy_usr $OPD_SRC_DIR $OPD_DEST_NOW
		copy_c_h_y_l $OPD_SRC_DIR $OPD_DEST_NOW
		for j in $OPD_USR_SUB_DIR ;do
			check_create_dir_root $i/$j/ 
			copy_c_h_y_l $OPD_SRC_DIR $OPD_DEST_NOW
			#echo "copy_c_h_y_l $OPD_SRC_DIR $OPD_DEST_NOW"
		done
	done
}

function copy_h_files_root()
{
	check_create_dir_root $1
	copy_h $OPD_SRC_DIR $OPD_DEST_NOW
}

function copy_c_h_y_l_files_root()
{
	check_create_dir_root $1
	copy_c_h_y_l $OPD_SRC_DIR $OPD_DEST_NOW
	#echo "copy_c_h_y_l_files_root $OPD_SRC_DIR $OPD_DEST_NOW"
}

function copy_exe_c_h() {
	local i
	. $OPD_ROOT/scripts/set_gui
	. $OPD_ROOT/scripts/set_dsp
	. $OPD_ROOT/scripts/set_com

OPD_DSP_ARITH="$OPD_ROOT/src/dsp/arith/int16mod \
	$OPD_ROOT/src/dsp/arith/float \
	$OPD_ROOT/src/menus/dsp"	

	for i in $OPD_GUI_C_DIR $OPD_GUI_H_DIR $OPD_GUI_SPEC_DIR \
		$OPD_DSP_C_DIR $OPD_DSP_H_DIR $OPD_COM_C_DIR $OPD_COM_H_DIR \
		$OPD_DSP_ARITH ;do
		check_create_dir_root $i/
    	copy_c_h_y_l_files_root $i/ $OPD_DEST_NOW
	done
}

	
function copy_files_dest()
{
	local i 
	for i in $1 ;do
		if [ -e $i ] ;then 
			check_create_dir_root ${i%/*} ;
			$COPY $i $OPD_DEST_NOW
		fi
	done
}

function copy_files_root()
{
	local i 
	check_create_dir_root $1
	OPD_TEST="1" ;
	for i in $* ;do
		if [ -z "$OPD_TEST" ] ;then $COPY $OPD_SRC_DIR/$i $OPD_DEST_NOW ;fi
		OPD_TEST=
	done
}
	
function copy_files()
{
	local i
	check_create_dir $1
	OPD_TEST="1" ;
	for i in $* ;do
		if [ -z "$OPD_TEST" ] ;then $COPY $OPD_SRC_DIR/$i $OPD_DEST_NOW ;fi
		OPD_TEST=
	done
}

function clean_dir()
{
	if [ ! -d $OPD_DIST ] ;then mkdir $OPD_DIST ;fi
	if [ ! -d $OPD_DIST/$OPD_FTP_BASE ] ;then
		mkdir $OPD_DIST/$OPD_FTP_BASE ;fi
	if [ -e $OPD_DEST ] ;then
		echo "Warning \`$OPD_DEST' exists."
		echo "Will attempt to move it to \`$OPD_DIST/old_root'"

		if ! mv $OPD_DEST $OPD_DIST/old_root ;then 
			echo Distribution build aborted.
			exit ;fi 
	fi

	
}

function copy_Makefile_ () {
	#echo $1/Makefile_head* 
	#echo $1/Makefile_inc*
	#echo $1/Makefile_tail*
	copy_files_dest "$1/Makefile_head*"
	copy_files_dest "$1/Makefile_inc*"
	copy_files_dest "$1/Makefile_tail*"
}

function copy_all_doc() {
	#	For documentation we need to copy `.tex' files that are not
	#	created, .roff files, script files in roff directory, Makefiles.
	#	roff/mmake contains list .cxx .c and a makefile all of which must
	#	be copided. Tex direcotries use local makefile to list items
	#   to transfer.

	copy_files doc/roff/mmake Makefile Makefile.base ad_bp.cxx \
		flt.c mmake.cxx help_list node_list examp_list

	copy_files doc/roff copy.hlp

	copy_files_dest "$OPD_ROOT/doc/roff/*.roff"

	copy_files_dest "$OPD_ROOT/doc/trademark/*.tex \
		$OPD_ROOT/doc/trademark/README"

	copy_files_dest "$OPD_ROOT/doc/mac/*.tex"

	copy_files_dest "$OPD_ROOT/doc/mac/Makefile*"

	copy_files_dest "$OPD_ROOT/doc/scripts/*"

	copy_files_dest "$OPD_ROOT/doc/mac/makefile_*"

	copy_files doc/mac set_tex_env

	copy_files doc/build Makefile README

	copy_files doc/psfig dsp_case_ps

	OPD_MAN_DIR="overview userman devman"

	for i in $OPD_MAN_DIR ;do
		OPD_DIR=$OPD_ROOT/doc/$i
		cd $OPD_DIR; make DIST_LIST
		OPD_FILES=`cat DIST_LIST` 
		echo "OPD_FILES: $OPD_FILES" >> $OPD_DIST/log
		copy_files doc/$i $OPD_FILES
	done
	
	. $OPD_ROOT/doc/scripts/xwd_to_ps.sh SET_ENV
	copy_files doc/xwd/auto $OPD_XWD_AUTO
	copy_files doc/xwd/hand $OPD_XWD_HAND
}

function copy_makemake_librarys () {
	# makemake and the two librarys it uses have relative Makefiles
	# so they can be created before domakemake exists
	# we must copy these three Makefiles as well as the domakemakes
	OPD_DOMAKEMAKE_NEED="$OPD_ROOT/src/genlib/opdgen \
		$OPD_ROOT/src/genlib/common $OPD_ROOT/src/genlib/nogui"

	#additional directories where makemake (and other programs) gets objs
	OPD_MAKEMAKE_NEED="$OPD_ROOT/src/genlib/nogui \
		$OPD_ROOT/src/genlib/opdgen $OPD_ROOT/src/genlib/common"


	for i in $OPD_MAKEMAKE_NEED $OPD_DOMAKEMAKE_NEED ;do 
		copy_c_h_y_l_files_root $i/ ; done

	for i in $OPD_MAKEMAKE_NEED $OPD_MAKEMAKE_DIR ;do 
		copy_files_root $i/obj Makefile ;done

	for i in $OPD_DOMAKEMAKE_NEED ;do 
		copy_Makefile_ $i/obj
		copy_files_root $i/obj domakemake
	done
}




function all_common() {
	if [ -z "$DID_COMMON" ] ;then 
		# make sure OPD_ROOT is set
		. is_root_set.sh

		OPD_WHAT=ObjectProDSP  
		. $OPD_ROOT/scripts/set_version.sh
		echo "Creating $OPD_DIST_TYPE distribution for $OPD_WHAT version $VERSION."
		echo "Files are copied from \`$OPD_ROOT'"
		echo "Files are copied to \`$OPD_DIST'"
		if [ -z "$OPD_NO_PROMPT" ] ;then
			echo "Type RETURN to continue or ^C to abort:"
			read OPD_x
		fi
		OPD_FTP_BASE=ftp
		OPD_START_VALIDATE=$OPD_DIST/start_time
		if [ ! -e $OPD_DIST ] ;then mkdir $OPD_DIST ;fi
		if  ! touch $OPD_START_VALIDATE  ;then abort touch_start_time ;fi
		OPD_NEW_ROOT=opd-$VERSION


		# remove any old log file
		if [ -e $OPD_DIST/log ] ;then 
			rm $OPD_DIST/log ;fi
		. $OPD_ROOT/scripts/set_usr
		OPD_USR="$OPD_USR $OPD_USR_16 $OPD_USR_32"

		OPD_STRIP=$OPD_ROOT
		OPD_DEST=$OPD_DIST/$OPD_NEW_ROOT
		OPD_USR_SUB_DIR=common
		OPDU=$OPD_ROOT/src/util
		OPD_MAKEMAKE_DIR=$OPDU/makemake
		OPD_UTIL_DIR="$OPD_MAKEMAKE_DIR/obj $OPDU/mknode/mknodeo $OPDU/mkmenu/menuo \
			$OPDU/indextex/ix $OPDU/maketex/mktex $OPDU/nod_sort/o \
			$OPDU/rofftotex/o $OPDU/misc $OPDU/copyright/cp"

		clean_dir
		OPD_FTP=$OPD_DIST/$OPD_FTP_BASE
		OPD_FTP_DIST=$OPD_FTP/opd

		OPD_FTP_DOC=$OPD_FTP/$OPD_NEW_ROOT-doc

		OPD_SOURCE_TAR=$OPD_NEW_ROOT-src.tar
		OPD_FTP_SRC=$OPD_FTP/$OPD_SOURCE_TAR.gz

		OPD_BIN_TAR=$OPD_NEW_ROOT-bin-linux.tar
		OPD_FTP_BIN=$OPD_FTP/$OPD_BIN_TAR.gz

		OPD_TEST_DATA_TAR=$OPD_NEW_ROOT-test-data.tar
		OPD_FTP_DATA=$OPD_FTP/$OPD_TEST_DATA_TAR.gz
		
		#OPD_FTP_DIRS="$OPD_FTP $OPD_FTP_DOC $OPD_FTP_SRC $OPD_FTP_BIN $OPD_FTP_DATA"
		OPD_FTP_DIRS="$OPD_FTP $OPD_FTP_DIST $OPD_FTP_DOC"
		check_exist_literal_dirs $OPD_FTP_DIRS
	fi
	DID_COMMON=yes
}

function binary_source_test_common() {
	copy_files_dest "$OPD_ROOT/validate/*.dat"
	copy_files_dest "$OPD_ROOT/validate/*.dpp"
	copy_files_dest "$OPD_ROOT/validate/*.rec"
	copy_files_dest "$OPD_ROOT/validate/base*_log"
	copy_files_dest $OPD_ROOT/validate/README
}

function binary_source_common () {

	OPD_AUX_HEAD="$OPD_ROOT/src/include/ObjProNoGui/ObjProComGui \
		$OPD_ROOT/src/include/ObjProFlt/ObjProArith \
		$OPD_ROOT/src/include/ObjProInt16/ObjProArith \
		$OPD_ROOT/src/include/ObjProNoGui/ObjProGui \
		$OPD_ROOT/src/include/ObjProNoGui/ObjProDSPint \
		$OPD_ROOT/src/include/ObjProNoGui/ObjProNet \
		$OPD_ROOT/src/include/ObjProDSPtar/ObjProUsr \
		$OPD_ROOT/src/include/ObjProDSPtar/ObjProDSPint \
		$OPD_ROOT/src/include/ObjProNoGui/ObjProShare"

	for i in $OPD_AUX_HEAD ;do copy_h_files_root $i/ ; done

	binary_source_test_common

	copy_files bin banner headcnv

	copy_dir scripts

	copy_files_dest "$OPD_ROOT/help/*.hlp"

	copy_files_dest "$OPD_ROOT/examp/*.xml"

	copy_files . README COPYING set_root

	copy_files test README

}

function obj_pro_dsp_is() {
	echo "This is the $OPD_DIST_TYPE distribution of version $VERSION of ObjectProDSP," >> README
	echo "an object oriented tool for Digital Signal Processing design" >> README
	echo "analysis and implementation." >> README
	echo >> README
	echo "ObjectProDSP is licensed for free use and distribution under" >> README
	echo "version 2 of the Gnu General Public License. There is NO WARRANTY." >> README
	echo >> README
	echo "ObjectProDSP is a trademark of Mountain Math Software." >> README
	echo >> README
}

function create_dist_tar_file () {
	# $1 source directory
	# $2 destination directory
	# $3 destination file
	# $4 split prefix (not used)

	SRC_DIR=$1          # $1 source directory
    DEST_DIR=$2         # $3 destination directory
    DEST_FIL=$3         # $4 destination file
    SPLIT_PRE=$4        # $5 split prefix

    # we are careful here because we are going to delete a
    # directory tree and we want to make sure we are at the right spot
    if [ -z "$OPD_NEW_ROOT" ] ;then abort null_tar_new_root_file ;fi
    if [ ! "$OPD_NEW_ROOT" = "opd-$VERSION" ] ;then abort bad_new_root ;fi
    if ! cd $SRC_DIR ;then abort cd_tar_dir ;fi
    if [ ! -d $OPD_NEW_ROOT ] ;then abort tar_new_root_not_directory ;fi
    if [ ! -e $OPD_START_VALIDATE ] ;then abort no_file_for_start_time ;fi
    if [ $OPD_NEW_ROOT -ot $OPD_START_VALIDATE ] ;then abort tar_new_root_too_old ;fi
    if ! tar cf $DEST_DIR/$DEST_FIL $OPD_NEW_ROOT ;then abort tar_failed ;fi
    if ! rm -r $OPD_NEW_ROOT ;then abort remove_temp_tree ;fi
    
    cd $DEST_DIR
    gzip $DEST_FIL
}


# split files are no longer used but this is left here in case it
# will be needed later
function create_split_tar_file () {
	# $1 source directory
	# $2 destination directory
	# $3 destination file
	# $4 split prefix

	SRC_DIR=$1			# $1 source directory
	DEST_DIR=$2			# $3 destination directory
	DEST_FIL=$3			# $4 destination file
	SPLIT_PRE=$4		# $5 split prefix
	local i

	# we are careful here because we are going to delete a
	# directory tree and we want to make sure we are at the right spot
	if [ -z "$OPD_NEW_ROOT" ] ;then abort null_tar_new_root_file ;fi
	if [ ! "$OPD_NEW_ROOT" = "opd-$VERSION" ] ;then abort bad_new_root ;fi
	if ! cd $SRC_DIR ;then abort cd_tar_dir ;fi
	if [ ! -d $OPD_NEW_ROOT ] ;then abort tar_new_root_not_directory ;fi
	if [ ! -e $OPD_START_VALIDATE ] ;then abort no_file_for_start_time ;fi
	if [ $OPD_NEW_ROOT -ot $OPD_START_VALIDATE ] ;then abort tar_new_root_too_old ;fi
	if ! tar cf $DEST_DIR/$DEST_FIL $OPD_NEW_ROOT ;then abort tar_failed ;fi
	if ! rm -r $OPD_NEW_ROOT ;then abort remove_temp_tree ;fi
	
	cd $DEST_DIR
	gzip $DEST_FIL
	split -b 250k $DEST_FIL.gz $SPLIT_PRE
	rm $DEST_FIL.gz

	echo "This directory contains a split version of $DEST_FIL.gz." > README
	obj_pro_dsp_is
	echo "To recreate the original concatenate the parts. For example enter:" >> README
	echo "cat $SPLIT_PRE* > $DEST_FIL.gz" >> README
	echo >> README
	echo "Checksums are:" >> README
	echo >> README
	for i in $SPLIT_PRE* ;do echo "`sum $i`   $i" >> README ;done
}


function source_distribution() {

	all_common
	OPD_CREATE_DIR="$OPD_ROOT/bin $OPD_ROOT/lib $OPD_ROOT/help \
		$OPD_ROOT/src/menus/nodes/concat $OPD_ROOT/test \
		$OPD_ROOT/src/menus/nodes/texnodes \
		$OPD_ROOT/doc/nodetex $OPD_ROOT/doc/helptex $OPD_ROOT/doc/examptex \
		$OPD_ROOT/doc/menus"

	for i in $OPD_CREATE_DIR ;do check_create_dir_root $i ;done

	copy_exe_c_h

	binary_source_common

	copy_all_doc

	copy_all_usr

	copy_files build Makefile README
	copy_files_dest "$OPD_ROOT/build/make_*.sh"

	copy_files src/menus opd.menu

	# copy source code for utilities
	for i in $OPD_UTIL_DIR ;do
		OPD_TAIL=${i##$OPDU/}
		#echo $OPD_TAIL
		OPD_TAIL=${OPD_TAIL%/*}
		#echo $OPD_TAIL
		check_create_dir_root $OPDU/$OPD_TAIL/
		#echo "copy_c_h_y_l $OPD_SRC_DIR $OPD_DEST_NOW"
		copy_c_h_y_l $OPD_SRC_DIR $OPD_DEST_NOW
	done


	copy_c_h_y_l_files_root $OPD_ROOT/src/start_up
	copy_c_h_y_l_files_root $OPD_ROOT/src/dsp/lib/target/tarnet
	copy_c_h_y_l_files_root $OPD_ROOT/src/dsp/lib/target/nobenchm


	# cp domakemake & Makefile_dummy or Makefile
	OPD_MAKE_DIR="$OPD_ROOT/src/gui/build/iv $OPD_ROOT/src/dsp/build/fltgui \
		$OPD_ROOT/src/dsp/build/int16gui \
		$OPD_ROOT/src/start_up \
		$OPD_UTIL_DIR \
		$OPD_ROOT/src/dsp/lib/target/build/tarflt \
		$OPD_ROOT/src/dsp/lib/target/build/tarint \
		$OPD_ROOT/doc/userman  \
		$OPD_ROOT/doc/overview"

	for i in $OPD_MAKE_DIR ;do
		OPD_TO_COPY=
		OPD_ABS_TO_COPY=
		if [ -e $i/domakemake ] ;then
			copy_files_root $i domakemake
			$COPY $OPD_ROOT/scripts/Makefile_dummy $OPD_DEST_NOW/Makefile
		else copy_files_root $i Makefile ;fi
		copy_Makefile_ $i
	done
	copy_makemake_librarys # must come AFTER above to overwrite dummy Makefile
			  	# so we can build domakemake

	for i in $OPD_ROOT/src/dsp/lib/control/int16gui \
		$OPD_ROOT/src/dsp/lib/control/fltgui \
		$OPD_ROOT/src/gui/validate/iv \
		$OPD_ROOT/src/dsp/lib/target/build ;do
		copy_Makefile_ $i 
	done

	create_dist_tar_file \
		$OPD_DIST \
        $OPD_FTP_DIST \
        $OPD_SOURCE_TAR \
        part

	#mv $OPD_DEST $OPD_DIST/$OPD_DIST_TYPE-$VERSION
}


function echo_do () {
	echo "$1"
	$1
}



function binary_distribution () {
	all_common
	convert_dir $OPD_ROOT
	check_create_dir_root $OPD_ROOT/src/include


	. $OPD_ROOT/scripts/set_gui
	. $OPD_ROOT/scripts/set_dsp
	. $OPD_ROOT/scripts/set_com


	for i in $OPD_GUI_H_DIR $OPD_DSP_H_DIR $OPD_COM_H_DIR ;do
		OPD_TEST=${i##$OPD_ROOT/src/include/ObjPro}
		if [ "$i" != "$OPD_TEST" ] ;then
			check_create_dir_root $i/
    		copy_h_files_root $i/ $OPD_DEST_NOW
		fi
	done
	
	binary_source_common

	copy_files bin makemake opd opd_dsp16_exe opd_dsp_exe opd_gui_exe \
		nametrans cmp_val_log gen_data gen_dpp_code report_test \
		compare_byte

	copy_files lib LibTarLnxFlt LibTarnobenchmFlt Libopdcom \
		LibTarLnxInt16 LibTarnobenchmInt16 Libopdgen Libopdnogui

	create_dist_tar_file \
		$OPD_DIST \
		$OPD_FTP_DIST \
		$OPD_BIN_TAR \
		part

	#mv $OPD_DEST $OPD_DIST/$OPD_DIST_TYPE-$VERSION
}

function get_ps () { #$1 directory, $2 list of files, $3 destination directory
	local i
	echo "cd $1"
	cd $1
	echo "make $2"
	make $2
	for i in $2 ;do echo "gzip $i" ; gzip $i ;done
	for i in $2 ;do mv $i.gz $3 ;done
}

function documentation_distribution () {

	all_common
	( cd $OPD_ROOT/build ; make DOC )
	echo $OPD_PS
	get_ps $OPD_ROOT/doc/overview "ovr_front.ps ovr_app.ps nodeman.ps" \
		$OPD_FTP_DOC
	get_ps $OPD_ROOT/doc/userman userman.ps $OPD_FTP_DOC
	get_ps $OPD_ROOT/doc/devman devman.ps $OPD_FTP_DOC
	cd $OPD_FTP_DOC
	echo "This directory contains gzip compressed postscript files of" > README
	echo "the ObjectProDSP manuals." >> README
	obj_pro_dsp_is
	echo "File              Sum          Manual" >> README
	echo "----              ---          ------" >> README
	echo "ovr_front.ps.gz   `sum ovr_front.ps.gz`  Overview and turorial" >> README
	echo "ovr_app.ps.gz     `sum ovr_app.ps.gz`  Overview and turorial appendix" >> README
	echo "nodeman.ps.gz     `sum nodeman.ps.gz`  DSP node library" >> README
	echo "userman.ps.gz     `sum userman.ps.gz`  User's reference" >> README
	echo "devman.ps.gz      `sum devman.ps.gz`  Developer's reference" >> README
	echo >> README
	echo "The \`Overview and tutorial' is only 30 pages but contains" >> README
	echo "many figures from X-windows images. It will expand to" >> README
	echo "16 megabytes when uncompressed. You may want to pipe it" >> README
	echo "to your printer using \`gzip -d -c' if your disk space is limited." >> README
}

function test_data_distribution () {
	OPD_TEST_NODES=$OPD_ROOT/validate/test_nodes
	if [ ! -d $OPD_TEST_NODES ] ;then 
		echo "There is no directory \`$OPD_TEST_NODES'."
		echo "You must install the test data distribution or create"
		echo "the base line test data (do \`make VAL_DATA' in"
		echo "\`$OPD_ROOT/build')"
		echo "before you can create the test data distribution."
		exit 1
	fi
	all_common
	find $OPD_ROOT/validate/test_nodes '(' -name '*.dat' -o -name '*.cmpb' ')' \
		> $OPD_DIST/test_data_list
	( while read OPD_TEST_FILE ;do  copy_files_dest $OPD_TEST_FILE ;done ) \
        < $OPD_DIST/test_data_list

	for i in $OPD_ROOT/validate/test_data/*.dat ;do copy_files_dest $i ;done
	for i in $OPD_ROOT/validate/test_data/interactive/*.dat ;do \
		 copy_files_dest $i ;done

	binary_source_test_common

	rm $OPD_DIST/test_data_list

	check_create_dir_root $OPD_ROOT/validate/test_data 
	# nothing tranferred from here but we want to make sure it exists
		
	create_dist_tar_file \
		$OPD_DIST \
        $OPD_FTP_DIST \
        $OPD_TEST_DATA_TAR \
        part

	#mv $OPD_DEST $OPD_DIST/$OPD_DIST_TYPE-$VERSION
}

function all_distribution() {
	all_common
	OPD_THIS_DIR=`pwd`

	cd $OPD_THIS_DIR
	OPD_DIST_TYPE=$SOURCE
	echo Now doing  $OPD_DIST_TYPE distribution.
	source_distribution

	cd $OPD_THIS_DIR
	OPD_DIST_TYPE=$BINARY
	echo Now doing  $OPD_DIST_TYPE distribution.
	binary_distribution

	cd $OPD_THIS_DIR
	OPD_DIST_TYPE=$DOCUMENTATION
	echo Now doing  $OPD_DIST_TYPE distribution.
	documentation_distribution

	# Save for last. It will abort if no base line test data exists.
	cd $OPD_THIS_DIR
	OPD_DIST_TYPE=$TEST_DATA
	echo Now doing  $OPD_DIST_TYPE distribution.
	test_data_distribution

}

# start of execution


OPD_DIST_TYPE=$1
case $1 in
$SOURCE) source_distribution ;;
$BINARY) binary_distribution ;;
$DOCUMENTATION) documentation_distribution ;;
$TEST_DATA) test_data_distribution ;;
FULL) all_distribution ;;
*) echo "Must say what distribution to make:"
	echo "	$SOURCE"
	echo "	$BINARY"
	echo "	$DOCUMENTATION"
	echo "	$TEST_DATA"
	echo "	$FULL"
	echo "Set OPD_NO_PROMPT to run with no prompting."
;;
esac
