#ifndef lint
static const char rcsid[] = "$Id: str_namespace.c,v 1.1.1.1 1996/06/30 00:09:17 mtp Exp $";
#endif
/****************************************************************************
 * @Header@
 ****************************************************************************
 * $Log: str_namespace.c,v $
 * Revision 1.1.1.1  1996/06/30 00:09:17  mtp
 * Resubmission of PD DCE sources
 *
 * Revision 1.1.1.1  1995/12/31 05:20:05  mtp
 * + Placed under CVS control
 *
 ****************************************************************************
 */
/*
 * str_namespace.c
 */
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include "str_namespace.h"

unsigned32
rpc_ns_register( FILE *fd, const rpc_string_binding_t str_binding  )
{
   unsigned32 status = rpc_s_ok;
   char buf[30];
   int len;

   if( str_binding == NULL )
       return( -1 );

   len = strlen( str_binding );
   strncpy( buf, str_binding, len );

   if( fputs( buf, fd ) == EOF )
       status = -1;

   return( status );
}

unsigned32
rpc_ns_query( FILE *fd, 
              const char *protocol,            /* tcp or udp */
              rpc_string_binding_t *str_binding )
{
   unsigned32 status = -1;
   char buf[256];

   while( fgets( buf, 29, fd ) != NULL )
   {
       *str_binding = malloc( 30 );
       strcpy( *str_binding, buf );
       if( strpbrk( *str_binding, protocol ) != NULL )
       {
           status = rpc_s_ok;
           break;
       }
   }

   return( status );
}

void
rpc_ns_close( FILE *fd )
{
   fclose(fd);
}

FILE *
rpc_ns_open( const unsigned_char_t *ns_file )
{
   return( fopen( ns_file, "w+" ) );
}

FILE *
rpc_ns_open_read_only( const unsigned_char_t *ns_file )
{
   return( fopen( ns_file, "r" ) );
}

void
rpc_ns_free_string( rpc_string_binding_t *str )
{
   free( *str );
   *str = NULL;
}
