/*
 * $Id: check_status.h,v 1.1.1.1 1996/06/30 00:09:17 mtp Exp $
 ****************************************************************************
 * @Header@
 ****************************************************************************
 * $Log: check_status.h,v $
 * Revision 1.1.1.1  1996/06/30 00:09:17  mtp
 * Resubmission of PD DCE sources
 *
 * Revision 1.1.1.1  1995/12/31 05:20:05  mtp
 * + Placed under CVS control
 *
 ****************************************************************************
 */
/*
 * check_status.h
 */
#ifndef _check_status_
#define _check_status_

#include <stdio.h>
#include <dce/dce_error.h>

#define RESUME 0
#define ABORT  1

#define CHECK_STATUS(input_status, comment, action) \
{ \
    if(input_status != rpc_s_ok) \
    { \
        dce_error_string_t  error_string; \
        int error_stat; \
        dce_error_inq_text( (unsigned long) input_status, (unsigned char *) error_string, (int *) &error_stat ); \
        pthread_lock_global_np(); \
        fprintf(stderr, "%s\n", comment); \
        fprintf(stderr, "%s\n", error_string); \
        pthread_unlock_global_np(); \
        if(action == ABORT) \
             exit(1); \
    } \
}

#endif
