/*
 * $Id: sysconf.h,v 1.2 1996/07/10 14:57:31 mtp Exp $
 ****************************************************************************
 * @Header@
 ****************************************************************************
 * $Log: sysconf.h,v $
 * Revision 1.2  1996/07/10 14:57:31  mtp
 * No change
 *
 * Revision 1.1.1.1  1996/06/30 00:09:15  mtp
 * Resubmission of PD DCE sources
 *
 * Revision 1.1.1.1  1995/12/31 05:20:10  mtp
 * + Placed under CVS control
 *
 ****************************************************************************
 */
/*
 * 
 * (c) Copyright 1989 OPEN SOFTWARE FOUNDATION, INC.
 * (c) Copyright 1989 HEWLETT-PACKARD COMPANY
 * (c) Copyright 1989 DIGITAL EQUIPMENT CORPORATION
 * To anyone who acknowledges that this file is provided "AS IS"
 * without any express or implied warranty:
 *                 permission to use, copy, modify, and distribute this
 * file for any purpose is hereby granted without fee, provided that
 * the above copyright notices and this notice appears in all source
 * code copies, and that none of the names of Open Software
 * Foundation, Inc., Hewlett-Packard Company, or Digital Equipment
 * Corporation be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.  Neither Open Software Foundation, Inc., Hewlett-
 * Packard Company, nor Digital Equipment Corporation makes any
 * representations about the suitability of this software for any
 * purpose.
 * 
 */
/*
 */

/*
**
**  NAME:
**
**      osf/1_mips.h
**
**  FACILITY:
**
**      Remote Procedure Call (RPC) 
**
**  ABSTRACT:
**
**  This file contains all definitions specific to the osf/1 MIPS platform
**
**
*/

#ifndef _SYSCONF_H
#define _SYSCONF_H	1	

/******************************************************************************/

#include <dce/pthread_exc.h>
#include <dce/dce.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/file.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
/* #include <sys/uio.h> @@ Not required when building under Linux 1.3.20 */
#include <sys/time.h>

/*
*
* IMPORTANT ORDER DEPENDENCY:
*
*       The <cmaxxx.h> include files above do #ifdefs on 
*       _POSIX_REENTRANT_FUNCTIONS.  Under OSF/1, this
*       is set in <unistd.h>.  The problem is that for
*       the OSF/1 DCE reference port, we need to build
*       with vanilla CMA threads and no help from the 
*       kernel.
*
*       Therefore, the include of <unistd.h> must come
*       after the <cmaxxx.h> files above.
*
*       You have been warned.
*
*/
#include <unistd.h>
#include <assert.h>
#include <fcntl.h>
#include <string.h>

#define NO_VOID_STAR           /* @@ (void *) is supported in GCC -ansi mode */
#define USE_PROTOTYPES  1
#define STDARG_PRINTF   1
#define NO_VARARGS_PRINTF      /* @@ */

/* 
 * if SOCKADDR_LEN isn't defined MSG_MAXIOVLEN will not be defined in
 * <sys/socket.h>, so define it here.
 */
#ifndef MSG_MAXIOVLEN
#define MSG_MAXIOVLEN	16
#endif

#define RPC_DEFAULT_NLSPATH \
"/usr/users/mtp/sde/pd_dce/opt/dcelocal/nls/msg/en_US.ISO8859-1"

/**************************************************************************/
#define NON_CANCELLABLE_IO 1

#if 0
/*
 * This definition means the ioctl() call to get the interface
 * addresses in ipnaf_bsd.c in enumerate_interfaces() will not be
 * called. This is because Ultrix returns the same internet address
 * for all interfaces.
 */
    #define NO_SIOCGIFADDR 1  /* Exclude because Linux defines SIOCGIFADDR */

    #ifndef PD_BUILD
    #define NON_CANCELLABLE_IO
    #define RPC_C_DG_SOCK_MAX_PRIV_SOCKS 0
    #endif

    #ifndef DCE_DEBUG
    #define DCE_DEBUG 1
    #endif

    #ifndef MAX_DEBUG
    #define MAX_DEBUG 1
    #endif

    #ifndef DEBUG
    #define DEBUG 1
    #endif
#endif

#endif /* _SYSCONF_H */
