/*
 * $Id: y_tab.c,v 1.1.1.1 1996/06/30 00:09:01 mtp Exp $
 ****************************************************************************
 * @Header@
 ****************************************************************************
 * $Log: y_tab.c,v $
 * Revision 1.1.1.1  1996/06/30 00:09:01  mtp
 * Resubmission of PD DCE sources
 *
 * Revision 1.1.1.1  1995/12/31 05:20:17  mtp
 * + Placed under CVS control
 *
 ****************************************************************************
 */

# line 2 "nidl.y"
/*
 *  
 *  (c) Copyright 1989 OPEN SOFTWARE FOUNDATION, INC.
 *  (c) Copyright 1989 HEWLETT-PACKARD COMPANY
 *  (c) Copyright 1989 DIGITAL EQUIPMENT CORPORATION
 *  To anyone who acknowledges that this file is provided "AS IS"
 *  without any express or implied warranty:
 *                  permission to use, copy, modify, and distribute this
 *  file for any purpose is hereby granted without fee, provided that
 *  the above copyright notices and this notice appears in all source
 *  code copies, and that none of the names of Open Software
 *  Foundation, Inc., Hewlett-Packard Company, or Digital Equipment
 *  Corporation be used in advertising or publicity pertaining to
 *  distribution of the software without specific, written prior
 *  permission.  Neither Open Software Foundation, Inc., Hewlett-
 *  Packard Company, nor Digital Equipment Corporation makes any
 *  representations about the suitability of this software for any
 *  purpose.
 *  
 */
/*
**
**  NAME:
**
**      IDL.Y
**
**  FACILITY:
**
**      Interface Definition Language (IDL) Compiler
**
**  ABSTRACT:
**
**      This module defines the main IDL grammar accepted
**      by the IDL compiler.
**
**  VERSION: DCE 1.0
**
*/

#ifdef vms
#  include <types.h>
#else
#  include <sys/types.h>
#endif

#include <nidl.h>
#include <nametbl.h>
#include <errors.h>
#include <ast.h>
#include <astp.h>
#include <frontend.h>

extern boolean search_attributes_table ;

int yyparse (
#ifdef PROTO
    void
#endif
);

int yylex (
#ifdef PROTO
    void
#endif
);

/*
**  Local cells used for inter-production communication
*/
static ASTP_attr_k_t       ASTP_bound_type;    /* Array bound attribute */



# line 78 "nidl.y"
typedef union 
{
    NAMETABLE_id_t         y_id ;          /* Identifier           */
    STRTAB_str_t           y_string ;      /* String               */
    STRTAB_str_t           y_float ;       /* Float constant       */
    long                   y_ival ;        /* Integer constant     */
    AST_export_n_t*        y_export ;      /* an export node       */
    AST_import_n_t*        y_import ;      /* Import node          */
    AST_exception_n_t*     y_exception ;   /* Exception node       */
    AST_constant_n_t*      y_constant;     /* Constant node        */
    AST_parameter_n_t*     y_parameter ;   /* Parameter node       */
    AST_type_n_t*          y_type ;        /* Type node            */
    AST_type_p_n_t*        y_type_ptr ;    /* Type pointer node    */
    AST_field_n_t*         y_field ;       /* Field node           */
    AST_arm_n_t*           y_arm ;         /* Union variant arm    */
    AST_operation_n_t*     y_operation ;   /* Routine node         */
    AST_interface_n_t*     y_interface ;   /* Interface node       */
    AST_case_label_n_t*    y_label ;       /* Union tags           */
    ASTP_declarator_n_t*   y_declarator ;  /* Declarator info      */
    ASTP_array_index_n_t*  y_index ;       /* Array index info     */
    nidl_uuid_t            y_uuid ;        /* Universal UID        */
    char                   y_char;         /* character constant   */
    ASTP_attributes_t      y_attributes;   /* attributes flags     */
    struct {
        AST_type_k_t    int_size;
        int             int_signed;
        }                  y_int_info;     /* int size and signedness */
    ASTP_exp_n_t           y_exp;          /* constant expression info */
} YYSTYPE;
# define ALIGN_KW 257
# define BYTE_KW 258
# define CHAR_KW 259
# define CONST_KW 260
# define DEFAULT_KW 261
# define ENUM_KW 262
# define EXCEPTIONS_KW 263
# define FLOAT_KW 264
# define HYPER_KW 265
# define INT_KW 266
# define INTERFACE_KW 267
# define IMPORT_KW 268
# define LONG_KW 269
# define PIPE_KW 270
# define REF_KW 271
# define SMALL_KW 272
# define STRUCT_KW 273
# define TYPEDEF_KW 274
# define UNION_KW 275
# define UNSIGNED_KW 276
# define SHORT_KW 277
# define VOID_KW 278
# define DOUBLE_KW 279
# define BOOLEAN_KW 280
# define CASE_KW 281
# define SWITCH_KW 282
# define HANDLE_T_KW 283
# define TRUE_KW 284
# define FALSE_KW 285
# define NULL_KW 286
# define BROADCAST_KW 287
# define COMM_STATUS_KW 288
# define CONTEXT_HANDLE_KW 289
# define FIRST_IS_KW 290
# define HANDLE_KW 291
# define IDEMPOTENT_KW 292
# define IGNORE_KW 293
# define IMPLICIT_HANDLE_KW 294
# define IN_KW 295
# define LAST_IS_KW 296
# define LENGTH_IS_KW 297
# define LOCAL_KW 298
# define MAX_IS_KW 299
# define MAYBE_KW 300
# define MIN_IS_KW 301
# define MUTABLE_KW 302
# define OUT_KW 303
# define POINTER_DEFAULT_KW 304
# define ENDPOINT_KW 305
# define PTR_KW 306
# define REFLECT_DELETIONS_KW 307
# define REMOTE_KW 308
# define SECURE_KW 309
# define SHAPE_KW 310
# define SIZE_IS_KW 311
# define STRING_KW 312
# define SWITCH_IS_KW 313
# define SWITCH_TYPE_KW 314
# define TRANSMIT_AS_KW 315
# define UNIQUE_KW 316
# define UUID_KW 317
# define VERSION_KW 318
# define V1_ARRAY_KW 319
# define V1_STRING_KW 320
# define V1_ENUM_KW 321
# define V1_STRUCT_KW 322
# define UUID_REP 323
# define COLON 324
# define COMMA 325
# define DOTDOT 326
# define EQUAL 327
# define LBRACE 328
# define LBRACKET 329
# define LPAREN 330
# define RBRACE 331
# define RBRACKET 332
# define RPAREN 333
# define SEMI 334
# define STAR 335
# define QUESTION 336
# define BAR 337
# define BARBAR 338
# define LANGLE 339
# define LANGLEANGLE 340
# define RANGLE 341
# define RANGLEANGLE 342
# define AMP 343
# define AMPAMP 344
# define LESSEQUAL 345
# define GREATEREQUAL 346
# define EQUALEQUAL 347
# define CARET 348
# define PLUS 349
# define MINUS 350
# define NOT 351
# define NOTEQUAL 352
# define SLASH 353
# define PERCENT 354
# define TILDE 355
# define UNKNOWN 356
# define IDENTIFIER 357
# define STRING 358
# define INTEGER_NUMERIC 359
# define CHAR 360
# define FLOAT_NUMERIC 361
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
typedef int yytabelem;
# define YYERRCODE 256

# line 1777 "nidl.y"

yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 68,
	331, 7,
	-2, 181,
-1, 170,
	325, 130,
	333, 130,
	-2, 181,
-1, 313,
	333, 46,
	-2, 45,
	};
# define YYNPROD 262
# define YYLAST 680
yytabelem yyact[]={

    75,   409,    83,   250,   402,   411,   319,   214,   273,   260,
    74,   375,    79,   320,   242,   103,    62,    80,    63,   109,
    49,    98,   116,   277,   182,    46,   115,   110,   184,   113,
   107,   182,   108,   112,   114,   104,    99,   102,    79,    78,
   106,    57,    73,    80,    52,   276,   280,   261,    82,   117,
   182,    79,    68,   415,   397,   380,   347,   345,    60,    26,
   403,   120,   139,   304,   292,    78,   144,   290,   279,   238,
   239,   237,    46,   275,   182,   300,   134,   301,    78,   181,
   173,   305,   306,   294,   176,   175,   143,   293,   295,   302,
   303,   383,   123,   291,   136,   148,   140,   125,   135,   272,
   128,   149,   150,   185,   151,   124,   152,   288,   129,   289,
    80,   127,   126,   189,   105,   232,   153,   131,   154,   142,
   141,   133,    52,   429,   130,   132,   138,   137,   192,    29,
   406,   196,   413,   139,   228,   229,   231,   144,   321,    53,
   230,    69,   235,   236,   233,   234,   240,   134,   343,   166,
   157,   155,   412,   238,   239,   237,   344,   143,   401,   156,
    72,    71,   145,   123,    70,   136,   148,   140,   125,   135,
    69,   128,   149,   150,   243,   151,   124,   152,   212,   129,
   405,   396,   127,   126,   373,   340,   246,   153,   131,   154,
   142,   141,   133,   341,   371,   130,   132,   138,   137,   232,
     6,   210,   169,   171,   211,   420,   238,   239,   237,   296,
   283,   297,   344,   162,   160,   298,   299,   339,   228,   229,
   231,   161,   159,   338,   230,   337,   235,   236,   233,   234,
   240,   336,   335,   145,   334,   333,   332,   287,   238,   239,
   237,   285,   245,   286,   194,   164,   315,   284,   317,   163,
   391,    29,   232,   322,    28,   390,   318,   350,   389,   388,
   330,    29,   326,    29,    37,    25,   329,   325,   252,   327,
   204,   228,   229,   231,   202,   201,   200,   230,   199,   235,
   236,   233,   234,   240,   232,   244,   238,   239,   237,   348,
   198,   197,    36,    35,   349,    34,   351,    33,    47,     6,
   207,     5,   208,   228,   229,   231,   209,   254,     9,   230,
    84,   235,   236,   233,   234,   240,   182,   376,   188,   317,
    43,   256,   247,    54,    45,   166,   317,   316,   313,   103,
   379,   384,   232,   109,   262,    98,   116,   427,    44,   423,
   115,   110,   392,   113,   107,    31,   108,   112,   114,   104,
    99,   102,   249,   182,   106,   264,    65,   263,     6,   235,
   236,   233,   234,   240,   225,   223,   221,   219,   217,   220,
   190,   224,   218,   342,   413,   376,   243,    24,   216,   222,
     8,   314,    10,   213,   177,   398,   394,   393,   121,   395,
    12,    66,   268,     6,   412,   399,   267,    16,   179,   265,
   400,    67,   248,   227,   266,   178,   118,    56,   407,    59,
   414,   404,    32,   183,   421,   416,   419,   387,    51,   425,
   424,   422,   417,   103,   426,    16,   203,   428,   105,    98,
   116,   111,    18,    27,   115,    77,    76,   113,    19,    15,
   386,   112,   114,   104,    99,   102,    30,    13,   106,    39,
   116,    14,    17,   372,   115,    23,   226,   113,   215,   119,
    18,   278,   114,   147,   274,   146,    19,    15,   122,    64,
   385,    61,    58,    55,    11,   312,   241,   170,    48,    14,
    17,   168,   167,   259,   187,   258,   271,   418,   410,   257,
   408,   255,   100,   101,    97,    96,    95,    94,    93,    92,
    91,   158,    90,    89,    88,    87,    86,    85,    81,    42,
    41,   269,   270,    40,   172,    50,   174,    22,   165,   180,
   186,    38,   105,    21,    20,     4,     7,     3,     2,     1,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,   191,     0,     0,     0,     0,     0,
     0,     0,     0,   193,   195,     0,     0,     0,     0,     0,
     0,     0,     0,   324,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,   205,     0,   206,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   251,     0,     0,     0,   186,     0,   253,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   281,   311,     0,   282,     0,
     0,     0,     0,     0,     0,     0,   258,     0,     0,     0,
     0,     0,   307,   308,   309,   310,   381,     0,     0,     0,
     0,     0,     0,   374,     0,     0,     0,     0,     0,   382,
   378,   331,   346,     0,   323,     0,     0,     0,     0,   354,
   356,   358,   359,   357,   355,   328,   364,   365,   353,   368,
   369,   370,   352,   377,   366,   367,   360,   361,   362,   363 };
yytabelem yypact[]={

 -1000, -1000,   -30,    52,   115,   134, -1000, -1000,   109,   -66,
  -298,   -71,   -69, -1000,    89,   -33,   -35,   -37, -1000,   -38,
   -67,    64,   109, -1000,  -236, -1000, -1000, -1000,    -2, -1000,
 -1000, -1000, -1000,  -317,  -299,  -343,    85, -1000,  -164, -1000,
  -170,  -173,  -174,  -292,   -30,    71,    71,  -195, -1000,  -183,
  -175, -1000, -1000,   162, -1000,  -111, -1000, -1000,  -112, -1000,
 -1000,   -84, -1000, -1000,   -88, -1000, -1000, -1000,    64, -1000,
 -1000, -1000, -1000, -1000,     0, -1000,  -127,  -279, -1000,  -318,
  -225, -1000,    71,  -318, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
   118,   139, -1000, -1000, -1000, -1000, -1000,  -278,  -254,   -10,
    71,    94,   185, -1000, -1000, -1000, -1000,  -318, -1000,   -81,
  -203, -1000, -1000, -1000, -1000, -1000, -1000, -1000,   -39,   -40,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,   -52,
 -1000,   -54,   -55,   -56, -1000, -1000,   -60,   -60, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000,  -314, -1000, -1000,
    -2, -1000,    -2, -1000, -1000, -1000,    -2, -1000, -1000,  -131,
    29, -1000,  -127,   -91, -1000,  -318,    -5, -1000, -1000, -1000,
   -30,   -12, -1000, -1000,   -62,    25,   -30, -1000,  -310, -1000,
 -1000, -1000,     0, -1000,    -2, -1000, -1000,    47,    45,   127,
   165,   165,  -215,  -312, -1000,  -289, -1000,  -317,  -299,  -318,
 -1000,   -85,   -89, -1000, -1000,  -229,  -277,  -244,  -284,  -256,
  -264,  -130,  -265,  -260,  -272, -1000, -1000, -1000,     2,     2,
     2,     2,  -215, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000,     3, -1000,    71,   -30, -1000,     0,  -215,  -193, -1000,
    71,   -30,   165, -1000,   -63,  -193, -1000, -1000,  -195,   -65,
 -1000, -1000,  -124,   -97,   -98,   -99,  -101,  -102,  -108,  -110,
  -116,  -140, -1000, -1000,  -177, -1000, -1000,  -300,  -121, -1000,
  -301, -1000, -1000, -1000, -1000,   -46, -1000,   -78,  -215,  -215,
  -215,  -215,  -215,  -215,  -215,  -215,  -215,  -215,  -215,  -215,
  -215,  -215,  -215,  -215,  -215,  -215,  -215, -1000, -1000, -1000,
 -1000,  -139, -1000,    -2,  -149,   -30,  -318, -1000, -1000, -1000,
   -30, -1000,   -30,  -193,  -302,   165, -1000,   -30,  -243, -1000,
    -2, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
  -215, -1000, -1000,  -312, -1000, -1000, -1000, -1000,   -73,   -74,
   -77,   -82,    18,  -277,  -244,  -284,  -256,  -264,  -130,  -130,
  -265,  -265,  -265,  -265,  -260,  -260,  -272,  -272, -1000, -1000,
 -1000, -1000,    29, -1000,  -318, -1000, -1000, -1000,  -318, -1000,
  -152,  -303, -1000, -1000,  -318,  -310, -1000, -1000, -1000, -1000,
 -1000, -1000,  -215, -1000, -1000,  -176,  -297,  -153,  -204, -1000,
 -1000, -1000, -1000,   -12,   113,  -304, -1000, -1000,  -193, -1000,
  -129, -1000,  -215,    15, -1000,   -12, -1000,   113, -1000, -1000,
 -1000,    71,    13, -1000, -1000, -1000,  -318, -1000,  -211, -1000 };
yytabelem yypgo[]={

     0,   529,   528,   527,   526,   525,   524,   523,   521,    13,
   517,   455,   515,   418,   449,   513,   510,   509,     2,     0,
     8,   383,   508,     3,    10,   310,   507,   506,   505,   504,
   503,   502,   500,   499,   498,   497,   496,   495,   494,   139,
   493,   431,   492,   411,     6,   413,     4,   491,   490,   321,
     1,   489,   488,   487,   486,    99,     5,   298,   406,   402,
   352,   327,   484,   483,     9,   436,   435,   482,   481,   477,
   476,   475,    14,    11,   433,   426,   373,   474,   447,   473,
   472,   471,   469,   407,   409,   468,   465,   464,   463,   461,
    73,   459,   388,     7,   458,   378,   368,   372,   367,   369,
   366,   379,   365,   371,   364,   456,   403 };
yytabelem yyr1[]={

     0,     1,     3,     2,     4,     4,     4,     6,     7,     7,
    10,    10,    11,    11,    11,    12,    12,    13,     8,     8,
    14,    14,    14,    14,    16,    20,    15,    22,    18,    18,
    25,    25,    25,    25,    25,    25,    25,    25,    26,    26,
    26,    26,    33,    27,    27,    39,    39,     9,     9,    40,
    40,    41,    41,    41,    41,    42,    42,    42,    28,    28,
    28,    29,    30,    31,    32,    34,    43,    44,    36,    36,
    36,    36,    36,    36,    36,    45,    46,    47,    47,    48,
    48,    49,    50,    54,    54,    52,    52,    55,    56,    56,
    51,    51,    53,    53,    35,    35,    35,    59,    59,    60,
    37,    62,    63,    63,    64,    38,    24,    24,    19,    19,
    66,    66,    65,    65,    65,    65,    67,    67,    67,    67,
    67,    67,    67,    17,    17,    68,    69,    71,    70,    70,
    70,    72,    72,    73,    73,    57,    74,    75,    76,    61,
     5,     5,     5,    77,    77,    77,    78,    78,    78,    78,
    78,    78,    78,    82,    82,    82,    81,    81,    79,    79,
    80,    80,    83,    84,    85,    85,    86,    86,    86,    86,
    86,    86,    87,    87,    90,    90,    90,    88,    89,    89,
    23,    23,    58,    58,    58,    91,    91,    92,    92,    92,
    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,
    92,    92,    92,    92,    92,    92,    92,    92,    92,    92,
    92,    92,    92,    92,    92,    92,    21,    93,    93,    94,
    94,    95,    95,    96,    96,    97,    97,    98,    98,    99,
    99,    99,   100,   100,   100,   100,   100,   101,   101,   101,
   102,   102,   102,   103,   103,   103,   103,   104,   105,   105,
   105,   105,   105,   106,   106,   106,   106,   106,   106,   106,
   106,   106 };
yytabelem yyr2[]={

     0,     7,     7,     1,     7,     3,     5,     7,     2,     1,
     2,     5,     5,     7,     7,     2,     7,     3,     2,     7,
     5,     5,     5,     5,    11,     3,     5,     7,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     3,     3,     3,     0,     3,     0,     3,     3,
     1,     3,     3,     3,     3,     3,     5,     5,     3,     5,
     5,     5,     3,     3,     3,     3,     3,     3,     5,    15,
     7,    17,    17,    19,     5,     7,     7,     2,     7,     2,
     7,     3,     5,     2,     7,     2,     5,     3,     7,     5,
     7,    11,     3,     9,     9,    11,     5,     2,     7,    11,
     5,     7,     2,     9,     3,     5,     2,     9,     3,     5,
     3,     5,     3,     5,     7,     5,     5,     7,     7,    11,
    11,    11,    11,     7,     5,     7,     3,     5,     2,     9,
     1,     9,     7,     3,     1,     3,     3,     3,     3,     3,
     6,     7,     0,     2,     8,     0,     5,     5,     9,     9,
     9,     3,     9,     3,     3,     3,     3,     3,     2,     8,
     3,     9,     3,     3,     9,     9,     3,     3,     3,     3,
     3,     3,     2,     7,     3,     5,     1,     3,     3,     5,
     5,     1,     4,     5,     5,     3,     9,     3,     3,     3,
     3,     3,     3,     3,     9,     3,     9,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     9,     9,     9,     9,
     3,     9,     9,     9,     3,     3,     3,     3,    11,     3,
     7,     3,     7,     3,     7,     3,     7,     3,     7,     3,
     7,     7,     3,     7,     7,     7,     7,     3,     7,     7,
     3,     7,     7,     3,     7,     7,     7,     3,     3,     5,
     5,     5,     5,     7,     3,     3,     3,     3,     3,     3,
     3,     3 };
yytabelem yychk[]={

 -1000,    -1,    -2,    -3,    -5,   -57,   329,    -4,   328,   256,
   267,   -77,   256,   -78,   317,   305,   263,   318,   298,   304,
    -6,    -7,   -10,   -11,   268,   331,   357,   -74,   325,   332,
   -74,   256,   323,   330,   330,   330,   330,   331,    -8,   -14,
   -15,   -16,   -17,   256,   274,   260,   -23,   -57,   -11,   256,
   -12,   -13,   358,   -39,   325,   -79,   -83,   358,   -80,   -84,
   357,   -81,   359,   361,   -82,   271,   306,   316,    -9,   334,
   334,   334,   334,   334,   -24,   -19,   -65,   -66,   357,   330,
   335,   -22,   -23,   -18,   -25,   -26,   -27,   -28,   -29,   -30,
   -31,   -32,   -33,   -34,   -35,   -36,   -37,   -38,   264,   279,
   -42,   -40,   280,   258,   278,   357,   283,   273,   275,   262,
   270,   -41,   276,   272,   277,   269,   265,   -18,   -58,   -91,
   256,   -92,   -85,   287,   300,   292,   307,   306,   295,   303,
   319,   312,   320,   316,   271,   293,   289,   322,   321,   257,
   291,   315,   314,   281,   261,   357,   -86,   -88,   290,   296,
   297,   299,   301,   311,   313,   334,   334,   325,   -78,   333,
   325,   333,   325,   333,   333,   -14,   325,   -67,   -68,   329,
   -69,   330,   -65,   -19,   -66,   -18,   -19,   266,   266,   259,
   -43,   357,   328,   -45,   282,   357,   -43,   -62,   328,   -18,
   276,   -41,   -24,   -74,   325,   -74,   334,   330,   330,   330,
   330,   330,   330,   -75,   330,   -75,   -13,   -39,   -39,   -39,
   332,   335,   -20,   -21,   -93,   -94,   -95,   -96,   -97,   -98,
   -99,  -100,  -101,  -102,  -103,  -104,  -105,  -106,   349,   350,
   355,   351,   330,   359,   360,   357,   358,   286,   284,   285,
   361,   -70,   -72,   -23,   256,   333,   -24,   327,   -59,   -60,
   -23,   -43,   330,   -45,   282,   -47,   -49,   -51,   -57,   -63,
   -64,   357,   -39,   310,   310,   272,   277,   269,   265,   -25,
   -25,   -54,   -55,   -20,   -87,   -90,   357,   335,   -89,   357,
   335,   -83,   -84,   -19,   332,   326,   332,   326,   336,   338,
   344,   337,   348,   343,   347,   352,   339,   341,   345,   346,
   340,   342,   349,   350,   335,   353,   354,  -106,  -106,  -106,
  -106,   -21,   -71,   325,   -39,   -18,   -61,   -23,   -20,   -44,
    -9,   331,   -18,   -59,   -25,   330,   -44,    -9,   -58,   331,
   325,   -92,   333,   333,   333,   333,   333,   333,   333,   333,
   325,   333,   -76,   325,   333,   357,   -76,   357,   335,   -20,
   335,   -20,   -21,   -95,   -96,   -97,   -98,   -99,  -100,  -100,
  -101,  -101,  -101,  -101,  -102,  -102,  -103,  -103,  -104,  -104,
  -104,   333,   -39,   333,   -61,   -73,   -19,   -60,   -61,   -44,
   357,   -25,   -49,   334,   -18,   -39,   -55,   -90,   332,   332,
   332,   332,   324,   -72,   -73,   -24,   333,   357,   -19,   -64,
   -93,   334,   -46,   357,   -43,   333,   334,   -46,   -48,   -50,
   -52,   -56,   281,   261,   -46,   357,   -44,    -9,   -53,   -56,
   334,   -23,   -20,   324,   -46,   -50,   -18,   324,   -19,   334 };
yytabelem yydef[]={

     3,    -2,   142,     0,     0,   145,   135,     1,     9,     5,
     0,     0,     0,   143,     0,     0,     0,     0,   151,     0,
     0,   181,     8,    10,     0,     6,     2,   140,    45,   136,
   141,   146,   147,     0,     0,     0,     0,     4,    47,    18,
     0,     0,     0,     0,   181,    50,    50,     0,    11,    12,
     0,    15,    17,     0,    46,     0,   158,   162,     0,   160,
   163,     0,   156,   157,     0,   153,   154,   155,    -2,    48,
    20,    21,    22,    23,   124,   106,   108,     0,   112,     0,
   110,    26,    50,     0,    28,    29,    30,    31,    32,    33,
    34,    35,    36,    37,    38,    39,    40,    41,    43,    44,
    58,     0,    62,    63,    64,    42,    65,     0,     0,     0,
    50,    55,    49,    51,    52,    53,    54,     0,   180,     0,
     0,   185,   187,   188,   189,   190,   191,   192,   193,   195,
   197,   198,   199,   200,   201,   202,   203,   204,   205,     0,
   210,     0,     0,     0,   214,   215,     0,     0,   166,   167,
   168,   169,   170,   171,   177,    13,    14,     0,   144,   148,
    45,   149,    45,   150,   152,    19,    45,   113,   115,     0,
    -2,   126,   109,     0,   111,     0,     0,    59,    60,    61,
   181,    96,    66,    68,     0,    74,     0,   100,     0,   105,
    57,    56,   123,   182,    45,   183,   184,     0,     0,     0,
    50,    50,     0,   176,   137,     0,    16,     0,     0,     0,
   116,     0,     0,    25,   216,   217,   219,   221,   223,   225,
   227,   229,   232,   237,   240,   243,   247,   248,     0,     0,
     0,     0,     0,   254,   255,   256,   257,   258,   259,   260,
   261,    45,   128,    50,   181,   114,    27,     0,    47,    97,
    50,   181,    50,    70,     0,    47,    77,    81,     0,     0,
   102,   104,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,    83,    87,     0,   172,   174,     0,     0,   178,
     0,   159,   161,   107,   117,     0,   118,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   249,   250,   251,
   252,     0,   125,    -2,     0,   181,   134,   139,    24,    94,
   181,    67,   181,    47,     0,    50,    75,     0,    50,   101,
    45,   186,   194,   196,   206,   207,   208,   209,   211,   212,
     0,   213,   164,   176,   138,   175,   165,   179,     0,     0,
     0,     0,     0,   220,   222,   224,   226,   228,   230,   231,
   233,   234,   235,   236,   238,   239,   241,   242,   244,   245,
   246,   253,   181,   127,   134,   132,   133,    98,     0,    95,
     0,     0,    78,    90,     0,     0,    84,   173,   119,   120,
   121,   122,     0,   129,   131,     0,     0,     0,     0,   103,
   218,    99,    69,     0,     0,     0,    91,    71,    47,    79,
   181,    85,     0,     0,    72,     0,    76,     0,    82,    86,
    92,    50,     0,    89,    73,    80,     0,    88,     0,    93 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"ALIGN_KW",	257,
	"BYTE_KW",	258,
	"CHAR_KW",	259,
	"CONST_KW",	260,
	"DEFAULT_KW",	261,
	"ENUM_KW",	262,
	"EXCEPTIONS_KW",	263,
	"FLOAT_KW",	264,
	"HYPER_KW",	265,
	"INT_KW",	266,
	"INTERFACE_KW",	267,
	"IMPORT_KW",	268,
	"LONG_KW",	269,
	"PIPE_KW",	270,
	"REF_KW",	271,
	"SMALL_KW",	272,
	"STRUCT_KW",	273,
	"TYPEDEF_KW",	274,
	"UNION_KW",	275,
	"UNSIGNED_KW",	276,
	"SHORT_KW",	277,
	"VOID_KW",	278,
	"DOUBLE_KW",	279,
	"BOOLEAN_KW",	280,
	"CASE_KW",	281,
	"SWITCH_KW",	282,
	"HANDLE_T_KW",	283,
	"TRUE_KW",	284,
	"FALSE_KW",	285,
	"NULL_KW",	286,
	"BROADCAST_KW",	287,
	"COMM_STATUS_KW",	288,
	"CONTEXT_HANDLE_KW",	289,
	"FIRST_IS_KW",	290,
	"HANDLE_KW",	291,
	"IDEMPOTENT_KW",	292,
	"IGNORE_KW",	293,
	"IMPLICIT_HANDLE_KW",	294,
	"IN_KW",	295,
	"LAST_IS_KW",	296,
	"LENGTH_IS_KW",	297,
	"LOCAL_KW",	298,
	"MAX_IS_KW",	299,
	"MAYBE_KW",	300,
	"MIN_IS_KW",	301,
	"MUTABLE_KW",	302,
	"OUT_KW",	303,
	"POINTER_DEFAULT_KW",	304,
	"ENDPOINT_KW",	305,
	"PTR_KW",	306,
	"REFLECT_DELETIONS_KW",	307,
	"REMOTE_KW",	308,
	"SECURE_KW",	309,
	"SHAPE_KW",	310,
	"SIZE_IS_KW",	311,
	"STRING_KW",	312,
	"SWITCH_IS_KW",	313,
	"SWITCH_TYPE_KW",	314,
	"TRANSMIT_AS_KW",	315,
	"UNIQUE_KW",	316,
	"UUID_KW",	317,
	"VERSION_KW",	318,
	"V1_ARRAY_KW",	319,
	"V1_STRING_KW",	320,
	"V1_ENUM_KW",	321,
	"V1_STRUCT_KW",	322,
	"UUID_REP",	323,
	"COLON",	324,
	"COMMA",	325,
	"DOTDOT",	326,
	"EQUAL",	327,
	"LBRACE",	328,
	"LBRACKET",	329,
	"LPAREN",	330,
	"RBRACE",	331,
	"RBRACKET",	332,
	"RPAREN",	333,
	"SEMI",	334,
	"STAR",	335,
	"QUESTION",	336,
	"BAR",	337,
	"BARBAR",	338,
	"LANGLE",	339,
	"LANGLEANGLE",	340,
	"RANGLE",	341,
	"RANGLEANGLE",	342,
	"AMP",	343,
	"AMPAMP",	344,
	"LESSEQUAL",	345,
	"GREATEREQUAL",	346,
	"EQUALEQUAL",	347,
	"CARET",	348,
	"PLUS",	349,
	"MINUS",	350,
	"NOT",	351,
	"NOTEQUAL",	352,
	"SLASH",	353,
	"PERCENT",	354,
	"TILDE",	355,
	"UNKNOWN",	356,
	"IDENTIFIER",	357,
	"STRING",	358,
	"INTEGER_NUMERIC",	359,
	"CHAR",	360,
	"FLOAT_NUMERIC",	361,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
      "interface : interface_init interface_start interface_tail",
      "interface_start : interface_attributes INTERFACE_KW IDENTIFIER",
      "interface_init : /* empty */",
      "interface_tail : LBRACE interface_body RBRACE",
      "interface_tail : error",
      "interface_tail : error RBRACE",
      "interface_body : optional_imports exports extraneous_semi",
      "optional_imports : imports",
      "optional_imports : /* empty */",
      "imports : import",
      "imports : imports import",
      "import : IMPORT_KW error",
      "import : IMPORT_KW error SEMI",
      "import : IMPORT_KW import_files SEMI",
      "import_files : import_file",
      "import_files : import_files COMMA import_file",
      "import_file : STRING",
      "exports : export",
      "exports : exports extraneous_semi export",
      "export : type_dcl SEMI",
      "export : const_dcl SEMI",
      "export : operation_dcl SEMI",
      "export : error SEMI",
      "const_dcl : CONST_KW type_spec declarator EQUAL const_exp",
      "const_exp : expression",
      "type_dcl : TYPEDEF_KW type_declarator",
      "type_declarator : attributes type_spec declarators",
      "type_spec : simple_type_spec",
      "type_spec : constructed_type_spec",
      "simple_type_spec : floating_point_type_spec",
      "simple_type_spec : integer_type_spec",
      "simple_type_spec : char_type_spec",
      "simple_type_spec : boolean_type_spec",
      "simple_type_spec : byte_type_spec",
      "simple_type_spec : void_type_spec",
      "simple_type_spec : named_type_spec",
      "simple_type_spec : handle_type_spec",
      "constructed_type_spec : struct_type_spec",
      "constructed_type_spec : union_type_spec",
      "constructed_type_spec : enum_type_spec",
      "constructed_type_spec : pipe_type_spec",
      "named_type_spec : IDENTIFIER",
      "floating_point_type_spec : FLOAT_KW",
      "floating_point_type_spec : DOUBLE_KW",
      "extraneous_comma : /* empty */",
      "extraneous_comma : COMMA",
      "extraneous_semi : /* empty */",
      "extraneous_semi : SEMI",
      "optional_unsigned_kw : UNSIGNED_KW",
      "optional_unsigned_kw : /* empty */",
      "integer_size_spec : SMALL_KW",
      "integer_size_spec : SHORT_KW",
      "integer_size_spec : LONG_KW",
      "integer_size_spec : HYPER_KW",
      "integer_modifiers : integer_size_spec",
      "integer_modifiers : UNSIGNED_KW integer_size_spec",
      "integer_modifiers : integer_size_spec UNSIGNED_KW",
      "integer_type_spec : integer_modifiers",
      "integer_type_spec : integer_modifiers INT_KW",
      "integer_type_spec : optional_unsigned_kw INT_KW",
      "char_type_spec : optional_unsigned_kw CHAR_KW",
      "boolean_type_spec : BOOLEAN_KW",
      "byte_type_spec : BYTE_KW",
      "void_type_spec : VOID_KW",
      "handle_type_spec : HANDLE_T_KW",
      "push_name_space : LBRACE",
      "pop_name_space : RBRACE",
      "union_type_spec : UNION_KW ne_union_body",
      "union_type_spec : UNION_KW SWITCH_KW LPAREN simple_type_spec IDENTIFIER RPAREN union_body",
      "union_type_spec : UNION_KW IDENTIFIER ne_union_body",
      "union_type_spec : UNION_KW SWITCH_KW LPAREN simple_type_spec IDENTIFIER RPAREN IDENTIFIER union_body",
      "union_type_spec : UNION_KW IDENTIFIER SWITCH_KW LPAREN simple_type_spec IDENTIFIER RPAREN union_body",
      "union_type_spec : UNION_KW IDENTIFIER SWITCH_KW LPAREN simple_type_spec IDENTIFIER RPAREN IDENTIFIER union_body",
      "union_type_spec : UNION_KW IDENTIFIER",
      "ne_union_body : push_name_space ne_union_cases pop_name_space",
      "union_body : push_name_space union_cases pop_name_space",
      "ne_union_cases : ne_union_case",
      "ne_union_cases : ne_union_cases extraneous_semi ne_union_case",
      "union_cases : union_case",
      "union_cases : union_cases extraneous_semi union_case",
      "ne_union_case : ne_union_member",
      "union_case : union_case_list union_member",
      "ne_union_case_list : ne_union_case_label",
      "ne_union_case_list : ne_union_case_list COMMA ne_union_case_label",
      "union_case_list : union_case_label",
      "union_case_list : union_case_list union_case_label",
      "ne_union_case_label : const_exp",
      "union_case_label : CASE_KW const_exp COLON",
      "union_case_label : DEFAULT_KW COLON",
      "ne_union_member : attribute_opener rest_of_attribute_list SEMI",
      "ne_union_member : attribute_opener rest_of_attribute_list type_spec declarator SEMI",
      "union_member : SEMI",
      "union_member : attributes type_spec declarator SEMI",
      "struct_type_spec : STRUCT_KW push_name_space member_list pop_name_space",
      "struct_type_spec : STRUCT_KW IDENTIFIER push_name_space member_list pop_name_space",
      "struct_type_spec : STRUCT_KW IDENTIFIER",
      "member_list : member",
      "member_list : member_list extraneous_semi member",
      "member : attributes type_spec old_attribute_syntax declarators SEMI",
      "enum_type_spec : ENUM_KW enum_body",
      "enum_body : LBRACE enum_ids RBRACE",
      "enum_ids : enum_id",
      "enum_ids : enum_ids COMMA extraneous_comma enum_id",
      "enum_id : IDENTIFIER",
      "pipe_type_spec : PIPE_KW type_spec",
      "declarators : declarator",
      "declarators : declarators COMMA extraneous_comma declarator",
      "declarator : direct_declarator",
      "declarator : pointer direct_declarator",
      "pointer : STAR",
      "pointer : STAR pointer",
      "direct_declarator : IDENTIFIER",
      "direct_declarator : direct_declarator array_bounds",
      "direct_declarator : LPAREN declarator RPAREN",
      "direct_declarator : direct_declarator parameter_dcls",
      "array_bounds : LBRACKET RBRACKET",
      "array_bounds : LBRACKET STAR RBRACKET",
      "array_bounds : LBRACKET const_exp RBRACKET",
      "array_bounds : LBRACKET STAR DOTDOT STAR RBRACKET",
      "array_bounds : LBRACKET STAR DOTDOT const_exp RBRACKET",
      "array_bounds : LBRACKET const_exp DOTDOT STAR RBRACKET",
      "array_bounds : LBRACKET const_exp DOTDOT const_exp RBRACKET",
      "operation_dcl : attributes type_spec declarators",
      "operation_dcl : error declarators",
      "parameter_dcls : param_names param_list end_param_names",
      "param_names : LPAREN",
      "end_param_names : extraneous_comma RPAREN",
      "param_list : param_dcl",
      "param_list : param_list COMMA extraneous_comma param_dcl",
      "param_list : /* empty */",
      "param_dcl : attributes type_spec old_attribute_syntax declarator_or_null",
      "param_dcl : error old_attribute_syntax declarator_or_null",
      "declarator_or_null : declarator",
      "declarator_or_null : /* empty */",
      "attribute_opener : LBRACKET",
      "attribute_closer : RBRACKET",
      "bounds_opener : LPAREN",
      "bounds_closer : RPAREN",
      "old_attribute_syntax : attributes",
      "interface_attributes : attribute_opener interface_attr_list attribute_closer",
      "interface_attributes : attribute_opener error attribute_closer",
      "interface_attributes : /* empty */",
      "interface_attr_list : interface_attr",
      "interface_attr_list : interface_attr_list COMMA extraneous_comma interface_attr",
      "interface_attr_list : /* empty */",
      "interface_attr : UUID_KW error",
      "interface_attr : UUID_KW UUID_REP",
      "interface_attr : ENDPOINT_KW LPAREN port_list RPAREN",
      "interface_attr : EXCEPTIONS_KW LPAREN excep_list RPAREN",
      "interface_attr : VERSION_KW LPAREN version_number RPAREN",
      "interface_attr : LOCAL_KW",
      "interface_attr : POINTER_DEFAULT_KW LPAREN pointer_class RPAREN",
      "pointer_class : REF_KW",
      "pointer_class : PTR_KW",
      "pointer_class : UNIQUE_KW",
      "version_number : INTEGER_NUMERIC",
      "version_number : FLOAT_NUMERIC",
      "port_list : port_spec",
      "port_list : port_list COMMA extraneous_comma port_spec",
      "excep_list : excep_spec",
      "excep_list : excep_list COMMA extraneous_comma excep_spec",
      "port_spec : STRING",
      "excep_spec : IDENTIFIER",
      "fp_attribute : array_bound_type bounds_opener array_bound_id_list bounds_closer",
      "fp_attribute : neu_switch_type bounds_opener neu_switch_id bounds_closer",
      "array_bound_type : FIRST_IS_KW",
      "array_bound_type : LAST_IS_KW",
      "array_bound_type : LENGTH_IS_KW",
      "array_bound_type : MAX_IS_KW",
      "array_bound_type : MIN_IS_KW",
      "array_bound_type : SIZE_IS_KW",
      "array_bound_id_list : array_bound_id",
      "array_bound_id_list : array_bound_id_list COMMA array_bound_id",
      "array_bound_id : IDENTIFIER",
      "array_bound_id : STAR IDENTIFIER",
      "array_bound_id : /* empty */",
      "neu_switch_type : SWITCH_IS_KW",
      "neu_switch_id : IDENTIFIER",
      "neu_switch_id : STAR IDENTIFIER",
      "attributes : attribute_opener rest_of_attribute_list",
      "attributes : /* empty */",
      "rest_of_attribute_list : attribute_list attribute_closer",
      "rest_of_attribute_list : error attribute_closer",
      "rest_of_attribute_list : error SEMI",
      "attribute_list : attribute",
      "attribute_list : attribute_list COMMA extraneous_comma attribute",
      "attribute : fp_attribute",
      "attribute : BROADCAST_KW",
      "attribute : MAYBE_KW",
      "attribute : IDEMPOTENT_KW",
      "attribute : REFLECT_DELETIONS_KW",
      "attribute : PTR_KW",
      "attribute : IN_KW",
      "attribute : IN_KW LPAREN SHAPE_KW RPAREN",
      "attribute : OUT_KW",
      "attribute : OUT_KW LPAREN SHAPE_KW RPAREN",
      "attribute : V1_ARRAY_KW",
      "attribute : STRING_KW",
      "attribute : V1_STRING_KW",
      "attribute : UNIQUE_KW",
      "attribute : REF_KW",
      "attribute : IGNORE_KW",
      "attribute : CONTEXT_HANDLE_KW",
      "attribute : V1_STRUCT_KW",
      "attribute : V1_ENUM_KW",
      "attribute : ALIGN_KW LPAREN SMALL_KW RPAREN",
      "attribute : ALIGN_KW LPAREN SHORT_KW RPAREN",
      "attribute : ALIGN_KW LPAREN LONG_KW RPAREN",
      "attribute : ALIGN_KW LPAREN HYPER_KW RPAREN",
      "attribute : HANDLE_KW",
      "attribute : TRANSMIT_AS_KW LPAREN simple_type_spec RPAREN",
      "attribute : SWITCH_TYPE_KW LPAREN simple_type_spec RPAREN",
      "attribute : CASE_KW LPAREN ne_union_case_list RPAREN",
      "attribute : DEFAULT_KW",
      "attribute : IDENTIFIER",
      "expression : conditional_expression",
      "conditional_expression : logical_OR_expression",
      "conditional_expression : logical_OR_expression QUESTION expression COLON conditional_expression",
      "logical_OR_expression : logical_AND_expression",
      "logical_OR_expression : logical_OR_expression BARBAR logical_AND_expression",
      "logical_AND_expression : inclusive_OR_expression",
      "logical_AND_expression : logical_AND_expression AMPAMP inclusive_OR_expression",
      "inclusive_OR_expression : exclusive_OR_expression",
      "inclusive_OR_expression : inclusive_OR_expression BAR exclusive_OR_expression",
      "exclusive_OR_expression : AND_expression",
      "exclusive_OR_expression : exclusive_OR_expression CARET AND_expression",
      "AND_expression : equality_expression",
      "AND_expression : AND_expression AMP equality_expression",
      "equality_expression : relational_expression",
      "equality_expression : equality_expression EQUALEQUAL relational_expression",
      "equality_expression : equality_expression NOTEQUAL relational_expression",
      "relational_expression : shift_expression",
      "relational_expression : relational_expression LANGLE shift_expression",
      "relational_expression : relational_expression RANGLE shift_expression",
      "relational_expression : relational_expression LESSEQUAL shift_expression",
      "relational_expression : relational_expression GREATEREQUAL shift_expression",
      "shift_expression : additive_expression",
      "shift_expression : shift_expression LANGLEANGLE additive_expression",
      "shift_expression : shift_expression RANGLEANGLE additive_expression",
      "additive_expression : multiplicative_expression",
      "additive_expression : additive_expression PLUS multiplicative_expression",
      "additive_expression : additive_expression MINUS multiplicative_expression",
      "multiplicative_expression : cast_expression",
      "multiplicative_expression : multiplicative_expression STAR cast_expression",
      "multiplicative_expression : multiplicative_expression SLASH cast_expression",
      "multiplicative_expression : multiplicative_expression PERCENT cast_expression",
      "cast_expression : unary_expression",
      "unary_expression : primary_expression",
      "unary_expression : PLUS primary_expression",
      "unary_expression : MINUS primary_expression",
      "unary_expression : TILDE primary_expression",
      "unary_expression : NOT primary_expression",
      "primary_expression : LPAREN expression RPAREN",
      "primary_expression : INTEGER_NUMERIC",
      "primary_expression : CHAR",
      "primary_expression : IDENTIFIER",
      "primary_expression : STRING",
      "primary_expression : NULL_KW",
      "primary_expression : TRUE_KW",
      "primary_expression : FALSE_KW",
      "primary_expression : FLOAT_NUMERIC",
};
#endif /* YYDEBUG */
/* @(#)27       1.7.1.1  com/cmd/lang/yacc/yaccpar, cmdlang, bos320, 9209320f 2/19/92 16:36:02 */
/*
 * COMPONENT_NAME: (CMDLANG) Language Utilities
 *
 * FUNCTIONS: yyparse
 * ORIGINS: 03
 */
/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#ifdef YYSPLIT
#   define YYERROR      return(-2)
#else
#   define YYERROR      goto yyerrlab
#endif
#ifdef YACC_MSG
#ifndef _XOPEN_SOURCE
#define _XOPEN_SOURCE
#endif
#include <nl_types.h>
nl_catd catd;
#endif
#define YYACCEPT        return(0)
#define YYABORT         return(1)
#ifndef YACC_MSG
#define YYBACKUP( newtoken, newvalue )\
{\
        if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
        {\
                yyerror( "syntax error - cannot backup" );\
                YYERROR;\
        }\
        yychar = newtoken;\
        yystate = *yyps;\
        yylval = newvalue;\
        goto yynewstate;\
}
#else
#define YYBACKUP( newtoken, newvalue )\
{\
        if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
        {\
                catd=catopen("yacc_user.cat",0);\
                yyerror(catgets(catd,1,1,"syntax error - cannot backup" ));\
                YYERROR;\
        }\
        yychar = newtoken;\
        yystate = *yyps;\
        yylval = newvalue;\
        goto yynewstate;\
}
#endif
#define YYRECOVERING()  (!!yyerrflag)
#ifndef YYDEBUG
#       define YYDEBUG  1       /* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;                    /* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG          (-1000)

#ifdef YYSPLIT
#   define YYSCODE { \
                        extern int (*_yyf[])(); \
                        register int yyret; \
                        if (_yyf[yytmp]) \
                            if ((yyret=(*_yyf[yytmp])()) == -2) \
                                    goto yyerrlab; \
                                else if (yyret>=0) return(yyret); \
                   }
#endif

/*
** global variables used by the parser
*/
YYSTYPE yyv[ YYMAXDEPTH ];      /* value stack */
int yys[ YYMAXDEPTH ];          /* state stack */

YYSTYPE *yypv;                  /* top of value stack */
YYSTYPE *yypvt;                 /* top of value stack for $vars */
int *yyps;                      /* top of state stack */

int yystate;                    /* current state */
int yytmp;                      /* extra var (lasts between blocks) */

int yynerrs;                    /* number of errors */
int yyerrflag;                  /* error recovery flag */
int yychar;                     /* current input token number */

#ifdef __cplusplus
 #ifdef _CPP_IOSTREAMS
  #include <iostream.h>
  extern void yyerror (char *); /* error message routine -- iostream version */
 #else
  #include <stdio.h>
  extern "C" void yyerror (char *); /* error message routine -- stdio version */
 #endif /* _CPP_IOSTREAMS */
 extern "C" int yylex(void);        /* return the next token */
#endif /* __cplusplus */


/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
#ifdef __cplusplus
extern "C"
#endif /* __cplusplus */
int
yyparse()
{
        /*
        ** Initialize externals - yyparse may be called more than once
        */
        yypv = &yyv[-1];
        yyps = &yys[-1];
        yystate = 0;
        yytmp = 0;
        yynerrs = 0;
        yyerrflag = 0;
        yychar = -1;
#ifdef YACC_MSG
        catd=catopen("yacc_user.cat",0);
#endif
        goto yystack;
        {
                register YYSTYPE *yy_pv;        /* top of value stack */
                register int *yy_ps;            /* top of state stack */
                register int yy_state;          /* current state */
                register int  yy_n;             /* internal state number info */

                /*
                ** get globals into registers.
                ** branch to here only if YYBACKUP was called.
                */
        yynewstate:
                yy_pv = yypv;
                yy_ps = yyps;
                yy_state = yystate;
                goto yy_newstate;

                /*
                ** get globals into registers.
                ** either we just started, or we just finished a reduction
                */
        yystack:
                yy_pv = yypv;
                yy_ps = yyps;
                yy_state = yystate;

                /*
                ** top of for (;;) loop while no reductions done
                */
        yy_stack:
                /*
                ** put a state and value onto the stacks
                */
#if YYDEBUG
                /*
                ** if debugging, look up token value in list of value vs.
                ** name pairs.  0 and negative (-1) are special values.
                ** Note: linear search is used since time is not a real
                ** consideration while debugging.
                */
                if ( yydebug )
                {
                        register int yy_i;

#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                        cout << "State " << yy_state << " token ";
                        if ( yychar == 0 )
                                cout << "end-of-file" << endl;
                        else if ( yychar < 0 )
                                cout << "-none-" << endl;
#else
                        printf( "State %d, token ", yy_state );
                        if ( yychar == 0 )
                                printf( "end-of-file\n" );
                        else if ( yychar < 0 )
                                printf( "-none-\n" );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
                        else
                        {
                                for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
                                        yy_i++ )
                                {
                                        if ( yytoks[yy_i].t_val == yychar )
                                                break;
                                }
#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                                cout << yytoks[yy_i].t_name << endl;
#else
                                printf( "%s\n", yytoks[yy_i].t_name );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
                        }
                }
#endif /* YYDEBUG */
                if ( ++yy_ps >= &yys[ YYMAXDEPTH ] )    /* room on stack? */
                {
#ifndef YACC_MSG
                        yyerror( "yacc stack overflow" );
#else
                        yyerror(catgets(catd,1,2,"yacc stack overflow" ));
#endif
                        YYABORT;
                }
                *yy_ps = yy_state;
                *++yy_pv = yyval;

                /*
                ** we have a new state - find out what to do
                */
        yy_newstate:
                if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
                        goto yydefault;         /* simple state */
#if YYDEBUG
                /*
                ** if debugging, need to mark whether new token grabbed
                */
                yytmp = yychar < 0;
#endif
                if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
                        yychar = 0;             /* reached EOF */
#if YYDEBUG
                if ( yydebug && yytmp )
                {
                        register int yy_i;

#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                        cout << "Received token " << endl;
                        if ( yychar == 0 )
                                cout << "end-of-file" << endl;
                        else if ( yychar < 0 )
                                cout << "-none-" << endl;
#else
                        printf( "Received token " );
                        if ( yychar == 0 )
                                printf( "end-of-file\n" );
                        else if ( yychar < 0 )
                                printf( "-none-\n" );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
                        else
                        {
                                for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
                                        yy_i++ )
                                {
                                        if ( yytoks[yy_i].t_val == yychar )
                                                break;
                                }
#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                                cout << yytoks[yy_i].t_name << endl;
#else
                                printf( "%s\n", yytoks[yy_i].t_name );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
                        }
                }
#endif /* YYDEBUG */
                if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
                        goto yydefault;
                if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )  /*valid shift*/
                {
                        yychar = -1;
                        yyval = yylval;
                        yy_state = yy_n;
                        if ( yyerrflag > 0 )
                                yyerrflag--;
                        goto yy_stack;
                }

        yydefault:
                if ( ( yy_n = yydef[ yy_state ] ) == -2 )
                {
#if YYDEBUG
                        yytmp = yychar < 0;
#endif
                        if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
                                yychar = 0;             /* reached EOF */
#if YYDEBUG
                        if ( yydebug && yytmp )
                        {
                                register int yy_i;

#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                                cout << "Received token " << endl;
                                if ( yychar == 0 )
                                        cout << "end-of-file" << endl;
                                else if ( yychar < 0 )
                                        cout << "-none-" << endl;
#else
                                printf( "Received token " );
                                if ( yychar == 0 )
                                        printf( "end-of-file\n" );
                                else if ( yychar < 0 )
                                        printf( "-none-\n" );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
                                else
                                {
                                        for ( yy_i = 0;
                                                yytoks[yy_i].t_val >= 0;
                                                yy_i++ )
                                        {
                                                if ( yytoks[yy_i].t_val
                                                        == yychar )
                                                {
                                                        break;
                                                }
                                        }
#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                                        cout << yytoks[yy_i].t_name << endl;
#else
                                        printf( "%s\n", yytoks[yy_i].t_name );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
                                }
                        }
#endif /* YYDEBUG */
                        /*
                        ** look through exception table
                        */
                        {
                                register int *yyxi = yyexca;

                                while ( ( *yyxi != -1 ) ||
                                        ( yyxi[1] != yy_state ) )
                                {
                                        yyxi += 2;
                                }
                                while ( ( *(yyxi += 2) >= 0 ) &&
                                        ( *yyxi != yychar ) )
                                        ;
                                if ( ( yy_n = yyxi[1] ) < 0 )
                                        YYACCEPT;
                        }
                }

                /*
                ** check for syntax error
                */
                if ( yy_n == 0 )        /* have an error */
                {
                        /* no worry about speed here! */
                        switch ( yyerrflag )
                        {
                        case 0:         /* new error */
#ifndef YACC_MSG
                                yyerror( "syntax error" );
#else
                                yyerror(catgets(catd,1,3,"syntax error" ));
#endif
                                goto skip_init;
                        yyerrlab:
                                /*
                                ** get globals into registers.
                                ** we have a user generated syntax type error
                                */
                                yy_pv = yypv;
                                yy_ps = yyps;
                                yy_state = yystate;
                                yynerrs++;
                        skip_init:
                        case 1:
                        case 2:         /* incompletely recovered error */
                                        /* try again... */
                                yyerrflag = 3;
                                /*
                                ** find state where "error" is a legal
                                ** shift action
                                */
                                while ( yy_ps >= yys )
                                {
                                        yy_n = yypact[ *yy_ps ] + YYERRCODE;
                                        if ( yy_n >= 0 && yy_n < YYLAST &&
                                                yychk[yyact[yy_n]] == YYERRCODE)                                        {
                                                /*
                                                ** simulate shift of "error"
                                                */
                                                yy_state = yyact[ yy_n ];
                                                goto yy_stack;
                                        }
                                        /*
                                        ** current state has no shift on
                                        ** "error", pop stack
                                        */
#if YYDEBUG
                                        if ( yydebug )
#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                                            cout << "Error recovery pops state "
                                                 << (*yy_ps)
                                                 << ", uncovers state "
                                                 << yy_ps[-1] << endl;
#else
#       define _POP_ "Error recovery pops state %d, uncovers state %d\n"
                                                printf( _POP_, *yy_ps,
                                                        yy_ps[-1] );
#       undef _POP_
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
#endif
                                        yy_ps--;
                                        yy_pv--;
                                }
                                /*
                                ** there is no state on stack with "error" as
                                ** a valid shift.  give up.
                                */
                                YYABORT;
                        case 3:         /* no shift yet; eat a token */
#if YYDEBUG
                                /*
                                ** if debugging, look up token in list of
                                ** pairs.  0 and negative shouldn't occur,
                                ** but since timing doesn't matter when
                                ** debugging, it doesn't hurt to leave the
                                ** tests here.
                                */
                                if ( yydebug )
                                {
                                        register int yy_i;

#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                                        cout << "Error recovery discards ";
                                        if ( yychar == 0 )
                                            cout << "token end-of-file" << endl;
                                        else if ( yychar < 0 )
                                            cout << "token -none-" << endl;
#else
                                        printf( "Error recovery discards " );
                                        if ( yychar == 0 )
                                                printf( "token end-of-file\n" );
                                        else if ( yychar < 0 )
                                                printf( "token -none-\n" );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
                                        else
                                        {
                                                for ( yy_i = 0;
                                                        yytoks[yy_i].t_val >= 0;
                                                        yy_i++ )
                                                {
                                                        if ( yytoks[yy_i].t_val
                                                                == yychar )
                                                        {
                                                                break;
                                                        }
                                                }
#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                                                cout << "token " <<
                                                    yytoks[yy_i].t_name <<
                                                    endl;
#else
                                                printf( "token %s\n",
                                                        yytoks[yy_i].t_name );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
                                        }
                                }
#endif /* YYDEBUG */
                                if ( yychar == 0 )      /* reached EOF. quit */
                                        YYABORT;
                                yychar = -1;
                                goto yy_newstate;
                        }
                }/* end if ( yy_n == 0 ) */
                /*
                ** reduction by production yy_n
                ** put stack tops, etc. so things right after switch
                */
#if YYDEBUG
                /*
                ** if debugging, print the string that is the user's
                ** specification of the reduction which is just about
                ** to be done.
                */
                if ( yydebug )
#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                        cout << "Reduce by (" << yy_n << ") \"" <<
                            yyreds[ yy_n ] << "\"\n";
#else
                        printf( "Reduce by (%d) \"%s\"\n",
                                yy_n, yyreds[ yy_n ] );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
#endif
                yytmp = yy_n;                   /* value to switch over */
                yypvt = yy_pv;                  /* $vars top of value stack */
                /*
                ** Look in goto table for next state
                ** Sorry about using yy_state here as temporary
                ** register variable, but why not, if it works...
                ** If yyr2[ yy_n ] doesn't have the low order bit
                ** set, then there is no action to be done for
                ** this reduction.  So, no saving & unsaving of
                ** registers done.  The only difference between the
                ** code just after the if and the body of the if is
                ** the goto yy_stack in the body.  This way the test
                ** can be made before the choice of what to do is needed.
                */
                {
                        /* length of production doubled with extra bit */
                        register int yy_len = yyr2[ yy_n ];

                        if ( !( yy_len & 01 ) )
                        {
                                yy_len >>= 1;
                                yyval = ( yy_pv -= yy_len )[1]; /* $$ = $1 */
                                yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
                                        *( yy_ps -= yy_len ) + 1;
                                if ( yy_state >= YYLAST ||
                                        yychk[ yy_state =
                                        yyact[ yy_state ] ] != -yy_n )
                                {
                                        yy_state = yyact[ yypgo[ yy_n ] ];
                                }
                                goto yy_stack;
                        }
                        yy_len >>= 1;
                        yyval = ( yy_pv -= yy_len )[1]; /* $$ = $1 */
                        yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
                                *( yy_ps -= yy_len ) + 1;
                        if ( yy_state >= YYLAST ||
                                yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
                        {
                                yy_state = yyact[ yypgo[ yy_n ] ];
                        }
                }
                                        /* save until reenter driver code */
                yystate = yy_state;
                yyps = yy_ps;
                yypv = yy_pv;
        }
        /*
        ** code supplied by user is placed in this switch
        */

                switch(yytmp){

case 1:
# line 244 "nidl.y"
{
            AST_finish_interface_node(the_interface);
        } /*NOTREACHED*/ break;
case 2:
# line 251 "nidl.y"
{
            the_interface->name = yypvt[-0].y_id;
            ASTP_add_name_binding(the_interface->name, (char *)the_interface);
        } /*NOTREACHED*/ break;
case 3:
# line 259 "nidl.y"
{
            STRTAB_str_t nidl_idl_str;
            nidl_idl_str = STRTAB_add_string (AUTO_IMPORT_FILE);
            the_interface = AST_interface_node();
            the_interface->imports = AST_import_node(nidl_idl_str);
            the_interface->imports->interface = FE_parse_import (nidl_idl_str);
            if (the_interface->imports->interface != NULL)
            {
                AST_CLR_OUT_OF_LINE(the_interface->imports->interface);
                AST_SET_IN_LINE(the_interface->imports->interface);
            }
        } /*NOTREACHED*/ break;
case 4:
# line 275 "nidl.y"
{ yyval.y_interface = yypvt[-1].y_interface; } /*NOTREACHED*/ break;
case 5:
# line 277 "nidl.y"
{
            yyval.y_interface = NULL;
            log_error(yylineno,NIDL_MISSONINTER);
        } /*NOTREACHED*/ break;
case 6:
# line 282 "nidl.y"
{
            yyval.y_interface = NULL;
        } /*NOTREACHED*/ break;
case 7:
# line 290 "nidl.y"
{
            /* May already be an import of nbase, so concat */
            the_interface->imports = (AST_import_n_t *) AST_concat_element(
                                        (ASTP_node_t *) the_interface->imports,
                                        (ASTP_node_t *) yypvt[-2].y_import);
            the_interface->exports = yypvt[-1].y_export;
        } /*NOTREACHED*/ break;
case 9:
# line 302 "nidl.y"
{
            yyval.y_import = (AST_import_n_t *)NULL;
        } /*NOTREACHED*/ break;
case 11:
# line 309 "nidl.y"
{
                yyval.y_import = (AST_import_n_t *) AST_concat_element(
                                                (ASTP_node_t *) yypvt[-1].y_import,
                                                (ASTP_node_t *) yypvt[-0].y_import);
        } /*NOTREACHED*/ break;
case 12:
# line 318 "nidl.y"
{
            yyval.y_import = (AST_import_n_t *)NULL;
        } /*NOTREACHED*/ break;
case 13:
# line 322 "nidl.y"
{
            yyval.y_import = (AST_import_n_t *)NULL;
        } /*NOTREACHED*/ break;
case 14:
# line 326 "nidl.y"
{
            yyval.y_import = yypvt[-1].y_import;
        } /*NOTREACHED*/ break;
case 16:
# line 334 "nidl.y"
{
                yyval.y_import = (AST_import_n_t *) AST_concat_element(
                                                (ASTP_node_t *) yypvt[-2].y_import,
                                                (ASTP_node_t *) yypvt[-0].y_import);
        } /*NOTREACHED*/ break;
case 17:
# line 345 "nidl.y"
{
            AST_interface_n_t  *int_p;
            int_p = FE_parse_import (yypvt[-0].y_string);
            if (int_p != (AST_interface_n_t *)NULL)
            {
                yyval.y_import = AST_import_node(yypvt[-0].y_string);
                yyval.y_import->interface = int_p;
            }
            else
                yyval.y_import = (AST_import_n_t *)NULL;
        } /*NOTREACHED*/ break;
case 19:
# line 361 "nidl.y"
{
                yyval.y_export = (AST_export_n_t *) AST_concat_element(
                                            (ASTP_node_t *) yypvt[-2].y_export,
                                            (ASTP_node_t *) yypvt[-0].y_export) ;
        } /*NOTREACHED*/ break;
case 20:
# line 371 "nidl.y"
{
                yyval.y_export = AST_types_to_exports (yypvt[-1].y_type_ptr);
        } /*NOTREACHED*/ break;
case 21:
# line 375 "nidl.y"
{
                yyval.y_export = AST_export_node (
                        (ASTP_node_t *) yypvt[-1].y_constant, AST_constant_k);
        } /*NOTREACHED*/ break;
case 22:
# line 380 "nidl.y"
{
            if (ASTP_parsing_main_idl)
                yyval.y_export = AST_export_node (
                        (ASTP_node_t *) yypvt[-1].y_operation, AST_operation_k);
        } /*NOTREACHED*/ break;
case 23:
# line 386 "nidl.y"
{
            yyval.y_export = (AST_export_n_t *)NULL;
        } /*NOTREACHED*/ break;
case 24:
# line 394 "nidl.y"
{
           yyval.y_constant = AST_finish_constant_node (yypvt[-0].y_constant,
                                        yypvt[-2].y_declarator, yypvt[-3].y_type);
        } /*NOTREACHED*/ break;
case 25:
# line 402 "nidl.y"
{
            if (yypvt[-0].y_exp.type == AST_int_const_k)
                yyval.y_constant = AST_integer_constant (yypvt[-0].y_exp.val.integer) ;
            else
                yyval.y_constant = yypvt[-0].y_exp.val.other;
        } /*NOTREACHED*/ break;
case 26:
# line 413 "nidl.y"
{
            yyval.y_type_ptr = yypvt[-0].y_type_ptr;
        } /*NOTREACHED*/ break;
case 27:
# line 420 "nidl.y"
{
            yyval.y_type_ptr  = AST_declarators_to_types(yypvt[-1].y_type,
                        yypvt[-0].y_declarator, &yypvt[-2].y_attributes) ;
            ASTP_free_simple_list((ASTP_node_t *)yypvt[-2].y_attributes.bounds);
        } /*NOTREACHED*/ break;
case 42:
# line 455 "nidl.y"
{
            yyval.y_type = AST_lookup_named_type(yypvt[-0].y_id);
        } /*NOTREACHED*/ break;
case 43:
# line 462 "nidl.y"
{
            yyval.y_type = AST_lookup_type_node(AST_short_float_k);
        } /*NOTREACHED*/ break;
case 44:
# line 466 "nidl.y"
{
            yyval.y_type = AST_lookup_type_node(AST_long_float_k);
        } /*NOTREACHED*/ break;
case 46:
# line 474 "nidl.y"
{ log_warning(yylineno, NIDL_EXTRAPUNCT, ",");} /*NOTREACHED*/ break;
case 48:
# line 480 "nidl.y"
{ log_warning(yylineno, NIDL_EXTRAPUNCT, ";");} /*NOTREACHED*/ break;
case 49:
# line 484 "nidl.y"
{ yyval.y_ival = false; } /*NOTREACHED*/ break;
case 50:
# line 485 "nidl.y"
{ yyval.y_ival = true; } /*NOTREACHED*/ break;
case 51:
# line 490 "nidl.y"
{
            yyval.y_int_info.int_size = AST_small_integer_k;
            yyval.y_int_info.int_signed = true;
        } /*NOTREACHED*/ break;
case 52:
# line 495 "nidl.y"
{
            yyval.y_int_info.int_size = AST_short_integer_k;
            yyval.y_int_info.int_signed = true;
        } /*NOTREACHED*/ break;
case 53:
# line 500 "nidl.y"
{
            yyval.y_int_info.int_size = AST_long_integer_k;
            yyval.y_int_info.int_signed = true;
        } /*NOTREACHED*/ break;
case 54:
# line 505 "nidl.y"
{
            yyval.y_int_info.int_size = AST_hyper_integer_k;
            yyval.y_int_info.int_signed = true;
        } /*NOTREACHED*/ break;
case 55:
# line 513 "nidl.y"
{ yyval.y_int_info = yypvt[-0].y_int_info; } /*NOTREACHED*/ break;
case 56:
# line 515 "nidl.y"
{
            yyval.y_int_info.int_size = yypvt[-0].y_int_info.int_size;
            yyval.y_int_info.int_signed = false;
        } /*NOTREACHED*/ break;
case 57:
# line 520 "nidl.y"
{
            yyval.y_int_info.int_size = yypvt[-1].y_int_info.int_size;
            yyval.y_int_info.int_signed = false;
        } /*NOTREACHED*/ break;
case 58:
# line 528 "nidl.y"
{ yyval.y_type = AST_lookup_integer_type_node(yypvt[-0].y_int_info.int_size,yypvt[-0].y_int_info.int_signed); } /*NOTREACHED*/ break;
case 59:
# line 530 "nidl.y"
{ yyval.y_type = AST_lookup_integer_type_node(yypvt[-1].y_int_info.int_size,yypvt[-1].y_int_info.int_signed); } /*NOTREACHED*/ break;
case 60:
# line 532 "nidl.y"
{
            log_warning(yylineno,NIDL_INTSIZEREQ);
            yyval.y_type = AST_lookup_integer_type_node(AST_long_integer_k,yypvt[-1].y_ival);
        } /*NOTREACHED*/ break;
case 61:
# line 540 "nidl.y"
{ yyval.y_type = AST_lookup_type_node(AST_character_k); } /*NOTREACHED*/ break;
case 62:
# line 545 "nidl.y"
{ yyval.y_type = AST_lookup_type_node(AST_boolean_k); } /*NOTREACHED*/ break;
case 63:
# line 550 "nidl.y"
{ yyval.y_type = AST_lookup_type_node(AST_byte_k); } /*NOTREACHED*/ break;
case 64:
# line 555 "nidl.y"
{ yyval.y_type = AST_lookup_type_node(AST_void_k); } /*NOTREACHED*/ break;
case 65:
# line 560 "nidl.y"
{ yyval.y_type = AST_lookup_type_node(AST_handle_k); } /*NOTREACHED*/ break;
case 66:
# line 565 "nidl.y"
{
            NAMETABLE_push_level ();
        } /*NOTREACHED*/ break;
case 67:
# line 572 "nidl.y"
{
            ASTP_patch_field_reference ();
            NAMETABLE_pop_level ();
        } /*NOTREACHED*/ break;
case 68:
# line 580 "nidl.y"
{
        yyval.y_type = AST_disc_union_node(
                         NAMETABLE_NIL_ID,      /* tag name          */
                         NAMETABLE_NIL_ID,      /* union name        */
                         NAMETABLE_NIL_ID,      /* discriminant name */
                         NULL,                  /* discriminant type */
                         yypvt[-0].y_arm );           /* the arm list      */
        } /*NOTREACHED*/ break;
case 69:
# line 590 "nidl.y"
{
        yyval.y_type = AST_disc_union_node(
                         NAMETABLE_NIL_ID,      /* tag name          */
                         ASTP_tagged_union_id,  /* union name        */
                         yypvt[-2].y_id,              /* discriminant name */
                         yypvt[-3].y_type,            /* discriminant type */
                         yypvt[-0].y_arm );           /* the arm list      */
        } /*NOTREACHED*/ break;
case 70:
# line 599 "nidl.y"
{
        yyval.y_type = AST_disc_union_node(
                         yypvt[-1].y_id,              /* tag name          */
                         NAMETABLE_NIL_ID,      /* union name        */
                         NAMETABLE_NIL_ID,      /* discriminant name */
                         NULL,                  /* discriminant type */
                         yypvt[-0].y_arm );           /* the arm list      */
        } /*NOTREACHED*/ break;
case 71:
# line 608 "nidl.y"
{
        yyval.y_type = AST_disc_union_node(
                         NAMETABLE_NIL_ID,      /* tag name          */
                         yypvt[-1].y_id,              /* union name        */
                         yypvt[-3].y_id,              /* discriminant name */
                         yypvt[-4].y_type,            /* discriminant type */
                         yypvt[-0].y_arm );           /* the arm list      */
        } /*NOTREACHED*/ break;
case 72:
# line 617 "nidl.y"
{
        yyval.y_type = AST_disc_union_node(
                         yypvt[-6].y_id,              /* tag name          */
                         ASTP_tagged_union_id,  /* union name        */
                         yypvt[-2].y_id,              /* discriminant name */
                         yypvt[-3].y_type,            /* discriminant type */
                         yypvt[-0].y_arm );           /* the arm list      */
        } /*NOTREACHED*/ break;
case 73:
# line 626 "nidl.y"
{
        yyval.y_type = AST_disc_union_node(
                         yypvt[-7].y_id,              /* tag name          */
                         yypvt[-1].y_id,              /* union name        */
                         yypvt[-3].y_id,              /* discriminant name */
                         yypvt[-4].y_type,            /* discriminant type */
                         yypvt[-0].y_arm );           /* the arm list      */
        } /*NOTREACHED*/ break;
case 74:
# line 635 "nidl.y"
{
            yyval.y_type = AST_type_from_tag (AST_disc_union_k, yypvt[-0].y_id);
        } /*NOTREACHED*/ break;
case 75:
# line 642 "nidl.y"
{
                yyval.y_arm = yypvt[-1].y_arm;
        } /*NOTREACHED*/ break;
case 76:
# line 648 "nidl.y"
{
                yyval.y_arm = yypvt[-1].y_arm;
        } /*NOTREACHED*/ break;
case 78:
# line 656 "nidl.y"
{
            yyval.y_arm = (AST_arm_n_t *) AST_concat_element(
                                        (ASTP_node_t *) yypvt[-2].y_arm,
                                        (ASTP_node_t *) yypvt[-0].y_arm);
        } /*NOTREACHED*/ break;
case 80:
# line 665 "nidl.y"
{
            yyval.y_arm = (AST_arm_n_t *) AST_concat_element(
                                        (ASTP_node_t *) yypvt[-2].y_arm,
                                        (ASTP_node_t *) yypvt[-0].y_arm);
        } /*NOTREACHED*/ break;
case 81:
# line 674 "nidl.y"
{
            yyval.y_arm = yypvt[-0].y_arm;
        } /*NOTREACHED*/ break;
case 82:
# line 680 "nidl.y"
{
            yyval.y_arm = AST_label_arm(yypvt[-0].y_arm, yypvt[-1].y_label) ;
        } /*NOTREACHED*/ break;
case 84:
# line 688 "nidl.y"
{
            yyval.y_label = (AST_case_label_n_t *) AST_concat_element(
                                        (ASTP_node_t *) yypvt[-2].y_label,
                                        (ASTP_node_t *) yypvt[-0].y_label);
        } /*NOTREACHED*/ break;
case 86:
# line 697 "nidl.y"
{
            yyval.y_label = (AST_case_label_n_t *) AST_concat_element(
                                        (ASTP_node_t *) yypvt[-1].y_label,
                                        (ASTP_node_t *) yypvt[-0].y_label);
        } /*NOTREACHED*/ break;
case 87:
# line 706 "nidl.y"
{
            yyval.y_label = AST_case_label_node(yypvt[-0].y_constant);
        } /*NOTREACHED*/ break;
case 88:
# line 712 "nidl.y"
{
            yyval.y_label = AST_case_label_node(yypvt[-1].y_constant);
        } /*NOTREACHED*/ break;
case 89:
# line 716 "nidl.y"
{
            yyval.y_label = AST_default_case_label_node();
        } /*NOTREACHED*/ break;
case 90:
# line 723 "nidl.y"
{
            yyval.y_arm = AST_declarator_to_arm(NULL, NULL, &yypvt[-1].y_attributes);
            ASTP_free_simple_list((ASTP_node_t *)yypvt[-1].y_attributes.bounds);
        } /*NOTREACHED*/ break;
case 91:
# line 728 "nidl.y"
{
            yyval.y_arm = AST_declarator_to_arm(yypvt[-2].y_type,
                                yypvt[-1].y_declarator, &yypvt[-3].y_attributes);
            ASTP_free_simple_list((ASTP_node_t *)yypvt[-3].y_attributes.bounds);
        } /*NOTREACHED*/ break;
case 92:
# line 736 "nidl.y"
{
            yyval.y_arm = AST_arm_node(NAMETABLE_NIL_ID,NULL,NULL);
        } /*NOTREACHED*/ break;
case 93:
# line 740 "nidl.y"
{
            if (ASTP_TEST_ATTR(&yypvt[-3].y_attributes, ASTP_CASE))
            {
                ASTP_attr_flag_t attr1 = ASTP_CASE;
                log_error(yylineno, NIDL_EUMEMATTR,
                      KEYWORDS_lookup_text(AST_attribute_to_token(&attr1)));
            }
            if (ASTP_TEST_ATTR(&yypvt[-3].y_attributes, ASTP_DEFAULT))
            {
                ASTP_attr_flag_t attr1 = ASTP_DEFAULT;
                log_error(yylineno, NIDL_EUMEMATTR,
                      KEYWORDS_lookup_text(AST_attribute_to_token(&attr1)));
            }
            yyval.y_arm = AST_declarator_to_arm(yypvt[-2].y_type,
                                yypvt[-1].y_declarator, &yypvt[-3].y_attributes);
            ASTP_free_simple_list((ASTP_node_t *)yypvt[-3].y_attributes.bounds);
        } /*NOTREACHED*/ break;
case 94:
# line 761 "nidl.y"
{
            yyval.y_type = AST_structure_node(yypvt[-1].y_field, NAMETABLE_NIL_ID) ;
        } /*NOTREACHED*/ break;
case 95:
# line 765 "nidl.y"
{
            yyval.y_type = AST_structure_node(yypvt[-1].y_field, yypvt[-3].y_id) ;
        } /*NOTREACHED*/ break;
case 96:
# line 769 "nidl.y"
{
            yyval.y_type = AST_type_from_tag (AST_structure_k, yypvt[-0].y_id);
        } /*NOTREACHED*/ break;
case 98:
# line 777 "nidl.y"
{
            yyval.y_field = (AST_field_n_t *)AST_concat_element(
                                    (ASTP_node_t *) yypvt[-2].y_field,
                                    (ASTP_node_t *) yypvt[-0].y_field) ;
        } /*NOTREACHED*/ break;
case 99:
# line 786 "nidl.y"
{
            yyval.y_field = AST_declarators_to_fields(yypvt[-1].y_declarator,
                                                    yypvt[-3].y_type,
                                                    &yypvt[-4].y_attributes);
            ASTP_free_simple_list((ASTP_node_t *)yypvt[-4].y_attributes.bounds);
        } /*NOTREACHED*/ break;
case 100:
# line 796 "nidl.y"
{
             yyval.y_type = AST_enumerator_node(yypvt[-0].y_constant, AST_short_integer_k);
        } /*NOTREACHED*/ break;
case 101:
# line 803 "nidl.y"
{
            yyval.y_constant = yypvt[-1].y_constant ;
        } /*NOTREACHED*/ break;
case 103:
# line 811 "nidl.y"
{
            yyval.y_constant = (AST_constant_n_t *) AST_concat_element(
                                    (ASTP_node_t *) yypvt[-3].y_constant,
                                    (ASTP_node_t *) yypvt[-0].y_constant) ;
        } /*NOTREACHED*/ break;
case 104:
# line 820 "nidl.y"
{
            yyval.y_constant  = AST_enum_constant(yypvt[-0].y_id) ;
        } /*NOTREACHED*/ break;
case 105:
# line 827 "nidl.y"
{
            yyval.y_type = AST_pipe_node (yypvt[-0].y_type);
        } /*NOTREACHED*/ break;
case 107:
# line 835 "nidl.y"
{
            yyval.y_declarator = (ASTP_declarator_n_t *) AST_concat_element(
                                            (ASTP_node_t *) yypvt[-3].y_declarator,
                                            (ASTP_node_t *) yypvt[-0].y_declarator) ;
        } /*NOTREACHED*/ break;
case 108:
# line 846 "nidl.y"
{ yyval.y_declarator = yypvt[-0].y_declarator; } /*NOTREACHED*/ break;
case 109:
# line 848 "nidl.y"
{
                yyval.y_declarator = yypvt[-0].y_declarator;
                AST_declarator_operation(yyval.y_declarator, AST_pointer_k,
                        (ASTP_node_t *)NULL, yypvt[-1].y_ival );
            } /*NOTREACHED*/ break;
case 110:
# line 857 "nidl.y"
{ yyval.y_ival = 1;} /*NOTREACHED*/ break;
case 111:
# line 859 "nidl.y"
{ yyval.y_ival = yypvt[-0].y_ival + 1; } /*NOTREACHED*/ break;
case 112:
# line 864 "nidl.y"
{ yyval.y_declarator = AST_declarator_node ( yypvt[-0].y_id ); } /*NOTREACHED*/ break;
case 113:
# line 866 "nidl.y"
{
                yyval.y_declarator = yyval.y_declarator;
                AST_declarator_operation(yyval.y_declarator, AST_array_k,
                        (ASTP_node_t *) yypvt[-0].y_index, 0 );
            } /*NOTREACHED*/ break;
case 114:
# line 872 "nidl.y"
{
            yyval.y_declarator = yypvt[-1].y_declarator;
            } /*NOTREACHED*/ break;
case 115:
# line 876 "nidl.y"
{
                yyval.y_declarator = yyval.y_declarator;
                AST_declarator_operation(yyval.y_declarator, AST_function_k,
                        (ASTP_node_t *) yypvt[-0].y_parameter, 0 );
            } /*NOTREACHED*/ break;
case 116:
# line 904 "nidl.y"
{
            yyval.y_index = ASTP_array_index_node ( NULL, ASTP_default_bound,
                                                 NULL, ASTP_open_bound);
        } /*NOTREACHED*/ break;
case 117:
# line 909 "nidl.y"
{
            yyval.y_index = ASTP_array_index_node  ( NULL, ASTP_default_bound,
                                                 NULL, ASTP_open_bound);
        } /*NOTREACHED*/ break;
case 118:
# line 914 "nidl.y"
{
            yyval.y_index = ASTP_array_index_node  ( NULL, ASTP_default_bound,
                                                 yypvt[-1].y_constant, ASTP_constant_bound);
        } /*NOTREACHED*/ break;
case 119:
# line 919 "nidl.y"
{
            yyval.y_index = ASTP_array_index_node  ( NULL, ASTP_open_bound,
                                                 NULL, ASTP_open_bound);
        } /*NOTREACHED*/ break;
case 120:
# line 924 "nidl.y"
{
            yyval.y_index = ASTP_array_index_node  ( NULL, ASTP_open_bound,
                                                 yypvt[-1].y_constant, ASTP_constant_bound);
        } /*NOTREACHED*/ break;
case 121:
# line 929 "nidl.y"
{
            yyval.y_index = ASTP_array_index_node  ( yypvt[-3].y_constant, ASTP_constant_bound,
                                                 NULL, ASTP_open_bound);
        } /*NOTREACHED*/ break;
case 122:
# line 934 "nidl.y"
{
            yyval.y_index = ASTP_array_index_node  ( yypvt[-3].y_constant, ASTP_constant_bound,
                                                 yypvt[-1].y_constant, ASTP_constant_bound);
        } /*NOTREACHED*/ break;
case 123:
# line 943 "nidl.y"
{
            if (ASTP_parsing_main_idl)
                yyval.y_operation = AST_operation_node (
                                    yypvt[-1].y_type,         /*The type node*/
                                    yypvt[-0].y_declarator,   /* Declarator list */
                                   &yypvt[-2].y_attributes);  /* attributes */
            ASTP_free_simple_list((ASTP_node_t *)yypvt[-2].y_attributes.bounds);
        } /*NOTREACHED*/ break;
case 124:
# line 952 "nidl.y"
{
        log_error(yylineno,NIDL_MISSONOP);
        yyval.y_operation = NULL;
        } /*NOTREACHED*/ break;
case 125:
# line 960 "nidl.y"
{
            yyval.y_parameter = yypvt[-1].y_parameter;
        } /*NOTREACHED*/ break;
case 126:
# line 967 "nidl.y"
{
        NAMETABLE_push_level ();
        } /*NOTREACHED*/ break;
case 127:
# line 974 "nidl.y"
{
        ASTP_patch_field_reference ();
        NAMETABLE_pop_level ();
        } /*NOTREACHED*/ break;
case 129:
# line 983 "nidl.y"
{
            if (ASTP_parsing_main_idl)
                yyval.y_parameter = (AST_parameter_n_t *) AST_concat_element(
                                    (ASTP_node_t *) yypvt[-3].y_parameter,
                                    (ASTP_node_t *) yypvt[-0].y_parameter);
        } /*NOTREACHED*/ break;
case 130:
# line 990 "nidl.y"
{
            yyval.y_parameter = (AST_parameter_n_t *)NULL;
        } /*NOTREACHED*/ break;
case 131:
# line 997 "nidl.y"
{
            /*
             * We have to use special code here to allow (void) as a parameter
             * specification.  If there are no declarators, then we need to
             * make sure that the type is void and that there are no attributes .
             */
            if (yypvt[-0].y_declarator == NULL)
            {
                /*
                 * If the type is not void or some attribute is specified,
                 * there is a syntax error.  Force a yacc error, so that
                 * we can safely recover from the lack of a declarator.
                 */
                if ((yypvt[-2].y_type->kind != AST_void_k) ||
                   (yypvt[-3].y_attributes.bounds != NULL) ||
                   (yypvt[-3].y_attributes.attr_flags != 0))
                {
                    yywhere();  /* Issue a syntax error for this line */
                    YYERROR;    /* Allow natural error recovery */
                }

                yyval.y_parameter = (AST_parameter_n_t *)NULL;
            }
            else
            {
                if (ASTP_parsing_main_idl)
                    yyval.y_parameter = AST_declarator_to_param(
                                            &yypvt[-3].y_attributes,
                                            yypvt[-2].y_type,
                                            yypvt[-0].y_declarator);
            }
            ASTP_free_simple_list((ASTP_node_t *)yypvt[-3].y_attributes.bounds);
        } /*NOTREACHED*/ break;
case 132:
# line 1031 "nidl.y"
{
            log_error(yylineno, NIDL_MISSONPARAM);
            yyval.y_parameter = (AST_parameter_n_t *)NULL;
        } /*NOTREACHED*/ break;
case 133:
# line 1039 "nidl.y"
{ yyval.y_declarator = yypvt[-0].y_declarator; } /*NOTREACHED*/ break;
case 134:
# line 1041 "nidl.y"
{ yyval.y_declarator = NULL; } /*NOTREACHED*/ break;
case 135:
# line 1057 "nidl.y"
{
            search_attributes_table = true;
        } /*NOTREACHED*/ break;
case 136:
# line 1064 "nidl.y"
{
            search_attributes_table = false;
        } /*NOTREACHED*/ break;
case 137:
# line 1071 "nidl.y"
{
            search_attributes_table = false;
        } /*NOTREACHED*/ break;
case 138:
# line 1078 "nidl.y"
{
            search_attributes_table = true;
        } /*NOTREACHED*/ break;
case 139:
# line 1090 "nidl.y"
{
            /* Give an error on notranslated sources */
            if ((yypvt[-0].y_attributes.bounds != NULL) ||
               (yypvt[-0].y_attributes.attr_flags != 0))
            {
                log_error(yylineno,NIDL_ATTRTRANS);
                ASTP_free_simple_list((ASTP_node_t *)yypvt[-0].y_attributes.bounds);
            }
        } /*NOTREACHED*/ break;
case 141:
# line 1111 "nidl.y"
{
            log_error(yylineno,NIDL_ERRINATTR);
        } /*NOTREACHED*/ break;
case 146:
# line 1126 "nidl.y"
{
            log_error(yylineno,NIDL_SYNTAXUUID);
        } /*NOTREACHED*/ break;
case 147:
# line 1130 "nidl.y"
{
            {
                if (ASTP_IF_AF_SET(the_interface,ASTP_IF_UUID))
                        log_error(yylineno, NIDL_ATTRUSEMULT);
                ASTP_SET_IF_AF(the_interface,ASTP_IF_UUID);
                the_interface->uuid = yypvt[-0].y_uuid;
            }
        } /*NOTREACHED*/ break;
case 148:
# line 1139 "nidl.y"
{
            if (ASTP_IF_AF_SET(the_interface,ASTP_IF_PORT))
                    log_error(yylineno, NIDL_ATTRUSEMULT);
            ASTP_SET_IF_AF(the_interface,ASTP_IF_PORT);
        } /*NOTREACHED*/ break;
case 149:
# line 1145 "nidl.y"
{
            if (ASTP_IF_AF_SET(the_interface, ASTP_IF_EXCEPTIONS))
                log_error(yylineno, NIDL_ATTRUSEMULT);
            ASTP_SET_IF_AF(the_interface, ASTP_IF_EXCEPTIONS);
        } /*NOTREACHED*/ break;
case 150:
# line 1151 "nidl.y"
{
            {
                if (ASTP_IF_AF_SET(the_interface,ASTP_IF_VERSION))
                        log_error(yylineno, NIDL_ATTRUSEMULT);
                ASTP_SET_IF_AF(the_interface,ASTP_IF_VERSION);
            }

        } /*NOTREACHED*/ break;
case 151:
# line 1160 "nidl.y"
{
            {
                if (AST_LOCAL_SET(the_interface))
                        log_warning(yylineno, NIDL_MULATTRDEF);
                AST_SET_LOCAL(the_interface);
            }
        } /*NOTREACHED*/ break;
case 152:
# line 1168 "nidl.y"
{
            if (interface_pointer_class != 0)
                    log_error(yylineno, NIDL_ATTRUSEMULT);
            interface_pointer_class = yypvt[-1].y_ival;
        } /*NOTREACHED*/ break;
case 153:
# line 1176 "nidl.y"
{ yyval.y_ival = ASTP_REF; } /*NOTREACHED*/ break;
case 154:
# line 1177 "nidl.y"
{ yyval.y_ival = ASTP_PTR; } /*NOTREACHED*/ break;
case 155:
# line 1178 "nidl.y"
{ yyval.y_ival = ASTP_UNIQUE; } /*NOTREACHED*/ break;
case 156:
# line 1183 "nidl.y"
{
            the_interface->version = yypvt[-0].y_ival;
            if (yypvt[-0].y_ival > (unsigned int)ASTP_C_USHORT_MAX)
                log_error(yylineno, NIDL_MAJORTOOLARGE, ASTP_C_USHORT_MAX);
        } /*NOTREACHED*/ break;
case 157:
# line 1189 "nidl.y"
{
            char    *float_text;
            unsigned int            major_version,minor_version;
            STRTAB_str_to_string(yypvt[-0].y_string, &float_text);
            sscanf(float_text,"%d.%d",&major_version,&minor_version);
            if (major_version > (unsigned int)ASTP_C_USHORT_MAX)
                log_error(yylineno, NIDL_MAJORTOOLARGE, ASTP_C_USHORT_MAX);
            if (minor_version > (unsigned int)ASTP_C_USHORT_MAX)
                log_error(yylineno, NIDL_MINORTOOLARGE, ASTP_C_USHORT_MAX);
            the_interface->version = (minor_version * 65536) + major_version;
        } /*NOTREACHED*/ break;
case 160:
# line 1209 "nidl.y"
{
            the_interface->exceptions = yypvt[-0].y_exception;
        } /*NOTREACHED*/ break;
case 161:
# line 1213 "nidl.y"
{
            yyval.y_exception = (AST_exception_n_t *) AST_concat_element(
                                (ASTP_node_t *) the_interface->exceptions,
                                (ASTP_node_t *) yypvt[-0].y_exception );
        } /*NOTREACHED*/ break;
case 162:
# line 1222 "nidl.y"
{
            ASTP_parse_port(the_interface,yypvt[-0].y_string);
        } /*NOTREACHED*/ break;
case 163:
# line 1229 "nidl.y"
{
            if (ASTP_parsing_main_idl)
                yyval.y_exception = AST_exception_node(yypvt[-0].y_id);
            else
                yyval.y_exception = NULL;
        } /*NOTREACHED*/ break;
case 164:
# line 1247 "nidl.y"
{
            yyval.y_attributes.bounds = yypvt[-1].y_attributes.bounds;
            yyval.y_attributes.attr_flags = 0;
        } /*NOTREACHED*/ break;
case 165:
# line 1252 "nidl.y"
{
            yyval.y_attributes.bounds = yypvt[-1].y_attributes.bounds;
            yyval.y_attributes.attr_flags = 0;
        } /*NOTREACHED*/ break;
case 166:
# line 1260 "nidl.y"
{
            ASTP_bound_type = first_is_k;
        } /*NOTREACHED*/ break;
case 167:
# line 1264 "nidl.y"
{
            ASTP_bound_type = last_is_k;
        } /*NOTREACHED*/ break;
case 168:
# line 1268 "nidl.y"
{
            ASTP_bound_type = length_is_k;
        } /*NOTREACHED*/ break;
case 169:
# line 1272 "nidl.y"
{
            ASTP_bound_type = max_is_k;
        } /*NOTREACHED*/ break;
case 170:
# line 1276 "nidl.y"
{
            ASTP_bound_type = min_is_k;
        } /*NOTREACHED*/ break;
case 171:
# line 1280 "nidl.y"
{
            ASTP_bound_type = size_is_k;
        } /*NOTREACHED*/ break;
case 173:
# line 1289 "nidl.y"
{
        yyval.y_attributes.bounds = (ASTP_type_attr_n_t *) AST_concat_element (
                                (ASTP_node_t*) yypvt[-2].y_attributes.bounds,
                                (ASTP_node_t*) yypvt[-0].y_attributes.bounds);
        } /*NOTREACHED*/ break;
case 174:
# line 1298 "nidl.y"
{
        yyval.y_attributes.bounds = AST_array_bound_info (yypvt[-0].y_id, ASTP_bound_type, FALSE);
        } /*NOTREACHED*/ break;
case 175:
# line 1302 "nidl.y"
{
        yyval.y_attributes.bounds = AST_array_bound_info (yypvt[-0].y_id, ASTP_bound_type, TRUE);
        } /*NOTREACHED*/ break;
case 176:
# line 1306 "nidl.y"
{
        yyval.y_attributes.bounds = AST_array_bound_info (NAMETABLE_NIL_ID, ASTP_bound_type, FALSE);
        } /*NOTREACHED*/ break;
case 177:
# line 1313 "nidl.y"
{
            ASTP_bound_type = switch_is_k;
        } /*NOTREACHED*/ break;
case 178:
# line 1320 "nidl.y"
{
        yyval.y_attributes.bounds = AST_array_bound_info (yypvt[-0].y_id, ASTP_bound_type, FALSE);
        } /*NOTREACHED*/ break;
case 179:
# line 1324 "nidl.y"
{
        yyval.y_attributes.bounds = AST_array_bound_info (yypvt[-0].y_id, ASTP_bound_type, TRUE);
        } /*NOTREACHED*/ break;
case 180:
# line 1334 "nidl.y"
{ yyval.y_attributes = yypvt[-0].y_attributes; } /*NOTREACHED*/ break;
case 181:
# line 1337 "nidl.y"
{
        yyval.y_attributes.bounds = NULL;
        yyval.y_attributes.attr_flags = 0;
        } /*NOTREACHED*/ break;
case 183:
# line 1347 "nidl.y"
{
        /*
         * Can't tell if we had any valid attributes in the list, so return
         * none.
         */
        yyval.y_attributes.bounds = NULL;
        yyval.y_attributes.attr_flags = 0;
        log_error(yylineno, NIDL_ERRINATTR);
        } /*NOTREACHED*/ break;
case 184:
# line 1357 "nidl.y"
{
        /*
         * No closer to the attribute, so give a different message.
         */
        yyval.y_attributes.bounds = NULL;
        yyval.y_attributes.attr_flags = 0;
        log_error(yylineno, NIDL_MISSONATTR);
        search_attributes_table = false;
        } /*NOTREACHED*/ break;
case 185:
# line 1371 "nidl.y"
{ yyval.y_attributes = yypvt[-0].y_attributes; } /*NOTREACHED*/ break;
case 186:
# line 1374 "nidl.y"
{
          /*
           * If the same bit has been specified more than once, then issue
           * a message.
           */
          if ((yypvt[-3].y_attributes.attr_flags & yypvt[-0].y_attributes.attr_flags) != 0)
                log_warning(yylineno, NIDL_MULATTRDEF);
          yyval.y_attributes.attr_flags = yypvt[-3].y_attributes.attr_flags |
                                        yypvt[-0].y_attributes.attr_flags;
          yyval.y_attributes.bounds = (ASTP_type_attr_n_t *) AST_concat_element (
                                (ASTP_node_t*) yypvt[-3].y_attributes.bounds,
                                (ASTP_node_t*) yypvt[-0].y_attributes.bounds);
        } /*NOTREACHED*/ break;
case 187:
# line 1392 "nidl.y"
{ yyval.y_attributes = yypvt[-0].y_attributes; } /*NOTREACHED*/ break;
case 188:
# line 1395 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_BROADCAST;
                                  yyval.y_attributes.bounds = NULL;       } /*NOTREACHED*/ break;
case 189:
# line 1397 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_MAYBE;
                                  yyval.y_attributes.bounds = NULL;       } /*NOTREACHED*/ break;
case 190:
# line 1399 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_IDEMPOTENT;
                                  yyval.y_attributes.bounds = NULL;       } /*NOTREACHED*/ break;
case 191:
# line 1401 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_REFLECT_DELETIONS;
                                  yyval.y_attributes.bounds = NULL;       } /*NOTREACHED*/ break;
case 192:
# line 1405 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_PTR;
                                  yyval.y_attributes.bounds = NULL;       } /*NOTREACHED*/ break;
case 193:
# line 1407 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_IN;
                                  yyval.y_attributes.bounds = NULL;       } /*NOTREACHED*/ break;
case 194:
# line 1410 "nidl.y"
{ yyval.y_attributes.attr_flags =
                                        ASTP_IN | ASTP_IN_SHAPE;
                                  yyval.y_attributes.bounds = NULL;       } /*NOTREACHED*/ break;
case 195:
# line 1413 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_OUT;
                                  yyval.y_attributes.bounds = NULL;       } /*NOTREACHED*/ break;
case 196:
# line 1416 "nidl.y"
{ yyval.y_attributes.attr_flags =
                                        ASTP_OUT | ASTP_OUT_SHAPE;
                                  yyval.y_attributes.bounds = NULL;       } /*NOTREACHED*/ break;
case 197:
# line 1421 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_SMALL;
                                  yyval.y_attributes.bounds = NULL;       } /*NOTREACHED*/ break;
case 198:
# line 1423 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_STRING;
                                  yyval.y_attributes.bounds = NULL;       } /*NOTREACHED*/ break;
case 199:
# line 1425 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_STRING0;
                                  yyval.y_attributes.bounds = NULL;       } /*NOTREACHED*/ break;
case 200:
# line 1427 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_UNIQUE;
                                  yyval.y_attributes.bounds = NULL;       } /*NOTREACHED*/ break;
case 201:
# line 1429 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_REF;
                                  yyval.y_attributes.bounds = NULL;       } /*NOTREACHED*/ break;
case 202:
# line 1431 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_IGNORE;
                                  yyval.y_attributes.bounds = NULL;       } /*NOTREACHED*/ break;
case 203:
# line 1433 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_CONTEXT;
                                  yyval.y_attributes.bounds = NULL;       } /*NOTREACHED*/ break;
case 204:
# line 1437 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_UNALIGN;
                                  yyval.y_attributes.bounds = NULL;       } /*NOTREACHED*/ break;
case 205:
# line 1439 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_V1_ENUM;
                                  yyval.y_attributes.bounds = NULL;       } /*NOTREACHED*/ break;
case 206:
# line 1442 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_ALIGN_SMALL;
                                  yyval.y_attributes.bounds = NULL;       } /*NOTREACHED*/ break;
case 207:
# line 1445 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_ALIGN_SHORT;
                                  yyval.y_attributes.bounds = NULL;       } /*NOTREACHED*/ break;
case 208:
# line 1448 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_ALIGN_LONG;
                                  yyval.y_attributes.bounds = NULL;       } /*NOTREACHED*/ break;
case 209:
# line 1451 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_ALIGN_HYPER;
                                  yyval.y_attributes.bounds = NULL;       } /*NOTREACHED*/ break;
case 210:
# line 1453 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_HANDLE;
                                  yyval.y_attributes.bounds = NULL;       } /*NOTREACHED*/ break;
case 211:
# line 1456 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_TRANSMIT_AS;
                                  yyval.y_attributes.bounds = NULL;
                                  ASTP_transmit_as_type = yypvt[-1].y_type;
                                } /*NOTREACHED*/ break;
case 212:
# line 1461 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_SWITCH_TYPE;
                                  yyval.y_attributes.bounds = NULL;
                                  ASTP_switch_type = yypvt[-1].y_type;
                                } /*NOTREACHED*/ break;
case 213:
# line 1468 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_CASE;
                                  yyval.y_attributes.bounds = NULL;
                                  ASTP_case = yypvt[-1].y_label;
                                } /*NOTREACHED*/ break;
case 214:
# line 1472 "nidl.y"
{ yyval.y_attributes.attr_flags = ASTP_DEFAULT;
                                  yyval.y_attributes.bounds = NULL;       
                                } /*NOTREACHED*/ break;
case 215:
# line 1476 "nidl.y"
{
                char *identifier;       /* place to receive the identifier text */
                NAMETABLE_id_to_string (yypvt[-0].y_id, &identifier);
                log_error (yylineno, NIDL_UNKNOWNATTR, identifier);
                yyval.y_attributes.attr_flags = 0;
                yyval.y_attributes.bounds = NULL;
        } /*NOTREACHED*/ break;
case 216:
# line 1492 "nidl.y"
{yyval.y_exp = yypvt[-0].y_exp;} /*NOTREACHED*/ break;
case 217:
# line 1497 "nidl.y"
{yyval.y_exp = yypvt[-0].y_exp;} /*NOTREACHED*/ break;
case 218:
# line 1499 "nidl.y"
{
            ASTP_validate_integer(&yypvt[-4].y_exp);
            ASTP_validate_integer(&yypvt[-2].y_exp);
            ASTP_validate_integer(&yypvt[-0].y_exp);
            yyval.y_exp.type = AST_int_const_k;
            yyval.y_exp.val.integer = yypvt[-4].y_exp.val.integer ? yypvt[-2].y_exp.val.integer : yypvt[-0].y_exp.val.integer;
        } /*NOTREACHED*/ break;
case 219:
# line 1510 "nidl.y"
{yyval.y_exp = yypvt[-0].y_exp;} /*NOTREACHED*/ break;
case 220:
# line 1512 "nidl.y"
{
           ASTP_validate_integer(&yypvt[-2].y_exp);
           ASTP_validate_integer(&yypvt[-0].y_exp);
           yyval.y_exp.type = AST_int_const_k;
           yyval.y_exp.val.integer = yypvt[-2].y_exp.val.integer || yypvt[-0].y_exp.val.integer;
        } /*NOTREACHED*/ break;
case 221:
# line 1522 "nidl.y"
{yyval.y_exp = yypvt[-0].y_exp;} /*NOTREACHED*/ break;
case 222:
# line 1524 "nidl.y"
{
            ASTP_validate_integer(&yypvt[-2].y_exp);
            ASTP_validate_integer(&yypvt[-0].y_exp);
            yyval.y_exp.type = AST_int_const_k;
            yyval.y_exp.val.integer = yypvt[-1].y_exp.val.integer && yypvt[-0].y_exp.val.integer;
        } /*NOTREACHED*/ break;
case 223:
# line 1534 "nidl.y"
{yyval.y_exp = yypvt[-0].y_exp;} /*NOTREACHED*/ break;
case 224:
# line 1536 "nidl.y"
{
            ASTP_validate_integer(&yypvt[-2].y_exp);
            ASTP_validate_integer(&yypvt[-0].y_exp);
            yyval.y_exp.type = AST_int_const_k;
            yyval.y_exp.val.integer = yypvt[-2].y_exp.val.integer | yypvt[-0].y_exp.val.integer;
        } /*NOTREACHED*/ break;
case 225:
# line 1546 "nidl.y"
{yyval.y_exp = yypvt[-0].y_exp;} /*NOTREACHED*/ break;
case 226:
# line 1548 "nidl.y"
{
            ASTP_validate_integer(&yypvt[-2].y_exp);
            ASTP_validate_integer(&yypvt[-0].y_exp);
            yyval.y_exp.type = AST_int_const_k;
            yyval.y_exp.val.integer = yypvt[-2].y_exp.val.integer ^ yypvt[-0].y_exp.val.integer;
        } /*NOTREACHED*/ break;
case 227:
# line 1558 "nidl.y"
{yyval.y_exp = yypvt[-0].y_exp;} /*NOTREACHED*/ break;
case 228:
# line 1560 "nidl.y"
{
            ASTP_validate_integer(&yypvt[-2].y_exp);
            ASTP_validate_integer(&yypvt[-0].y_exp);
            yyval.y_exp.type = AST_int_const_k;
            yyval.y_exp.val.integer = yypvt[-2].y_exp.val.integer & yypvt[-0].y_exp.val.integer;
        } /*NOTREACHED*/ break;
case 229:
# line 1570 "nidl.y"
{yyval.y_exp = yypvt[-0].y_exp;} /*NOTREACHED*/ break;
case 230:
# line 1572 "nidl.y"
{
            ASTP_validate_integer(&yypvt[-2].y_exp);
            ASTP_validate_integer(&yypvt[-0].y_exp);
            yyval.y_exp.type = AST_int_const_k;
            yyval.y_exp.val.integer = yypvt[-2].y_exp.val.integer == yypvt[-0].y_exp.val.integer;
        } /*NOTREACHED*/ break;
case 231:
# line 1579 "nidl.y"
{
            ASTP_validate_integer(&yypvt[-2].y_exp);
            ASTP_validate_integer(&yypvt[-0].y_exp);
            yyval.y_exp.type = AST_int_const_k;
            yyval.y_exp.val.integer = yypvt[-2].y_exp.val.integer != yypvt[-0].y_exp.val.integer;
        } /*NOTREACHED*/ break;
case 232:
# line 1589 "nidl.y"
{yyval.y_exp = yypvt[-0].y_exp;} /*NOTREACHED*/ break;
case 233:
# line 1591 "nidl.y"
{
            ASTP_validate_integer(&yypvt[-2].y_exp);
            ASTP_validate_integer(&yypvt[-0].y_exp);
            yyval.y_exp.type = AST_int_const_k;
            yyval.y_exp.val.integer = yypvt[-2].y_exp.val.integer < yypvt[-0].y_exp.val.integer;
        } /*NOTREACHED*/ break;
case 234:
# line 1598 "nidl.y"
{
            ASTP_validate_integer(&yypvt[-2].y_exp);
            ASTP_validate_integer(&yypvt[-0].y_exp);
            yyval.y_exp.type = AST_int_const_k;
            yyval.y_exp.val.integer = yypvt[-2].y_exp.val.integer > yypvt[-0].y_exp.val.integer;
        } /*NOTREACHED*/ break;
case 235:
# line 1605 "nidl.y"
{
            ASTP_validate_integer(&yypvt[-2].y_exp);
            ASTP_validate_integer(&yypvt[-0].y_exp);
            yyval.y_exp.type = AST_int_const_k;
            yyval.y_exp.val.integer = yypvt[-2].y_exp.val.integer <= yypvt[-0].y_exp.val.integer;
        } /*NOTREACHED*/ break;
case 236:
# line 1612 "nidl.y"
{
            ASTP_validate_integer(&yypvt[-2].y_exp);
            ASTP_validate_integer(&yypvt[-0].y_exp);
            yyval.y_exp.type = AST_int_const_k;
            yyval.y_exp.val.integer = yypvt[-2].y_exp.val.integer >= yypvt[-0].y_exp.val.integer;
        } /*NOTREACHED*/ break;
case 237:
# line 1622 "nidl.y"
{yyval.y_exp = yypvt[-0].y_exp;} /*NOTREACHED*/ break;
case 238:
# line 1624 "nidl.y"
{
            ASTP_validate_integer(&yypvt[-2].y_exp);
            ASTP_validate_integer(&yypvt[-0].y_exp);
            yyval.y_exp.type = AST_int_const_k;
            yyval.y_exp.val.integer = yypvt[-2].y_exp.val.integer << yypvt[-0].y_exp.val.integer;
        } /*NOTREACHED*/ break;
case 239:
# line 1631 "nidl.y"
{
            ASTP_validate_integer(&yypvt[-2].y_exp);
            ASTP_validate_integer(&yypvt[-0].y_exp);
            yyval.y_exp.type = AST_int_const_k;
            yyval.y_exp.val.integer = yypvt[-2].y_exp.val.integer >> yypvt[-0].y_exp.val.integer;
        } /*NOTREACHED*/ break;
case 240:
# line 1641 "nidl.y"
{yyval.y_exp = yypvt[-0].y_exp;} /*NOTREACHED*/ break;
case 241:
# line 1643 "nidl.y"
{
            ASTP_validate_integer(&yypvt[-2].y_exp);
            ASTP_validate_integer(&yypvt[-0].y_exp);
            yyval.y_exp.type = AST_int_const_k;
            yyval.y_exp.val.integer = yypvt[-2].y_exp.val.integer + yypvt[-0].y_exp.val.integer;
            if ((yyval.y_exp.val.integer < yypvt[-2].y_exp.val.integer) &&
                (yyval.y_exp.val.integer < yypvt[-0].y_exp.val.integer))
                log_error (yylineno, NIDL_INTOVERFLOW, KEYWORDS_lookup_text(LONG_KW));
        } /*NOTREACHED*/ break;
case 242:
# line 1653 "nidl.y"
{
            ASTP_validate_integer(&yypvt[-2].y_exp);
            ASTP_validate_integer(&yypvt[-0].y_exp);
            yyval.y_exp.type = AST_int_const_k;
            yyval.y_exp.val.integer = yypvt[-2].y_exp.val.integer - yypvt[-0].y_exp.val.integer;
        } /*NOTREACHED*/ break;
case 243:
# line 1663 "nidl.y"
{yyval.y_exp = yypvt[-0].y_exp;} /*NOTREACHED*/ break;
case 244:
# line 1665 "nidl.y"
{
            ASTP_validate_integer(&yypvt[-2].y_exp);
            ASTP_validate_integer(&yypvt[-0].y_exp);
            yyval.y_exp.type = AST_int_const_k;
            yyval.y_exp.val.integer = yypvt[-2].y_exp.val.integer * yypvt[-0].y_exp.val.integer;
            if ((yyval.y_exp.val.integer < yypvt[-2].y_exp.val.integer) &&
                (yyval.y_exp.val.integer < yypvt[-0].y_exp.val.integer))
                log_error (yylineno, NIDL_INTOVERFLOW, KEYWORDS_lookup_text(LONG_KW));
        } /*NOTREACHED*/ break;
case 245:
# line 1675 "nidl.y"
{
            ASTP_validate_integer(&yypvt[-2].y_exp);
            ASTP_validate_integer(&yypvt[-0].y_exp);
            yyval.y_exp.type = AST_int_const_k;
            if (yypvt[-0].y_exp.val.integer != 0)
                yyval.y_exp.val.integer = yypvt[-2].y_exp.val.integer / yypvt[-0].y_exp.val.integer;
            else
                log_error (yylineno, NIDL_INTDIVBY0);
        } /*NOTREACHED*/ break;
case 246:
# line 1685 "nidl.y"
{
            ASTP_validate_integer(&yypvt[-2].y_exp);
            ASTP_validate_integer(&yypvt[-0].y_exp);
            yyval.y_exp.type = AST_int_const_k;
            if (yypvt[-0].y_exp.val.integer != 0)
                yyval.y_exp.val.integer = yypvt[-2].y_exp.val.integer % yypvt[-0].y_exp.val.integer;
            else
                log_error (yylineno, NIDL_INTDIVBY0);
        } /*NOTREACHED*/ break;
case 247:
# line 1697 "nidl.y"
{yyval.y_exp = yypvt[-0].y_exp;} /*NOTREACHED*/ break;
case 248:
# line 1702 "nidl.y"
{yyval.y_exp = yypvt[-0].y_exp;} /*NOTREACHED*/ break;
case 249:
# line 1704 "nidl.y"
{
            ASTP_validate_integer(&yypvt[-0].y_exp);
            yyval.y_exp.type = AST_int_const_k;
            yyval.y_exp.val.integer = yypvt[-0].y_exp.val.integer;
        } /*NOTREACHED*/ break;
case 250:
# line 1710 "nidl.y"
{
            ASTP_validate_integer(&yypvt[-0].y_exp);
            yyval.y_exp.type = AST_int_const_k;
            yyval.y_exp.val.integer = -yypvt[-0].y_exp.val.integer;
        } /*NOTREACHED*/ break;
case 251:
# line 1716 "nidl.y"
{
            ASTP_validate_integer(&yypvt[-0].y_exp);
            yyval.y_exp.type = AST_int_const_k;
            yyval.y_exp.val.integer = ~yypvt[-0].y_exp.val.integer;
        } /*NOTREACHED*/ break;
case 252:
# line 1722 "nidl.y"
{
            ASTP_validate_integer(&yypvt[-0].y_exp);
            yyval.y_exp.type = AST_int_const_k;
            yyval.y_exp.val.integer = !yypvt[-0].y_exp.val.integer;
        } /*NOTREACHED*/ break;
case 253:
# line 1731 "nidl.y"
{ yyval.y_exp = yypvt[-1].y_exp; } /*NOTREACHED*/ break;
case 254:
# line 1733 "nidl.y"
{
            yyval.y_exp.type = AST_int_const_k;
            yyval.y_exp.val.integer = yypvt[-0].y_ival;
        } /*NOTREACHED*/ break;
case 255:
# line 1738 "nidl.y"
{
            yyval.y_exp.type = AST_nil_const_k;
            yyval.y_exp.val.other = AST_char_constant (yypvt[-0].y_char) ;
        } /*NOTREACHED*/ break;
case 256:
# line 1743 "nidl.y"
{
            yyval.y_exp.type = AST_nil_const_k;
            yyval.y_exp.val.other  = AST_named_constant(yypvt[-0].y_id) ;
        } /*NOTREACHED*/ break;
case 257:
# line 1748 "nidl.y"
{
            yyval.y_exp.type = AST_nil_const_k;
            yyval.y_exp.val.other = AST_string_constant (yypvt[-0].y_string) ;
        } /*NOTREACHED*/ break;
case 258:
# line 1753 "nidl.y"
{
            yyval.y_exp.type = AST_nil_const_k;
            yyval.y_exp.val.other = AST_null_constant() ;
        } /*NOTREACHED*/ break;
case 259:
# line 1759 "nidl.y"
{
            yyval.y_exp.type = AST_nil_const_k;
            yyval.y_exp.val.other = AST_boolean_constant(true) ;
        } /*NOTREACHED*/ break;
case 260:
# line 1765 "nidl.y"
{
            yyval.y_exp.type = AST_nil_const_k;
            yyval.y_exp.val.other = AST_boolean_constant(false) ;
        } /*NOTREACHED*/ break;
case 261:
# line 1770 "nidl.y"
{
            yyval.y_exp.type = AST_int_const_k;
            yyval.y_exp.val.integer = 0;
            log_error(yylineno, NIDL_FLOATCONSTNOSUP);
        } /*NOTREACHED*/ break;
}


        goto yystack;           /* reset registers in driver code */
}
