/*
 * $Id: astp_dmp.h,v 1.1.1.1 1996/06/30 00:08:57 mtp Exp $
 ****************************************************************************
 * @Header@
 ****************************************************************************
 * $Log: astp_dmp.h,v $
 * Revision 1.1.1.1  1996/06/30 00:08:57  mtp
 * Resubmission of PD DCE sources
 *
 * Revision 1.1.1.1  1995/12/31 05:20:14  mtp
 * + Placed under CVS control
 *
 ****************************************************************************
 */
/*
 * 
 * (c) Copyright 1989 OPEN SOFTWARE FOUNDATION, INC.
 * (c) Copyright 1989 HEWLETT-PACKARD COMPANY
 * (c) Copyright 1989 DIGITAL EQUIPMENT CORPORATION
 * To anyone who acknowledges that this file is provided "AS IS"
 * without any express or implied warranty:
 *                 permission to use, copy, modify, and distribute this
 * file for any purpose is hereby granted without fee, provided that
 * the above copyright notices and this notice appears in all source
 * code copies, and that none of the names of Open Software
 * Foundation, Inc., Hewlett-Packard Company, or Digital Equipment
 * Corporation be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.  Neither Open Software Foundation, Inc., Hewlett-
 * Packard Company, nor Digital Equipment Corporation makes any
 * representations about the suitability of this software for any
 * purpose.
 * 
 */
/*
 */ 
/*
**
**  NAME
**      ASTP_DMP.H
**
**
**  FACILITY:
**
**      Remote Procedure Call (RPC)
**
**  ABSTRACT:
**
**      Header file for the AST Builder Dumper module, ASTP_DMP.C
**
**  VERSION: DCE 1.0
**
*/

#ifndef ASTP_DMP_H
#define ASTP_DMP_H
#ifdef DUMPERS
#include <nidl.h>
#include <ast.h>

/*
 * Exported dump routines
 */

void AST_dump_interface
(
#ifdef PROTO
    AST_interface_n_t *if_n_p
#endif
);

void AST_dump_operation
(
#ifdef PROTO
    AST_operation_n_t *operation_node_ptr,
    int indentation
#endif
);

void AST_dump_parameter
(
#ifdef PROTO
    AST_parameter_n_t *parameter_node_ptr,
    int indentation
#endif
);

void AST_dump_nametable_id
(
#ifdef PROTO
    char   *format_string,
    NAMETABLE_id_t id
#endif
);

void AST_dump_parameter
(
#ifdef PROTO
    AST_parameter_n_t *param_node_ptr,
    int     indentation
#endif
);

void AST_dump_type(
#ifdef PROTO
    AST_type_n_t *type_n_p,
    char *format,
    int indentation
#endif
);


void AST_dump_constant
(
#ifdef PROTO
    AST_constant_n_t *constant_node_ptr,
    int indentation
#endif
);

void AST_enable_hex_dump();


#endif /* Dumpers */
#endif /* ASTP_DMP_H */
