/*
 * $Id: ast.h,v 1.1.1.1 1996/06/30 00:08:57 mtp Exp $
 ****************************************************************************
 * @Header@
 ****************************************************************************
 * $Log: ast.h,v $
 * Revision 1.1.1.1  1996/06/30 00:08:57  mtp
 * Resubmission of PD DCE sources
 *
 * Revision 1.1.1.1  1995/12/31 05:20:13  mtp
 * + Placed under CVS control
 *
 ****************************************************************************
 */
/*
 * 
 * (c) Copyright 1993 OPEN SOFTWARE FOUNDATION, INC.
 * (c) Copyright 1993 HEWLETT-PACKARD COMPANY
 * (c) Copyright 1993 DIGITAL EQUIPMENT CORPORATION
 * To anyone who acknowledges that this file is provided "AS IS"
 * without any express or implied warranty:
 *                 permission to use, copy, modify, and distribute this
 * file for any purpose is hereby granted without fee, provided that
 * the above copyright notices and this notice appears in all source
 * code copies, and that none of the names of Open Software
 * Foundation, Inc., Hewlett-Packard Company, or Digital Equipment
 * Corporation be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.  Neither Open Software Foundation, Inc., Hewlett-
 * Packard Company, nor Digital Equipment Corporation makes any
 * representations about the suitability of this software for any
 * purpose.
 * 
 */
/*
**
**  NAME:
**
**      ast.h
**
**  FACILITY:
**
**      Interface Definition Language (IDL) Compiler
**
**  ABSTRACT:
**
**  Definition of Abstract Syntax Tree (AST) data structures.
**
**  VERSION: DCE 1.1
*/

#ifndef AST_H
#define AST_H

 /*
 *  a s t . h
 *
 *  This file contains the declarations for the abstract syntax tree
 *  nodes used in the tree generated by the frontend and read by the
 *  backend.
 *
 *  Naming conventions: _n_t suffix used for struct or union types used
 *  for ast nodes; _k_t suffix used for enumerated types used to
 *  discriminate among the variants of a node type represented as a union.
 *
 *
 *  Notes on the representation of attributes
 *  -----------------------------------------
 *  The following table gives information on all of the attributes
 *  used in the IDL language and in the intermediate rep of interface
 *  definitions.
 *
 *  attribute         | type        |  where      |  kind  |  notes
 *  name              | of          |  allowed    |  of    |
 *                    | value       |  in         |  attr  |
 *                    |             |  source     |        |
 *  ------------------|-------------|-------------|--------|-------
 *  auto_handle       | boolean     |    i        |  i     |
 *  local             | boolean     |    i        |  i     |
 *  implicit_handle   | <name,type> |    i        |  i     |
 *  uuid              | uuid_t      |    i        |  i     |
 *  port              | int[]       |    i        |  i     |
 *  version           | unsigned    |    i        |  i     |
 *  npb               | boolean     |    i        |  i     | 5
 *  implicit_handle_g | boolean     |  <inferred> |  i     | 10
 *  double_used       | boolean     |  <inferred> |  i     |
 *  has_encode_ops    | boolean     |  <inferred> |  i     |
 *  ------------------|-------------|-------------|--------|-------
 *  represent_as      | type_t *    |          t  |  t     |
 *  transmit_as       | type_t *    |          t  |  t     |
 *  handle            | boolean     |          t  |  t     |
 *  context           | boolean     |          t  |  t     | 3
 *  unalign           | boolean     |          t  |  t     | 7
 *  align             | int         |          t  |  t     | 7
 *  ref               | boolean     |  f     p t  |a,t,f,p | 6
 *  unique            | boolean     |  f     p t  |a,t,f,p |
 *  ptr               | boolean     |        p    |a,t,f,p |
 *  self_pointing     | boolean     |  <inferred> |  t     | 1
 *  def_as_tag        | boolean     |  <inferred> |  t     |
 *  v1_enum           | boolean     |          t  |  t     |
 *  in                | boolean     |  <inferred> |  t     |
 *  out               | boolean     |  <inferred> |  t     |
 *  out_pa_ref        | boolean     |  <inferred> |  t     |
 *  in_fixed          | boolean     |  <inferred> |  t     |
 *  out_fixed         | boolean     |  <inferred> |  t     |
 *  in_varying        | boolean     |  <inferred> |  t     |
 *  out_varying       | boolean     |  <inferred> |  t     |
 *  in_pa_stub        | boolean     |  <inferred> |  t     |
 *  out_pa_stub       | boolean     |  <inferred> |  t     |
 *  ------------------|-------------|-------------|--------|-------
 *  broadcast         | boolean     |      o      |  o     |
 *  enable_allocate   | boolean     |      o      |  o     |
 *  maybe             | boolean     |      o      |  o     |
 *  idempotent        | boolean     |      o      |  o     |
 *  reflect_deletions | boolean     |      o      |  o     |
 *                    |             |             |        |
 *  code              | boolean     |    i o      |  o     |
 *  no_code           | boolean     |    i o      |  o     |
 *  decode            | boolean     |    i o      |  o     |
 *  encode            | boolean     |    i o      |  o     |
 *  explicit_handle   | boolean     |    i o      |  o     |
 *                    |             |             |        |
 *  has_ins           | boolean     |  <inferred> |  o     |
 *  has_in_pipes      | boolean     |  <inferred> |  o     |
 *  has_outs          | boolean     |  <inferred> |  o     |
 *  has_out_pipes     | boolean     |  <inferred> |  o     |
 *  has_in_ptrs       | boolean     |  <inferred> |  o     |
 *  has_out_ptrs      | boolean     |  <inferred> |  o     |
 *  has_in_ools       | boolean     |  <inferred> |  o     |
 *  has_out_ools      | boolean     |  <inferred> |  o     |
 *  has_in_ctx        | boolean     |  <inferred> |  o     |
 *  has_out_ctx       | boolean     |  <inferred> |  o     |
 *  has_in_out_ctx    | boolean     |  <inferred> |  o     |
 *  has_xmit_as       | boolean     |  <inferred> |  o     |
 *  has_in_full_ptrs  | boolean     |  <inferred> |  o     |
 *  ------------------|-------------|-------------|--------|-------
 *  in                | boolean     |        p    |  p     | 8
 *  out               | boolean     |        p    |  p     | 8
 *  in_shape          | boolean     |        p    |  p     |
 *  out_shape         | boolean     |        p    |  p     |
 *  cs_stag           | boolean     |        p    |  p     |
 *  cs_drtag          | boolean     |        p    |  p     |
 *  cs_rtag           | boolean     |        p    |  p     |
 *  hidden            | boolean     |        p    |  p     |
 *                    |             |             |        |
 *  comm_status       | boolean     |      o p    |  p     | 2
 *  add_comm_status   | boolean     |      o p    |  p     | 9
 *  fault_status      | boolean     |      o p    |  p     | 2
 *  add_fault_status  | boolean     |      o p    |  p     | 9
 *  ------------------|-------------|-------------|--------|-------
 *  last_is           | ref         |  f     p    |  f     |
 *  first_is          | ref         |  f     p    |  f     |
 *  max_is            | ref         |  f     p    |  f     |
 *  min_is            | ref         |  f     p    |  f     |
 *  length_is         | ref         |  f     p    |  f     |
 *  size_is           | ref         |  f     p    |  f     |
 *                    |             |             |        |
 *  string            | boolean     |  f     p t  |  f     |
 *  string0           | boolean     |  f     p t  |  f     |
 *  ignore            | boolean     |  f       t  |  f     |
 *  small             | boolean     |  f     p t  |  f     |
 *                    |             |             |        |
 *  heap              | boolean     |        p t  |  p     |
 *  in_line           | boolean     |  f i   p t  |  f     |
 *  out_of_line       | boolean     |  f i   p t  |  f     |
 *                    |             |             |        |
 *  context           | boolean     |  f     p    |  f     | 4
 *  varying           | boolean     |  f     p    |  f,p,t | 11
 *  ------------------|-------------|-------------|--------|-------
 *  extern            | boolean     |    i        |  e     |
 *                    |             |             |        |
 *  ------------------|-------------|-------------|--------|-------
 *  f - field or arm attribute
 *  i - interface attribute
 *  o - operation attribute
 *  p - parameter attribute
 *  t - type attribute
 *  e - exception attribute
 *
 *  notes:
 *
 *  1. "Self_pointing" means that a type is or contains a pointer that could
 *  directly or indirectly point to another instance of itself, i.e. T is
 *  self_pointing iff (T,T) is in the transitive closure of the "contains
 *  a pointer to" relation on types.
 *
 *  2. While [comm_status] or [fault_status] appears in operation attribute
 *  position it is represented only as a parameter attribute in the implicit
 *  parameter which models the function result.
 *
 *  3. This is the context with rundown which is denoted by applying the
 *  [context_handle] attribute to a type.
 *
 *  4. This is the context withOUT rundown which is denoted by applying the
 *  [context_handle] attribute to a field or parameter.
 *
 *  5. "npb" stands for "non-parametric binding" which means that either
 *  auto_handle or implicit_handle also needs to be specified.
 *
 *  6. The ref flag is used on parameters to avoid pervasive changes just
 *  for naming.  In the source this is specified via the lack of [ptr] and
 *  [unique] on parameters, and by the presence of [ref] on types and fields.
 *
 *  7. [unalign] is set to indicate that the aligment_size is set to
 *  the alignment of the first field in the struct.  [align] puts
 *  the specified size in the alignment_size field of the type.
 *
 *  8. The [in] and [out] synthesized attributes on types indicate that
 *  there are one or more occurences of that type as [in] or [out] params.
 *
 *  9. [add_comm_status] or [add_fault_status] indicates that the an additional
 *  status_t parameter is added to the argument list.  If no errors occur it
 *  should be set to the success value, otherwise it contains the error status.
 *  This is different from the corresponding attribute in that it is used
 *  only for status and is not an explicit parameter that may be set by the
 *  programmer.
 *
 *  10. When set the [implicit_handle_g] sythesized attribute indicates that
 *  the type used as the implicit handle is not a handle_t and thus must
 *  have binding routines generated for it.
 *
 *  11. When [varying] is set on an instance location, this indicates the
 *  usage site is varying.  When set on a type, this indicates that the
 *  type may be used as varying at some point.
 *
 *  On the representation of boolean valued attributes
 *  --------------------------------------------------
 *
 *  Boolean attributes are represented as bits in flag words.  The same
 *  bit in the same field is used to represent a given attribute regardless
 *  of the kind of node in which it occurs. In order to achieve this
 *  regularity and to represent all flags as compactly as possible a
 *  "bin-packing" algorithm should be used to assign boolean attributes
 *  to bit positions.  The current assignment is represented by the
 *  following table.  However, the flags should be manipulated through
 *  the supplied macros in case the bit assignments need to be changed or
 *  expanded to more than one 16-bit flag word.
 *
 *    bit    | node type in which flag occurs (i.e. field stands for field_n_t):
 *           | field       | arm     | interface   | operation     | parameter   | type          | array_index
 *    -------|-------------|---------|-------------|---------------|-------------|---------------|-------------
 *   0x00001 | in_line     |         | in_line     | broadcast     | in_line     | in_line       | fixed_lower
 *   0x00002 | out_of_line |         | out_of_line | maybe         | out_of_line | out_of_line   | fixed_upper
 *   0x00004 | string      | string  | code        | code          | string      | string        |
 *   0x00008 | string0     | string0 | no_code     | no_code       | string0     | string0       |
 *   0x00010 | unique      | unique  | auto_handle | idempotent    | unique      | unique        |
 *   0x00020 | ref         | ref     | local       | has_ins       | ref         | ref           |
 *   0x00040 | ignore      |         | npb         | has_in_pipes  |             | ignore        |
 *   0x00080 | small       | small   |impl_handle_g| has_outs      | small       | small         |
 *   0x00100 | context     | context |double_used  | has_out_pipes | context     | handle        |
 *   0x00200 | varying     | varying |has_encode_ops|has_in_ctx    | varying     | varying       |
 *   0x00400 |             |         |             | has_in_ptrs   | in          | in            |
 *   0x00800 |             |         |             | has_out_ptrs  | out         | out           |
 *   0x01000 |             |         |             | has_out_ctx   | comm_status | self-pointing |
 *   0x02000 |             |         |             | has_in_ools   | in_shape    | conformant    |
 *   0x04000 |             |         |             | has_out_ools  | out_shape   | def_as_tag    |
 *   0x08000 |             |         |             | has_in_out_ctx|add_com_statu| unalign       |
 *   0x10000 | ptr         | ptr     | explicit_han| explicit_han  | ptr         | ptr           |
 *   0x20000 |             |         |             | enable_alloc  | heap        | heap          |
 *   0x40000 |             |         |             | has_xmit_as   | fault_status| v1_enum       |
 *   0x80000 |             |         |             | has_full_ptrs |add_flt_statu| out_pa_ref    |
 *  0x100000 |             |         | decode      | decode        | cs_stag     | in_fixed      |
 *  0x200000 |             |         | encode      | encode        | cs_drtag    | in_varying    |
 *  0x400000 |             |         |             |reflect_deletions| cs_rtag   | out_fixed     |
 *  0x800000 |             |         |             |               | hidden      | out_varying   |
 *  0x100000 |             |         |             |               |             | in_fixed      |
 *  0x200000 |             |         |             |               |             | in_varying    |
 *  0x400000 |             |         |             |               |             | out_fixed     |
 *  0x800000 |             |         |             |               |             | out_varying   |
 * 0x1000000 |             |         |             |               |             | context_rd    |
 * 0x2000000 |             |         |             |               |             |               |
 * 0x4000000 |             |         |             |               |             | in_pa_stub    |
 * 0x8000000 |             |         |             |               |             | out_pa_stub   |
  */


#include <nidl.h>
#include <be_pvt.h>
#include <ir_pvt.h>
#include <fe_pvt.h>
#include <nametbl.h>


/* flags used in interface, type, field, parameter attribute flag words */
#define AST_IN_LINE       0x0001
#define AST_OUT_OF_LINE   0x0002

/* flags used in interface, operation attribute flag words */
#define AST_CODE          0x0004
#define AST_NO_CODE       0x0008
#define AST_EXPLICIT_HANDLE 0x10000
#define AST_DECODE        0x100000
#define AST_ENCODE        0x200000

/* flags used in  operation attribute flag word */
#define AST_BROADCAST     0x0001
#define AST_MAYBE         0x0002
#define AST_IDEMPOTENT    0x0010
#define AST_HAS_INS       0x0020
#define AST_HAS_IN_PIPES  0x0040
#define AST_HAS_OUTS      0x0080
#define AST_HAS_OUT_PIPES 0x0100
#define AST_HAS_IN_CTX    0x0200
#define AST_HAS_IN_PTRS   0x0400
#define AST_HAS_OUT_PTRS  0x0800
#define AST_HAS_OUT_CTX   0x1000
#define AST_HAS_OUT_OOLS  0x2000
#define AST_HAS_IN_OOLS   0x4000
#define AST_HAS_IN_OUT_CTX 0x8000
#define AST_ENABLE_ALLOCATE 0x20000
#define AST_HAS_FULL_PTRS   0x40000
#define AST_HAS_XMIT_AS     0x80000
#define AST_REFLECT_DELETIONS 0x400000

/* flags used in interface attribute flag word */
#define AST_AUTO_HANDLE   0x0010
#define AST_LOCAL         0x0020
#define AST_NPB           0x0040
#define AST_IMPLICIT_HANDLE_G  0x0080
#define AST_DOUBLE_USED   0x00100
#define AST_HAS_ENCODE_OPS 0x00200

/* flags used in type, field, parameter attribute flag words */
#define AST_STRING        0x0004
#define AST_STRING0       0x0008
#define AST_IGNORE        0x0040
#define AST_SMALL         0x0080

/* flags used in type, parameter attribute flag words */
#define AST_HEAP         0x20000

/* flags used in type flag word */
#define AST_HANDLE        0x0100
#define AST_SELF_POINTER  0x1000
#define AST_CONFORMANT    0x2000
#define AST_DEF_AS_TAG    0x4000
#define AST_REF           0x0020
#define AST_UNIQUE        0x0010
#define AST_PTR          0x10000
#define AST_UNALIGN       0x8000
#define AST_V1_ENUM      0x40000
#define AST_OUT_PA_REF   0x80000
#define AST_IN_FIXED    0x100000
#define AST_IN_VARYING  0x200000
#define AST_OUT_FIXED   0x400000
#define AST_OUT_VARYING 0x800000
#define AST_CONTEXT_RD  0x1000000
#define AST_IN_PA_STUB  0x4000000
#define AST_OUT_PA_STUB 0x8000000

/* flags used in parameter flag word */
#define AST_IN                  0x0400
#define AST_OUT                 0x0800
#define AST_COMM_STATUS         0x1000
#define AST_IN_SHAPE            0x2000
#define AST_OUT_SHAPE           0x4000
#define AST_ADD_COMM_STATUS     0x8000
#define AST_FAULT_STATUS       0x40000
#define AST_ADD_FAULT_STATUS   0x80000
#define AST_CS_STAG           0x100000
#define AST_CS_DRTAG          0x200000
#define AST_CS_RTAG           0x400000
#define AST_HIDDEN            0x800000

/* flag used in parameter and field words */
#define AST_CONTEXT       0x0100
#define AST_VARYING       0x0200

/* flag used in field words */

/* flags used in AST_array_index_n_t's flag word */
#define AST_FIXED_LOWER   0x0001
#define AST_FIXED_UPPER   0x0002

/* flags used in exception attribute flag words */
#define AST_EXTERN        0x0001

/*
 *  Macros for set, clearing, and testing the flag bits in AST nodes.
 *  To be used to achieve representation independence.
 */

#define AST_CLR_FLAGS(np)         (np)->flags = 0

#define AST_DOUBLE_USED_SET(np)       (AST_DOUBLE_USED & (np)->flags)
#define AST_CLR_DOUBLE_USED(np)       (np)->flags &= ~AST_DOUBLE_USED
#define AST_SET_DOUBLE_USED(np)       (np)->flags |= AST_DOUBLE_USED

#define AST_HAS_ENCODE_OPS_SET(np)    (AST_HAS_ENCODE_OPS & (np)->flags)
#define AST_CLR_HAS_ENCODE_OPS(np)    (np)->flags &= ~AST_HAS_ENCODE_OPS
#define AST_SET_HAS_ENCODE_OPS(np)    (np)->flags |= AST_HAS_ENCODE_OPS

#define AST_UNALIGN_SET(np)       (AST_UNALIGN & (np)->flags)
#define AST_CLR_UNALIGN(np)       (np)->flags &= ~AST_UNALIGN
#define AST_SET_UNALIGN(np)       (np)->flags |= AST_UNALIGN

#define AST_V1_ENUM_SET(np)       (AST_V1_ENUM & (np)->flags)
#define AST_CLR_V1_ENUM(np)       (np)->flags &= ~AST_V1_ENUM
#define AST_SET_V1_ENUM(np)       (np)->flags |= AST_V1_ENUM

#define AST_HEAP_SET(np)          (AST_HEAP & (np)->flags)
#define AST_CLR_HEAP(np)          (np)->flags &= ~AST_HEAP
#define AST_SET_HEAP(np)          (np)->flags |= AST_HEAP

#define AST_IN_LINE_SET(np)       (AST_IN_LINE & (np)->flags)
#define AST_CLR_IN_LINE(np)       (np)->flags &= ~AST_IN_LINE
#define AST_SET_IN_LINE(np)       (np)->flags |= AST_IN_LINE

#define AST_OUT_OF_LINE_SET(np)   (AST_OUT_OF_LINE & (np)->flags)
#define AST_CLR_OUT_OF_LINE(np)   (np)->flags &= ~AST_OUT_OF_LINE
#define AST_SET_OUT_OF_LINE(np)   (np)->flags |= AST_OUT_OF_LINE

#define AST_STRING_SET(np)        (AST_STRING & (np)->flags)
#define AST_CLR_STRING(np)        (np)->flags &= ~AST_STRING
#define AST_SET_STRING(np)        (np)->flags |= AST_STRING

#define AST_STRING0_SET(np)       (AST_STRING0 & (np)->flags)
#define AST_CLR_STRING0(np)       (np)->flags &= ~AST_STRING0
#define AST_SET_STRING0(np)       (np)->flags |= AST_STRING0

#define AST_UNIQUE_SET(np)        (AST_UNIQUE & (np)->flags)
#define AST_CLR_UNIQUE(np)        (np)->flags &= ~AST_UNIQUE
#define AST_SET_UNIQUE(np)        (np)->flags |= AST_UNIQUE

#define AST_REF_SET(np)           (AST_REF & (np)->flags)
#define AST_CLR_REF(np)           (np)->flags &= ~AST_REF
#define AST_SET_REF(np)           (np)->flags |= AST_REF

#define AST_PTR_SET(np)           (AST_PTR & (np)->flags)
#define AST_CLR_PTR(np)           (np)->flags &= ~AST_PTR
#define AST_SET_PTR(np)           (np)->flags |= AST_PTR

#define AST_IGNORE_SET(np)        (AST_IGNORE & (np)->flags)
#define AST_CLR_IGNORE(np)        (np)->flags &= ~AST_IGNORE
#define AST_SET_IGNORE(np)        (np)->flags |= AST_IGNORE

#define AST_SMALL_SET(np)         (AST_SMALL & (np)->flags)
#define AST_CLR_SMALL(np)         (np)->flags &= ~AST_SMALL
#define AST_SET_SMALL(np)         (np)->flags |= AST_SMALL

#define AST_CODE_SET(np)          (AST_CODE & (np)->flags)
#define AST_CLR_CODE(np)          (np)->flags &= ~AST_CODE
#define AST_SET_CODE(np)          (np)->flags |= AST_CODE

#define AST_NO_CODE_SET(np)       (AST_NO_CODE & (np)->flags)
#define AST_CLR_NO_CODE(np)       (np)->flags &= ~AST_NO_CODE
#define AST_SET_NO_CODE(np)       (np)->flags |= AST_NO_CODE

#define AST_DECODE_SET(np)        (AST_DECODE & (np)->flags)
#define AST_CLR_DECODE(np)        (np)->flags &= ~AST_DECODE
#define AST_SET_DECODE(np)        (np)->flags |= AST_DECODE

#define AST_ENCODE_SET(np)        (AST_ENCODE & (np)->flags)
#define AST_CLR_ENCODE(np)        (np)->flags &= ~AST_ENCODE
#define AST_SET_ENCODE(np)        (np)->flags |= AST_ENCODE

#define AST_EXPLICIT_HANDLE_SET(np) (AST_EXPLICIT_HANDLE & (np)->flags)
#define AST_CLR_EXPLICIT_HANDLE(np) (np)->flags &= ~AST_EXPLICIT_HANDLE
#define AST_SET_EXPLICIT_HANDLE(np) (np)->flags |= AST_EXPLICIT_HANDLE

#define AST_AUTO_HANDLE_SET(np)   (AST_AUTO_HANDLE & (np)->flags)
#define AST_CLR_AUTO_HANDLE(np)   (np)->flags &= ~AST_AUTO_HANDLE
#define AST_SET_AUTO_HANDLE(np)   (np)->flags |= AST_AUTO_HANDLE

#define AST_LOCAL_SET(np)         (AST_LOCAL & (np)->flags)
#define AST_CLR_LOCAL(np)         (np)->flags &= ~AST_LOCAL
#define AST_SET_LOCAL(np)         (np)->flags |= AST_LOCAL

#define AST_NPB_SET(np)           (AST_NPB & (np)->flags)
#define AST_CLR_NPB(np)           (np)->flags &= ~AST_NPB
#define AST_SET_NPB(np)           (np)->flags |= AST_NPB

#define AST_IMPLICIT_HANDLE_G_SET(np)   (AST_IMPLICIT_HANDLE_G & (np)->flags)
#define AST_CLR_IMPLICIT_HANDLE_G(np)   (np)->flags &= ~AST_IMPLICIT_HANDLE_G
#define AST_SET_IMPLICIT_HANDLE_G(np)   (np)->flags |= AST_IMPLICIT_HANDLE_G

#define AST_BROADCAST_SET(np)     (AST_BROADCAST & (np)->flags)
#define AST_CLR_BROADCAST(np)     (np)->flags &= ~AST_BROADCAST
#define AST_SET_BROADCAST(np)     (np)->flags |= AST_BROADCAST

#define AST_ENABLE_ALLOCATE_SET(np) (AST_ENABLE_ALLOCATE & (np)->flags)
#define AST_CLR_ENABLE_ALLOCATE(np) (np)->flags &= ~AST_ENABLE_ALLOCATE
#define AST_SET_ENABLE_ALLOCATE(np) (np)->flags |= AST_ENABLE_ALLOCATE

#define AST_HAS_FULL_PTRS_SET(np)  (AST_HAS_FULL_PTRS & (np)->flags)
#define AST_CLR_HAS_FULL_PTRS(np)  (np)->flags &= ~AST_HAS_FULL_PTRS
#define AST_SET_HAS_FULL_PTRS(np)  (np)->flags |= AST_HAS_FULL_PTRS

#define AST_MAYBE_SET(np)         (AST_MAYBE & (np)->flags)
#define AST_CLR_MAYBE(np)         (np)->flags &= ~AST_MAYBE
#define AST_SET_MAYBE(np)         (np)->flags |= AST_MAYBE

#define AST_IDEMPOTENT_SET(np)    (AST_IDEMPOTENT & (np)->flags)
#define AST_CLR_IDEMPOTENT(np)    (np)->flags &= ~AST_IDEMPOTENT
#define AST_SET_IDEMPOTENT(np)    (np)->flags |= AST_IDEMPOTENT

#define AST_REFLECT_DELETIONS_SET(np)   (AST_REFLECT_DELETIONS & (np)->flags)
#define AST_CLR_REFLECT_DELETIONS(np)   (np)->flags &= ~AST_REFLECT_DELETIONS
#define AST_SET_REFLECT_DELETIONS(np)   (np)->flags |= AST_REFLECT_DELETIONS

#define AST_HAS_INS_SET(np)       (AST_HAS_INS & (np)->flags)
#define AST_CLR_HAS_INS(np)       (np)->flags &= ~AST_HAS_INS
#define AST_SET_HAS_INS(np)       (np)->flags |= AST_HAS_INS

#define AST_HAS_IN_PIPES_SET(np)  (AST_HAS_IN_PIPES & (np)->flags)
#define AST_CLR_HAS_IN_PIPES(np)  (np)->flags &= ~AST_HAS_IN_PIPES
#define AST_SET_HAS_IN_PIPES(np)  (np)->flags |= AST_HAS_IN_PIPES

#define AST_HAS_IN_PTRS_SET(np)  (AST_HAS_IN_PTRS & (np)->flags)
#define AST_CLR_HAS_IN_PTRS(np)  (np)->flags &= ~AST_HAS_IN_PTRS
#define AST_SET_HAS_IN_PTRS(np)  (np)->flags |= AST_HAS_IN_PTRS

#define AST_HAS_IN_CTX_SET(np)    (AST_HAS_IN_CTX & (np)->flags)
#define AST_CLR_HAS_IN_CTX(np)    (np)->flags &= ~AST_HAS_IN_CTX
#define AST_SET_HAS_IN_CTX(np)    (np)->flags |= AST_HAS_IN_CTX

#define AST_HAS_OUT_CTX_SET(np)   (AST_HAS_OUT_CTX & (np)->flags)
#define AST_CLR_HAS_OUT_CTX(np)   (np)->flags &= ~AST_HAS_OUT_CTX
#define AST_SET_HAS_OUT_CTX(np)   (np)->flags |= AST_HAS_OUT_CTX

#define AST_HAS_IN_OUT_CTX_SET(np)   (AST_HAS_IN_OUT_CTX & (np)->flags)
#define AST_CLR_HAS_IN_OUT_CTX(np)   (np)->flags &= ~AST_HAS_IN_OUT_CTX
#define AST_SET_HAS_IN_OUT_CTX(np)   (np)->flags |= AST_HAS_IN_OUT_CTX

#define AST_HAS_OUTS_SET(np)      (AST_HAS_OUTS & (np)->flags)
#define AST_CLR_HAS_OUTS(np)      (np)->flags &= ~AST_HAS_OUTS
#define AST_SET_HAS_OUTS(np)      (np)->flags |= AST_HAS_OUTS

#define AST_HAS_OUT_PIPES_SET(np) (AST_HAS_OUT_PIPES & (np)->flags)
#define AST_CLR_HAS_OUT_PIPES(np) (np)->flags &= ~AST_HAS_OUT_PIPES
#define AST_SET_HAS_OUT_PIPES(np) (np)->flags |= AST_HAS_OUT_PIPES

#define AST_HAS_OUT_PTRS_SET(np) (AST_HAS_OUT_PTRS & (np)->flags)
#define AST_CLR_HAS_OUT_PTRS(np) (np)->flags &= ~AST_HAS_OUT_PTRS
#define AST_SET_HAS_OUT_PTRS(np) (np)->flags |= AST_HAS_OUT_PTRS

#define AST_HAS_OUT_OOLS_SET(np) (AST_HAS_OUT_OOLS & (np)->flags)
#define AST_CLR_HAS_OUT_OOLS(np) (np)->flags &= ~AST_HAS_OUT_OOLS
#define AST_SET_HAS_OUT_OOLS(np) (np)->flags |= AST_HAS_OUT_OOLS

#define AST_HAS_IN_OOLS_SET(np) (AST_HAS_IN_OOLS & (np)->flags)
#define AST_CLR_HAS_IN_OOLS(np) (np)->flags &= ~AST_HAS_IN_OOLS
#define AST_SET_HAS_IN_OOLS(np) (np)->flags |= AST_HAS_IN_OOLS

#define AST_HAS_XMIT_AS_SET(np) (AST_HAS_XMIT_AS & (np)->flags)
#define AST_CLR_HAS_XMIT_AS(np) (np)->flags &= ~AST_HAS_XMIT_AS
#define AST_SET_HAS_XMIT_AS(np) (np)->flags |= AST_HAS_XMIT_AS

#define AST_OUT_PA_REF_SET(np) (AST_OUT_PA_REF & (np)->flags)
#define AST_CLR_OUT_PA_REF(np) (np)->flags &= ~AST_OUT_PA_REF
#define AST_SET_OUT_PA_REF(np) (np)->flags |= AST_OUT_PA_REF

#define AST_IN_SET(np)            (AST_IN & (np)->flags)
#define AST_CLR_IN(np)            (np)->flags &= ~AST_IN
#define AST_SET_IN(np)            (np)->flags |= AST_IN

#define AST_OUT_SET(np)           (AST_OUT & (np)->flags)
#define AST_CLR_OUT(np)           (np)->flags &= ~AST_OUT
#define AST_SET_OUT(np)           (np)->flags |= AST_OUT

#define AST_IN_SHAPE_SET(np)      (AST_IN_SHAPE & (np)->flags)
#define AST_CLR_IN_SHAPE(np)      (np)->flags &= ~AST_IN_SHAPE
#define AST_SET_IN_SHAPE(np)      (np)->flags |= AST_IN_SHAPE

#define AST_OUT_SHAPE_SET(np)     (AST_OUT_SHAPE & (np)->flags)
#define AST_CLR_OUT_SHAPE(np)     (np)->flags &= ~AST_OUT_SHAPE
#define AST_SET_OUT_SHAPE(np)     (np)->flags |= AST_OUT_SHAPE

#define AST_COMM_STATUS_SET(np)   (AST_COMM_STATUS & (np)->flags)
#define AST_CLR_COMM_STATUS(np)   (np)->flags &= ~AST_COMM_STATUS
#define AST_SET_COMM_STATUS(np)   (np)->flags |= AST_COMM_STATUS

#define AST_ADD_COMM_STATUS_SET(np) (AST_ADD_COMM_STATUS & (np)->flags)
#define AST_CLR_ADD_COMM_STATUS(np) (np)->flags &= ~AST_ADD_COMM_STATUS
#define AST_SET_ADD_COMM_STATUS(np) (np)->flags |= AST_ADD_COMM_STATUS

#define AST_FAULT_STATUS_SET(np)   (AST_FAULT_STATUS & (np)->flags)
#define AST_CLR_FAULT_STATUS(np)   (np)->flags &= ~AST_FAULT_STATUS
#define AST_SET_FAULT_STATUS(np)   (np)->flags |= AST_FAULT_STATUS

#define AST_ADD_FAULT_STATUS_SET(np) (AST_ADD_FAULT_STATUS & (np)->flags)
#define AST_CLR_ADD_FAULT_STATUS(np) (np)->flags &= ~AST_ADD_FAULT_STATUS
#define AST_SET_ADD_FAULT_STATUS(np) (np)->flags |= AST_ADD_FAULT_STATUS

#define AST_CS_STAG_SET(np)     (AST_CS_STAG & (np)->flags)
#define AST_CLR_CS_STAG(np)     (np)->flags &= ~AST_CS_STAG
#define AST_SET_CS_STAG(np)     (np)->flags |= AST_CS_STAG

#define AST_CS_DRTAG_SET(np)    (AST_CS_DRTAG & (np)->flags)
#define AST_CLR_CS_DRTAG(np)    (np)->flags &= ~AST_CS_DRTAG
#define AST_SET_CS_DRTAG(np)    (np)->flags |= AST_CS_DRTAG

#define AST_CS_RTAG_SET(np)     (AST_CS_RTAG & (np)->flags)
#define AST_CLR_CS_RTAG(np)     (np)->flags &= ~AST_CS_RTAG
#define AST_SET_CS_RTAG(np)     (np)->flags |= AST_CS_RTAG

#define AST_HIDDEN_SET(np)      (AST_HIDDEN & (np)->flags)
#define AST_CLR_HIDDEN(np)      (np)->flags &= ~AST_HIDDEN
#define AST_SET_HIDDEN(np)      (np)->flags |= AST_HIDDEN

#define AST_HANDLE_SET(np)        (AST_HANDLE & (np)->flags)
#define AST_CLR_HANDLE(np)        (np)->flags &= ~AST_HANDLE
#define AST_SET_HANDLE(np)        (np)->flags |= AST_HANDLE

#define AST_CONTEXT_RD_SET(np)    (AST_CONTEXT_RD & (np)->flags)
#define AST_CLR_CONTEXT_RD(np)    (np)->flags &= ~AST_CONTEXT_RD
#define AST_SET_CONTEXT_RD(np)    (np)->flags |= AST_CONTEXT_RD

#define AST_SELF_POINTER_SET(np)  (AST_SELF_POINTER & (np)->flags)
#define AST_CLR_SELF_POINTER(np)  (np)->flags &= ~AST_SELF_POINTER
#define AST_SET_SELF_POINTER(np)  (np)->flags |= AST_SELF_POINTER

#define AST_CONTEXT_SET(np)       (AST_CONTEXT & (np)->flags)
#define AST_CLR_CONTEXT(np)       (np)->flags &= ~AST_CONTEXT
#define AST_SET_CONTEXT(np)       (np)->flags |= AST_CONTEXT

#define AST_FIXED_LOWER_SET(np)   (AST_FIXED_LOWER & (np)->flags)
#define AST_CLR_FIXED_LOWER(np)   (np)->flags &= ~AST_FIXED_LOWER
#define AST_SET_FIXED_LOWER(np)   (np)->flags |= AST_FIXED_LOWER

#define AST_FIXED_UPPER_SET(np)   (AST_FIXED_UPPER & (np)->flags)
#define AST_CLR_FIXED_UPPER(np)   (np)->flags &= ~AST_FIXED_UPPER
#define AST_SET_FIXED_UPPER(np)   (np)->flags |= AST_FIXED_UPPER

#define AST_CONFORMANT_SET(np)    (AST_CONFORMANT & (np)->flags)
#define AST_CLR_CONFORMANT(np)    (np)->flags &= ~AST_CONFORMANT
#define AST_SET_CONFORMANT(np)    (np)->flags |= AST_CONFORMANT

#define AST_VARYING_SET(np)       (AST_VARYING & (np)->flags)
#define AST_CLR_VARYING(np)       (np)->flags &= ~AST_VARYING
#define AST_SET_VARYING(np)       (np)->flags |= AST_VARYING

#define AST_DEF_AS_TAG_SET(np)    (AST_DEF_AS_TAG & (np)->flags)
#define AST_CLR_DEF_AS_TAG(np)    (np)->flags &= ~AST_DEF_AS_TAG
#define AST_SET_DEF_AS_TAG(np)    (np)->flags |= AST_DEF_AS_TAG

#define AST_IN_FIXED_SET(np)       (AST_IN_FIXED & (np)->flags)
#define AST_CLR_IN_FIXED(np)       (np)->flags &= ~AST_IN_FIXED
#define AST_SET_IN_FIXED(np)       (np)->flags |= AST_IN_FIXED

#define AST_IN_VARYING_SET(np)       (AST_IN_VARYING & (np)->flags)
#define AST_CLR_IN_VARYING(np)       (np)->flags &= ~AST_IN_VARYING
#define AST_SET_IN_VARYING(np)       (np)->flags |= AST_IN_VARYING

#define AST_OUT_FIXED_SET(np)       (AST_OUT_FIXED & (np)->flags)
#define AST_CLR_OUT_FIXED(np)       (np)->flags &= ~AST_OUT_FIXED
#define AST_SET_OUT_FIXED(np)       (np)->flags |= AST_OUT_FIXED

#define AST_OUT_VARYING_SET(np)       (AST_OUT_VARYING & (np)->flags)
#define AST_CLR_OUT_VARYING(np)       (np)->flags &= ~AST_OUT_VARYING
#define AST_SET_OUT_VARYING(np)       (np)->flags |= AST_OUT_VARYING

#define AST_IN_PA_STUB_SET(np)       (AST_IN_PA_STUB & (np)->flags)
#define AST_CLR_IN_PA_STUB(np)       (np)->flags &= ~AST_IN_PA_STUB
#define AST_SET_IN_PA_STUB(np)       (np)->flags |= AST_IN_PA_STUB

#define AST_OUT_PA_STUB_SET(np)       (AST_OUT_PA_STUB & (np)->flags)
#define AST_CLR_OUT_PA_STUB(np)       (np)->flags &= ~AST_OUT_PA_STUB
#define AST_SET_OUT_PA_STUB(np)       (np)->flags |= AST_OUT_PA_STUB

#define AST_EXTERN_SET(np)  (AST_EXTERN & (np)->flags)
#define AST_CLR_EXTERN(np)  (np)->flags &= ~AST_EXTERN
#define AST_SET_EXTERN(np)  (np)->flags |= AST_EXTERN

/* Mutable pointers are represented by unique and ref bits clear */
#define AST_MUTABLE_SET(np)       (((np)->flags & (AST_UNIQUE|AST_REF)) == 0)
#define AST_SET_MUTABLE(np)       ((np) == (np))



/*
 *  A S T _ f l a g s _ t
 *
 *  32-bit flag word
 */

typedef unsigned long AST_flags_t;


/*
 *  A S T _ i n t e r f a c e _ n _ t
 */

typedef struct AST_interface_n_t {
    fe_info_t            *fe_info;
    be_info_t            be_info;

    NAMETABLE_id_t       name;

    /*
     * interface attributes
     */
    nidl_uuid_t         uuid;
    unsigned long int   version;
    int                 number_of_ports;        /* Number of protocol/endpoints below */
    STRTAB_str_t        *protocol;              /* Pointer to array of protocol strings */
    STRTAB_str_t        *endpoints;             /* Pointer to array of endpoint strings */
    NAMETABLE_id_t      implicit_handle_name;
    NAMETABLE_id_t      implicit_handle_type_name;
    struct AST_type_n_t *implicit_handle_type;
    int                 op_count;               /* synthsized: */
    AST_flags_t         flags;

    /*
     *  The following five fields head lists of type_p_n_t nodes that point
     *  to exported types that, in one way or another, oblige the backend
     *  to construct routines other than the basic stub routines for the
     *  operations of the interface.
     */
    struct AST_type_p_n_t *pipe_types; /* synth: list of pipe types */
    struct AST_type_p_n_t *ool_types;  /* synth: list of [out_of_line] types */
    struct AST_type_p_n_t *ra_types;   /* synth: list of [represent_as] types */
    struct AST_type_p_n_t *cs_types;   /* synth: list of [cs_char] types */
    struct AST_type_p_n_t *sp_types;   /* synth: list of self_pointer types */
    struct AST_type_p_n_t *pa_types;   /* synth: list of pointed-at types */
    struct AST_type_p_n_t *up_types;   /* synth: list of unions containing pointers */
    struct AST_include_n_t *includes;
    struct AST_import_n_t  *imports;
    struct AST_export_n_t  *exports;
    struct AST_exception_n_t *exceptions;  /* list of user-defined exceptions */
    NAMETABLE_id_t     cs_tag_rtn_name; /* [cs_tag_rtn] name if any */
    struct AST_name_n_t   *cs_tag_rtns; /* synth: list of [cs_tag_rtn] names */
    NAMETABLE_id_t  binding_callout_name;  /* [binding_callout] name if any */
} AST_interface_n_t;


/*
 *  A S T _ t y p e _ p _ n _ t
 */

typedef struct AST_type_p_n_t {
    fe_info_t             *fe_info;
    be_info_t             be_info;
    struct AST_type_p_n_t *next;
    struct AST_type_p_n_t *last;
    struct AST_type_n_t   *type;
} AST_type_p_n_t;


/*
 *  A S T _ i n c l u d e  _ n _ t
 */

typedef struct AST_include_n_t {
    fe_info_t              *fe_info;
    be_info_t              be_info;
    struct AST_include_n_t *next;
    struct AST_include_n_t *last;
    STRTAB_str_t           file_name;
    STRTAB_str_t           simple_file_name;
} AST_include_n_t;


/*
 *  A S T _ e x c e p t i o n _ n _ t
 */

typedef struct AST_exception_n_t {
    fe_info_t                   *fe_info;
    be_info_t                   be_info;
    struct AST_exception_n_t    *next;
    struct AST_exception_n_t    *last;
    NAMETABLE_id_t              name;
    AST_flags_t                 flags;
} AST_exception_n_t;


/*
 *  A S T _ n a m e _ n _ t
 */

typedef struct AST_name_n_t {
    fe_info_t               *fe_info;
    be_info_t               be_info;
    struct AST_name_n_t     *next;
    struct AST_name_n_t     *last;
    NAMETABLE_id_t          name;
} AST_name_n_t;


/*
 *  A S T _ i m p o r t _ n _ t
 */

typedef struct AST_import_n_t {
    fe_info_t             *fe_info;
    be_info_t             be_info;
    struct AST_import_n_t *next;
    struct AST_import_n_t *last;
    STRTAB_str_t          file_name;
    AST_interface_n_t     *interface;
} AST_import_n_t;


/*
 *  A S T _ e x p o r t _ k _ t
 */

typedef enum {
    AST_constant_k,
    AST_operation_k,
    AST_type_k
} AST_export_k_t;


/*
 *  A S T _ e x p o r t _ n _ t
 */

typedef struct AST_export_n_t {
    fe_info_t             *fe_info;
    be_info_t             be_info;
    struct AST_export_n_t *next;
    struct AST_export_n_t *last;
    AST_export_k_t        kind;
    union {
        struct AST_constant_n_t  *exported_constant;
        struct AST_type_n_t      *exported_type;
        struct AST_operation_n_t *exported_operation;
    } thing_p;
} AST_export_n_t;


/*
 *  A S T _ c o n s t a n t _ k _ t
 */

typedef enum {
    AST_nil_const_k,
    AST_int_const_k,
    AST_hyper_int_const_k,
    AST_char_const_k,
    AST_string_const_k,
    AST_boolean_const_k
} AST_constant_k_t;


/*
 *  A S T _ c o n s t a n t _ n _ t
 */

typedef struct AST_constant_n_t {
    fe_info_t               *fe_info;
    be_info_t               be_info;
    struct AST_constant_n_t *next;
    struct AST_constant_n_t *last;
    NAMETABLE_id_t          name;
    struct AST_constant_n_t *defined_as;
    AST_constant_k_t        kind;
    union {
        STRTAB_str_t string_val;
        char         char_val;
        boolean      boolean_val;
        long int     int_val;
        struct {
            long int high;
            unsigned long int low;
        }            hyper_int_val;
    } value;
} AST_constant_n_t;


/*
 *  A S T _ t y p e _ k _ t
 */

typedef enum {
    AST_handle_k,

    AST_boolean_k, AST_byte_k, AST_character_k,

    AST_small_integer_k, AST_short_integer_k, AST_long_integer_k,
    AST_hyper_integer_k,

    AST_small_unsigned_k, AST_short_unsigned_k, AST_long_unsigned_k,
    AST_hyper_unsigned_k,

    AST_short_float_k, AST_long_float_k,

    AST_array_k, AST_structure_k, AST_pipe_k, AST_pointer_k, AST_void_k,
    AST_function_k, AST_disc_union_k, AST_enum_k,

    AST_null_k
} AST_type_k_t;


/*
 *  A S T _ t y p e _ n _ t
 */

typedef struct AST_type_n_t {
    fe_info_t           *fe_info;
    be_info_t           be_info;
    NAMETABLE_id_t      name;        /* NAMETABLE_NIL_ID iff anonymous type exp */
    struct AST_type_n_t *defined_as;
    AST_type_k_t        kind;
    union {
        struct AST_array_n_t       *array;        /* kind == array_k */
        struct AST_disc_union_n_t  *disc_union;   /*  "   == disc_union_k */
        struct AST_enumeration_n_t *enumeration;  /*  "   == enum_k */
        struct AST_pipe_n_t        *pipe;         /*  "   == pipe_k */
        struct AST_pointer_n_t     *pointer;      /*  "   == pointer_k */
        struct AST_operation_n_t   *function;     /*  "   == function_k */
        struct AST_structure_n_t   *structure;    /*  "   == structure_k */
    } type_structure;


    /* type attributes */
    AST_flags_t           flags;
    struct AST_type_n_t   *xmit_as_type;
    struct AST_rep_as_n_t *rep_as_type;
    struct AST_cs_char_n_t *cs_char_type;

    int                 ndr_size;       /* size of type in bytes; 0 means unspecified */
    int                 alignment_size; /* 0 means [unaligned] was specified */
    struct AST_type_n_t   *array_rep_type;
    IR_info_t           ir_info;
    struct IR_tup_n_t   *data_tups;     /* Intermediate rep tuples */
} AST_type_n_t;


/*
 *  A S T _ r e p _ a s _ n _ t
 */

typedef struct AST_rep_as_n_t {
    fe_info_t             *fe_info;
    be_info_t             be_info;
    NAMETABLE_id_t        type_name;
    STRTAB_str_t          file_name;
    IR_info_t           ir_info;
    struct IR_tup_n_t   *data_tups;     /* Intermediate rep tuples */
} AST_rep_as_n_t;


/*
 *  A S T _ c s _ c h a r _ n _ t
 */

typedef struct AST_cs_char_n_t {
    fe_info_t             *fe_info;
    be_info_t             be_info;
    NAMETABLE_id_t        type_name;
    IR_info_t           ir_info;
    struct IR_tup_n_t   *data_tups;     /* Intermediate rep tuples */
} AST_cs_char_n_t;


/*
 *  A S T _ a r r a y _ n _ t
 */

typedef struct AST_array_n_t {
    fe_info_t                  *fe_info;
    be_info_t                  be_info;
    struct AST_type_n_t        *element_type;
    unsigned short             index_count;
    struct AST_array_index_n_t *index_vec;  /* a vector of size index_count */
} AST_array_n_t;


/*
 *  A S T _ a r r a y _ i n d e x _ n _ t
 */

typedef struct AST_array_index_n_t {
    fe_info_t           *fe_info;
    be_info_t           be_info;
    AST_flags_t         flags;
    AST_constant_n_t    *lower_bound; /* defined iff (flags & FIXED_LOWER) */
    AST_constant_n_t    *upper_bound; /* defined iff (flags & FIXED_UPPER) */
} AST_array_index_n_t;


/*
 *  A S T _ d i s c _ u n i o n _ n _ t
 */

typedef struct AST_disc_union_n_t {
    fe_info_t           *fe_info;
    be_info_t           be_info;
    NAMETABLE_id_t      tag_name;   /* NAMETABLE_NIL_ID if no tag */
    NAMETABLE_id_t      union_name; /* id ("tagged_union" if no name supplied) */
    NAMETABLE_id_t      discrim_name;
    struct AST_type_n_t *discrim_type;
    struct AST_arm_n_t  *arms;
} AST_disc_union_n_t;


/*
 *  A S T _ a r m _ n _ t
 */

#if 0
typedef struct AST_arm_n_t {
    fe_info_t                 *fe_info;
    be_info_t                 be_info;
    struct AST_arm_n_t        *next;
    struct AST_arm_n_t        *last;
    AST_flags_t               flags;
    struct AST_case_label_n_t *labels;
    NAMETABLE_id_t            name;  /* NAMETABLE_NIL_ID iff rep of empty arm */
    AST_type_n_t              *type; /* NULL             iff rep of empty arm */
} AST_arm_n_t;
#endif

/*
 * The fields up to and including 'ir_info' must be identical and in the same
 * order in arm, field, and parameter nodes.
 */
typedef struct AST_arm_n_t {
    fe_info_t                 *fe_info;
    be_info_t                 be_info;
    struct AST_arm_n_t        *next;
    struct AST_arm_n_t        *last;
    AST_type_n_t              *type;        /* NULL iff rep of empty arm */
    struct AST_field_attr_n_t *field_attrs; /* Always NULL for arms */
    NAMETABLE_id_t            name;  /* NAMETABLE_NIL_ID iff rep of empty arm */
    AST_flags_t               flags;
    IR_info_t                 ir_info;
    struct AST_case_label_n_t *labels;
} AST_arm_n_t;


/*
 *  A S T _ c a s e _ l a b e l _ n _ t
 */

typedef struct AST_case_label_n_t {
    fe_info_t                 *fe_info;
    be_info_t                 be_info;
    struct AST_case_label_n_t *next;
    struct AST_case_label_n_t *last;
    boolean                   default_label; /* iff represents default: */
    AST_constant_n_t          *value;
} AST_case_label_n_t;


/*
 *  A S T _ e n u m e r a t i o n _ n _ t
 */

typedef struct AST_enumeration_n_t {
    fe_info_t        *fe_info;
    be_info_t        be_info;
    AST_constant_n_t *enum_constants;
} AST_enumeration_n_t;


/*
 *  A S T _ p i p e _ n _ t
 */

typedef struct AST_pipe_n_t {
    fe_info_t    *fe_info;
    be_info_t    be_info;
    AST_type_n_t *base_type;
} AST_pipe_n_t;


/*
 *  A S T _ p o i n t e r _ n _ t
 */

typedef struct AST_pointer_n_t {
    fe_info_t    *fe_info;
    be_info_t    be_info;
    AST_type_n_t *pointee_type;
} AST_pointer_n_t;


/*
 *  A S T _ s t r u c t u r e _ n _ t
 */

typedef struct AST_structure_n_t {
    fe_info_t            *fe_info;
    be_info_t            be_info;
    struct AST_field_n_t *fields;
    NAMETABLE_id_t       tag_name;     /* NAMETABLE_NIL_ID if no tag */
} AST_structure_n_t;


/*
 *  A S T _ f i e l d _ n _t
 */

#if 0
typedef struct AST_field_n_t {
    fe_info_t                 *fe_info;
    be_info_t                 be_info;
    struct AST_field_n_t      *next;
    struct AST_field_n_t      *last;
    AST_flags_t               flags;
    NAMETABLE_id_t            name;
    struct AST_type_n_t       *type;
    struct AST_field_attr_n_t *field_attrs;
} AST_field_n_t;
#endif

/*
 * The fields up to and including 'ir_info' must be identical and in the same
 * order in arm, field, and parameter nodes.
 */
typedef struct AST_field_n_t {
    fe_info_t                 *fe_info;
    be_info_t                 be_info;
    struct AST_field_n_t      *next;
    struct AST_field_n_t      *last;
    struct AST_type_n_t       *type;
    struct AST_field_attr_n_t *field_attrs;
    NAMETABLE_id_t            name;
    AST_flags_t               flags;
    IR_info_t                 ir_info;
    int                       field_num;
} AST_field_n_t;



/*
 *  A S T _ f i e l d _ a t t r _ n _ t
 */
typedef struct AST_field_attr_n_t {
    fe_info_t                *fe_info;
    be_info_t                be_info;
    /*
     * these six fields will be NULL iff corresponding attribute not used
     */
    struct AST_field_ref_n_t *first_is_vec;
    struct AST_field_ref_n_t *last_is_vec;
    struct AST_field_ref_n_t *length_is_vec;
    struct AST_field_ref_n_t *min_is_vec;
    struct AST_field_ref_n_t *max_is_vec;
    struct AST_field_ref_n_t *size_is_vec;
    struct AST_field_ref_n_t *switch_is;
} AST_field_attr_n_t;


/*
 *  A S T _ f i e l d _ r e f _ n _ t
 *
 *  Used as elements of vector fields in field_attr_n_t.
 */

typedef struct AST_field_ref_n_t {
    fe_info_t *fe_info;
    be_info_t be_info;
    boolean   valid;
    union {
        struct AST_field_n_t     *f_ref;
        struct AST_parameter_n_t *p_ref;
    } ref;
} AST_field_ref_n_t;


/*
 *  A S T _ p a r a m e t e r _ n _ t
 */

#if 0
typedef struct AST_parameter_n_t {
    fe_info_t                 *fe_info;
    be_info_t                 be_info;
    struct AST_parameter_n_t  *next;
    struct AST_parameter_n_t  *last;
    NAMETABLE_id_t            name;
    struct AST_type_n_t       *type;
    struct AST_field_attr_n_t *field_attrs;
    AST_flags_t               flags;
    struct AST_operation_n_t  *uplink; /* points to op. containing parameter */
} AST_parameter_n_t;
#endif

/*
 * The fields up to and including 'ir_info' must be identical and in the same
 * order in arm, field, and parameter nodes.
 */
typedef struct AST_parameter_n_t {
    fe_info_t                 *fe_info;
    be_info_t                 be_info;
    struct AST_parameter_n_t  *next;
    struct AST_parameter_n_t  *last;
    struct AST_type_n_t       *type;
    struct AST_field_attr_n_t *field_attrs;
    NAMETABLE_id_t            name;
    AST_flags_t               flags;
    IR_info_t                 ir_info;
    struct IR_tup_n_t         *data_tups;   /* Intermediate rep tuples */
    int                       param_num;
    struct AST_operation_n_t  *uplink; /* points to op. containing parameter */
} AST_parameter_n_t;


/*
 *  A S T _ o p e r a t i o n _ n _ t
 */

typedef struct AST_operation_n_t {
    fe_info_t          *fe_info;
    be_info_t          be_info;
    AST_flags_t        flags;
    NAMETABLE_id_t     name;
    AST_parameter_n_t* parameters;
    AST_parameter_n_t* result;
    int                op_number;    /* inherited */
    IR_info_t          ir_info;
    struct IR_tup_n_t  *init_tups;   /* IREP tuples for stub initializations */
    struct IR_tup_n_t  *clean_tups;  /* IREP tuples for stub cleanups */
    NAMETABLE_id_t     cs_tag_rtn_name; /* [cs_tag_rtn] name if any */
} AST_operation_n_t;

/*
 * This is the common layout of the first fields of the primary instance nodes,
 * i.e. arm, field, and parameter nodes.  Note that the first 4 of these fields
 * must also agree with an ASTP_node_t.
 */
typedef struct AST_instance_n_t {
    fe_info_t                 *fe_info;
    be_info_t                 be_info;
    struct AST_instance_n_t   *next;
    struct AST_instance_n_t   *last;
    struct AST_type_n_t       *type;
    struct AST_field_attr_n_t *field_attrs;
    NAMETABLE_id_t            name;
    AST_flags_t               flags;
    IR_info_t                 ir_info;
} AST_instance_n_t;

#endif
