
# line 45 "acf.y"
/*----------------------*
 *  yacc included code  *
 *----------------------*/

/* Declarations in this section are copied from yacc source to y_tab.c. */

#include <nidl.h>               /* IDL compiler-wide defs */
#include <acf.h>                /* ACF include file - keep first! */

#include <ast.h>                /* Abstract Syntax Tree defs */
#include <astp.h>               /* Import AST processing routine defs */
#include <command.h>            /* Command line defs */
#include <message.h>            /* Error message defs */
#include <nidlmsg.h>            /* Error message IDs */
#include <files.h>
#include <propagat.h>
#include <checker.h>

extern AST_interface_n_t *the_interface;    /* Ptr to AST interface node */
extern boolean ASTP_parsing_main_idl;       /* True when parsing main IDL */

typedef union                   /* Attributes bitmask */
{
    struct
    {
        unsigned auto_handle    : 1;
        unsigned binding_callout: 1;
        unsigned code           : 1;
        unsigned comm_status    : 1;
        unsigned cs_char        : 1;
        unsigned cs_drtag       : 1;
        unsigned cs_rtag        : 1;
        unsigned cs_stag        : 1;
        unsigned cs_tag_rtn     : 1;
        unsigned decode         : 1;
        unsigned enable_allocate: 1;
        unsigned encode         : 1;
        unsigned explicit_handle: 1;
        unsigned extern_exceps  : 1;
        unsigned fault_status   : 1;
        unsigned heap           : 1;
        unsigned implicit_handle: 1;
        unsigned in_line        : 1;
        unsigned nocode         : 1;
        unsigned out_of_line    : 1;
        unsigned represent_as   : 1;
    }   bit;
    long    mask;
}   acf_attrib_t;

typedef struct acf_param_t      /* ACF parameter info structure */
{
    struct acf_param_t *next;                   /* Forward link */
    acf_attrib_t    parameter_attr;             /* Parameter attributes */
    NAMETABLE_id_t  param_id;                   /* Parameter name */
}   acf_param_t;


static acf_attrib_t interface_attr,     /* Interface attributes */
                    type_attr,          /* Type attributes */
                    operation_attr,     /* Operation attributes */
                    parameter_attr;     /* Parameter attributes */

static char     *interface_name,        /* Interface name */
                *impl_name,             /* Implicit handle name */
                *type_name,             /* Current type name */
                *repr_type_name,        /* Current represent_as type */
                *cs_char_type_name,     /* Current cs_char type */
                *operation_name,        /* Current operation name */
                *cs_tag_rtn_name,       /* Current cs_tag_rtn name */
                *binding_callout_name;  /* Current binding_callout name */

static boolean  named_type;             /* True if parsed type is named type */

static AST_include_n_t  *include_list,  /* List of AST include nodes */
                        *include_p;     /* Ptr to a created include node */

static acf_param_t  *parameter_list,        /* Param list for curr. operation */
                    *parameter_free_list;   /* List of available acf_param_t */
static boolean      parameter_attr_list;    /* True if param attrs specified */

static boolean      *cmd_opt;       /* Array of command option flags */
static void         **cmd_val;      /* Array of command option values */

# line 139 "acf.y"
typedef union 
{
    NAMETABLE_id_t  y_id;       /* Identifier */
    STRTAB_str_t    y_string;   /* Text string */
} YYSTYPE;
# define AUTO_HANDLE_KW 257
# define BINDING_CALLOUT_KW 258
# define CODE_KW 259
# define COMM_STATUS_KW 260
# define CS_CHAR_KW 261
# define CS_TAG_RTN_KW 262
# define ENABLE_ALLOCATE_KW 263
# define EXPLICIT_HANDLE_KW 264
# define EXTERN_EXCEPS_KW 265
# define FAULT_STATUS_KW 266
# define HANDLE_T_KW 267
# define HEAP_KW 268
# define IMPLICIT_HANDLE_KW 269
# define INCLUDE_KW 270
# define INTERFACE_KW 271
# define IN_LINE_KW 272
# define NOCODE_KW 273
# define OUT_OF_LINE_KW 274
# define REPRESENT_AS_KW 275
# define TYPEDEF_KW 276
# define COMMA 277
# define LBRACE 278
# define LBRACKET 279
# define LPAREN 280
# define RBRACE 281
# define RBRACKET 282
# define RPAREN 283
# define SEMI 284
# define UNKNOWN 285
# define IDENTIFIER 286
# define STRING 287
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
typedef int yytabelem;
# define YYERRCODE 256

# line 1113 "acf.y"


/***************************
 *  yacc programs section  *
 ***************************/

/*
 *  a c f _ i n i t
 *
 *  Function:   Called before ACF parsing to initialize variables.
 *
 */

void acf_init
#ifdef PROTO
(
    boolean     *cmd_opt_arr,   /* [in] Array of command option flags */
    void        **cmd_val_arr,  /* [in] Array of command option values */
    char        *acf_file       /* [in] ACF file name */
)
#else
(cmd_opt_arr, cmd_val_arr, acf_file)
    boolean     *cmd_opt_arr;   /* [in] Array of command option flags */
    void        **cmd_val_arr;  /* [in] Array of command option values */
    char        *acf_file;      /* [in] ACF file name */
#endif

{
    /* Save passed command array and interface node addrs in static storage. */
    cmd_opt = cmd_opt_arr;
    cmd_val = cmd_val_arr;

    /* Set global (STRTAB_str_t error_file_name_id) for error processing. */
    set_name_for_errors(acf_file);

    interface_attr.mask = 0;
    type_attr.mask      = 0;
    operation_attr.mask = 0;
    parameter_attr.mask = 0;

    interface_name      = NULL;
    type_name           = NULL;
    repr_type_name      = NULL;
    cs_char_type_name   = NULL;
    operation_name      = NULL;
    binding_callout_name= NULL;
    cs_tag_rtn_name     = NULL;

    include_list        = NULL;

    parameter_list      = NULL;
    parameter_free_list = NULL;
}

/*
 *  a c f _ c l e a n u p
 *
 *  Function:   Called after ACF parsing to free allocated memory.
 *
 */

#ifdef PROTO
void acf_cleanup(void)
#else
void acf_cleanup()
#endif

{
    acf_param_t *p, *q;     /* Ptrs to parameter record */

    p = parameter_free_list;

    while (p != NULL)
    {
        q = p;
        p = p->next;
        FREE(q);
    }
}

/*
**  a c f _ e r r o r
**
**  Issues an error message, and bumps the error count.
**
**  Note:       This function is not prototyped since the way we use it allows
**              it to be called with 1 to 6 arguments.
*/

static void acf_error(msgid, arg1, arg2, arg3, arg4, arg5)
    long    msgid;              /* [in] Message id */
    char    *arg1;              /* [in] 0 to 5 arguments to fill in message */
    char    *arg2;              /*      directives */
    char    *arg3;
    char    *arg4;
    char    *arg5;

{
    log_error(acf_yylineno, msgid, arg1, arg2, arg3, arg4, arg5);
}


/*
**  a c f _ w a r n i n g
**
**  Issues a warning message.
**
**  Note:       This function is not prototyped since the way we use it allows
**              it to be called with 1 to 6 arguments.
*/

static void acf_warning(msgid, arg1, arg2, arg3, arg4, arg5)
    long    msgid;              /* [in] Message id */
    char    *arg1;              /* [in] 0 to 5 arguments to fill in message */
    char    *arg2;              /*      directives */
    char    *arg3;
    char    *arg4;
    char    *arg5;

{
    log_warning(acf_yylineno, msgid, arg1, arg2, arg3, arg4, arg5);
}

/*
**  l o o k u p _ e x c e p t i o n
**
**  Looks up a name in the nametable, and if it is bound to a valid exception
**  node, returns the address of the exception node.
**
**  Returns:    TRUE if lookup succeeds, FALSE otherwise.
*/

static boolean lookup_exception
#ifdef PROTO
(
    NAMETABLE_id_t  excep_id,     /* [in] Nametable id of exception name */
    boolean         log_error,    /* [in] TRUE => log error if name not found */
    AST_exception_n_t **excep_ptr /*[out] Ptr to AST exception node */
)
#else
(excep_id, log_error, excep_ptr)
    NAMETABLE_id_t  excep_id;     /* [in] Nametable id of exception name */
    boolean         log_error;    /* [in] TRUE => log error if name not found */
    AST_exception_n_t **excep_ptr;/*[out] Ptr to AST exception node */
#endif

{
    AST_exception_n_t *excep_p;     /* Ptr to node bound to looked up name */
    char            *perm_excep_name;   /* Ptr to permanent copy */
    NAMETABLE_id_t  name_id;            /* Handle on permanent copy */

    if (excep_id != NAMETABLE_NIL_ID)
    {
        excep_p = (AST_exception_n_t *)NAMETABLE_lookup_binding(excep_id);

        if (excep_p != NULL && excep_p->fe_info->node_kind == fe_exception_n_k)
        {
            *excep_ptr = excep_p;
            return TRUE;
        }
    }

    if (log_error)
    {
        NAMETABLE_id_to_string(excep_id, &perm_excep_name);
        acf_error(NIDL_EXCNOTDEF, perm_excep_name);
    }

    *excep_ptr = NULL;
    return FALSE;
}

/*
**  l o o k u p _ t y p e
**
**  Looks up a name in the nametable, and if it is bound to a valid type
**  node, returns the address of the type node.
**
**  Returns:    TRUE if lookup succeeds, FALSE otherwise.
*/

static boolean lookup_type
#ifdef PROTO
(
    char            *type_name, /* [in] Name to look up */
    boolean         log_error,  /* [in] TRUE => log error if name not found */
    NAMETABLE_id_t  *type_id,   /*[out] Nametable id of type name */
    AST_type_n_t    **type_ptr  /*[out] Ptr to AST type node */
)
#else
(type_name, log_error, type_id, type_ptr)
    char            *type_name; /* [in] Name to look up */
    boolean         log_error;  /* [in] TRUE => log error if name not found */
    NAMETABLE_id_t  *type_id;   /*[out] Nametable id of type name */
    AST_type_n_t    **type_ptr; /*[out] Ptr to AST type node */
#endif

{
    AST_type_n_t    *type_p;    /* Ptr to node bound to looked up name */
    char            *perm_type_name;    /* Ptr to permanent copy */
    NAMETABLE_id_t  name_id;            /* Handle on permanent copy */

    *type_id = NAMETABLE_lookup_id(type_name);

    if (*type_id != NAMETABLE_NIL_ID)
    {
        type_p = (AST_type_n_t *)NAMETABLE_lookup_binding(*type_id);

        if (type_p != NULL && type_p->fe_info->node_kind == fe_type_n_k)
        {
            *type_ptr = type_p;
            return TRUE;
        }
    }

    if (log_error)
    {
        name_id = NAMETABLE_add_id(type_name);
        NAMETABLE_id_to_string(name_id, &perm_type_name);
        acf_error(NIDL_TYPNOTDEF, perm_type_name);
    }

    *type_ptr = NULL;
    return FALSE;
}

/*
**  l o o k u p _ o p e r a t i o n
**
**  Looks up a name in the nametable, and if it is bound to a valid operation
**  node, returns the address of the operation node.
**
**  Returns:    TRUE if lookup succeeds, FALSE otherwise.
*/

static boolean lookup_operation
#ifdef PROTO
(
    char            *op_name,   /* [in] Name to look up */
    boolean         log_error,  /* [in] TRUE => log error if name not found */
    NAMETABLE_id_t  *op_id,     /*[out] Nametable id of operation name */
    AST_operation_n_t **op_ptr  /*[out] Ptr to AST operation node */
)
#else
(op_name, log_error, op_id, op_ptr)
    char            *op_name;   /* [in] Name to look up */
    boolean         log_error;  /* [in] TRUE => log error if name not found */
    NAMETABLE_id_t  *op_id;     /*[out] Nametable id of operation name */
    AST_operation_n_t **op_ptr; /*[out] Ptr to AST operation node */
#endif

{
    AST_operation_n_t   *op_p;  /* Ptr to node bound to looked up name */
    char            *perm_op_name;      /* Ptr to permanent copy */
    NAMETABLE_id_t  name_id;            /* Handle on permanent copy */

    *op_id = NAMETABLE_lookup_id(op_name);

    if (*op_id != NAMETABLE_NIL_ID)
    {
        op_p = (AST_operation_n_t *)NAMETABLE_lookup_binding(*op_id);

        if (op_p != NULL && op_p->fe_info->node_kind == fe_operation_n_k)
        {
            *op_ptr = op_p;
            return TRUE;
        }
    }

    if (log_error)
    {
        name_id = NAMETABLE_add_id(op_name);
        NAMETABLE_id_to_string(name_id, &perm_op_name);
        acf_error(NIDL_OPNOTDEF, perm_op_name);
    }

    *op_ptr = NULL;
    return FALSE;
}

/*
**  l o o k u p _ p a r a m e t e r
**
**  Searches an operation node's parameter list for the parameter name passed.
**  If found, returns the address of the parameter node.
**
**  Returns:    TRUE if lookup succeeds, FALSE otherwise.
*/

static boolean lookup_parameter
#ifdef PROTO
(
    AST_operation_n_t   *op_p,          /* [in] Ptr to AST operation node */
    char                *param_name,    /* [in] Parameter name to look up */
    boolean             log_error,      /* [in] TRUE=> log error if not found */
    NAMETABLE_id_t      *param_id,      /*[out] Nametable id of param name */
    AST_parameter_n_t   **param_ptr     /*[out] Ptr to AST parameter node */
)
#else
(op_p, param_name, log_error, param_id, param_ptr)
    AST_operation_n_t   *op_p;          /* [in] Ptr to AST operation node */
    char                *param_name;    /* [in] Parameter name to look up */
    boolean             log_error;      /* [in] TRUE=> log error if not found */
    NAMETABLE_id_t      *param_id;      /*[out] Nametable id of param name */
    AST_parameter_n_t   **param_ptr;    /*[out] Ptr to AST parameter node */
#endif

{
    AST_parameter_n_t   *param_p;       /* Ptr to operation parameter node */
    char                *op_param_name; /* Name of an operation parameter */
    char                *op_name;       /* Operation name */
    char            *perm_param_name;   /* Ptr to permanent copy */
    NAMETABLE_id_t  name_id;            /* Handle on permanent copy */

    for (param_p = op_p->parameters ; param_p != NULL ; param_p = param_p->next)
    {
        NAMETABLE_id_to_string(param_p->name, &op_param_name);

        if (strcmp(param_name, op_param_name) == 0)
        {
            *param_id   = param_p->name;
            *param_ptr  = param_p;
            return TRUE;
        }
    }

    if (log_error)
    {
        char    *file_name;     /* Related file name */

        NAMETABLE_id_to_string(op_p->name, &op_name);
        name_id = NAMETABLE_add_id(param_name);
        NAMETABLE_id_to_string(name_id, &perm_param_name);

        STRTAB_str_to_string(op_p->fe_info->file, &file_name);

        acf_error(NIDL_PRMNOTDEF, perm_param_name, op_name);
        acf_error(NIDL_NAMEDECLAT, op_name, file_name,
                  op_p->fe_info->source_line);
    }

    return FALSE;
}

/*
**  l o o k u p _ r e p _ a s _ n a m e
**
**  Scans a list of type nodes that have represent_as types for a match with
**  the type name given by the parameter repr_name_id.  If so, returns the
**  address of the found type node and a pointer to the associated
**  represent_as type name.
**
**  Returns:    TRUE if lookup succeeds, FALSE otherwise.
*/

static boolean lookup_rep_as_name
#ifdef PROTO
(
    AST_type_p_n_t  *typep_p,           /* [in] Listhead of type ptr nodes */
    NAMETABLE_id_t  repr_name_id,       /* [in] represent_as name to look up */
    AST_type_n_t    **ret_type_p,       /*[out] Type node if found */
    char            **ret_type_name     /*[out] Type name if found */
)
#else
(typep_p, repr_name_id, ret_type_p, ret_type_name)
    AST_type_p_n_t  *typep_p;           /* [in] Listhead of type ptr nodes */
    NAMETABLE_id_t  repr_name_id;       /* [in] represent_as name to look up */
    AST_type_n_t    **ret_type_p;       /*[out] Type node if found */
    char            **ret_type_name;    /*[out] Type name if found */
#endif

{
    AST_type_n_t    *type_p;            /* Ptr to a type node */

    for ( ; typep_p != NULL ; typep_p = typep_p->next )
    {
        type_p = typep_p->type;
        if (type_p->name == repr_name_id)
        {
            *ret_type_p = type_p;
            NAMETABLE_id_to_string(type_p->rep_as_type->type_name,
                                   ret_type_name);
            return TRUE;
        }
    }

    return FALSE;
}

/*
**  l o o k u p _ c s _ c h a r _ n a m e
**
**  Scans a list of type nodes that have cs_char types for a match with
**  the type name given by the parameter cs_char_name_id.  If so, returns the
**  address of the found type node and a pointer to the associated
**  cs_char type name.
**
**  Returns:    TRUE if lookup succeeds, FALSE otherwise.
*/

static boolean lookup_cs_char_name
#ifdef PROTO
(
    AST_type_p_n_t  *typep_p,           /* [in] Listhead of type ptr nodes */
    NAMETABLE_id_t  cs_char_name_id,    /* [in] cs_char name to look up */
    AST_type_n_t    **ret_type_p,       /*[out] Type node if found */
    char            **ret_type_name     /*[out] Type name if found */
)
#else
(typep_p, cs_char_name_id, ret_type_p, ret_type_name)
    AST_type_p_n_t  *typep_p;           /* [in] Listhead of type ptr nodes */
    NAMETABLE_id_t  cs_char_name_id;    /* [in] cs_char name to look up */
    AST_type_n_t    **ret_type_p;       /*[out] Type node if found */
    char            **ret_type_name;    /*[out] Type name if found */
#endif

{
    AST_type_n_t    *type_p;            /* Ptr to a type node */

    for ( ; typep_p != NULL ; typep_p = typep_p->next )
    {
        type_p = typep_p->type;
        if (type_p->name == cs_char_name_id)
        {
            *ret_type_p = type_p;
            NAMETABLE_id_to_string(type_p->cs_char_type->type_name,
                                   ret_type_name);
            return TRUE;
        }
    }

    return FALSE;
}

/*
 *  a c f _ a l l o c _ p a r a m
 *
 *  Function:   Allocates an acf_param_t, either from the free list or heap.
 *
 *  Returns:    Address of acf_param_t
 *
 *  Globals:    parameter_free_list - listhead for free list
 *
 *  Side Effects:   Exits program if unable to allocate memory.
 */

#ifdef PROTO
static acf_param_t *alloc_param(void)
#else
static acf_param_t *alloc_param()
#endif

{
    acf_param_t *p;     /* Ptr to parameter record */

    if (parameter_free_list != NULL)
    {
        p = parameter_free_list;
        parameter_free_list = parameter_free_list->next;
    }
    else
    {
        p = (acf_param_t *)MALLOC(sizeof(acf_param_t));
        p->next                 = NULL;
        p->parameter_attr.mask  = 0;
        p->param_id             = NAMETABLE_NIL_ID;
    }

    return p;
}

/*
 *  a c f _ f r e e _ p a r a m
 *
 *  Function:   Frees an acf_param_t by reinitilizing it and returning it to
 *              the head of the free list.
 *
 *  Input:      p - Pointer to acf_param_t record
 *
 *  Globals:    parameter_free_list - listhead for free list
 */

static void free_param
#ifdef PROTO
(
    acf_param_t *p              /* [in] Pointer to acf_param_t record */
)
#else
(p)
    acf_param_t *p;             /* [in] Pointer to acf_param_t record */
#endif

{
    p->parameter_attr.mask  = 0;
    p->param_id             = NAMETABLE_NIL_ID;

    p->next                 = parameter_free_list;
    parameter_free_list     = p;
}


/*
 *  a c f _ f r e e _ p a r a m _ l i s t
 *
 *  Function:   Frees a list of acf_param_t records.
 *
 *  Input:      list - Address of list pointer
 *
 *  Output:     list pointer = NULL
 */

static void free_param_list
#ifdef PROTO
(
    acf_param_t **list          /* [in] Address of list pointer */
)
#else
(list)
    acf_param_t **list;         /* [in] Address of list pointer */
#endif

{
    acf_param_t *p, *q;     /* Ptrs to parameter record */

    p = *list;

    while (p != NULL)
    {
        q = p;
        p = p->next;
        free_param(q);
    }

    *list = NULL;            /* List now empty */
}

/*
 *  a d d _ p a r a m _ t o _ l i s t
 *
 *  Function:   Add a acf_param_t record to the end of a list.
 *
 *  Inputs:     p - Pointer to parameter record
 *              list - Address of list pointer
 *
 *  Outputs:    List is modified.
 */

void add_param_to_list
#ifdef PROTO
(
    acf_param_t *p,             /* [in] Pointer to parameter record */
    acf_param_t **list          /* [in] Address of list pointer */
)
#else
(p, list)
    acf_param_t *p;             /* [in] Pointer to parameter record */
    acf_param_t **list;         /* [in] Address of list pointer */
#endif

{
    acf_param_t *q;         /* Ptr to parameter record */

    if (*list == NULL)      /* If list empty */
        *list = p;          /* then list now points at param */
    else
    {
        for (q = *list ; q->next != NULL ; q = q->next)
            ;
        q->next = p;        /* else last record in list now points at param */
    }

    p->next = NULL;         /* Param is now last in list */
}

/*
**  a p p e n d _ p a r a m e t e r
**
**  Appends a parameter to an operation's parameter list.
*/

static void append_parameter
#ifdef PROTO
(
    AST_operation_n_t   *op_p,          /* [in] Ptr to AST operation node */
    char                *param_name,    /* [in] Parameter name */
    acf_attrib_t        *param_attr     /* [in] Parameter attributes */
)
#else
(op_p, param_name, param_attr)
    AST_operation_n_t   *op_p;          /* [in] Ptr to AST operation node */
    char                *param_name;    /* [in] Parameter name */
    acf_attrib_t        *param_attr;    /* [in] Parameter attributes */
#endif

{
    NAMETABLE_id_t      new_param_id;   /* Nametable id of new parameter name */
    AST_parameter_n_t   *new_param_p;   /* Ptr to new parameter node */
    AST_type_n_t        *new_type_p;    /* Ptr to new parameter type node */
    AST_pointer_n_t     *new_ptr_p;     /* Ptr to new pointer node */
    NAMETABLE_id_t      status_id;      /* Nametable id of status_t */
    AST_type_n_t        *status_type_p; /* Type node bound to status_t name */
    AST_parameter_n_t   *param_p;       /* Ptr to operation parameter node */

    /* Look up error_status_t type. */
    status_id = NAMETABLE_add_id("error_status_t");
    status_type_p = (AST_type_n_t *)NAMETABLE_lookup_binding(status_id);
    if (status_type_p == NULL)
    {
        acf_error(NIDL_ERRSTATDEF, "error_status_t", "nbase.idl");
        return;
    }

    /*
     * Have to create an '[out] error_status_t *param_name' parameter
     * that has the specified parameter attributes.
     */
    new_param_id = NAMETABLE_add_id(param_name);
    new_param_p = AST_parameter_node(new_param_id);
    new_type_p  = AST_type_node(AST_pointer_k);
    new_ptr_p   = AST_pointer_node(status_type_p);

    new_type_p->type_structure.pointer = new_ptr_p;
    AST_SET_REF(new_type_p);

    new_param_p->name = new_param_id;
    new_param_p->type = new_type_p;
    new_param_p->uplink = op_p;
    if (param_attr->bit.comm_status)
        AST_SET_ADD_COMM_STATUS(new_param_p);
    if (param_attr->bit.fault_status)
        AST_SET_ADD_FAULT_STATUS(new_param_p);
    AST_SET_OUT(new_param_p);
    AST_SET_REF(new_param_p);

    param_p = op_p->parameters;
    if (param_p == NULL)
    {
        /* Was null param list, now has one param. */
        op_p->parameters = new_param_p;
    }
    else if (param_p->last == NULL)
    {
        /* Was one param, now have two params. */
        param_p->next = new_param_p;
        param_p->last = new_param_p;
    }
    else
    {
        /* Was more than one param, now have one more. */
        param_p->last->next = new_param_p;
        param_p->last = new_param_p;
    }
}

/*
**  p r o c e s s _ r e p _ a s _ t y p e
**
**  Processes a [represent_as] clause applied to a type.  Validates that
**  [represent_as] types are not nested.  Adds the type to a list of types
**  that have the [represent_as] attribute.
*/

static void process_rep_as_type
#ifdef PROTO
(
    AST_interface_n_t   *int_p,     /* [in] Ptr to AST interface node */
    AST_type_n_t        *type_p,    /* [in] Ptr to AST type node */
    char            *ref_type_name  /* [in] Name in represent_as() clause */
)
#else
(int_p, type_p, ref_type_name)
    AST_interface_n_t   *int_p;     /* [in] Ptr to AST interface node */
    AST_type_n_t        *type_p;    /* [in] Ptr to AST type node */
    char            *ref_type_name; /* [in] Name in represent_as() clause */
#endif

{
    NAMETABLE_id_t  ref_type_id;    /* Nametable id of referenced name */
    char            *file_name;     /* Related file name */
    char            *perm_name;     /* Permanent copy of referenced name */
    AST_type_n_t    *parent_type_p; /* Parent type with same attribute */
    char            *parent_name;   /* Name of parent type */

    ref_type_id = NAMETABLE_add_id(ref_type_name);

    /*
     * Report error if the type name referenced in the attribute is an AST
     * type which also has the same attribute, i.e. types with this attribute
     * cannot nest.
     */
    if (lookup_rep_as_name(int_p->ra_types, ref_type_id, &parent_type_p,
                           &perm_name))
    {
        NAMETABLE_id_to_string(parent_type_p->name, &parent_name);
        STRTAB_str_to_string(parent_type_p->fe_info->acf_file, &file_name);

        acf_error(NIDL_REPASNEST);
        acf_error(NIDL_TYPEREPAS, parent_name, perm_name);
        acf_error(NIDL_NAMEDECLAT, parent_name, file_name,
                  parent_type_p->fe_info->acf_source_line);
    }

    /*
     * If the type node already has a type name for this attribute,
     * this one must duplicate that same name.
     */
    if (type_p->rep_as_type != NULL)
    {
        NAMETABLE_id_to_string(type_p->rep_as_type->type_name, &perm_name);

        if (strcmp(perm_name, ref_type_name) != 0)
        {
            char    *new_ref_type_name; /* Ptr to permanent copy */
            NAMETABLE_id_t  name_id;    /* Handle on perm copy */

            name_id = NAMETABLE_add_id(ref_type_name);
            NAMETABLE_id_to_string(name_id, &new_ref_type_name);

            STRTAB_str_to_string(
                            type_p->rep_as_type->fe_info->acf_file, &file_name);

            acf_error(NIDL_CONFREPRTYPE, new_ref_type_name, perm_name);
            acf_error(NIDL_NAMEDECLAT, perm_name, file_name,
                      type_p->rep_as_type->fe_info->acf_source_line);
        }
    }
    else
    {
        /*
         * Process valid [represent_as] clause.
         */
        AST_type_p_n_t  *typep_p;       /* Used to link type nodes */
        AST_rep_as_n_t  *repas_p;       /* Ptr to represent_as node */

        /* Add represent_as type name and build rep_as AST node. */

        repas_p = type_p->rep_as_type = AST_represent_as_node(ref_type_id);
        /* Store source information. */
        if (repas_p->fe_info != NULL)
        {
            repas_p->fe_info->acf_file = error_file_name_id;
            repas_p->fe_info->acf_source_line = acf_yylineno;
        }

        /* Check for associated def-as-tag node. */

        if (type_p->fe_info->tag_ptr != NULL)
            type_p->fe_info->tag_ptr->rep_as_type = type_p->rep_as_type;

        /* Link type node into list of represent_as types. */

        typep_p = AST_type_ptr_node();
        typep_p->type = type_p;

        int_p->ra_types = (AST_type_p_n_t *)AST_concat_element(
                                                (ASTP_node_t *)int_p->ra_types,
                                                (ASTP_node_t *)typep_p);
    }
}

/*
**  p r o c e s s _ c s _ c h a r _ t y p e
**
**  Processes a [cs_char] clause applied to a type.  Validates that
**  [cs_char] types are not nested.  Adds the type to a list of types
**  that have the [cs_char] attribute.
*/

static void process_cs_char_type
#ifdef PROTO
(
    AST_interface_n_t   *int_p,     /* [in] Ptr to AST interface node */
    AST_type_n_t        *type_p,    /* [in] Ptr to AST type node */
    char            *ref_type_name  /* [in] Name in cs_char() clause */
)
#else
(int_p, type_p, ref_type_name)
    AST_interface_n_t   *int_p;     /* [in] Ptr to AST interface node */
    AST_type_n_t        *type_p;    /* [in] Ptr to AST type node */
    char            *ref_type_name; /* [in] Name in cs_char() clause */
#endif

{
    NAMETABLE_id_t  ref_type_id;    /* Nametable id of referenced name */
    char            *file_name;     /* Related file name */
    char            *perm_name;     /* Permanent copy of referenced name */
    AST_type_n_t    *parent_type_p; /* Parent type with same attribute */
    char            *parent_name;   /* Name of parent type */

    ref_type_id = NAMETABLE_add_id(ref_type_name);

    /*
     * Report error if the type name referenced in the attribute is an AST
     * type which also has the same attribute, i.e. types with this attribute
     * cannot nest.
     */
    if (lookup_cs_char_name(int_p->cs_types, ref_type_id, &parent_type_p,
                            &perm_name))
    {
        NAMETABLE_id_to_string(parent_type_p->name, &parent_name);
        STRTAB_str_to_string(parent_type_p->fe_info->acf_file, &file_name);

        /*** This needs updating ***/
        acf_error(NIDL_REPASNEST);
        acf_error(NIDL_TYPEREPAS, parent_name, perm_name);
        acf_error(NIDL_NAMEDECLAT, parent_name, file_name,
                  parent_type_p->fe_info->acf_source_line);
    }

    /*
     * If the type node already has a type name for this attribute,
     * this one must duplicate that same name.
     */
    if (type_p->cs_char_type != NULL)
    {
        NAMETABLE_id_to_string(type_p->cs_char_type->type_name, &perm_name);

        if (strcmp(perm_name, ref_type_name) != 0)
        {
            char    *new_ref_type_name; /* Ptr to permanent copy */
            NAMETABLE_id_t  name_id;    /* Handle on perm copy */

            name_id = NAMETABLE_add_id(ref_type_name);
            NAMETABLE_id_to_string(name_id, &new_ref_type_name);

            STRTAB_str_to_string(
                        type_p->cs_char_type->fe_info->acf_file, &file_name);

            /*** This needs updating ***/
            acf_error(NIDL_CONFREPRTYPE, new_ref_type_name, perm_name);
            acf_error(NIDL_NAMEDECLAT, perm_name, file_name,
                      type_p->cs_char_type->fe_info->acf_source_line);
        }
    }
    else
    {
        /*
         * Process valid [cs_char] clause.
         */
        AST_type_p_n_t  *typep_p;       /* Used to link type nodes */
        AST_cs_char_n_t *cschar_p;      /* Ptr to cs_char node */

        /* Add cs_char type name and build cs_char AST node. */

        cschar_p = type_p->cs_char_type = AST_cs_char_node(ref_type_id);
        /* Store source information. */
        if (cschar_p->fe_info != NULL)
        {
            cschar_p->fe_info->acf_file = error_file_name_id;
            cschar_p->fe_info->acf_source_line = acf_yylineno;
        }

        /* Check for associated def-as-tag node. */

        if (type_p->fe_info->tag_ptr != NULL)
            type_p->fe_info->tag_ptr->cs_char_type = type_p->cs_char_type;

        /* Link type node into list of cs_char types. */

        typep_p = AST_type_ptr_node();
        typep_p->type = type_p;

        int_p->cs_types = (AST_type_p_n_t *)AST_concat_element(
                                                (ASTP_node_t *)int_p->cs_types,
                                                (ASTP_node_t *)typep_p);
    }
}

#ifdef DUMPERS
/*
 *  d u m p _ a t t r i b u t e s
 *
 *  Function:   Prints list of attributes parsed for a particular node type
 *
 *  Inputs:     header_text - Initial text before node name and attributes
 *              node_name   - Name of interface, type, operation, or parameter
 *              node_attr_p - Address of node attributes structure
 *
 *  Globals:    repr_type_name  - represent_as type name, used if bit is set
 *              cs_char_type_name - cs_char type name, used if bit is set
 *              cs_tag_rtn_name - cs_tag_rtn name, used if bit is set
 *              binding_callout_name - binding_callout name, used if bit is set
 */

static void dump_attributes
#ifdef PROTO
(
    char            *header_text,       /* [in] Initial output text */
    char            *node_name,         /* [in] Name of tree node */
    acf_attrib_t    *node_attr_p        /* [in] Node attributes ptr */
)
#else
(header_text, node_name, node_attr_p)
    char            *header_text;       /* [in] Initial output text */
    char            *node_name;         /* [in] Name of tree node */
    acf_attrib_t    *node_attr_p;       /* [in] Node attributes ptr */
#endif

#define MAX_ATTR_TEXT   1024    /* Big enough for lots of extern_exceptions */

{
    char            attr_text[MAX_ATTR_TEXT];   /* Buf for formatting attrs */
    int             pos;                /* Position in buffer */
    acf_attrib_t    node_attr;          /* Node attributes */

    node_attr = *node_attr_p;

    printf("%s %s", header_text, node_name);

    if (node_attr.mask == 0)
        printf("\n");
    else
    {
        printf(" attributes: ");
        strcpy(attr_text, "[");

        if (node_attr.bit.auto_handle)
            strcat(attr_text, "auto_handle, ");
        if (node_attr.bit.code)
            strcat(attr_text, "code, ");
        if (node_attr.bit.nocode)
            strcat(attr_text, "nocode, ");
        if (node_attr.bit.comm_status)
            strcat(attr_text, "comm_status, ");
        if (node_attr.bit.decode)
            strcat(attr_text, "decode, ");
        if (node_attr.bit.enable_allocate)
            strcat(attr_text, "enable_allocate, ");
        if (node_attr.bit.encode)
            strcat(attr_text, "encode, ");
        if (node_attr.bit.explicit_handle)
            strcat(attr_text, "explicit_handle, ");
        if (node_attr.bit.extern_exceps && ASTP_parsing_main_idl)
        {
            AST_exception_n_t   *excep_p;
            char                *name;
            strcat(attr_text, "extern_exceptions(");
            for (excep_p = the_interface->exceptions;
                 excep_p != NULL;
                 excep_p = excep_p->next)
            {
                if (AST_EXTERN_SET(excep_p))
                {
                    NAMETABLE_id_to_string(excep_p->name, &name);
                    strcat(attr_text, name);
                    strcat(attr_text, ",");
                }
            }
            attr_text[strlen(attr_text)-1] = '\0';  /* overwrite trailing ',' */
            strcat(attr_text, "), ");
        }
        if (node_attr.bit.fault_status)
            strcat(attr_text, "fault_status, ");
        if (node_attr.bit.heap)
            strcat(attr_text, "heap, ");
        if (node_attr.bit.implicit_handle)
            strcat(attr_text, "implicit_handle, ");
        if (node_attr.bit.in_line)
            strcat(attr_text, "in_line, ");
        if (node_attr.bit.out_of_line)
            strcat(attr_text, "out_of_line, ");
        if (node_attr.bit.cs_stag)
            strcat(attr_text, "cs_stag, ");
        if (node_attr.bit.cs_drtag)
            strcat(attr_text, "cs_drtag, ");
        if (node_attr.bit.cs_rtag)
            strcat(attr_text, "cs_rtag, ");
        if (node_attr.bit.represent_as)
        {
            strcat(attr_text, "represent_as(");
            strcat(attr_text, repr_type_name);
            strcat(attr_text, "), ");
        }
        if (node_attr.bit.cs_char)
        {
            strcat(attr_text, "cs_char(");
            strcat(attr_text, cs_char_type_name);
            strcat(attr_text, "), ");
        }
        if (node_attr.bit.cs_tag_rtn)
        {
            strcat(attr_text, "cs_tag_rtn(");
            strcat(attr_text, cs_tag_rtn_name);
            strcat(attr_text, "), ");
        }
        if (node_attr.bit.binding_callout)
        {
            strcat(attr_text, "binding_callout(");
            strcat(attr_text, binding_callout_name);
            strcat(attr_text, "), ");
        }


        /* Overwrite trailing ", " with "]" */

        pos = strlen(attr_text) - strlen(", ");
        attr_text[pos] = ']';
        attr_text[pos+1] = '\0';

        printf("%s\n", attr_text);
    }
}
#endif
yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 111,
	286, 92,
	-2, 87,
	};
# define YYNPROD 111
# define YYLAST 267
yytabelem yyact[]={

    30,    24,    22,    59,    61,    25,   145,    26,    31,    90,
   142,   140,    29,    97,    93,    27,    23,    28,    22,    78,
    67,    25,    79,    26,   118,    80,    85,    78,    89,    21,
    83,    45,    23,    80,    61,   109,   126,    38,   125,    27,
   120,    28,    57,   155,    38,    77,   119,   158,    56,    55,
    54,    39,   157,   153,   154,   143,   124,    40,    39,   116,
    42,   123,    52,   115,    40,   114,   113,    42,    47,    33,
   128,   112,   127,    46,    43,   111,   100,    62,    51,    50,
    49,   108,    48,   134,     7,     4,   144,   122,   109,   110,
   108,    94,    27,     8,    28,   107,    17,   109,    16,    76,
    64,    27,    70,    28,   107,   104,     6,   147,   132,    96,
   101,    15,    14,    12,    11,    92,    69,    60,    66,    10,
    34,   146,   133,   131,    84,    82,    74,    68,   130,    65,
    41,   141,   139,   103,   102,    99,    98,    95,    63,    58,
    37,    36,    35,    32,    91,    88,   117,    87,    86,    20,
    19,    18,    13,    53,    75,    73,    72,    71,     9,    44,
     3,   106,     5,   105,     2,     1,     0,    81,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,   121,     0,     0,     0,     0,     0,     0,     0,
     0,   106,     0,   105,     0,    75,    73,    72,    71,   129,
   135,   152,   137,   151,   149,   138,   136,   148,     0,     0,
   150,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   156,     0,   152,     0,   151,   149,     0,
     0,   148,     0,     0,   150,     0,   159 };
yytabelem yypact[]={

  -194, -1000,  -172,  -178,  -257, -1000,  -212,  -207,  -255,  -209,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000,  -198,  -200, -1000, -1000, -1000,  -201,
 -1000,  -202,  -219, -1000, -1000,  -234,  -235,  -236,  -242,  -253,
  -179,  -266,  -241, -1000, -1000, -1000, -1000,  -257,  -256,  -260,
  -258,  -272, -1000, -1000, -1000, -1000, -1000, -1000,  -186, -1000,
 -1000, -1000, -1000,  -273,  -180,  -188, -1000,  -205,  -211, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000,  -218, -1000,  -220, -1000,  -224,  -262, -1000, -1000,
 -1000,  -237, -1000, -1000,  -283,  -190, -1000, -1000, -1000,  -221,
  -246, -1000, -1000, -1000, -1000, -1000, -1000,  -208,  -210, -1000,
  -266,  -196, -1000,  -241, -1000, -1000, -1000, -1000, -1000, -1000,
  -272, -1000,  -273, -1000,  -171, -1000, -1000,  -275,  -276, -1000,
  -228,  -191, -1000,  -280,  -233, -1000, -1000, -1000, -1000,  -229,
 -1000,  -240, -1000, -1000,  -196, -1000,  -230, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,  -233, -1000 };
yytabelem yypgo[]={

     0,   165,   164,   162,   160,   159,   158,   119,   114,   113,
   152,   112,   111,    98,    96,   151,   150,   149,   148,   147,
   146,   145,   144,   115,   143,   120,   142,   141,   140,   139,
   117,   138,   137,   109,   136,   135,   110,   134,   133,   105,
   132,   131,   130,   129,   118,   128,   127,   116,   102,   126,
    99,   125,   124,   123,   108,   122,   121,   107 };
yytabelem yyr1[]={

     0,     1,     2,     4,     4,     6,     6,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,    15,    18,
    19,    19,    21,    20,    17,    17,    22,    22,    23,     5,
     3,     3,     3,     3,    24,    24,    25,    25,    25,    25,
    26,    26,    29,    29,    30,    27,    27,    32,    32,    33,
    31,    31,    34,    34,    34,    35,    35,    36,    36,    36,
    36,    36,    37,    40,    38,    41,    28,    43,    43,    44,
    42,    42,    46,    46,    47,    47,    47,    47,    47,    47,
    47,    47,    10,    51,    11,    52,    45,    45,    53,    53,
    54,    55,    55,    56,    56,    57,    57,    57,    57,    57,
    57,    16,     8,     9,    49,    12,    39,    13,    14,    48,
    50 };
yytabelem yyr2[]={

     0,     4,     7,     6,     0,     2,     6,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     8,     4,
     3,     3,     2,     3,     8,     3,     2,     6,     3,     3,
     6,     4,     3,     5,     2,     4,     4,     4,     4,     5,
     5,     5,     2,     6,     3,     5,     7,     3,     7,     3,
     4,     0,     4,     5,     5,     2,     6,     3,     3,     3,
     3,     3,     8,     3,     8,     3,     5,     2,     6,     9,
     6,     0,     2,     6,     3,     3,     3,     3,     3,     3,
     3,     3,     8,     3,     8,     3,     2,     0,     2,     6,
     5,     7,     1,     2,     6,     3,     3,     3,     3,     3,
     3,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2 };
yytabelem yychk[]={

 -1000,    -1,    -2,    -4,   279,    -3,   278,   256,   271,    -6,
    -7,    -8,    -9,   -10,   -11,   -12,   -13,   -14,   -15,   -16,
   -17,   286,   259,   273,   258,   262,   264,   272,   274,   269,
   257,   265,   -24,   281,   -25,   -26,   -27,   -28,   256,   270,
   276,   -42,   279,   281,    -5,   286,   282,   277,   280,   280,
   280,   280,   281,   -25,   284,   284,   284,   284,   -29,   256,
   -30,   287,   256,   -31,   279,   -43,   -44,   286,   -46,   -47,
   -48,    -8,    -9,   -11,   -49,   -12,   -50,   286,   260,   263,
   266,    -7,   -51,   286,   -52,   286,   -18,   -19,   -21,   286,
   267,   -22,   -23,   286,   277,   -32,   -33,   286,   -34,   -35,
   256,   -36,   -37,   -38,   -39,   -13,   -14,   275,   261,   268,
   277,   280,   282,   277,   283,   283,   283,   -20,   286,   283,
   277,   -30,   277,   282,   277,   284,   282,   280,   280,   -44,
   -45,   -53,   -54,   -55,   279,   -47,   -23,   -33,   -36,   -40,
   286,   -41,   286,   283,   277,   286,   -56,   -57,   -48,   -50,
   -39,   -13,   -14,   286,   283,   283,   -54,   282,   277,   -57 };
yytabelem yydef[]={

     4,    -2,     0,     0,     0,     1,    71,    32,     0,     0,
     5,     7,     8,     9,    10,    11,    12,    13,    14,    15,
    16,    17,   102,   103,     0,     0,   105,   107,   108,     0,
   101,    25,    71,    31,    34,     0,     0,     0,     0,     0,
    51,     0,     0,    33,     2,    29,     3,     0,     0,     0,
     0,     0,    30,    35,    36,    37,    38,    39,    40,    41,
    42,    44,    45,     0,     0,    66,    67,     0,     0,    72,
    74,    75,    76,    77,    78,    79,    80,    81,   109,   104,
   110,     6,     0,    83,     0,    85,     0,     0,    20,    21,
    22,     0,    26,    28,     0,    46,    47,    49,    50,     0,
     0,    55,    57,    58,    59,    60,    61,     0,     0,   106,
     0,    -2,    70,     0,    82,    84,    18,    19,    23,    24,
     0,    43,     0,    52,     0,    53,    54,     0,     0,    68,
     0,    86,    88,     0,     0,    73,    27,    48,    56,     0,
    63,     0,    65,    69,    92,    90,     0,    93,    95,    96,
    97,    98,    99,   100,    62,    64,    89,    91,     0,    94 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"AUTO_HANDLE_KW",	257,
	"BINDING_CALLOUT_KW",	258,
	"CODE_KW",	259,
	"COMM_STATUS_KW",	260,
	"CS_CHAR_KW",	261,
	"CS_TAG_RTN_KW",	262,
	"ENABLE_ALLOCATE_KW",	263,
	"EXPLICIT_HANDLE_KW",	264,
	"EXTERN_EXCEPS_KW",	265,
	"FAULT_STATUS_KW",	266,
	"HANDLE_T_KW",	267,
	"HEAP_KW",	268,
	"IMPLICIT_HANDLE_KW",	269,
	"INCLUDE_KW",	270,
	"INTERFACE_KW",	271,
	"IN_LINE_KW",	272,
	"NOCODE_KW",	273,
	"OUT_OF_LINE_KW",	274,
	"REPRESENT_AS_KW",	275,
	"TYPEDEF_KW",	276,
	"COMMA",	277,
	"LBRACE",	278,
	"LBRACKET",	279,
	"LPAREN",	280,
	"RBRACE",	281,
	"RBRACKET",	282,
	"RPAREN",	283,
	"SEMI",	284,
	"UNKNOWN",	285,
	"IDENTIFIER",	286,
	"STRING",	287,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
      "acf_interface : acf_interface_header acf_interface_body",
      "acf_interface_header : acf_interface_attr_list INTERFACE_KW acf_interface_name",
      "acf_interface_attr_list : LBRACKET acf_interface_attrs RBRACKET",
      "acf_interface_attr_list : /* empty */",
      "acf_interface_attrs : acf_interface_attr",
      "acf_interface_attrs : acf_interface_attrs COMMA acf_interface_attr",
      "acf_interface_attr : acf_code_attr",
      "acf_interface_attr : acf_nocode_attr",
      "acf_interface_attr : acf_binding_callout_attr",
      "acf_interface_attr : acf_cs_tag_rtn_attr",
      "acf_interface_attr : acf_explicit_handle_attr",
      "acf_interface_attr : acf_inline_attr",
      "acf_interface_attr : acf_outofline_attr",
      "acf_interface_attr : acf_implicit_handle_attr",
      "acf_interface_attr : acf_auto_handle_attr",
      "acf_interface_attr : acf_extern_exceps_attr",
      "acf_interface_attr : IDENTIFIER",
      "acf_implicit_handle_attr : IMPLICIT_HANDLE_KW LPAREN acf_implicit_handle RPAREN",
      "acf_implicit_handle : acf_impl_type acf_impl_name",
      "acf_impl_type : acf_handle_type",
      "acf_impl_type : IDENTIFIER",
      "acf_handle_type : HANDLE_T_KW",
      "acf_impl_name : IDENTIFIER",
      "acf_extern_exceps_attr : EXTERN_EXCEPS_KW LPAREN acf_ext_excep_list RPAREN",
      "acf_extern_exceps_attr : EXTERN_EXCEPS_KW",
      "acf_ext_excep_list : acf_ext_excep",
      "acf_ext_excep_list : acf_ext_excep_list COMMA acf_ext_excep",
      "acf_ext_excep : IDENTIFIER",
      "acf_interface_name : IDENTIFIER",
      "acf_interface_body : LBRACE acf_body_elements RBRACE",
      "acf_interface_body : LBRACE RBRACE",
      "acf_interface_body : error",
      "acf_interface_body : error RBRACE",
      "acf_body_elements : acf_body_element",
      "acf_body_elements : acf_body_elements acf_body_element",
      "acf_body_element : acf_include SEMI",
      "acf_body_element : acf_type_declaration SEMI",
      "acf_body_element : acf_operation_declaration SEMI",
      "acf_body_element : error SEMI",
      "acf_include : INCLUDE_KW acf_include_list",
      "acf_include : INCLUDE_KW error",
      "acf_include_list : acf_include_name",
      "acf_include_list : acf_include_list COMMA acf_include_name",
      "acf_include_name : STRING",
      "acf_type_declaration : TYPEDEF_KW error",
      "acf_type_declaration : TYPEDEF_KW acf_type_attr_list acf_named_type_list",
      "acf_named_type_list : acf_named_type",
      "acf_named_type_list : acf_named_type_list COMMA acf_named_type",
      "acf_named_type : IDENTIFIER",
      "acf_type_attr_list : LBRACKET acf_rest_of_attr_list",
      "acf_type_attr_list : /* empty */",
      "acf_rest_of_attr_list : acf_type_attrs RBRACKET",
      "acf_rest_of_attr_list : error SEMI",
      "acf_rest_of_attr_list : error RBRACKET",
      "acf_type_attrs : acf_type_attr",
      "acf_type_attrs : acf_type_attrs COMMA acf_type_attr",
      "acf_type_attr : acf_represent_attr",
      "acf_type_attr : acf_cs_char_attr",
      "acf_type_attr : acf_heap_attr",
      "acf_type_attr : acf_inline_attr",
      "acf_type_attr : acf_outofline_attr",
      "acf_represent_attr : REPRESENT_AS_KW LPAREN acf_repr_type RPAREN",
      "acf_repr_type : IDENTIFIER",
      "acf_cs_char_attr : CS_CHAR_KW LPAREN acf_cs_char_type RPAREN",
      "acf_cs_char_type : IDENTIFIER",
      "acf_operation_declaration : acf_op_attr_list acf_operations",
      "acf_operations : acf_operation",
      "acf_operations : acf_operations COMMA acf_operation",
      "acf_operation : IDENTIFIER LPAREN acf_parameter_list RPAREN",
      "acf_op_attr_list : LBRACKET acf_op_attrs RBRACKET",
      "acf_op_attr_list : /* empty */",
      "acf_op_attrs : acf_op_attr",
      "acf_op_attrs : acf_op_attrs COMMA acf_op_attr",
      "acf_op_attr : acf_commstat_attr",
      "acf_op_attr : acf_code_attr",
      "acf_op_attr : acf_nocode_attr",
      "acf_op_attr : acf_cs_tag_rtn_attr",
      "acf_op_attr : acf_enable_allocate_attr",
      "acf_op_attr : acf_explicit_handle_attr",
      "acf_op_attr : acf_faultstat_attr",
      "acf_op_attr : IDENTIFIER",
      "acf_binding_callout_attr : BINDING_CALLOUT_KW LPAREN acf_binding_callout_name RPAREN",
      "acf_binding_callout_name : IDENTIFIER",
      "acf_cs_tag_rtn_attr : CS_TAG_RTN_KW LPAREN acf_cs_tag_rtn_name RPAREN",
      "acf_cs_tag_rtn_name : IDENTIFIER",
      "acf_parameter_list : acf_parameters",
      "acf_parameter_list : /* empty */",
      "acf_parameters : acf_parameter",
      "acf_parameters : acf_parameters COMMA acf_parameter",
      "acf_parameter : acf_param_attr_list IDENTIFIER",
      "acf_param_attr_list : LBRACKET acf_param_attrs RBRACKET",
      "acf_param_attr_list : /* empty */",
      "acf_param_attrs : acf_param_attr",
      "acf_param_attrs : acf_param_attrs COMMA acf_param_attr",
      "acf_param_attr : acf_commstat_attr",
      "acf_param_attr : acf_faultstat_attr",
      "acf_param_attr : acf_heap_attr",
      "acf_param_attr : acf_inline_attr",
      "acf_param_attr : acf_outofline_attr",
      "acf_param_attr : IDENTIFIER",
      "acf_auto_handle_attr : AUTO_HANDLE_KW",
      "acf_code_attr : CODE_KW",
      "acf_nocode_attr : NOCODE_KW",
      "acf_enable_allocate_attr : ENABLE_ALLOCATE_KW",
      "acf_explicit_handle_attr : EXPLICIT_HANDLE_KW",
      "acf_heap_attr : HEAP_KW",
      "acf_inline_attr : IN_LINE_KW",
      "acf_outofline_attr : OUT_OF_LINE_KW",
      "acf_commstat_attr : COMM_STATUS_KW",
      "acf_faultstat_attr : FAULT_STATUS_KW",
};
#endif /* YYDEBUG */
/* @(#)27       1.7.1.1  com/cmd/lang/yacc/yaccpar, cmdlang, bos320, 9209320f 2/19/92 16:36:02 */
/*
 * COMPONENT_NAME: (CMDLANG) Language Utilities
 *
 * FUNCTIONS: yyparse
 * ORIGINS: 03
 */
/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#ifdef YYSPLIT
#   define YYERROR      return(-2)
#else
#   define YYERROR      goto yyerrlab
#endif
#ifdef YACC_MSG
#ifndef _XOPEN_SOURCE
#define _XOPEN_SOURCE
#endif
#include <nl_types.h>
nl_catd catd;
#endif
#define YYACCEPT        return(0)
#define YYABORT         return(1)
#ifndef YACC_MSG
#define YYBACKUP( newtoken, newvalue )\
{\
        if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
        {\
                yyerror( "syntax error - cannot backup" );\
                YYERROR;\
        }\
        yychar = newtoken;\
        yystate = *yyps;\
        yylval = newvalue;\
        goto yynewstate;\
}
#else
#define YYBACKUP( newtoken, newvalue )\
{\
        if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
        {\
                catd=catopen("yacc_user.cat",0);\
                yyerror(catgets(catd,1,1,"syntax error - cannot backup" ));\
                YYERROR;\
        }\
        yychar = newtoken;\
        yystate = *yyps;\
        yylval = newvalue;\
        goto yynewstate;\
}
#endif
#define YYRECOVERING()  (!!yyerrflag)
#ifndef YYDEBUG
#       define YYDEBUG  1       /* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;                    /* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG          (-1000)

#ifdef YYSPLIT
#   define YYSCODE { \
                        extern int (*_yyf[])(); \
                        register int yyret; \
                        if (_yyf[yytmp]) \
                            if ((yyret=(*_yyf[yytmp])()) == -2) \
                                    goto yyerrlab; \
                                else if (yyret>=0) return(yyret); \
                   }
#endif

/*
** global variables used by the parser
*/
YYSTYPE yyv[ YYMAXDEPTH ];      /* value stack */
int yys[ YYMAXDEPTH ];          /* state stack */

YYSTYPE *yypv;                  /* top of value stack */
YYSTYPE *yypvt;                 /* top of value stack for $vars */
int *yyps;                      /* top of state stack */

int yystate;                    /* current state */
int yytmp;                      /* extra var (lasts between blocks) */

int yynerrs;                    /* number of errors */
int yyerrflag;                  /* error recovery flag */
int yychar;                     /* current input token number */

#ifdef __cplusplus
 #ifdef _CPP_IOSTREAMS
  #include <iostream.h>
  extern void yyerror (char *); /* error message routine -- iostream version */
 #else
  #include <stdio.h>
  extern "C" void yyerror (char *); /* error message routine -- stdio version */
 #endif /* _CPP_IOSTREAMS */
 extern "C" int yylex(void);        /* return the next token */
#endif /* __cplusplus */


/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
#ifdef __cplusplus
extern "C"
#endif /* __cplusplus */
int
yyparse()
{
        /*
        ** Initialize externals - yyparse may be called more than once
        */
        yypv = &yyv[-1];
        yyps = &yys[-1];
        yystate = 0;
        yytmp = 0;
        yynerrs = 0;
        yyerrflag = 0;
        yychar = -1;
#ifdef YACC_MSG
        catd=catopen("yacc_user.cat",0);
#endif
        goto yystack;
        {
                register YYSTYPE *yy_pv;        /* top of value stack */
                register int *yy_ps;            /* top of state stack */
                register int yy_state;          /* current state */
                register int  yy_n;             /* internal state number info */

                /*
                ** get globals into registers.
                ** branch to here only if YYBACKUP was called.
                */
        yynewstate:
                yy_pv = yypv;
                yy_ps = yyps;
                yy_state = yystate;
                goto yy_newstate;

                /*
                ** get globals into registers.
                ** either we just started, or we just finished a reduction
                */
        yystack:
                yy_pv = yypv;
                yy_ps = yyps;
                yy_state = yystate;

                /*
                ** top of for (;;) loop while no reductions done
                */
        yy_stack:
                /*
                ** put a state and value onto the stacks
                */
#if YYDEBUG
                /*
                ** if debugging, look up token value in list of value vs.
                ** name pairs.  0 and negative (-1) are special values.
                ** Note: linear search is used since time is not a real
                ** consideration while debugging.
                */
                if ( yydebug )
                {
                        register int yy_i;

#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                        cout << "State " << yy_state << " token ";
                        if ( yychar == 0 )
                                cout << "end-of-file" << endl;
                        else if ( yychar < 0 )
                                cout << "-none-" << endl;
#else
                        printf( "State %d, token ", yy_state );
                        if ( yychar == 0 )
                                printf( "end-of-file\n" );
                        else if ( yychar < 0 )
                                printf( "-none-\n" );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
                        else
                        {
                                for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
                                        yy_i++ )
                                {
                                        if ( yytoks[yy_i].t_val == yychar )
                                                break;
                                }
#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                                cout << yytoks[yy_i].t_name << endl;
#else
                                printf( "%s\n", yytoks[yy_i].t_name );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
                        }
                }
#endif /* YYDEBUG */
                if ( ++yy_ps >= &yys[ YYMAXDEPTH ] )    /* room on stack? */
                {
#ifndef YACC_MSG
                        yyerror( "yacc stack overflow" );
#else
                        yyerror(catgets(catd,1,2,"yacc stack overflow" ));
#endif
                        YYABORT;
                }
                *yy_ps = yy_state;
                *++yy_pv = yyval;

                /*
                ** we have a new state - find out what to do
                */
        yy_newstate:
                if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
                        goto yydefault;         /* simple state */
#if YYDEBUG
                /*
                ** if debugging, need to mark whether new token grabbed
                */
                yytmp = yychar < 0;
#endif
                if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
                        yychar = 0;             /* reached EOF */
#if YYDEBUG
                if ( yydebug && yytmp )
                {
                        register int yy_i;

#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                        cout << "Received token " << endl;
                        if ( yychar == 0 )
                                cout << "end-of-file" << endl;
                        else if ( yychar < 0 )
                                cout << "-none-" << endl;
#else
                        printf( "Received token " );
                        if ( yychar == 0 )
                                printf( "end-of-file\n" );
                        else if ( yychar < 0 )
                                printf( "-none-\n" );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
                        else
                        {
                                for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
                                        yy_i++ )
                                {
                                        if ( yytoks[yy_i].t_val == yychar )
                                                break;
                                }
#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                                cout << yytoks[yy_i].t_name << endl;
#else
                                printf( "%s\n", yytoks[yy_i].t_name );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
                        }
                }
#endif /* YYDEBUG */
                if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
                        goto yydefault;
                if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )  /*valid shift*/
                {
                        yychar = -1;
                        yyval = yylval;
                        yy_state = yy_n;
                        if ( yyerrflag > 0 )
                                yyerrflag--;
                        goto yy_stack;
                }

        yydefault:
                if ( ( yy_n = yydef[ yy_state ] ) == -2 )
                {
#if YYDEBUG
                        yytmp = yychar < 0;
#endif
                        if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
                                yychar = 0;             /* reached EOF */
#if YYDEBUG
                        if ( yydebug && yytmp )
                        {
                                register int yy_i;

#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                                cout << "Received token " << endl;
                                if ( yychar == 0 )
                                        cout << "end-of-file" << endl;
                                else if ( yychar < 0 )
                                        cout << "-none-" << endl;
#else
                                printf( "Received token " );
                                if ( yychar == 0 )
                                        printf( "end-of-file\n" );
                                else if ( yychar < 0 )
                                        printf( "-none-\n" );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
                                else
                                {
                                        for ( yy_i = 0;
                                                yytoks[yy_i].t_val >= 0;
                                                yy_i++ )
                                        {
                                                if ( yytoks[yy_i].t_val
                                                        == yychar )
                                                {
                                                        break;
                                                }
                                        }
#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                                        cout << yytoks[yy_i].t_name << endl;
#else
                                        printf( "%s\n", yytoks[yy_i].t_name );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
                                }
                        }
#endif /* YYDEBUG */
                        /*
                        ** look through exception table
                        */
                        {
                                register int *yyxi = yyexca;

                                while ( ( *yyxi != -1 ) ||
                                        ( yyxi[1] != yy_state ) )
                                {
                                        yyxi += 2;
                                }
                                while ( ( *(yyxi += 2) >= 0 ) &&
                                        ( *yyxi != yychar ) )
                                        ;
                                if ( ( yy_n = yyxi[1] ) < 0 )
                                        YYACCEPT;
                        }
                }

                /*
                ** check for syntax error
                */
                if ( yy_n == 0 )        /* have an error */
                {
                        /* no worry about speed here! */
                        switch ( yyerrflag )
                        {
                        case 0:         /* new error */
#ifndef YACC_MSG
                                yyerror( "syntax error" );
#else
                                yyerror(catgets(catd,1,3,"syntax error" ));
#endif
                                goto skip_init;
                        yyerrlab:
                                /*
                                ** get globals into registers.
                                ** we have a user generated syntax type error
                                */
                                yy_pv = yypv;
                                yy_ps = yyps;
                                yy_state = yystate;
                                yynerrs++;
                        skip_init:
                        case 1:
                        case 2:         /* incompletely recovered error */
                                        /* try again... */
                                yyerrflag = 3;
                                /*
                                ** find state where "error" is a legal
                                ** shift action
                                */
                                while ( yy_ps >= yys )
                                {
                                        yy_n = yypact[ *yy_ps ] + YYERRCODE;
                                        if ( yy_n >= 0 && yy_n < YYLAST &&
                                                yychk[yyact[yy_n]] == YYERRCODE)                                        {
                                                /*
                                                ** simulate shift of "error"
                                                */
                                                yy_state = yyact[ yy_n ];
                                                goto yy_stack;
                                        }
                                        /*
                                        ** current state has no shift on
                                        ** "error", pop stack
                                        */
#if YYDEBUG
                                        if ( yydebug )
#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                                            cout << "Error recovery pops state "
                                                 << (*yy_ps)
                                                 << ", uncovers state "
                                                 << yy_ps[-1] << endl;
#else
#       define _POP_ "Error recovery pops state %d, uncovers state %d\n"
                                                printf( _POP_, *yy_ps,
                                                        yy_ps[-1] );
#       undef _POP_
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
#endif
                                        yy_ps--;
                                        yy_pv--;
                                }
                                /*
                                ** there is no state on stack with "error" as
                                ** a valid shift.  give up.
                                */
                                YYABORT;
                        case 3:         /* no shift yet; eat a token */
#if YYDEBUG
                                /*
                                ** if debugging, look up token in list of
                                ** pairs.  0 and negative shouldn't occur,
                                ** but since timing doesn't matter when
                                ** debugging, it doesn't hurt to leave the
                                ** tests here.
                                */
                                if ( yydebug )
                                {
                                        register int yy_i;

#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                                        cout << "Error recovery discards ";
                                        if ( yychar == 0 )
                                            cout << "token end-of-file" << endl;
                                        else if ( yychar < 0 )
                                            cout << "token -none-" << endl;
#else
                                        printf( "Error recovery discards " );
                                        if ( yychar == 0 )
                                                printf( "token end-of-file\n" );
                                        else if ( yychar < 0 )
                                                printf( "token -none-\n" );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
                                        else
                                        {
                                                for ( yy_i = 0;
                                                        yytoks[yy_i].t_val >= 0;
                                                        yy_i++ )
                                                {
                                                        if ( yytoks[yy_i].t_val
                                                                == yychar )
                                                        {
                                                                break;
                                                        }
                                                }
#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                                                cout << "token " <<
                                                    yytoks[yy_i].t_name <<
                                                    endl;
#else
                                                printf( "token %s\n",
                                                        yytoks[yy_i].t_name );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
                                        }
                                }
#endif /* YYDEBUG */
                                if ( yychar == 0 )      /* reached EOF. quit */
                                        YYABORT;
                                yychar = -1;
                                goto yy_newstate;
                        }
                }/* end if ( yy_n == 0 ) */
                /*
                ** reduction by production yy_n
                ** put stack tops, etc. so things right after switch
                */
#if YYDEBUG
                /*
                ** if debugging, print the string that is the user's
                ** specification of the reduction which is just about
                ** to be done.
                */
                if ( yydebug )
#if defined(__cplusplus) && defined(_CPP_IOSTREAMS)
                        cout << "Reduce by (" << yy_n << ") \"" <<
                            yyreds[ yy_n ] << "\"\n";
#else
                        printf( "Reduce by (%d) \"%s\"\n",
                                yy_n, yyreds[ yy_n ] );
#endif /* defined(__cplusplus) && defined(_CPP_IOSTREAMS) */
#endif
                yytmp = yy_n;                   /* value to switch over */
                yypvt = yy_pv;                  /* $vars top of value stack */
                /*
                ** Look in goto table for next state
                ** Sorry about using yy_state here as temporary
                ** register variable, but why not, if it works...
                ** If yyr2[ yy_n ] doesn't have the low order bit
                ** set, then there is no action to be done for
                ** this reduction.  So, no saving & unsaving of
                ** registers done.  The only difference between the
                ** code just after the if and the body of the if is
                ** the goto yy_stack in the body.  This way the test
                ** can be made before the choice of what to do is needed.
                */
                {
                        /* length of production doubled with extra bit */
                        register int yy_len = yyr2[ yy_n ];

                        if ( !( yy_len & 01 ) )
                        {
                                yy_len >>= 1;
                                yyval = ( yy_pv -= yy_len )[1]; /* $$ = $1 */
                                yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
                                        *( yy_ps -= yy_len ) + 1;
                                if ( yy_state >= YYLAST ||
                                        yychk[ yy_state =
                                        yyact[ yy_state ] ] != -yy_n )
                                {
                                        yy_state = yyact[ yypgo[ yy_n ] ];
                                }
                                goto yy_stack;
                        }
                        yy_len >>= 1;
                        yyval = ( yy_pv -= yy_len )[1]; /* $$ = $1 */
                        yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
                                *( yy_ps -= yy_len ) + 1;
                        if ( yy_state >= YYLAST ||
                                yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
                        {
                                yy_state = yyact[ yypgo[ yy_n ] ];
                        }
                }
                                        /* save until reenter driver code */
                yystate = yy_state;
                yyps = yy_ps;
                yypv = yy_pv;
        }
        /*
        ** code supplied by user is placed in this switch
        */

                switch(yytmp){

case 2:
# line 207 "acf.y"
{
        char            *ast_int_name;  /* Interface name in AST node */
        NAMETABLE_id_t  type_id;        /* Nametable id of impl_handle type */
        NAMETABLE_id_t  impl_name_id;   /* Nametable id of impl_handle var */
        AST_type_n_t    *type_p;        /* Ptr to implicit_handle type node */

#ifdef DUMPERS
        if (cmd_opt[opt_dump_acf])
            dump_attributes("ACF interface", interface_name, &interface_attr);
#endif

        /* Store source information. */
        if (the_interface->fe_info != NULL)
        {
            the_interface->fe_info->acf_file = error_file_name_id;
            the_interface->fe_info->acf_source_line = acf_yylineno;
        }

        /*
         *  Interface attributes are saved for main and imported interfaces.
         *  the_interface = pointer to main or imported interface node
         *
         *  Make sure that the interface name in the ACF agrees with the
         *  interface name in the main IDL file.  Then set the parsed
         *  attributes in the interface node.
         *
         *  interface_attr = bitmask of interface attributes parsed.
         *  interface_name = ACF interface name parsed.
         */

        NAMETABLE_id_to_string(the_interface->name, &ast_int_name);

        if (strcmp(interface_name, ast_int_name) != 0)
        {
            char    *acf_int_name;      /* Ptr to permanent copy */
            NAMETABLE_id_t name_id;     /* Handle on permanent copy */
            char    *file_name;         /* Related file name */

            name_id = NAMETABLE_add_id(interface_name);
            NAMETABLE_id_to_string(name_id, &acf_int_name);

            STRTAB_str_to_string(the_interface->fe_info->file, &file_name);

            acf_error(NIDL_INTNAMDIF, acf_int_name, ast_int_name);
            acf_error(NIDL_NAMEDECLAT, ast_int_name, file_name,
                      the_interface->fe_info->source_line);
        }
        else
        {
            if (interface_attr.bit.code)
                AST_SET_CODE(the_interface);
            if (interface_attr.bit.nocode)
                AST_SET_NO_CODE(the_interface);
            if (interface_attr.bit.decode)
                AST_SET_DECODE(the_interface);
            if (interface_attr.bit.encode)
                AST_SET_ENCODE(the_interface);
            if (interface_attr.bit.explicit_handle)
                AST_SET_EXPLICIT_HANDLE(the_interface);
            if (interface_attr.bit.in_line)
                AST_SET_IN_LINE(the_interface);
            if (interface_attr.bit.out_of_line)
                AST_SET_OUT_OF_LINE(the_interface);
            if (interface_attr.bit.auto_handle)
                AST_SET_AUTO_HANDLE(the_interface);

            if (interface_attr.bit.cs_tag_rtn)
                the_interface->cs_tag_rtn_name = NAMETABLE_add_id(cs_tag_rtn_name);
            if (interface_attr.bit.binding_callout)
                the_interface->binding_callout_name = NAMETABLE_add_id(binding_callout_name);

            if (interface_attr.bit.implicit_handle)
            {
                /* Store the [implicit_handle] variable name in nametbl. */
                impl_name_id = NAMETABLE_add_id(impl_name);

                /*
                 * Store the type and name information in the AST.  If a
                 * named type, determine whether it is an IDL-defined type
                 * and process accordingly.  Otherwise the type is handle_t.
                 */
                if (named_type)
                {
                    if (lookup_type(type_name, FALSE, &type_id, &type_p))
                    {
                        the_interface->implicit_handle_name = impl_name_id;
                        the_interface->implicit_handle_type = type_p;
                        the_interface->implicit_handle_type_name = type_p->name;
                        if (AST_HANDLE_SET(type_p))
                            AST_SET_IMPLICIT_HANDLE_G(the_interface);
                    }
                    else    /* A user-defined type, not defined in IDL */
                    {
                        /* Store the user type name in nametbl. */
                        the_interface->implicit_handle_type_name
                            = NAMETABLE_add_id(type_name);

                        the_interface->implicit_handle_name = impl_name_id;
                        the_interface->implicit_handle_type = NULL;
                        AST_SET_IMPLICIT_HANDLE_G(the_interface);
                    }
                }
                else
                {
                    the_interface->implicit_handle_name = impl_name_id;
                    the_interface->implicit_handle_type = ASTP_handle_ptr;
                }
            }
        }

        interface_name = NULL;
        type_name = NULL;
        impl_name = NULL;
        binding_callout_name = NULL;
        cs_tag_rtn_name = NULL;
        interface_attr.mask = 0;        /* Reset attribute mask */
    } /*NOTREACHED*/ break;
case 7:
# line 338 "acf.y"
{
        if (interface_attr.bit.code)
            log_warning(yylineno, NIDL_MULATTRDEF);
        interface_attr.bit.code = TRUE;
    } /*NOTREACHED*/ break;
case 8:
# line 344 "acf.y"
{
        if (interface_attr.bit.nocode)
            log_warning(yylineno, NIDL_MULATTRDEF);
        interface_attr.bit.nocode = TRUE;
    } /*NOTREACHED*/ break;
case 9:
# line 350 "acf.y"
{
        if (interface_attr.bit.binding_callout)
            log_error(yylineno, NIDL_ATTRUSEMULT);
        interface_attr.bit.binding_callout = TRUE;
    } /*NOTREACHED*/ break;
case 10:
# line 356 "acf.y"
{
        if (interface_attr.bit.cs_tag_rtn)
            log_error(yylineno, NIDL_ATTRUSEMULT);
        interface_attr.bit.cs_tag_rtn = TRUE;
    } /*NOTREACHED*/ break;
case 11:
# line 362 "acf.y"
{
        if (interface_attr.bit.explicit_handle)
            log_warning(yylineno, NIDL_MULATTRDEF);
        interface_attr.bit.explicit_handle = TRUE;
    } /*NOTREACHED*/ break;
case 12:
# line 368 "acf.y"
{
        if (interface_attr.bit.in_line)
            log_warning(yylineno, NIDL_MULATTRDEF);
        interface_attr.bit.in_line = TRUE;
    } /*NOTREACHED*/ break;
case 13:
# line 374 "acf.y"
{
        if (interface_attr.bit.out_of_line)
            log_warning(yylineno, NIDL_MULATTRDEF);
        interface_attr.bit.out_of_line = TRUE;
    } /*NOTREACHED*/ break;
case 14:
# line 380 "acf.y"
{
        if (interface_attr.bit.implicit_handle)
            log_error(yylineno, NIDL_ATTRUSEMULT);
        interface_attr.bit.implicit_handle = TRUE;
    } /*NOTREACHED*/ break;
case 15:
# line 386 "acf.y"
{
        if (interface_attr.bit.auto_handle)
            log_warning(yylineno, NIDL_MULATTRDEF);
        interface_attr.bit.auto_handle = TRUE;
    } /*NOTREACHED*/ break;
case 16:
# line 392 "acf.y"
{
        if (interface_attr.bit.extern_exceps)
            log_warning(yylineno, NIDL_MULATTRDEF);
        interface_attr.bit.extern_exceps = TRUE;
    } /*NOTREACHED*/ break;
case 17:
# line 398 "acf.y"
{
        if (NAMETABLE_add_id("decode") == yypvt[-0].y_id)
        {
            if (interface_attr.bit.decode)
                log_warning(yylineno, NIDL_MULATTRDEF);
            interface_attr.bit.decode = TRUE;
        }
        else if (NAMETABLE_add_id("encode") == yypvt[-0].y_id)
        {
            if (interface_attr.bit.encode)
                log_warning(yylineno, NIDL_MULATTRDEF);
            interface_attr.bit.encode = TRUE;
        }
        else
            log_error(yylineno, NIDL_ERRINATTR);
    } /*NOTREACHED*/ break;
case 20:
# line 426 "acf.y"
{
        named_type = FALSE;
    } /*NOTREACHED*/ break;
case 21:
# line 430 "acf.y"
{
        NAMETABLE_id_to_string(yypvt[-0].y_id, &type_name);
        named_type = TRUE;
    } /*NOTREACHED*/ break;
case 23:
# line 442 "acf.y"
{
        NAMETABLE_id_to_string(yypvt[-0].y_id, &impl_name);
    } /*NOTREACHED*/ break;
case 25:
# line 450 "acf.y"
{
        if (ASTP_parsing_main_idl)
        {
            AST_exception_n_t *excep_p;
            for (excep_p = the_interface->exceptions;
                 excep_p != NULL;
                 excep_p = excep_p->next)
            {
                AST_SET_EXTERN(excep_p);
            }
        }
    } /*NOTREACHED*/ break;
case 28:
# line 471 "acf.y"
{
        AST_exception_n_t *excep_p;
        if (ASTP_parsing_main_idl)
            if (lookup_exception(yypvt[-0].y_id, TRUE, &excep_p))
                AST_SET_EXTERN(excep_p);
    } /*NOTREACHED*/ break;
case 29:
# line 481 "acf.y"
{
        NAMETABLE_id_to_string(yypvt[-0].y_id, &interface_name);
    } /*NOTREACHED*/ break;
case 32:
# line 490 "acf.y"
{ log_error(yylineno, NIDL_SYNTAXERR); } /*NOTREACHED*/ break;
case 33:
# line 492 "acf.y"
{ log_error(yylineno, NIDL_SYNTAXERR); } /*NOTREACHED*/ break;
case 39:
# line 505 "acf.y"
{
            log_error(yylineno, NIDL_SYNTAXERR);
            /* Re-initialize attr masks to avoid sticky attributes */
            interface_attr.mask = 0;
            type_attr.mask      = 0;
            operation_attr.mask = 0;
            parameter_attr.mask = 0;
        } /*NOTREACHED*/ break;
case 40:
# line 517 "acf.y"
{
        if (ASTP_parsing_main_idl)
            the_interface->includes = (AST_include_n_t *)
                AST_concat_element((ASTP_node_t *)the_interface->includes,
                                   (ASTP_node_t *)include_list);
        include_list = NULL;
        } /*NOTREACHED*/ break;
case 41:
# line 525 "acf.y"
{ log_error(yylineno, NIDL_SYNTAXERR); } /*NOTREACHED*/ break;
case 44:
# line 535 "acf.y"
{
        if (ASTP_parsing_main_idl)
        {
            char            *parsed_include_file;
            char            include_type[PATH_MAX];
            char            include_file[PATH_MAX];
            STRTAB_str_t    include_file_id;

            STRTAB_str_to_string(yypvt[-0].y_string, &parsed_include_file);

            /*
             * Log warning if include name contains a file extension.
             * Tack on the correct extension based on the -lang option.
             */
            FILE_parse(parsed_include_file, (char *)NULL, (char *)NULL,
                       include_type);
            if (include_type[0] != '\0')
                acf_warning(NIDL_INCLUDEXT);

            FILE_form_filespec(parsed_include_file, (char *)NULL,
			       ".h",
                               (char *)NULL, include_file);

            /* Create an include node. */
            include_file_id = STRTAB_add_string(include_file);
            include_p = AST_include_node(include_file_id, yypvt[-0].y_string);

            /* Store source information. */
            if (include_p->fe_info != NULL)
            {
                include_p->fe_info->acf_file = error_file_name_id;
                include_p->fe_info->acf_source_line = acf_yylineno;
            }

            include_list = (AST_include_n_t *)
                AST_concat_element((ASTP_node_t *)include_list,
                                   (ASTP_node_t *)include_p);
        }
    } /*NOTREACHED*/ break;
case 45:
# line 578 "acf.y"
{ log_error(yylineno, NIDL_SYNTAXERR); } /*NOTREACHED*/ break;
case 46:
# line 580 "acf.y"
{
        type_attr.mask = 0;             /* Reset attribute mask */
        repr_type_name = NULL;          /* Reset represent_as type name */
        cs_char_type_name = NULL;       /* Reset cs_char type name */
    } /*NOTREACHED*/ break;
case 47:
# line 589 "acf.y"
{
        type_name = NULL;               /* Reset type name */
    } /*NOTREACHED*/ break;
case 48:
# line 593 "acf.y"
{
        type_name = NULL;               /* Reset type name */
    } /*NOTREACHED*/ break;
case 49:
# line 600 "acf.y"
{
        NAMETABLE_id_t  type_id;        /* Nametable id of type name */
        AST_type_n_t    *type_p;        /* Ptr to AST type node */

        NAMETABLE_id_to_string(yypvt[-0].y_id, &type_name);

#ifdef DUMPERS
        if (cmd_opt[opt_dump_acf])
            dump_attributes("ACF type", type_name, &type_attr);
#endif

        /*
         *  Lookup the type_name parsed and verify that it is a valid type
         *  node.  Then set the parsed attributes in the type node.
         *
         *  type_attr = bitmask of type attributes parsed.
         *  type_name = name of type_t node to look up.
         *  [repr_type_name] = name of represent_as type.
         *  [cs_char_type_name] = name of cs_char type.
         */

        if (lookup_type(type_name, TRUE, &type_id, &type_p))
        {
            /* Store source information. */
            if (type_p->fe_info != NULL)
            {
                type_p->fe_info->acf_file = error_file_name_id;
                type_p->fe_info->acf_source_line = acf_yylineno;
            }

            if (type_attr.bit.heap
                && type_p->kind != AST_pipe_k
                && !AST_CONTEXT_RD_SET(type_p))
                PROP_set_type_attr(type_p,AST_HEAP);
            if (type_attr.bit.in_line)
                PROP_set_type_attr(type_p,AST_IN_LINE);
            if ((type_attr.bit.out_of_line) &&
                (type_p->kind != AST_pointer_k) &&
                (type_p->xmit_as_type == NULL))
                PROP_set_type_attr(type_p,AST_OUT_OF_LINE);
            if (type_attr.bit.represent_as)
                process_rep_as_type(the_interface, type_p, repr_type_name);
            if (type_attr.bit.cs_char)
                process_cs_char_type(the_interface, type_p, cs_char_type_name);
        }
    } /*NOTREACHED*/ break;
case 53:
# line 656 "acf.y"
{
        log_error(yylineno, NIDL_MISSONATTR);
        } /*NOTREACHED*/ break;
case 54:
# line 660 "acf.y"
{
        log_error(yylineno, NIDL_ERRINATTR);
        } /*NOTREACHED*/ break;
case 57:
# line 672 "acf.y"
{
        if (type_attr.bit.represent_as)
            log_error(yylineno, NIDL_ATTRUSEMULT);
        type_attr.bit.represent_as = TRUE;
    } /*NOTREACHED*/ break;
case 58:
# line 678 "acf.y"
{
        if (type_attr.bit.cs_char)
            log_error(yylineno, NIDL_ATTRUSEMULT);
        type_attr.bit.cs_char = TRUE;
    } /*NOTREACHED*/ break;
case 59:
# line 684 "acf.y"
{
        if (type_attr.bit.heap)
            log_warning(yylineno, NIDL_MULATTRDEF);
        type_attr.bit.heap = TRUE;
    } /*NOTREACHED*/ break;
case 60:
# line 690 "acf.y"
{
        if (type_attr.bit.in_line)
            log_warning(yylineno, NIDL_MULATTRDEF);
        type_attr.bit.in_line = TRUE;
    } /*NOTREACHED*/ break;
case 61:
# line 696 "acf.y"
{
        if (type_attr.bit.out_of_line)
            log_warning(yylineno, NIDL_MULATTRDEF);
        type_attr.bit.out_of_line = TRUE;
    } /*NOTREACHED*/ break;
case 63:
# line 709 "acf.y"
{
        NAMETABLE_id_to_string(yypvt[-0].y_id, &repr_type_name);
    } /*NOTREACHED*/ break;
case 65:
# line 720 "acf.y"
{
        NAMETABLE_id_to_string(yypvt[-0].y_id, &cs_char_type_name);
    } /*NOTREACHED*/ break;
case 66:
# line 727 "acf.y"
{
        operation_attr.mask = 0;        /* Reset attribute mask */
        cs_tag_rtn_name     = NULL;     /* Reset cs_tag_rtn name */
    } /*NOTREACHED*/ break;
case 69:
# line 740 "acf.y"
{
        acf_param_t         *p;         /* Ptr to local parameter structure */
        NAMETABLE_id_t      op_id;      /* Nametable id of operation name */
        NAMETABLE_id_t      param_id;   /* Nametable id of parameter name */
        AST_operation_n_t   *op_p;      /* Ptr to AST operation node */
        AST_parameter_n_t   *param_p;   /* Ptr to AST parameter node */
        boolean             log_error;  /* TRUE => error if name not found */
        char                *param_name;/* character string of param id */

        NAMETABLE_id_to_string(yypvt[-3].y_id, &operation_name);
#ifdef DUMPERS
        if (cmd_opt[opt_dump_acf])
            dump_attributes("ACF operation", operation_name, &operation_attr);
#endif

        /*
         *  Operation and parameter attributes are ignored for imported
         *  interfaces.  Operations and parameters within imported interfaces
         *  are not put in the AST.
         */
        if (ASTP_parsing_main_idl)
        {
            /*
             *  Lookup the operation_name parsed and verify that it is a valid
             *  operation node.  Then set the parsed attributes in the operation
             *  node.  For each parameter_name that was parsed for this
             *  operation, chase the parameter list off the AST operation node
             *  to verify that it is a valid parameter for that operation.
             *  Then set the parsed attributes for that parameter into the
             *  relevant parameter node.
             *
             *  operation_attr = bitmask of operation attributes parsed.
             *  operation_name = name of routine_t node to look up.
             *  [cs_tag_rtn_name] = cs_tag_rtn name.
             *  parameter_list = linked list of parameter information.
             */

            if (lookup_operation(operation_name, TRUE, &op_id, &op_p))
            {
                /* Store source information. */
                if (op_p->fe_info != NULL)
                {
                    op_p->fe_info->acf_file = error_file_name_id;
                    op_p->fe_info->acf_source_line = acf_yylineno;
                }

                if (operation_attr.bit.comm_status)
                {
                    /*
                     * Assume the AST Builder always builds a result param,
                     * even for void operations.
                     */
                    AST_SET_COMM_STATUS(op_p->result);
                }
                if (operation_attr.bit.fault_status)
                    AST_SET_FAULT_STATUS(op_p->result);

                if (operation_attr.bit.code)
                    AST_SET_CODE(op_p);
                if (operation_attr.bit.nocode)
                    AST_SET_NO_CODE(op_p);
                if (operation_attr.bit.decode)
                    AST_SET_DECODE(op_p);
                if (operation_attr.bit.encode)
                    AST_SET_ENCODE(op_p);
                if (operation_attr.bit.enable_allocate)
                    AST_SET_ENABLE_ALLOCATE(op_p);
                if (operation_attr.bit.explicit_handle)
                    AST_SET_EXPLICIT_HANDLE(op_p);
                if (operation_attr.bit.cs_tag_rtn)
                    op_p->cs_tag_rtn_name = NAMETABLE_add_id(cs_tag_rtn_name);

                for (p = parameter_list ; p != NULL ; p = p->next)
                {
                    /*
                     * Most parameter attributes, if present, require that the
                     * referenced parameter be defined in the IDL.  If only
                     * [comm_status] and/or [fault_status] is present, the
                     * parameter  needn't be IDL-defined.
                     */
                    if (!p->parameter_attr.bit.heap
                        &&  !p->parameter_attr.bit.in_line
                        &&  !p->parameter_attr.bit.out_of_line
                        &&  !p->parameter_attr.bit.cs_stag
                        &&  !p->parameter_attr.bit.cs_drtag
                        &&  !p->parameter_attr.bit.cs_rtag
                        &&  (p->parameter_attr.bit.comm_status
                             || p->parameter_attr.bit.fault_status))
                        log_error = FALSE;
                    else
                        log_error = TRUE;

                    NAMETABLE_id_to_string(p->param_id, &param_name);
                    if (lookup_parameter(op_p, param_name, log_error,
                                         &param_id, &param_p))
                    {
                        /* Store source information. */
                        if (param_p->fe_info != NULL)
                        {
                            param_p->fe_info->acf_file = error_file_name_id;
                            param_p->fe_info->acf_source_line = acf_yylineno;
                        }

                        if (p->parameter_attr.bit.comm_status)
                            AST_SET_COMM_STATUS(param_p);
                        if (p->parameter_attr.bit.fault_status)
                            AST_SET_FAULT_STATUS(param_p);
                        if (p->parameter_attr.bit.heap)
                        {
                            AST_type_n_t *ref_type_p;
                            ref_type_p = param_follow_ref_ptr(param_p,
                                                              CHK_follow_ref);
                            if (ref_type_p->kind != AST_pipe_k
                                && !AST_CONTEXT_SET(param_p)
                                && !AST_CONTEXT_RD_SET(ref_type_p)
                                && !type_is_scalar(ref_type_p))
                                AST_SET_HEAP(param_p);
                        }
                        if (p->parameter_attr.bit.in_line)
                            AST_SET_IN_LINE(param_p);
                        /*
                         * We parse the [out_of_line] parameter attribute,
                         * but disallow it.
                         */
                        if (p->parameter_attr.bit.out_of_line)
                            acf_error(NIDL_INVOOLPRM);
                        if (p->parameter_attr.bit.cs_stag)
                            AST_SET_CS_STAG(param_p);
                        if (p->parameter_attr.bit.cs_drtag)
                            AST_SET_CS_DRTAG(param_p);
                        if (p->parameter_attr.bit.cs_rtag)
                            AST_SET_CS_RTAG(param_p);
                    }
                    else if (log_error == FALSE)
                    {
                        /*
                         * Lookup failed, but OK since the parameter only has
                         * attribute(s) that specify an additional parameter.
                         * Append a parameter to the operation parameter list.
                         */
                        NAMETABLE_id_to_string(p->param_id, &param_name);
                        append_parameter(op_p, param_name, &p->parameter_attr);
                    }
                }
            }
        }

        free_param_list(&parameter_list);       /* Free parameter list */

        operation_name = NULL;
    } /*NOTREACHED*/ break;
case 74:
# line 905 "acf.y"
{
        if (operation_attr.bit.comm_status)
            log_warning(yylineno, NIDL_MULATTRDEF);
        operation_attr.bit.comm_status = TRUE;
    } /*NOTREACHED*/ break;
case 75:
# line 911 "acf.y"
{
        if (operation_attr.bit.code)
            log_warning(yylineno, NIDL_MULATTRDEF);
        operation_attr.bit.code = TRUE;
    } /*NOTREACHED*/ break;
case 76:
# line 917 "acf.y"
{
        if (operation_attr.bit.nocode)
            log_warning(yylineno, NIDL_MULATTRDEF);
        operation_attr.bit.nocode = TRUE;
    } /*NOTREACHED*/ break;
case 77:
# line 923 "acf.y"
{
        if (operation_attr.bit.cs_tag_rtn)
            log_error(yylineno, NIDL_ATTRUSEMULT);
        operation_attr.bit.cs_tag_rtn = TRUE;
    } /*NOTREACHED*/ break;
case 78:
# line 929 "acf.y"
{
        if (operation_attr.bit.enable_allocate)
            log_warning(yylineno, NIDL_MULATTRDEF);
        operation_attr.bit.enable_allocate = TRUE;
    } /*NOTREACHED*/ break;
case 79:
# line 935 "acf.y"
{
        if (operation_attr.bit.explicit_handle)
            log_warning(yylineno, NIDL_MULATTRDEF);
        operation_attr.bit.explicit_handle = TRUE;
    } /*NOTREACHED*/ break;
case 80:
# line 941 "acf.y"
{
        if (operation_attr.bit.fault_status)
            log_warning(yylineno, NIDL_MULATTRDEF);
        operation_attr.bit.fault_status = TRUE;
    } /*NOTREACHED*/ break;
case 81:
# line 947 "acf.y"
{
        if (NAMETABLE_add_id("decode") == yypvt[-0].y_id)
        {
            if (operation_attr.bit.decode)
                log_warning(yylineno, NIDL_MULATTRDEF);
            operation_attr.bit.decode = TRUE;
        }
        else if (NAMETABLE_add_id("encode") == yypvt[-0].y_id)
        {
            if (operation_attr.bit.encode)
                log_warning(yylineno, NIDL_MULATTRDEF);
            operation_attr.bit.encode = TRUE;
        }
        else
            log_error(yylineno, NIDL_ERRINATTR);
    } /*NOTREACHED*/ break;
case 83:
# line 971 "acf.y"
{
        NAMETABLE_id_to_string(yypvt[-0].y_id, &binding_callout_name);
    } /*NOTREACHED*/ break;
case 85:
# line 982 "acf.y"
{
        NAMETABLE_id_to_string(yypvt[-0].y_id, &cs_tag_rtn_name);
    } /*NOTREACHED*/ break;
case 90:
# line 999 "acf.y"
{
#ifdef DUMPERS
        if (cmd_opt[opt_dump_acf])
        {
            char *param_name;
            NAMETABLE_id_to_string(yypvt[-0].y_id, &param_name);
            dump_attributes("ACF parameter", param_name, &parameter_attr);
        }
#endif

        if (parameter_attr_list)        /* If there were param attributes: */
        {
            acf_param_t *p;             /* Pointer to parameter record */

            /*
             * Allocate and initialize a parameter record.
             */
            p = alloc_param();
            p->parameter_attr = parameter_attr;
            p->param_id = yypvt[-0].y_id;

            /*
             * Add to end of parameter list.
             */
            add_param_to_list(p, &parameter_list);

            parameter_attr.mask = 0;
        }
    } /*NOTREACHED*/ break;
case 91:
# line 1032 "acf.y"
{
        parameter_attr_list = TRUE;     /* Flag that we have param attributes */
    } /*NOTREACHED*/ break;
case 92:
# line 1036 "acf.y"
{
        parameter_attr_list = FALSE;
    } /*NOTREACHED*/ break;
case 95:
# line 1048 "acf.y"
{
        if (parameter_attr.bit.comm_status)
            log_warning(yylineno, NIDL_MULATTRDEF);
        parameter_attr.bit.comm_status = TRUE;
    } /*NOTREACHED*/ break;
case 96:
# line 1054 "acf.y"
{
        if (parameter_attr.bit.fault_status)
            log_warning(yylineno, NIDL_MULATTRDEF);
        parameter_attr.bit.fault_status = TRUE;
    } /*NOTREACHED*/ break;
case 97:
# line 1060 "acf.y"
{
        if (parameter_attr.bit.heap)
            log_warning(yylineno, NIDL_MULATTRDEF);
        parameter_attr.bit.heap = TRUE;
    } /*NOTREACHED*/ break;
case 98:
# line 1066 "acf.y"
{
        if (parameter_attr.bit.in_line)
            log_warning(yylineno, NIDL_MULATTRDEF);
        parameter_attr.bit.in_line = TRUE;
    } /*NOTREACHED*/ break;
case 99:
# line 1072 "acf.y"
{
        if (parameter_attr.bit.out_of_line)
            log_warning(yylineno, NIDL_MULATTRDEF);
        parameter_attr.bit.out_of_line = TRUE;
    } /*NOTREACHED*/ break;
case 100:
# line 1078 "acf.y"
{
        if (NAMETABLE_add_id("cs_stag") == yypvt[-0].y_id)
        {
            if (parameter_attr.bit.cs_stag)
                log_warning(yylineno, NIDL_MULATTRDEF);
            parameter_attr.bit.cs_stag = TRUE;
        }
        else if (NAMETABLE_add_id("cs_drtag") == yypvt[-0].y_id)
        {
            if (parameter_attr.bit.cs_drtag)
                log_warning(yylineno, NIDL_MULATTRDEF);
            parameter_attr.bit.cs_drtag = TRUE;
        }
        else if (NAMETABLE_add_id("cs_rtag") == yypvt[-0].y_id)
        {
            if (parameter_attr.bit.cs_rtag)
                log_warning(yylineno, NIDL_MULATTRDEF);
            parameter_attr.bit.cs_rtag = TRUE;
        }
        else
            log_error(yylineno, NIDL_ERRINATTR);
    } /*NOTREACHED*/ break;
}


        goto yystack;           /* reset registers in driver code */
}
