/*
 * $Id: acf_lex_yy_i.c,v 1.1.1.1 1996/06/30 00:09:00 mtp Exp $
 ****************************************************************************
 * @Header@
 ****************************************************************************
 * $Log: acf_lex_yy_i.c,v $
 * Revision 1.1.1.1  1996/06/30 00:09:00  mtp
 * Resubmission of PD DCE sources
 *
 * Revision 1.1.1.1  1995/12/31 05:20:17  mtp
 * + Placed under CVS control
 *
 ****************************************************************************
 */
#include <lex_lib_top.c>

/*
 *  
 *  (c) Copyright 1989 OPEN SOFTWARE FOUNDATION, INC.
 *  (c) Copyright 1989 HEWLETT-PACKARD COMPANY
 *  (c) Copyright 1989 DIGITAL EQUIPMENT CORPORATION
 *  To anyone who acknowledges that this file is provided "AS IS"
 *  without any express or implied warranty:
 *                  permission to use, copy, modify, and distribute this
 *  file for any purpose is hereby granted without fee, provided that
 *  the above copyright notices and this notice appears in all source
 *  code copies, and that none of the names of Open Software
 *  Foundation, Inc., Hewlett-Packard Company, or Digital Equipment
 *  Corporation be used in advertising or publicity pertaining to
 *  distribution of the software without specific, written prior
 *  permission.  Neither Open Software Foundation, Inc., Hewlett-
 *  Packard Company, nor Digital Equipment Corporation makes any
 *  representations about the suitability of this software for any
 *  purpose.
 *  
 */

/*
 */

 /*
 **
 **  NAME:
 **
 **      acf.l
 **
 **  FACILITY:
 **
 **      Interface Definition Language (IDL) Compiler
 **
 **  ABSTRACT:
 **
 ** "lex" source file for Attribute Configuration File (ACF) parser.
 **
 **  VERSION: DCE 1.0
 **
 */

#define PROCESSING_LEX          /* Define before including nidl.h */
#define PROCESSING_ACF_LEX      /* Define before including nidl.h */
#include <nidl.h>               /* IDL common defs */
#include <acf_y_tab.h>          /* yacc include file */
#include <nametbl.h>            /* Nametable defs */
#include <nidlmsg.h>            /* Error message IDs */
#include <command.h>

extern void commenteof(         /* Called on EOF within comment */
#ifdef PROTO
    void
#endif
);

static void acf_yymark(         /* Handles # <lineno> left by cpp */
#ifdef PROTO
    void
#endif
);

static int acf_screen(          /* Screens a token to see if it is a keyword */
#ifdef PROTO
    char *token
#endif
);

static void acf_read_comment(   /* Reads and copies comment text */
#ifdef PROTO
    void
#endif
);

static char *identifier_name;   /* Ptr to parsed identifier */

typedef struct                  /* Keyword and corresponding value */
{
    char    *keyword;
    int     token_value;
} keyword_entry;

static keyword_entry acf_keywords[] =   /* Table of keywords and values */
{
    {"auto_handle",     AUTO_HANDLE_KW},
    {"binding_callout", BINDING_CALLOUT_KW},
    {"code",            CODE_KW},
    {"comm_status",     COMM_STATUS_KW},
    {"cs_char",         CS_CHAR_KW},
    {"cs_tag_rtn",      CS_TAG_RTN_KW},
    {"enable_allocate", ENABLE_ALLOCATE_KW},
    {"explicit_handle", EXPLICIT_HANDLE_KW},
    {"extern_exceptions", EXTERN_EXCEPS_KW},
    {"fault_status",    FAULT_STATUS_KW},
    {"handle_t",        HANDLE_T_KW},
    {"heap",            HEAP_KW},
    {"implicit_handle", IMPLICIT_HANDLE_KW},
    {"include",         INCLUDE_KW},
    {"interface",       INTERFACE_KW},
    {"in_line",         IN_LINE_KW},
    {"nocode",          NOCODE_KW},
    {"out_of_line",     OUT_OF_LINE_KW},
    {"represent_as",    REPRESENT_AS_KW},
    {"typedef",         TYPEDEF_KW},
    {0,                 0}      /* Sentinel - Do not remove */
};

int yylex(){
int nstr; extern int yyprevious;
if (__once_yylex) {
      yysetlocale();

      if (yyin == NULL) yyin = stdin;
      if (yyout == NULL) yyout = stdout;

      __once_yylex = 0; }

while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
       { /* White space: No action, and no return */ }
/*NOTREACHED*/ break;
case 2:
        {return(COMMA);}
/*NOTREACHED*/ break;
case 3:
        {return(LBRACE);}
/*NOTREACHED*/ break;
case 4:
      {return(LBRACE);}
/*NOTREACHED*/ break;
case 5:
        {return(LBRACKET);}
/*NOTREACHED*/ break;
case 6:
        {return(LPAREN);}
/*NOTREACHED*/ break;
case 7:
        {return(RBRACE);}
/*NOTREACHED*/ break;
case 8:
      {return(RBRACE);}
/*NOTREACHED*/ break;
case 9:
        {return(RBRACKET);}
/*NOTREACHED*/ break;
case 10:
        {return(RPAREN);}
/*NOTREACHED*/ break;
case 11:
        {return(SEMI);}
/*NOTREACHED*/ break;
case 12:
   {acf_yymark();}
/*NOTREACHED*/ break;
case 13:
{  /* Quoted string: Strip off quotes, add to string table. */
                char    stripped_string[max_string_len];

                strcpy(stripped_string, (char *)&yytext[1]);
                stripped_string[strlen((char *)yytext)-2] = '\0';
                yylval.y_string = STRTAB_add_string(stripped_string);
                return(STRING);
            }
/*NOTREACHED*/ break;
case 14:
       {   /* Comment: Ignore through closing delimiter. */
                acf_read_comment();
            }
/*NOTREACHED*/ break;
case 15:
       {
                 /* If id is too long, truncate it and issue a warning */
                 if (yyleng > MAX_ID) {
                    NAMETABLE_id_t id;
                    char *identifier;
                    id = NAMETABLE_add_id((char *)yytext);
                    NAMETABLE_id_to_string(id, &identifier);
                    log_warning(yylineno, NIDL_IDTOOLONG, identifier, MAX_ID);
                    /* Truncate the string */
                    yytext[MAX_ID] = '\0';
                    id = NAMETABLE_add_id((char *)yytext);
                    }

                /* Identifier: See if it is a valid keyword. */
                return acf_screen((char *)yytext);
            }
/*NOTREACHED*/ break;
case 16:
    {return(UNKNOWN);}
/*NOTREACHED*/ break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

/*
 *  a c f _ y y w r a p
 *
 *  Function:   Called by lexical analyzer when end-of-file reached.
 *
 *  Globals:    acf_yylineno
 *
 *  Returns:    0 => continue lexical analysis
 *              1 => wrap-up lexical analysis
 */

#ifdef PROTO
int acf_yywrap(void)
#else
int acf_yywrap()
#endif

{
    /*
     * Note: Currently no support for one acf #including another.
     */
    return (1);
}

/*
**  a c f _ y y m a r k
**
**  Processes a "# lineno" line as left by cpp.
**
**  Implicit Outputs:
**      acf_yylineno is updated; If a filename was included in the source
**      line, set_name_for_errors is called to set up the source filename
**      for error messages.
*/

static void acf_yymark()
{
    char    *source ; /* Source file name in #line directive */
    int prev_lineno = acf_yylineno - 1;

    source = (char *) MALLOC(yyleng) ;
    if (sscanf((char *)yytext, "# line %d %s", &acf_yylineno, source) < 1)
    {
	if (sscanf((char *)yytext, "# %d %s", &acf_yylineno, source) < 1)
        {
            log_warning(prev_lineno, NIDL_CPPCMDOPT,
#ifdef VMS
                (CMD_DCL_interface) ? "/PREPROCESS" :
#endif
                "-cpp_cmd");
        }
    }

    /* If text included a source file name, set name for error reporting. */
    if (source[0] != '\0')
    {
        char    file_name[max_string_len];

        /* Strip the quotes. */
        strcpy(file_name, &source[1]);
        file_name[strlen(file_name)-1] = '\0';

        set_name_for_errors(file_name);
    }

    FREE(source);
}

/*
 *  a c f _ s c r e e n
 *
 *  Function:   Checks to see if a token is a keyword.
 *
 *  Inputs:     token to check
 *
 *  Returns:    specific keyword ID if token is a keyword;
 *              the value IDENTIFIER otherwise
 */

#ifdef PROTO
static int acf_screen(char *token)
#else
static int acf_screen(token)
    char *token;                /* Token to "screen" */
#endif

{
    int i;

    /*
     * Scan the reserved word table.
     */
    for (i = 0; acf_keywords[i].keyword != 0; i++)
        if (strcmp(token, acf_keywords[i].keyword) == 0)
            return acf_keywords[i].token_value;     /* Return keyword ID */

    /*
     * Not a reserved word; therefore, an identifier, return nametable id.
     */
    yylval.y_id = NAMETABLE_add_id(token);
    return IDENTIFIER;                  /* Return IDENTIFER */
}

/*
 *  a c f _ r e a d _ c o m m e n t
 *
 *  Function:   Reads a comment in the source file.
 *
 */

#ifdef PROTO
static void acf_read_comment(void)
#else
static void acf_read_comment()
#endif

{
    int     c;

    while ( (c = input()) != 0 )
    {
        if (c == '*')
        {
            if ( (c = input()) == '/')
                break;
            else
                unput(c);
        }
        else if (c == 0)
            commenteof();
    }
}

/*
 *  a c f _ k e y w o r d _ l o o k u p
 *
 *  Looks up a keyword's text string given its numeric token value.
 */

char * acf_keyword_lookup
#ifdef PROTO
(
    int         token_value     /* Numeric value of keyword token */
)
#else
(token_value)
    int         token_value;    /* Numeric value of keyword token */
#endif

{
    keyword_entry * entry;

    for (entry = acf_keywords ; entry->keyword != NULL ; entry++)
        if (entry->token_value == token_value)
            return entry->keyword;

    /* Not found, just return question mark. */
    return "?";
}


 /** End of "lex" source file. **/

int yyvstop[] = {
0,

16,
0,

1,
16,
0,

1,
0,

16,
0,

15,
16,
0,

6,
16,
0,

10,
16,
0,

2,
16,
0,

16,
0,

11,
16,
0,

16,
0,

5,
16,
0,

9,
16,
0,

3,
16,
0,

7,
16,
0,

16,
0,

13,
0,

15,
0,

14,
0,

12,
0,

4,
0,

8,
0,
0};
# define YYTYPE unsigned char
struct yywork { YYTYPE verify, advance; } yycrank[] = {
	0,0,	0,0,	1,3,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	1,4,	1,5,
	19,0,	4,5,	4,5,	0,0,
	4,5,	0,0,	0,0,	0,0,
	0,0,	6,19,	0,0,	0,0,
	18,24,	0,0,	0,0,	0,0,
	0,0,	6,19,	6,0,	0,0,
	18,24,	18,25,	0,0,	1,6,
	4,5,	1,7,	0,0,	0,0,
	0,0,	1,8,	1,9,	11,22,
	0,0,	1,10,	2,18,	0,0,
	1,11,	1,3,	0,0,	2,8,
	2,9,	0,0,	6,20,	2,10,
	6,19,	18,24,	2,11,	18,24,
	1,12,	23,26,	0,0,	23,27,
	1,13,	13,23,	0,0,	0,0,
	6,19,	0,0,	2,12,	18,24,
	0,0,	0,0,	2,13,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	1,14,	0,0,	1,15,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	2,14,	0,0,
	2,15,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	0,0,	0,0,
	1,16,	7,21,	1,17,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	2,16,	0,0,
	2,17,	7,21,	7,21,	7,21,
	7,21,	7,21,	7,21,	7,21,
	7,21,	7,21,	7,21,	0,0,
	0,0,	0,0,	0,0,	0,0,
	0,0,	0,0,	7,21,	7,21,
	7,21,	7,21,	7,21,	7,21,
	7,21,	7,21,	7,21,	7,21,
	7,21,	7,21,	7,21,	7,21,
	7,21,	7,21,	7,21,	7,21,
	7,21,	7,21,	7,21,	7,21,
	7,21,	7,21,	7,21,	7,21,
	0,0,	0,0,	0,0,	0,0,
	7,21,	0,0,	7,21,	7,21,
	7,21,	7,21,	7,21,	7,21,
	7,21,	7,21,	7,21,	7,21,
	7,21,	7,21,	7,21,	7,21,
	7,21,	7,21,	7,21,	7,21,
	7,21,	7,21,	7,21,	7,21,
	7,21,	7,21,	7,21,	7,21,
	0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+-1,	0,		0,	
yycrank+-11,	yysvec+1,	0,	
yycrank+0,	0,		yyvstop+1,
yycrank+4,	0,		yyvstop+3,
yycrank+0,	yysvec+4,	yyvstop+6,
yycrank+-20,	0,		yyvstop+8,
yycrank+89,	0,		yyvstop+10,
yycrank+0,	0,		yyvstop+13,
yycrank+0,	0,		yyvstop+16,
yycrank+0,	0,		yyvstop+19,
yycrank+1,	0,		yyvstop+22,
yycrank+0,	0,		yyvstop+24,
yycrank+2,	0,		yyvstop+27,
yycrank+0,	0,		yyvstop+29,
yycrank+0,	0,		yyvstop+32,
yycrank+0,	0,		yyvstop+35,
yycrank+0,	0,		yyvstop+38,
yycrank+-23,	0,		yyvstop+41,
yycrank+-2,	yysvec+6,	0,	
yycrank+0,	0,		yyvstop+43,
yycrank+0,	yysvec+7,	yyvstop+45,
yycrank+0,	0,		yyvstop+47,
yycrank+1,	0,		0,	
yycrank+0,	yysvec+18,	0,	
yycrank+0,	0,		yyvstop+49,
yycrank+0,	0,		yyvstop+51,
yycrank+0,	0,		yyvstop+53,
0,	0,	0};
struct yywork *yytop = yycrank+211;
struct yysvf *yybgin = yysvec+1;
unsigned char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,011 ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,'"' ,01  ,'$' ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'0' ,'0' ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,01  ,01  ,01  ,01  ,'$' ,
01  ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
0};
unsigned char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};

#include <lex_lib.c>
