/*
 * 
 * (c) Copyright 1991 OPEN SOFTWARE FOUNDATION, INC.
 * (c) Copyright 1991 HEWLETT-PACKARD COMPANY
 * (c) Copyright 1991 DIGITAL EQUIPMENT CORPORATION
 * To anyone who acknowledges that this file is provided "AS IS"
 * without any express or implied warranty:
 *                 permission to use, copy, modify, and distribute this
 * file for any purpose is hereby granted without fee, provided that
 * the above copyright notices and this notice appears in all source
 * code copies, and that none of the names of Open Software
 * Foundation, Inc., Hewlett-Packard Company, or Digital Equipment
 * Corporation be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.  Neither Open Software Foundation, Inc., Hewlett-
 * Packard Company, nor Digital Equipment Corporation makes any
 * representations about the suitability of this software for any
 * purpose.
 * 
 */
/*
 */
/*
*/
#ifndef PTHREAD_EXC_H
#define PTHREAD_EXC_H
/*
**
**  NAME:
**
**      pthread_exc.h
**
**  FACILITY:
**
**      Remote Procedure Call (RPC) 
**
**  ABSTRACT:
** 
**  Exception-raising Pthread API header file.
**
**  The exception-raising Pthread API is just like the regular Pthread API
**  except that errors in Pthread functions are indicated by raising exceptions
**  rather than by returning error codes.
** 
**
**  %a%private_end  
** 
*/

#include <pthread.h>
#include <dce/exc_handling.h>
#include <dce/pthread_np.h>

/* --------------------------------------------------------------------------- */

#ifdef __STDC__
#   define _PTDEXC_PROTO_(x) x
#else
#   define _PTDEXC_PROTO_(x) ()
#endif

/* --------------------------------------------------------------------------- */

extern EXCEPTION pthread_badparam_e;            /* Bad parameter */
extern EXCEPTION pthread_existence_e;           /* Object does not exist */
extern EXCEPTION pthread_in_use_e;              /* Object is in use */
extern EXCEPTION pthread_use_error_e;           /* Object inappropriate for operation */
extern EXCEPTION pthread_nostackmem_e;          /* No memory to allocate stack */
extern EXCEPTION pthread_exit_thread_e;         /* Used to terminate a thread */

/* --------------------------------------------------------------------------- */

#ifndef _PTDEXC_NOWRAP_

#define pthread_attr_create(attr) \
    ptdexc_attr_create(attr)

#define pthread_attr_delete(attr) \
    ptdexc_attr_delete(attr)

#define pthread_attr_setprio(attr,priority) \
    ptdexc_attr_setprio(attr,priority)

#define pthread_attr_getprio(attr) \
    ptdexc_attr_getprio(attr)

#define pthread_attr_setsched(attr,scheduler) \
    ptdexc_attr_setsched(attr,scheduler)

#define pthread_attr_getsched(attr) \
    ptdexc_attr_getsched(attr)

#define pthread_attr_setinheritsched(attr,inherit) \
    ptdexc_attr_setinheritsched(attr,inherit)

#define pthread_attr_getinheritsched(attr) \
    ptdexc_attr_getinheritsched(attr)

#define pthread_attr_setstacksize(attr,stacksize) \
    ptdexc_attr_setstacksize(attr,stacksize)

#define pthread_attr_getstacksize(attr) \
    ptdexc_attr_getstacksize(attr)

#define pthread_create(thread,attr,start_routine,arg) \
    ptdexc_create(thread,attr,start_routine,arg)

#define pthread_detach(thread) \
    ptdexc_detach(thread)

#define pthread_join(thread,status) \
    ptdexc_join(thread,status)

#define pthread_setprio(thread,priority) \
    ptdexc_setprio(thread,priority)

#define pthread_getprio(thread) \
    ptdexc_getprio(thread)

#define pthread_mutexattr_create(attr) \
    ptdexc_mutexattr_create(attr)

#define pthread_mutexattr_delete(attr) \
    ptdexc_mutexattr_delete(attr)

#define pthread_mutex_init(mutex,attr) \
    ptdexc_mutex_init(mutex,attr)

#define pthread_mutex_destroy(mutex) \
    ptdexc_mutex_destroy(mutex)

#define pthread_mutex_lock(mutex) \
    ptdexc_mutex_lock(mutex)

#define pthread_mutex_trylock(mutex) \
    ptdexc_mutex_trylock(mutex)

#define pthread_mutex_unlock(mutex) \
    ptdexc_mutex_unlock(mutex)

#define pthread_condattr_create(attr) \
    ptdexc_condattr_create(attr)

#define pthread_condattr_delete(attr) \
    ptdexc_condattr_delete(attr)

#define pthread_cond_init(cond,attr) \
    ptdexc_cond_init(cond,attr)

#define pthread_cond_destroy(cond) \
    ptdexc_cond_destroy(cond)

#define pthread_cond_broadcast(cond) \
    ptdexc_cond_broadcast(cond)

#define pthread_cond_signal(cond) \
    ptdexc_cond_signal(cond)

#define pthread_cond_timedwait(cond,mutex,abstime) \
    ptdexc_cond_timedwait(cond,mutex,abstime)

#define pthread_once(once_block,init_routine) \
    ptdexc_once(once_block,init_routine)

#define pthread_keycreate(key,destructor) \
    ptdexc_keycreate(key,destructor)

#define pthread_setspecific(key,value) \
    ptdexc_setspecific(key,value)

#define pthread_getspecific(key,value) \
    ptdexc_getspecific(key,value)

#define pthread_cancel(thread) \
    ptdexc_cancel(thread)

#ifdef OSF
#ifdef pthread_setasynccancel
#undef pthread_setasynccancel
#endif
#ifdef pthread_setcancel
#undef pthread_setcancel
#endif
#endif

#define pthread_setasynccancel(state) \
    ptdexc_setasynccancel(state)

#define pthread_setcancel(state) \
    ptdexc_setcancel(state)

#endif

/* --------------------------------------------------------------------------- */

/*
 * Operations to define thread creation attributes
 */
           
/*
 * Create the attribute.
 */
int
ptdexc_attr_create
    _PTDEXC_PROTO_((
        pthread_attr_t          *attr
    ));

/*
 * Set or obtain the default thread priority.
 */
void
ptdexc_attr_setprio
    _PTDEXC_PROTO_((
        pthread_attr_t          *attr,
        int                     priority
    ));

#ifdef LINUX
int
ptdexc_attr_getprio
    _PTDEXC_PROTO_((
        pthread_attr_t         *attr
    ));
#else
int
ptdexc_attr_getprio
    _PTDEXC_PROTO_((
        pthread_attr_t          attr
    ));
#endif

/*
 * Set or obtain the default scheduling algorithm
 */
void
ptdexc_attr_setsched
    _PTDEXC_PROTO_((
        pthread_attr_t          *attr,
        int                     scheduler
    ));

#ifdef LINUX
int
ptdexc_attr_getsched
    _PTDEXC_PROTO_((
        pthread_attr_t          *attr
    ));
#else
int
ptdexc_attr_getsched
    _PTDEXC_PROTO_((
        pthread_attr_t          attr
    ));
#endif
/*
 * Set or obtain whether a thread will use the default scheduling attributes,
 * or inherit them from the creating thread.
 */
void
ptdexc_attr_setinheritsched
    _PTDEXC_PROTO_((
        pthread_attr_t          *attr,
        int                     inherit
    ));

#ifdef LINUX
int
ptdexc_attr_getinheritsched
    _PTDEXC_PROTO_((
        pthread_attr_t          *attr
    ));
#else
int
ptdexc_attr_getinheritsched
    _PTDEXC_PROTO_((
        pthread_attr_t          attr
    ));
#endif

/*
 * Set or obtain the default stack size
 */
void
ptdexc_attr_setstacksize
    _PTDEXC_PROTO_((
        pthread_attr_t          *attr,
        long                    stacksize
    ));

long
ptdexc_attr_getstacksize
    _PTDEXC_PROTO_((
        pthread_attr_t          attr
    ));

/*
 * The following procedures can be used to control thread creation,
 * termination and deletion.
 */

/*
 * To create a thread object and runnable thread, a routine must be specified
 * as the new thread's start routine.  An argument may be passed to this
 * routine, as an untyped address; an untyped address may also be returned as
 * the routine's value.  An attributes object may be used to specify details
 * about the kind of thread being created.
 */
#ifdef LINUX
void
ptdexc_create
    _PTDEXC_PROTO_((
        pthread_t               *thread,
        pthread_attr_t          *attr,
        void                    *(*start_routine)(void *srarg),
        void                    *arg
    ));
#else
void
ptdexc_create
    _PTDEXC_PROTO_((
        pthread_t               *thread,
        pthread_attr_t          attr,
        void                    *(*start_routine)(void *srarg),
        void                    *arg
    ));
#endif

/*
 * A thread object may be "detached" to specify that the return value and
 * completion status will not be requested.
 */
void
ptdexc_detach
    _PTDEXC_PROTO_((
        pthread_t               *thread
    ));

/* 
 * A thread can await termination of another thread and retrieve the return
 * value of the thread.
 */
void
ptdexc_join
    _PTDEXC_PROTO_((
        pthread_t               thread,
        void                    **status
    ));

/*
 * Thread Scheduling Operations
 */

/*
 * The current user_assigned priority of a thread can be changed.
 */
int
ptdexc_setprio
    _PTDEXC_PROTO_((
        pthread_t               thread,
        int                     priority
    ));

/*
 * Thread Information Operations
 */

/*
 * The current user_assigned priority of a thread can be read.
 */
int
ptdexc_getprio
    _PTDEXC_PROTO_((
        pthread_t               thread
    ));

/*
 * Operations on Mutexes
 */

void
ptdexc_mutexattr_create
    _PTDEXC_PROTO_((
        pthread_mutexattr_t     *attr
    ));

void
ptdexc_mutexattr_delete
    _PTDEXC_PROTO_((
        pthread_mutexattr_t     *attr
    ));

/* 
 * The following routines create, delete, lock and unlock mutexes.
 */
#ifdef LINUX
void
ptdexc_mutex_init
    _PTDEXC_PROTO_((
        pthread_mutex_t         *mutex,
        pthread_mutexattr_t     *attr
    ));
#else
void
ptdexc_mutex_init
    _PTDEXC_PROTO_((
        pthread_mutex_t         *mutex,
        pthread_mutexattr_t     attr
    ));
#endif

void
ptdexc_mutex_destroy
    _PTDEXC_PROTO_((
        pthread_mutex_t         *mutex
    ));

void
ptdexc_mutex_lock
    _PTDEXC_PROTO_((
        pthread_mutex_t         *mutex
    ));

int
ptdexc_mutex_trylock
    _PTDEXC_PROTO_((
        pthread_mutex_t         *mutex
    ));

void
ptdexc_mutex_unlock
    _PTDEXC_PROTO_((
        pthread_mutex_t         *mutex
    ));

/*
 * Operations on condition variables
 */

void
ptdexc_condattr_create
    _PTDEXC_PROTO_((
        pthread_condattr_t      *attr
    ));

void
ptdexc_condattr_delete
    _PTDEXC_PROTO_((
        pthread_condattr_t      *attr
    ));

/*
 * A thread can create and delete condition variables.
 */
#ifdef LINUX
void
ptdexc_cond_init
    _PTDEXC_PROTO_((
        pthread_cond_t          *cond,
        pthread_condattr_t      *attr
    ));
#else
void
ptdexc_cond_init
    _PTDEXC_PROTO_((
        pthread_cond_t          *cond,
        pthread_condattr_t      attr
    ));
#endif

void
ptdexc_cond_destroy
    _PTDEXC_PROTO_((
        pthread_cond_t          *cond
    ));

/*
 * A thread can signal to and broadcast on a condition variable.
 */
void
ptdexc_cond_broadcast
    _PTDEXC_PROTO_((
        pthread_cond_t          *cond
    ));

void
ptdexc_cond_signal
    _PTDEXC_PROTO_((
        pthread_cond_t          *cond
    ));

/*
 * A thread can wait for a condition variable to be signalled or broadcast.
 */
void
ptdexc_cond_wait
    _PTDEXC_PROTO_((
        pthread_cond_t          *cond,
        pthread_mutex_t         *mutex
    ));

/*
 * Operations for timed waiting
 */

/*
 * A thread can perform a timed wait on a condition variable.
 */
int
ptdexc_cond_timedwait
    _PTDEXC_PROTO_((
        pthread_cond_t          *cond,
        pthread_mutex_t         *mutex,
        struct timespec         *abstime
    ));

/*
 * Operations for client initialization.
 */

void
ptdexc_once
    _PTDEXC_PROTO_((
        pthread_once_t          *once_block,
        void (*init_routine)()
    ));

/*
 * Operations for per-thread context
 */

/*
 * A unique per-thread context key can be obtained for the process
 */
void
ptdexc_keycreate
    _PTDEXC_PROTO_((
        pthread_key_t           *key,
        void                    (*destructor)(void *value)
    ));

/*
 * A thread can set a per-thread context value identified by a key.
 */
void
ptdexc_setspecific
    _PTDEXC_PROTO_((
        pthread_key_t           key,
        void                    *value
    ));

/*
 * A thread can retrieve a per-thread context value identified by a key.
 */
void
ptdexc_getspecific
    _PTDEXC_PROTO_((
        pthread_key_t           key,
        void                    **value
    ));

/*
 * Operations for alerts.
 */

/*
 * The current thread can request that a thread terminate it's execution.
 */

void
ptdexc_cancel
    _PTDEXC_PROTO_((
        pthread_t               thread
    ));

/*
 * The current thread can enable or disable alert delivery (PTHREAD
 * "cancels"); it can control "general cancelability" (CMA "defer") or
 * just "asynchronous cancelability" (CMA "asynch disable").
 */
int
ptdexc_setasynccancel
    _PTDEXC_PROTO_((
        int                     state
    ));

int
ptdexc_setcancel
    _PTDEXC_PROTO_((
        int                     state
    ));

#endif
