/*
 * 
 * (c) Copyright 1989 OPEN SOFTWARE FOUNDATION, INC.
 * (c) Copyright 1989 HEWLETT-PACKARD COMPANY
 * (c) Copyright 1989 DIGITAL EQUIPMENT CORPORATION
 * To anyone who acknowledges that this file is provided "AS IS"
 * without any express or implied warranty:
 *                 permission to use, copy, modify, and distribute this
 * file for any purpose is hereby granted without fee, provided that
 * the above copyright notices and this notice appears in all source
 * code copies, and that none of the names of Open Software
 * Foundation, Inc., Hewlett-Packard Company, or Digital Equipment
 * Corporation be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.  Neither Open Software Foundation, Inc., Hewlett-
 * Packard Company, nor Digital Equipment Corporation makes any
 * representations about the suitability of this software for any
 * purpose.
 * 
 */
/*
 */
/*
**
**  NAME
**
**      perfb.c
**
**  FACILITY:
**
**      Remote Procedure Call (RPC) 
**
**  ABSTRACT:
**
**  Server manager routines for performance and system execiser auxiliary
**  interface.  This interface is dynamically registered by the server when
**  request by the client through a call to an operation in the "perf"
**  interface.
**
**
*/

#include <perf_c.h>
#include <perf_p.h>


perfb_v1_0_epv_t perfb_mgr_epv =
{
    perfb_init,
    perfb_in,
    perfb_brd,
    perfb_null,
    perfb_null_idem
};


/***************************************************************************/

void perfb_init 
#ifdef IDL_PROTOTYPES
(
    handle_t                h,
    idl_char                *name
)
#else
    (h, name)
    handle_t                h;
    idl_char                *name;
#endif
{
    print_binding_info ("perfb_init", h);
    gethostname(name, 256);
}

/***************************************************************************/

void perfb_in 
#ifdef IDL_PROTOTYPES
(
    handle_t                h,
    perf_data_t             d,
    unsigned long           l,
    idl_boolean             verify,
    unsigned long           *sum
)
#else
    (h, d, l, verify, sum)
    handle_t                h;
    perf_data_t             d;
    unsigned long           l;
    idl_boolean             verify;
    unsigned long           *sum;
#endif
{
    print_binding_info ("perfb_in", h);
    perf_in(h, d, l, verify, sum);
}

/***************************************************************************/

void perfb_brd 
#ifdef IDL_PROTOTYPES
(
    handle_t                h,
    idl_char                *name
)
#else
    (h, name)
    handle_t                h;
    idl_char                *name;
#endif
{
    print_binding_info ("perfb_brd", h);
    gethostname(name, 256);
}

/***************************************************************************/

void perfb_null
#ifdef IDL_PROTOTYPES
(
    handle_t                h
)
#else
    (h)
    handle_t                h;
#endif
{
}

/***************************************************************************/

void perfb_null_idem
#ifdef IDL_PROTOTYPES
(
    handle_t                h
)
#else
    (h)
    handle_t                h;
#endif
{
}


