/****************************************************************************/
/* Simple (easy) RPC application                                            */
/*                                                                          */
/* Developed by Andrew L. Sandoval                                          */
/* 8/20/97                                                                  */
/****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dce/rpc.h>
#include <dce/dce_error.h>
#include "easy.h"

void print_error(char *caller, error_status_t status)
{
 dce_error_string_t error_string;
 int print_status;
 
 dce_error_inq_text(status, error_string, &print_status);
 fprintf(stderr, "%s: %s\n", caller, error_string);
}

void usage(char *name)
{
 printf("USAGE: %s [+d +f -e -?]\n\t +d = Turn ON debugging\n\t+f = Run in foreground\n\t-e = Turn OFF endpoint mapping\n\t-? = this help message\n",name);
}

int main(int argc, char **argv)
{
 unsigned32 status;
 rpc_binding_vector_t *binding_vector;
 int i, foreground = 0, debug = 0, register_endpoint = 1;
 unsigned_char_t *string_binding;
 
 for(i=1; i<argc; i++)
 {
  if(strcmp(argv[i], "+d")==0) { foreground++; debug++; }
  if(strcmp(argv[i], "+f")==0) foreground++;
  if(strcmp(argv[i], "-e")==0) register_endpoint=0;
  if(strcmp(argv[i], "-?")==0) { usage(argv[0]); return 0; }
 }
  
 printf("Easy RPC Server Starting...\n");

 /*
 ** Enable Debugging if selected:
 */
 if(debug)
 {
  rpc__dbg_set_switches("0.40", &status);
  if(status!=rpc_s_ok/*error_status_ok*/)
  {
   print_error("server main() calling rpc__dbg_set_switches()", status);
   return 1;
  }
 }
 
 
 /*
 ** Register INTERFACE with RPC Runtime
 */
 rpc_server_register_if(easy_v1_0_s_ifspec, NULL, NULL, &status);
 if(status!=error_status_ok)
 {
  print_error("server main() calling rpc_server_register_if()", status);
 /* return 1; */
 }
 
 /*
 ** Use all available PROTOCOL SEQUENCES:
 */
 rpc_server_use_all_protseqs(rpc_c_protseq_max_reqs_default, &status);
 if(status!=error_status_ok)
 {
  print_error("server main() calling rpc_server_use_all_protseqs()\n", status);
  return 1;
 }
 
 /*
 ** Get the Binding Handle:
 */
 rpc_server_inq_bindings(&binding_vector, &status);
 if(status!=error_status_ok)
 {
  print_error("server main() calling rpc_server_inq_bindings()\n", status);
  return 1;
 }
 
 /*
 ** Register with Endpoint mapper if desired:
 */
 if(register_endpoint)
 {
  rpc_ep_register( easy_v1_0_s_ifspec, binding_vector, NULL,
                   (unsigned_char_p_t)"Easy Logging Server version 1.0",
                   &status);
  if(status!=error_status_ok)
   print_error("server main() calling rpc_ep_register()", status);
 }

 /*
 ** Normally you COULD Export the Bindings to the CDS, though,
 ** this should only need to happen once!
 */
 
 /*
 ** Display bindings:
 */
 for(i=0; i < binding_vector->count; i++)
 {
  rpc_binding_to_string_binding(binding_vector->binding_h[i], &string_binding, &status);
  if(status!=error_status_ok)
   print_error("server main() calling rpc_binding_to_string_binding()", status);
  
  printf("BINDING: %s\n", string_binding);
  
  rpc_string_free(&string_binding, &status);   
  if(status!=error_status_ok)
   print_error("server main() calling rpc_string_free()", status);
 }
 
 /*
 ** Move to the background if desired:
 */
 if(!foreground)
 {
  setpgrp();
  if(fork()) exit(0);
 }
 
 /*
 ** Start Listening for calls:
 */
 rpc_server_listen(rpc_c_listen_max_calls_default, &status);
 if(status!=error_status_ok)
 {
  print_error("server main() calling rpc_server_listen()", status);
  return 1;
 }
 printf("Server Shutting Down\n");
 return 0;
}
