/****************************************************************************/
/* Simple (easy) RPC application                                            */
/*                                                                          */
/* Developed by Andrew L. Sandoval                                          */
/* 8/20/97                                                                  */
/****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <syslog.h>
#include <dce/pthread_exc.h>
#include <dce/dce_error.h>
#include "easy.h"

/*
** Globals:
*/
pthread_once_t initialized = pthread_once_init;
pthread_mutex_t lastmsg_mutex;
char *lastmsg;

void easy_manager_init()
{
 pthread_mutex_init(&lastmsg_mutex, NULL);
 lastmsg = 0;
 openlog("easy_rpc_server", LOG_NDELAY|LOG_PID, LOG_DAEMON);
}

void easy_logmessage(rpc_binding_handle_t binding_handle, idl_char message[],
                     unsigned32 msglen, error_status_t *status)
{
 pthread_once(&initialized, easy_manager_init);

 pthread_mutex_lock(&lastmsg_mutex);
 if(lastmsg) free(lastmsg);
 lastmsg = (char*)malloc(msglen+1);
 if(lastmsg) strcpy(lastmsg, message);
 pthread_mutex_unlock(&lastmsg_mutex);
 syslog(LOG_NOTICE, "New Message: %s", message);
 *status = error_status_ok;
}

void easy_readlast(rpc_binding_handle_t binding_handle, idl_char message[],
                   unsigned32 maxmsglen, error_status_t *status)
{
 pthread_once(&initialized, easy_manager_init);
 
 pthread_mutex_lock(&lastmsg_mutex);
 memset(message, 0, maxmsglen);
 if(lastmsg) strncpy(message, lastmsg, maxmsglen);
 pthread_mutex_unlock(&lastmsg_mutex);
 *status = error_status_ok;
}
