/****************************************************************************/
/* Simple (easy) RPC application                                            */
/*                                                                          */
/* Developed by Andrew L. Sandoval                                          */
/* 8/20/97                                                                  */
/****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dce/rpc.h>
#include <dce/dce_error.h>
#include <dce/pthread_exc.h>
#include "easy.h"

void print_error(char *caller, error_status_t status)
{
 dce_error_string_t error_string;
 int print_status;
 
 dce_error_inq_text(status, error_string, &print_status);
 fprintf(stderr, "%s: %s\n", caller, error_string);
}

void usage(char *name)
{
 printf("USAGE: %s [+d -p -s -#-?]\n\t+d = Turn ON debugging\n\t-p protocol_sequence\n\t-s server_ip_address\n\t-# port\n\t-? = this help message\n",name);
}

int main(int argc, char **argv)
{
 int i, debug = 0;
 idl_char buffer[1024];
 handle_t binding_handle;
 unsigned_char_t *actual;
 error_status_t status;
 char *protocol = "ncacn_ip_tcp";
 char *serverip = "192.168.1.3";
 char *port = 0;
   
 setbuf(stdout, NULL);
 
 for(i=1; i<argc; i++)
 {
  if(strcmp(argv[i], "+d")==0) debug++;
  if(strcmp(argv[i], "-?")==0) { usage(argv[0]); return 0; }
  if(strcmp(argv[i], "-p")==0) protocol = argv[i+1];
  if(strcmp(argv[i], "-s")==0) serverip = argv[i+1];
  if(strcmp(argv[i], "-#")==0) port = argv[i+1];
 }
  
 printf("Easy RPC Client Starting...\n");

 /*
 ** Enable Debugging if selected:
 */
 if(debug)
 {
  rpc__dbg_set_switches("0.40", &status);
  if(status!=error_status_ok)
  {
   print_error("client main() calling rpc__dbg_set_switches()", status);
   return 1;
  }
 }

 /*
 ** Obtain a binding handle
 */
 rpc_string_binding_compose(NULL, protocol, serverip, port, NULL, &actual, &status);
 if(status!=error_status_ok)
 {
  print_error("client main() calling rpc_string_binding_compose()\n", status);
  return 1;
 }
 printf("Composed Binding: %s\n", actual);
 
 /*
 ** Convert to a binding handle:
 */
 rpc_binding_from_string_binding(actual, &binding_handle, &status);
 if(status!=error_status_ok)
 {
  print_error("client main() calling rpc_binding_from_string_binding()", status);
  return 1;
 } 

 /*
 ** Free the string binding:
 */
 rpc_string_free(&actual, &status);
 if(status!=error_status_ok)
 {
  print_error("client main() calling rpc_string_free()", status);
  return 1;
 }
 
 /*
 ** Lookup the endpoint if a port was not provided:
 */
 if(port==NULL)
 {
  printf("Finding PORT in the Endpoint map\n");
  rpc_ep_resolve_binding(binding_handle, easy_v1_0_c_ifspec, &status);
 
  if(status!=error_status_ok)
  {
   print_error("client main() calling rpc_ep_resolve_binding()", status);
   return 1;
  }
  /*
  ** Convert back to a string to display final binding:
  */
  rpc_binding_to_string_binding(binding_handle, &actual, &status);
  if(status!=error_status_ok)
  {
   print_error("client main() calling rpc_binding_to_string_binding()", status);
   return 1;
  }
  printf("Final Binding: %s\n", actual);
  
  rpc_string_free(&actual, &status);
  if(status!=error_status_ok)
   print_error("client main() calling rpc_string_free()", status);  
 } 
 
 /*
 ** Read last one sent
 */
 TRY
 easy_readlast(binding_handle, buffer, sizeof(buffer)-1, &status);
 if(status!=error_status_ok)
  print_error("client main() doing RPC call easy_readlast()", status);
  
 if(strlen(buffer)) printf("Last Message Server Recorded: %s\n", buffer);
 CATCH_ALL
 {
  printf("Caught Something!\n");
 }
 ENDTRY;

 /*
 ** Binding should be established.  Try some calls.
 */
 memset((void*)&buffer, 0, sizeof(buffer));
 printf("Please Enter a Message to send to the log file:\n");
 fgets((char*)buffer, sizeof(buffer)-1, stdin);
 
 
 /*
 ** Send it:
 */
 easy_logmessage(binding_handle, buffer, strlen(buffer)+1, &status);
 if(status!=error_status_ok)
  print_error("client main() doing RPC call easy_logmessage()", status);
 
 /*
 ** Read last one sent ... might even be ours
 */
 buffer[0] = 0;
 easy_readlast(binding_handle, buffer, sizeof(buffer)-1, &status);
 if(status!=error_status_ok)
  print_error("client main() doing RPC call easy_readlast()", status);
 
 if(strlen(buffer)) printf("Last Message Server Recorded: %s\n", buffer);
}
