/*
 * Andrew L. Sandoval
 *
 * Quick (yes, very ugly) code to get the first ethernet hardware address
 *
 * Sorry it is ugly.  I did not want to spend valuable time here.
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <linux/if.h>

#define FILENAME "/etc/ieee_802_addr"
int written_to_file = 0;

int print_if(int s, char *ifname)
{
 short type;
 short flags;
 char hwaddr[32];
 struct sockaddr addr;
 struct ifreq ifr;
 FILE *f;
 
 /*
 **Get Flags:
 */
 strcpy(ifr.ifr_name, ifname);
 if(ioctl(s, SIOCGIFFLAGS, &ifr) < 0)
  return -1;
 else flags = ifr.ifr_flags;
 
 /*
 **Get IP Address:
 */
 strcpy(ifr.ifr_name, ifname);
 if(ioctl(s, SIOCGIFADDR, &ifr) < 0)
  memset((void*)&addr, 0, sizeof(struct sockaddr));
 else addr = ifr.ifr_addr;
 
 /*
 **Get Hardware Address:
 */
 strcpy(ifr.ifr_name, ifname);
 if(ioctl(s, SIOCGIFHWADDR, &ifr) < 0)
   memset(hwaddr, 0, 32);
 else memcpy(hwaddr, ifr.ifr_hwaddr.sa_data, 8);
 
 type = ifr.ifr_hwaddr.sa_family;
 
 printf("INTERFACE: %s  ", ifname);
 
 if(flags & IFF_UP) printf("is UP ");
 else printf("is DOWN ");
 
 if(type==AF_INET) 
   printf("+AF_INET ");
 if(flags & IFF_LOOPBACK) 
   printf("+LOOPBACK\n");
 else 
 {
   printf("HWADDR: %02X:%02X:%02X:%02X:%02X:%02X\n", 
           hwaddr[0] & 0xff,
           hwaddr[1] & 0xff,
           hwaddr[2] & 0xff,
           hwaddr[3] & 0xff,
           hwaddr[4] & 0xff,
           hwaddr[5] & 0xff,
           hwaddr[6] & 0xff);
   if(!written_to_file) 
   {
     f = fopen(FILENAME, "wt");
     if(!f) 
     {
       perror(FILENAME);
       return; 
     }
     fprintf(f, "%02X%02X%02X%02X%02X%02X\n", hwaddr[0] & 0xff,
             hwaddr[1] & 0xff, hwaddr[2] & 0xff, hwaddr[3] & 0xff,
             hwaddr[4] & 0xff, hwaddr[5] & 0xff, hwaddr[6] & 0xff);
     fclose(f);
     written_to_file++; 
   }          
 }
}

int main()
{
 int s, c, i;
 struct ifreq *IFR;
 struct ifconf ifc;
 char buf[1024]; 
 char thisname[IFNAMSIZ];
 
 s = socket(AF_INET, SOCK_DGRAM, 0);
 if(s==-1) { perror("socket"); exit(1); }

 ifc.ifc_len = sizeof(buf);
 ifc.ifc_buf = buf;
 ioctl(s, SIOCGIFCONF, &ifc);
 
 IFR = ifc.ifc_req;
 for(i = ifc.ifc_len / sizeof(struct ifreq); --i >= 0; IFR++)
 {
  strcpy(thisname, IFR->ifr_name);
  print_if(s, thisname);
 }
 close(s);
 if(written_to_file) return 0;
 else return 1;
}
