#
# zerocheck()
# Called by protopkg() to check for possible zero-length files that are in
# the package.  This usually indicates an error in the compile process.
#
# Parameters:   $1   The package tree.
#

zerocheck() {
   cd $1
   find . -type f -size 0c | while read file ; do
      echo "   WARNING: zero length file $file"
   done
   find . -type f -name '*.gz' -size 20c | while read file ; do
      echo "   WARNING: possible empty gzipped file $file"
   done
}
