#
# verifyproto()
# Called by protopkg() after it finds a prototype file.  It checks to make
# sure you have a compile and install functions, as well as a PKGNAME
# variable.  Those are the minimum things needed to create a package.
#

verifyproto() {
   # checks to make sure the prototype file is good to go

   if [ ! "$1" = "sub" ]
   then
      SECT_INSTALL="`cat ./prototype | grep install\(\)`"
      SECT_COMPILE="`cat ./prototype | grep compile\(\)`"
      SECT_PKGNAME="`cat ./prototype | grep PKGNAME=`"
   else
      ### checking a subpackage prototype file
      SECT_INSTALL="`cat $CWD/prototype.$2 | grep subinstall\(\)`"
      SECT_COMPILE="hejaz"
      SECT_PKGNAME="`cat $CWD/prototype.$2 | grep SUBPKGNAME=`"
   fi

   if [ "$SECT_INSTALL" = "" ]
   then
      echo "BAD"
      if [ "$1" = "sub" ]
      then
         echo "You are missing the subinstall() section from your subprototype file."
      else
         echo "You are missing the install() section from your prototype file."
      fi
      exit
   fi

   if [ "$SECT_COMPILE" = "" ]
   then
      echo "BAD"
      echo "You are missing the compile() section from your prototype file."
      exit
   fi

   if [ "$SECT_PKGNAME" = "" ]
   then
      echo "BAD"
      if [ "$1" = "sub" ]
      then
         echo "You are missing the package name (SUBPKGNAME) from your subprototype file."
      else
         echo "You are missing the package name (PKGNAME) from your prototype file."
      fi
      exit
   fi
}
