/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.util.Arrays;
import javax.naming.RefAddr;

public class BinaryRefAddr
extends RefAddr {
    private final byte[] buf;
    private static char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public BinaryRefAddr(String addrType, byte[] buf) {
        this(addrType, buf, 0, buf.length);
    }

    public BinaryRefAddr(String addrType, byte[] buf, int off, int length) {
        super(addrType);
        this.buf = new byte[length];
        System.arraycopy(buf, off, this.buf, 0, length);
    }

    public Object getContent() {
        return this.buf;
    }

    public boolean equals(Object o) {
        if (o instanceof BinaryRefAddr) {
            BinaryRefAddr refAddr = (BinaryRefAddr)o;
            if (this.getType().equals(refAddr.getType())) {
                byte[] c1 = (byte[])this.getContent();
                byte[] c2 = (byte[])refAddr.getContent();
                return Arrays.equals(c1, c2);
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        byte[] b = (byte[])this.getContent();
        for (int i = 0; i < b.length; ++i) {
            result ^= b[i];
        }
        return this.getType().hashCode() + result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[RefAddr type: ");
        sb.append(this.getType());
        sb.append(" content: 0x");
        byte[] b = (byte[])this.getContent();
        for (int i = 0; i < b.length && i < 32; ++i) {
            sb.append(hex[(b[i] & 0xF0) >> 4]);
            sb.append(hex[b[i] & 0xF]);
        }
        if (b.length > 32) {
            sb.append("...");
        }
        sb.append("]");
        return sb.toString();
    }
}

