/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class StringTokenizer
implements Enumeration {
    private int pos;
    private String str;
    private String delim;
    private boolean retDelims;

    public StringTokenizer(String str) {
        this(str, " \t\n\r\f", false);
    }

    public StringTokenizer(String str, String delim) {
        this(str, delim, false);
    }

    public StringTokenizer(String str, String delim, boolean returnDelims) {
        this.str = str;
        this.delim = delim;
        this.retDelims = returnDelims;
        this.pos = 0;
    }

    public boolean hasMoreTokens() {
        if (!this.retDelims) {
            while (this.pos < this.str.length() && this.delim.indexOf(this.str.charAt(this.pos)) > -1) {
                ++this.pos;
            }
        }
        return this.pos < this.str.length();
    }

    public String nextToken(String delim) throws NoSuchElementException {
        this.delim = delim;
        return this.nextToken();
    }

    public String nextToken() throws NoSuchElementException {
        if (this.pos < this.str.length() && this.delim.indexOf(this.str.charAt(this.pos)) > -1) {
            if (this.retDelims) {
                return this.str.substring(this.pos, ++this.pos);
            }
            while (++this.pos < this.str.length() && this.delim.indexOf(this.str.charAt(this.pos)) > -1) {
            }
        }
        if (this.pos < this.str.length()) {
            int start = this.pos;
            while (++this.pos < this.str.length() && this.delim.indexOf(this.str.charAt(this.pos)) == -1) {
            }
            return this.str.substring(start, this.pos);
        }
        throw new NoSuchElementException();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() throws NoSuchElementException {
        return this.nextToken();
    }

    public int countTokens() {
        int count = 0;
        int delimiterCount = 0;
        boolean tokenFound = false;
        int tmpPos = this.pos;
        while (tmpPos < this.str.length()) {
            if (this.delim.indexOf(this.str.charAt(tmpPos++)) > -1) {
                if (tokenFound) {
                    ++count;
                    tokenFound = false;
                }
                ++delimiterCount;
                continue;
            }
            tokenFound = true;
            while (tmpPos < this.str.length() && this.delim.indexOf(this.str.charAt(tmpPos)) == -1) {
                ++tmpPos;
            }
        }
        if (tokenFound) {
            ++count;
        }
        if (this.retDelims) {
            return count + delimiterCount;
        }
        return count;
    }
}

