/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PushbackInputStream
extends FilterInputStream {
    private static final int DEFAULT_BUFFER_SIZE = 1;
    protected byte[] buf;
    protected int pos;

    public PushbackInputStream(InputStream in) {
        this(in, 1);
    }

    public PushbackInputStream(InputStream in, int size) {
        super(in);
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        this.buf = new byte[size];
        this.pos = this.buf.length;
    }

    public int available() throws IOException {
        return this.buf.length - this.pos + super.available();
    }

    public synchronized void close() throws IOException {
        this.buf = null;
        super.close();
    }

    public boolean markSupported() {
        return false;
    }

    public void reset() throws IOException {
        throw new IOException("Mark not supported in this class");
    }

    public synchronized int read() throws IOException {
        if (this.pos < this.buf.length) {
            return this.buf[this.pos++] & 0xFF;
        }
        return super.read();
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int numBytes = Math.min(this.buf.length - this.pos, len);
        if (numBytes > 0) {
            System.arraycopy(this.buf, this.pos, b, off, numBytes);
            this.pos += numBytes;
            len -= numBytes;
            off += numBytes;
        }
        if (len > 0) {
            if ((len = super.read(b, off, len)) == -1) {
                if (numBytes > 0) {
                    return numBytes;
                }
                return -1;
            }
            numBytes += len;
        }
        return numBytes;
    }

    public synchronized void unread(int b) throws IOException {
        if (this.pos <= 0) {
            throw new IOException("Insufficient space in pushback buffer");
        }
        this.buf[--this.pos] = (byte)b;
    }

    public synchronized void unread(byte[] b) throws IOException {
        this.unread(b, 0, b.length);
    }

    public synchronized void unread(byte[] b, int off, int len) throws IOException {
        if (this.pos < len) {
            throw new IOException("Insufficient space in pushback buffer");
        }
        System.arraycopy(b, off, this.buf, this.pos - len, len);
        this.pos -= len;
    }

    public synchronized long skip(long n) throws IOException {
        long origN = n;
        if (n > 0L) {
            int numread = (int)Math.min((long)(this.buf.length - this.pos), n);
            this.pos += numread;
            n -= (long)numread;
            n -= super.skip(n);
        }
        return origN - n;
    }
}

