/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Unsafe;
import sun.security.action.LoadLibraryAction;

class Util {
    private static ThreadLocal bufferReference;
    private static ThreadLocal localSelector;
    private static Unsafe unsafe;
    private static int pageSize;
    private static Constructor directByteBufferConstructor;
    private static Constructor directByteBufferRConstructor;
    private static volatile boolean loaded;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$sun$nio$ch$Util;

    Util() {
    }

    static ByteBuffer getTemporaryDirectBuffer(int n2) {
        ByteBuffer byteBuffer = null;
        SoftReference softReference = (SoftReference)bufferReference.get();
        if (softReference == null || (byteBuffer = (ByteBuffer)softReference.get()) == null || byteBuffer.capacity() < n2) {
            byteBuffer = ByteBuffer.allocateDirect(n2);
            bufferReference.set(new SoftReference(byteBuffer));
        } else {
            byteBuffer.rewind();
            byteBuffer.limit(n2);
        }
        return byteBuffer;
    }

    static Selector getTemporarySelector(SelectableChannel selectableChannel) throws IOException {
        SoftReference softReference = (SoftReference)localSelector.get();
        Selector selector = null;
        if (softReference == null || (selector = (Selector)softReference.get()) == null || selector.provider() != selectableChannel.provider()) {
            selector = selectableChannel.provider().openSelector();
            localSelector.set(new SoftReference(selector));
        } else {
            selector.selectNow();
            if (!$assertionsDisabled && !selector.keys().isEmpty()) {
                throw new AssertionError((Object)"Temporary selector not empty");
            }
        }
        return selector;
    }

    static ByteBuffer[] subsequence(ByteBuffer[] byteBufferArray, int n2, int n3) {
        if (n2 == 0 && n3 == byteBufferArray.length) {
            return byteBufferArray;
        }
        int n4 = n3;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n4];
        int n5 = 0;
        while (n5 < n4) {
            byteBufferArray2[n5] = byteBufferArray[n2 + n5];
            ++n5;
        }
        return byteBufferArray2;
    }

    private static byte _get(long l2) {
        return unsafe.getByte(l2);
    }

    private static void _put(long l2, byte by) {
        unsafe.putByte(l2, by);
    }

    static Unsafe unsafe() {
        return unsafe;
    }

    static int pageSize() {
        if (pageSize == -1) {
            pageSize = Util.unsafe().pageSize();
        }
        return pageSize;
    }

    private static void initDBBConstructor() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class clazz = Class.forName("java.nio.DirectByteBuffer");
                    directByteBufferConstructor = clazz.getDeclaredConstructor(new Class[]{Integer.TYPE, Long.TYPE, Integer.TYPE, Boolean.TYPE});
                    directByteBufferConstructor.setAccessible(true);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new InternalError();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new InternalError();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InternalError();
                }
                catch (ClassCastException classCastException) {
                    throw new InternalError();
                }
                return null;
            }
        });
    }

    static MappedByteBuffer newMappedByteBuffer(int n2, long l2, int n3) {
        MappedByteBuffer mappedByteBuffer;
        if (directByteBufferConstructor == null) {
            Util.initDBBConstructor();
        }
        try {
            mappedByteBuffer = (MappedByteBuffer)directByteBufferConstructor.newInstance(new Object[]{new Integer(n2), new Long(l2), new Integer(n3), new Boolean(true)});
        }
        catch (InstantiationException instantiationException) {
            throw new InternalError();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InternalError();
        }
        return mappedByteBuffer;
    }

    private static void initDBBRConstructor() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class clazz = Class.forName("java.nio.DirectByteBufferR");
                    directByteBufferRConstructor = clazz.getDeclaredConstructor(new Class[]{Integer.TYPE, Long.TYPE, Integer.TYPE, Boolean.TYPE});
                    directByteBufferRConstructor.setAccessible(true);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new InternalError();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new InternalError();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InternalError();
                }
                catch (ClassCastException classCastException) {
                    throw new InternalError();
                }
                return null;
            }
        });
    }

    static MappedByteBuffer newMappedByteBufferR(int n2, long l2, int n3) {
        MappedByteBuffer mappedByteBuffer;
        if (directByteBufferRConstructor == null) {
            Util.initDBBRConstructor();
        }
        try {
            mappedByteBuffer = (MappedByteBuffer)directByteBufferRConstructor.newInstance(new Object[]{new Integer(n2), new Long(l2), new Integer(n3), new Boolean(true)});
        }
        catch (InstantiationException instantiationException) {
            throw new InternalError();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InternalError();
        }
        return mappedByteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void load() {
        if (loaded) {
            return;
        }
        Class clazz = class$sun$nio$ch$Util == null ? (class$sun$nio$ch$Util = Util.class$("sun.nio.ch.Util")) : class$sun$nio$ch$Util;
        synchronized (clazz) {
            if (loaded) {
                return;
            }
            AccessController.doPrivileged(new LoadLibraryAction("net"));
            AccessController.doPrivileged(new LoadLibraryAction("nio"));
            loaded = true;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$sun$nio$ch$Util == null ? (class$sun$nio$ch$Util = Util.class$("sun.nio.ch.Util")) : class$sun$nio$ch$Util).desiredAssertionStatus();
        bufferReference = new ThreadLocal();
        localSelector = new ThreadLocal();
        unsafe = Unsafe.getUnsafe();
        pageSize = -1;
        directByteBufferConstructor = null;
        directByteBufferRConstructor = null;
        loaded = false;
    }
}

