/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import sun.net.www.MimeEntry;
import sun.net.www.URLConnection;

public class MimeTable
implements FileNameMap {
    private Hashtable entries = new Hashtable();
    private Hashtable extensionMap = new Hashtable();
    private static String tempFileTemplate;
    private static final String filePreamble = "sun.net.www MIME content-types table";
    private static final String fileMagic = "#sun.net.www MIME content-types table";
    private static MimeTable defaultInstance;
    protected static String[] mailcapLocations;

    MimeTable() {
        this.load();
    }

    public static MimeTable getDefaultTable() {
        if (defaultInstance == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    defaultInstance = new MimeTable();
                    URLConnection.setFileNameMap(defaultInstance);
                    return null;
                }
            });
        }
        return defaultInstance;
    }

    public static FileNameMap loadTable() {
        MimeTable mimeTable = MimeTable.getDefaultTable();
        return mimeTable;
    }

    public synchronized int getSize() {
        return this.entries.size();
    }

    public synchronized String getContentTypeFor(String string) {
        MimeEntry mimeEntry = this.findByFileName(string);
        if (mimeEntry != null) {
            return mimeEntry.getType();
        }
        return null;
    }

    public synchronized void add(MimeEntry mimeEntry) {
        this.entries.put(mimeEntry.getType(), mimeEntry);
        String[] stringArray = mimeEntry.getExtensions();
        if (stringArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.extensionMap.put(stringArray[n2], mimeEntry);
            ++n2;
        }
    }

    public synchronized MimeEntry remove(String string) {
        MimeEntry mimeEntry = (MimeEntry)this.entries.get(string);
        return this.remove(mimeEntry);
    }

    public synchronized MimeEntry remove(MimeEntry mimeEntry) {
        String[] stringArray = mimeEntry.getExtensions();
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.extensionMap.remove(stringArray[n2]);
                ++n2;
            }
        }
        return (MimeEntry)this.entries.remove(mimeEntry.getType());
    }

    public synchronized MimeEntry find(String string) {
        MimeEntry mimeEntry = (MimeEntry)this.entries.get(string);
        if (mimeEntry == null) {
            Enumeration enumeration = this.entries.elements();
            while (enumeration.hasMoreElements()) {
                MimeEntry mimeEntry2 = (MimeEntry)enumeration.nextElement();
                if (!mimeEntry2.matches(string)) continue;
                return mimeEntry2;
            }
        }
        return mimeEntry;
    }

    public MimeEntry findByFileName(String string) {
        String string2 = "";
        int n2 = string.lastIndexOf(35);
        if (n2 > 0) {
            string = string.substring(0, n2 - 1);
        }
        n2 = string.lastIndexOf(46);
        n2 = Math.max(n2, string.lastIndexOf(47));
        if ((n2 = Math.max(n2, string.lastIndexOf(63))) != -1 && string.charAt(n2) == '.') {
            string2 = string.substring(n2).toLowerCase();
        }
        return this.findByExt(string2);
    }

    public synchronized MimeEntry findByExt(String string) {
        return (MimeEntry)this.extensionMap.get(string);
    }

    public synchronized MimeEntry findByDescription(String string) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            MimeEntry mimeEntry = (MimeEntry)enumeration.nextElement();
            if (!string.equals(mimeEntry.getDescription())) continue;
            return mimeEntry;
        }
        return this.find(string);
    }

    String getTempFileTemplate() {
        return tempFileTemplate;
    }

    public synchronized Enumeration elements() {
        return this.entries.elements();
    }

    public synchronized void load() {
        Properties properties = new Properties();
        File file = null;
        try {
            String string = System.getProperty("content.types.user.table");
            if (string != null) {
                file = new File(string);
                if (!file.exists()) {
                    file = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "content-types.properties");
                }
            } else {
                file = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "content-types.properties");
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            properties.load(bufferedInputStream);
            ((InputStream)bufferedInputStream).close();
        }
        catch (IOException iOException) {
            System.err.println("Warning: default mime table not found: " + file.getPath());
            return;
        }
        this.parse(properties);
    }

    void parse(Properties properties) {
        String string = (String)properties.get("temp.file.template");
        if (string != null) {
            properties.remove("temp.file.template");
            tempFileTemplate = string;
        }
        Enumeration enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            this.parse(string2, string3);
        }
    }

    void parse(String string, String string2) {
        MimeEntry mimeEntry = new MimeEntry(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            this.parse(string3, mimeEntry);
        }
        this.add(mimeEntry);
    }

    void parse(String string, MimeEntry mimeEntry) {
        String string2 = null;
        String string3 = null;
        boolean bl2 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        while (stringTokenizer.hasMoreTokens()) {
            if (bl2) {
                string3 = stringTokenizer.nextToken().trim();
                continue;
            }
            string2 = stringTokenizer.nextToken().trim();
            bl2 = true;
        }
        this.fill(mimeEntry, string2, string3);
    }

    void fill(MimeEntry mimeEntry, String string, String string2) {
        if ("description".equalsIgnoreCase(string)) {
            mimeEntry.setDescription(string2);
        } else if ("action".equalsIgnoreCase(string)) {
            mimeEntry.setAction(this.getActionCode(string2));
        } else if ("application".equalsIgnoreCase(string)) {
            mimeEntry.setCommand(string2);
        } else if ("icon".equalsIgnoreCase(string)) {
            mimeEntry.setImageFileName(string2);
        } else if ("file_extensions".equalsIgnoreCase(string)) {
            mimeEntry.setExtensions(string2);
        }
    }

    String[] getExtensions(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n2 = stringTokenizer.countTokens();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = stringTokenizer.nextToken();
            ++n3;
        }
        return stringArray;
    }

    int getActionCode(String string) {
        int n2 = 0;
        while (n2 < MimeEntry.actionKeywords.length) {
            if (string.equalsIgnoreCase(MimeEntry.actionKeywords[n2])) {
                return n2;
            }
            ++n2;
        }
        return 0;
    }

    public synchronized boolean save(String string) {
        if (string == null) {
            string = System.getProperty("user.home" + File.separator + "lib" + File.separator + "content-types.properties");
        }
        return this.saveAsProperties(new File(string));
    }

    public Properties getAsProperties() {
        Properties properties = new Properties();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            MimeEntry mimeEntry = (MimeEntry)enumeration.nextElement();
            properties.put(mimeEntry.getType(), mimeEntry.toProperty());
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean saveAsProperties(File file) {
        FileOutputStream fileOutputStream;
        block9: {
            fileOutputStream = null;
            fileOutputStream = new FileOutputStream(file);
            Properties properties = this.getAsProperties();
            properties.put("temp.file.template", tempFileTemplate);
            String string = System.getProperty("user.name");
            if (string != null) {
                String string2 = "; customized for " + string;
                properties.save(fileOutputStream, filePreamble + string2);
                break block9;
            }
            properties.save(fileOutputStream, filePreamble);
        }
        Object var7_8 = null;
        if (fileOutputStream == null) return true;
        try {
            fileOutputStream.close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
        {
            catch (IOException iOException) {
                iOException.printStackTrace();
                boolean bl2 = false;
                Object var7_9 = null;
                if (fileOutputStream == null) return bl2;
                try {
                    fileOutputStream.close();
                    return bl2;
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                tempFileTemplate = System.getProperty("content.types.temp.file.template", "/tmp/%s");
                mailcapLocations = new String[]{System.getProperty("user.mailcap"), System.getProperty("user.home") + "/.mailcap", "/etc/mailcap", "/usr/etc/mailcap", "/usr/local/etc/mailcap", System.getProperty("hotjava.home", "/usr/local/hotjava") + "/lib/mailcap"};
                return null;
            }
        });
        defaultInstance = null;
    }
}

