/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;
import sun.io.CharacterEncoding;

final class CompoundTextSupport {
    static int MAX_CONTROL_SEQUENCE_LEN;
    private static final Map sequenceToEncodingMap;
    private static final Map highBitsMap;
    private static final Map encodingToSequenceMap;
    private static final List encodings;

    private static boolean isEncodingSupported(String string) {
        String string2 = CharacterEncoding.aliasName(string);
        if (string2 == null) {
            string2 = string;
        }
        return CompoundTextSupport.encodingToByteToCharConverter(string2) != null && CompoundTextSupport.encodingToCharToByteConverter(string2) != null;
    }

    static ByteToCharConverter getStandardConverter(byte[] byArray) {
        return CompoundTextSupport.getNonStandardConverter(byArray, null);
    }

    static boolean getHighBit(byte[] byArray) {
        Boolean bl2 = (Boolean)highBitsMap.get(new ControlSequence(byArray));
        return bl2 == Boolean.TRUE;
    }

    static ByteToCharConverter getNonStandardConverter(byte[] byArray, byte[] byArray2) {
        return CompoundTextSupport.encodingToByteToCharConverter((String)sequenceToEncodingMap.get(new ControlSequence(byArray, byArray2)));
    }

    static ByteToCharConverter encodingToByteToCharConverter(String string) {
        Class clazz;
        if (string == null) {
            return null;
        }
        try {
            clazz = Class.forName("sun.io.ByteToChar" + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName("sun.awt.motif.ByteToChar" + string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return null;
            }
        }
        try {
            return (ByteToCharConverter)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    static byte[] getEscapeSequence(String string) {
        ControlSequence controlSequence = (ControlSequence)encodingToSequenceMap.get(string);
        if (controlSequence != null) {
            return controlSequence.escSequence;
        }
        return null;
    }

    static byte[] getEncoding(String string) {
        ControlSequence controlSequence = (ControlSequence)encodingToSequenceMap.get(string);
        if (controlSequence != null) {
            return controlSequence.encoding;
        }
        return null;
    }

    static List getEncodings() {
        return encodings;
    }

    static CharToByteConverter encodingToCharToByteConverter(String string) {
        Class clazz;
        if (string == null) {
            return null;
        }
        try {
            clazz = Class.forName("sun.io.CharToByte" + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName("sun.awt.motif.CharToByte" + string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return null;
            }
        }
        try {
            return (CharToByteConverter)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    private CompoundTextSupport() {
    }

    static {
        HashMap hashMap = new HashMap(33, 1.0f);
        HashMap hashMap2 = new HashMap(31, 1.0f);
        HashMap hashMap3 = new HashMap(21, 1.0f);
        ArrayList arrayList = new ArrayList(21);
        if (!CompoundTextSupport.isEncodingSupported("ASCII") || !CompoundTextSupport.isEncodingSupported("ISO8859_1")) {
            throw new ExceptionInInitializerError("US-ASCII and ISO-8859-1 unsupported");
        }
        ControlSequence controlSequence = new ControlSequence(new byte[]{27, 40, 66});
        hashMap.put(controlSequence, "ASCII");
        hashMap2.put(controlSequence, Boolean.FALSE);
        ControlSequence controlSequence2 = new ControlSequence(new byte[]{27, 41, 66});
        hashMap.put(controlSequence2, "ASCII");
        hashMap2.put(controlSequence2, Boolean.FALSE);
        controlSequence2 = new ControlSequence(new byte[]{27, 45, 65});
        hashMap.put(controlSequence2, "ISO8859_1");
        hashMap2.put(controlSequence2, Boolean.TRUE);
        ControlSequence controlSequence3 = controlSequence.concatenate(controlSequence2);
        hashMap3.put("ISO8859_1", controlSequence3);
        arrayList.add("ISO8859_1");
        if (CompoundTextSupport.isEncodingSupported("ISO8859_2")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 45, 66});
            hashMap.put(controlSequence2, "ISO8859_2");
            hashMap2.put(controlSequence2, Boolean.TRUE);
            controlSequence3 = controlSequence.concatenate(controlSequence2);
            hashMap3.put("ISO8859_2", controlSequence3);
            arrayList.add("ISO8859_2");
        }
        if (CompoundTextSupport.isEncodingSupported("ISO8859_3")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 45, 67});
            hashMap.put(controlSequence2, "ISO8859_3");
            hashMap2.put(controlSequence2, Boolean.TRUE);
            controlSequence3 = controlSequence.concatenate(controlSequence2);
            hashMap3.put("ISO8859_3", controlSequence3);
            arrayList.add("ISO8859_3");
        }
        if (CompoundTextSupport.isEncodingSupported("ISO8859_4")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 45, 68});
            hashMap.put(controlSequence2, "ISO8859_4");
            hashMap2.put(controlSequence2, Boolean.TRUE);
            controlSequence3 = controlSequence.concatenate(controlSequence2);
            hashMap3.put("ISO8859_4", controlSequence3);
            arrayList.add("ISO8859_4");
        }
        if (CompoundTextSupport.isEncodingSupported("ISO8859_5")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 45, 76});
            hashMap.put(controlSequence2, "ISO8859_5");
            hashMap2.put(controlSequence2, Boolean.TRUE);
            controlSequence3 = controlSequence.concatenate(controlSequence2);
            hashMap3.put("ISO8859_5", controlSequence3);
            arrayList.add("ISO8859_5");
        }
        if (CompoundTextSupport.isEncodingSupported("ISO8859_6")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 45, 71});
            hashMap.put(controlSequence2, "ISO8859_6");
            hashMap2.put(controlSequence2, Boolean.TRUE);
            controlSequence3 = controlSequence.concatenate(controlSequence2);
            hashMap3.put("ISO8859_6", controlSequence3);
            arrayList.add("ISO8859_6");
        }
        if (CompoundTextSupport.isEncodingSupported("ISO8859_7")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 45, 70});
            hashMap.put(controlSequence2, "ISO8859_7");
            hashMap2.put(controlSequence2, Boolean.TRUE);
            controlSequence3 = controlSequence.concatenate(controlSequence2);
            hashMap3.put("ISO8859_7", controlSequence3);
            arrayList.add("ISO8859_7");
        }
        if (CompoundTextSupport.isEncodingSupported("ISO8859_8")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 45, 72});
            hashMap.put(controlSequence2, "ISO8859_8");
            hashMap2.put(controlSequence2, Boolean.TRUE);
            controlSequence3 = controlSequence.concatenate(controlSequence2);
            hashMap3.put("ISO8859_8", controlSequence3);
            arrayList.add("ISO8859_8");
        }
        if (CompoundTextSupport.isEncodingSupported("ISO8859_9")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 45, 77});
            hashMap.put(controlSequence2, "ISO8859_9");
            hashMap2.put(controlSequence2, Boolean.TRUE);
            controlSequence3 = controlSequence.concatenate(controlSequence2);
            hashMap3.put("ISO8859_9", controlSequence3);
            arrayList.add("ISO8859_9");
        }
        if (CompoundTextSupport.isEncodingSupported("JIS0201")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 40, 74});
            controlSequence3 = new ControlSequence(new byte[]{27, 40, 73});
            ControlSequence controlSequence4 = new ControlSequence(new byte[]{27, 41, 74});
            ControlSequence controlSequence5 = new ControlSequence(new byte[]{27, 41, 73});
            hashMap.put(controlSequence2, "JIS0201");
            hashMap.put(controlSequence3, "JIS0201");
            hashMap.put(controlSequence4, "JIS0201");
            hashMap.put(controlSequence5, "JIS0201");
            hashMap2.put(controlSequence2, Boolean.FALSE);
            hashMap2.put(controlSequence3, Boolean.TRUE);
            hashMap2.put(controlSequence4, Boolean.FALSE);
            hashMap2.put(controlSequence5, Boolean.TRUE);
            ControlSequence controlSequence6 = controlSequence2.concatenate(controlSequence5);
            hashMap3.put("JIS0201", controlSequence6);
            arrayList.add("JIS0201");
        }
        if (CompoundTextSupport.isEncodingSupported("X11GB2312")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 36, 40, 65});
            controlSequence3 = new ControlSequence(new byte[]{27, 36, 41, 65});
            hashMap.put(controlSequence2, "X11GB2312");
            hashMap.put(controlSequence3, "X11GB2312");
            hashMap2.put(controlSequence2, Boolean.FALSE);
            hashMap2.put(controlSequence3, Boolean.FALSE);
            hashMap3.put("X11GB2312", controlSequence2);
            arrayList.add("X11GB2312");
        }
        if (CompoundTextSupport.isEncodingSupported("JIS0208")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 36, 40, 66});
            controlSequence3 = new ControlSequence(new byte[]{27, 36, 41, 66});
            hashMap.put(controlSequence2, "JIS0208");
            hashMap.put(controlSequence3, "JIS0208");
            hashMap2.put(controlSequence2, Boolean.FALSE);
            hashMap2.put(controlSequence3, Boolean.FALSE);
            hashMap3.put("JIS0208", controlSequence2);
            arrayList.add("JIS0208");
        }
        if (CompoundTextSupport.isEncodingSupported("X11KSC5601")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 36, 40, 67});
            controlSequence3 = new ControlSequence(new byte[]{27, 36, 41, 67});
            hashMap.put(controlSequence2, "X11KSC5601");
            hashMap.put(controlSequence3, "X11KSC5601");
            hashMap2.put(controlSequence2, Boolean.FALSE);
            hashMap2.put(controlSequence3, Boolean.FALSE);
            hashMap3.put("X11KSC5601", controlSequence2);
            arrayList.add("X11KSC5601");
        }
        if (CompoundTextSupport.isEncodingSupported("ISO8859_15")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 45, 98});
            hashMap.put(controlSequence2, "ISO8859_15");
            hashMap2.put(controlSequence2, Boolean.TRUE);
            controlSequence3 = controlSequence.concatenate(controlSequence2);
            hashMap3.put("ISO8859_15", controlSequence3);
            arrayList.add("ISO8859_15");
        }
        if (CompoundTextSupport.isEncodingSupported("TIS620")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 45, 84});
            hashMap.put(controlSequence2, "TIS620");
            hashMap2.put(controlSequence2, Boolean.TRUE);
            controlSequence3 = controlSequence.concatenate(controlSequence2);
            hashMap3.put("TIS620", controlSequence3);
            arrayList.add("TIS620");
        }
        if (CompoundTextSupport.isEncodingSupported("JIS0212")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 36, 40, 68});
            controlSequence3 = new ControlSequence(new byte[]{27, 36, 41, 68});
            hashMap.put(controlSequence2, "JIS0212");
            hashMap.put(controlSequence3, "JIS0212");
            hashMap2.put(controlSequence2, Boolean.FALSE);
            hashMap2.put(controlSequence3, Boolean.FALSE);
            hashMap3.put("JIS0212", controlSequence2);
            arrayList.add("JIS0212");
        }
        if (CompoundTextSupport.isEncodingSupported("X11CNS11643P1")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 36, 40, 71});
            controlSequence3 = new ControlSequence(new byte[]{27, 36, 41, 71});
            hashMap.put(controlSequence2, "X11CNS11643P1");
            hashMap.put(controlSequence3, "X11CNS11643P1");
            hashMap2.put(controlSequence2, Boolean.FALSE);
            hashMap2.put(controlSequence3, Boolean.FALSE);
            hashMap3.put("X11CNS11643P1", controlSequence2);
            arrayList.add("X11CNS11643P1");
        }
        if (CompoundTextSupport.isEncodingSupported("X11CNS11643P2")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 36, 40, 72});
            controlSequence3 = new ControlSequence(new byte[]{27, 36, 41, 72});
            hashMap.put(controlSequence2, "X11CNS11643P2");
            hashMap.put(controlSequence3, "X11CNS11643P2");
            hashMap2.put(controlSequence2, Boolean.FALSE);
            hashMap2.put(controlSequence3, Boolean.FALSE);
            hashMap3.put("X11CNS11643P2", controlSequence2);
            arrayList.add("X11CNS11643P2");
        }
        if (CompoundTextSupport.isEncodingSupported("X11CNS11643P3")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 36, 40, 73});
            controlSequence3 = new ControlSequence(new byte[]{27, 36, 41, 73});
            hashMap.put(controlSequence2, "X11CNS11643P3");
            hashMap.put(controlSequence3, "X11CNS11643P3");
            hashMap2.put(controlSequence2, Boolean.FALSE);
            hashMap2.put(controlSequence3, Boolean.FALSE);
            hashMap3.put("X11CNS11643P3", controlSequence2);
            arrayList.add("X11CNS11643P3");
        }
        if (CompoundTextSupport.isEncodingSupported("Johab")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 37, 47, 50}, new byte[]{83, 85, 78, 45, 75, 83, 67, 53, 54, 48, 49, 46, 49, 57, 57, 50, 45, 51});
            hashMap.put(controlSequence2, "Johab");
            hashMap3.put("Johab", controlSequence2);
            arrayList.add("Johab");
        }
        if (CompoundTextSupport.isEncodingSupported("Big5")) {
            controlSequence2 = new ControlSequence(new byte[]{27, 37, 47, 50}, new byte[]{83, 85, 78, 45, 66, 73, 71, 53, 45, 49});
            hashMap.put(controlSequence2, "Big5");
            hashMap3.put("Big5", controlSequence2);
            arrayList.add("Big5");
        }
        sequenceToEncodingMap = Collections.unmodifiableMap(hashMap);
        highBitsMap = Collections.unmodifiableMap(hashMap2);
        encodingToSequenceMap = Collections.unmodifiableMap(hashMap3);
        encodings = Collections.unmodifiableList(arrayList);
    }

    private static final class ControlSequence {
        final int hash;
        final byte[] escSequence;
        final byte[] encoding;

        ControlSequence(byte[] byArray) {
            this(byArray, null);
        }

        ControlSequence(byte[] byArray, byte[] byArray2) {
            if (byArray == null) {
                throw new NullPointerException();
            }
            this.escSequence = byArray;
            this.encoding = byArray2;
            int n2 = 0;
            int n3 = byArray.length;
            int n4 = 0;
            while (n4 < byArray.length) {
                n2 += (byArray[n4] & 0xFF) << n4 % 4;
                ++n4;
            }
            if (byArray2 != null) {
                int n5 = 0;
                while (n5 < byArray2.length) {
                    n2 += (byArray2[n5] & 0xFF) << n5 % 4;
                    ++n5;
                }
                n3 += 2 + byArray2.length + 1;
            }
            this.hash = n2;
            if (MAX_CONTROL_SEQUENCE_LEN < n3) {
                MAX_CONTROL_SEQUENCE_LEN = n3;
            }
        }

        public boolean equals(Object object) {
            int n2;
            if (this == object) {
                return true;
            }
            if (!(object instanceof ControlSequence)) {
                return false;
            }
            ControlSequence controlSequence = (ControlSequence)object;
            if (this.escSequence != controlSequence.escSequence) {
                if (this.escSequence.length != controlSequence.escSequence.length) {
                    return false;
                }
                n2 = 0;
                while (n2 < this.escSequence.length) {
                    if (this.escSequence[n2] != controlSequence.escSequence[n2]) {
                        return false;
                    }
                    ++n2;
                }
            }
            if (this.encoding != controlSequence.encoding) {
                if (this.encoding == null || controlSequence.encoding == null || this.encoding.length != controlSequence.encoding.length) {
                    return false;
                }
                n2 = 0;
                while (n2 < this.encoding.length) {
                    if (this.encoding[n2] != controlSequence.encoding[n2]) {
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }

        public int hashCode() {
            return this.hash;
        }

        ControlSequence concatenate(ControlSequence controlSequence) {
            if (this.encoding != null) {
                throw new IllegalArgumentException("cannot concatenate to a non-standard charset escape sequence");
            }
            int n2 = this.escSequence.length + controlSequence.escSequence.length;
            byte[] byArray = new byte[n2];
            System.arraycopy(this.escSequence, 0, byArray, 0, this.escSequence.length);
            System.arraycopy(controlSequence.escSequence, 0, byArray, this.escSequence.length, controlSequence.escSequence.length);
            return new ControlSequence(byArray, controlSequence.encoding);
        }
    }
}

