/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.operations;

import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;

public class Variable
extends Expression {
    private boolean m_fixUpWasCalled = false;
    protected QName m_qname;
    protected int m_index;
    protected boolean m_isGlobal = false;

    public void fixupVariables(Vector vector, int n2) {
        Object object;
        this.m_fixUpWasCalled = true;
        int n3 = vector.size();
        int n4 = vector.size() - 1;
        while (n4 >= 0) {
            object = (QName)vector.elementAt(n4);
            if (((QName)object).equals(this.m_qname)) {
                if (n4 < n2) {
                    this.m_isGlobal = true;
                    this.m_index = n4;
                } else {
                    this.m_index = n4 - n2;
                }
                return;
            }
            --n4;
        }
        object = XSLMessages.createXPATHMessage(81, new Object[]{this.m_qname.toString()});
        TransformerException transformerException = new TransformerException((String)object, this.m_slocator);
        throw new WrappedRuntimeException(transformerException);
    }

    public void setQName(QName qName) {
        this.m_qname = qName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XObject execute(XPathContext xPathContext) throws TransformerException {
        if (this.m_fixUpWasCalled) {
            XObject xObject = this.m_isGlobal ? xPathContext.getVarStack().getGlobalVariable(xPathContext, this.m_index) : xPathContext.getVarStack().getLocalVariable(xPathContext, this.m_index);
            if (null != xObject) return xObject;
            this.warn(xPathContext, 11, new Object[]{this.m_qname.getLocalPart()});
            return new XNodeSet(xPathContext.getDTMManager());
        }
        Variable variable = this;
        synchronized (variable) {
            PrefixResolver prefixResolver = xPathContext.getNamespaceContext();
            if (prefixResolver instanceof ElemTemplateElement) {
                ElemVariable elemVariable;
                ElemTemplateElement elemTemplateElement = (ElemTemplateElement)prefixResolver;
                if (!(elemTemplateElement instanceof Stylesheet)) {
                    while (!(elemTemplateElement.getParentNode() instanceof Stylesheet)) {
                        Serializable serializable = elemTemplateElement;
                        while (null != (elemTemplateElement = elemTemplateElement.getPreviousSiblingElem())) {
                            if (!(elemTemplateElement instanceof ElemVariable) || !(elemVariable = (ElemVariable)elemTemplateElement).getName().equals(this.m_qname)) continue;
                            this.m_index = elemVariable.getIndex();
                            this.m_isGlobal = false;
                            this.m_fixUpWasCalled = true;
                            return this.execute(xPathContext);
                        }
                        elemTemplateElement = serializable.getParentElem();
                    }
                }
                if (null != (elemVariable = elemTemplateElement.getStylesheetRoot().getVariableOrParamComposed(this.m_qname))) {
                    this.m_index = elemVariable.getIndex();
                    this.m_isGlobal = true;
                    this.m_fixUpWasCalled = true;
                    return this.execute(xPathContext);
                }
            }
            throw new TransformerException(XSLMessages.createXPATHMessage(74, new Object[]{this.m_qname.toString()}));
        }
    }

    public boolean isStableNumber() {
        return true;
    }
}

