/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.NamespaceAlias;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetComposed;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.XMLNSDecl;
import org.apache.xalan.transformer.ResultTreeHandler;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.UnImplNode;
import org.apache.xpath.WhitespaceStrippingElementMatcher;
import org.apache.xpath.XPathContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.NamespaceSupport;

public class ElemTemplateElement
extends UnImplNode
implements PrefixResolver,
Serializable,
SourceLocator,
WhitespaceStrippingElementMatcher {
    private int m_lineNumber;
    private int m_columnNumber;
    private boolean m_defaultSpace = true;
    private boolean m_hasTextLitOnly = false;
    protected boolean m_hasVariableDecl = false;
    private Vector m_declaredPrefixes;
    Vector m_prefixTable;
    protected int m_docOrderNumber = -1;
    protected ElemTemplateElement m_parentNode;
    ElemTemplateElement m_nextSibling;
    ElemTemplateElement m_firstChild;
    private transient Node m_DOMBackPointer;

    public boolean isCompiledTemplate() {
        return false;
    }

    public int getXSLToken() {
        return -1;
    }

    public String getNodeName() {
        return "Unknown XSLT Element";
    }

    public void runtimeInit(TransformerImpl transformerImpl) throws TransformerException {
    }

    public void execute(TransformerImpl transformerImpl) throws TransformerException {
    }

    public StylesheetComposed getStylesheetComposed() {
        return this.m_parentNode.getStylesheetComposed();
    }

    public Stylesheet getStylesheet() {
        return this.m_parentNode.getStylesheet();
    }

    public StylesheetRoot getStylesheetRoot() {
        return this.m_parentNode.getStylesheetRoot();
    }

    public void recompose(StylesheetRoot stylesheetRoot) throws TransformerException {
    }

    public void compose(StylesheetRoot stylesheetRoot) throws TransformerException {
        this.resolvePrefixTables();
        ElemTemplateElement elemTemplateElement = this.getFirstChildElem();
        this.m_hasTextLitOnly = elemTemplateElement != null && elemTemplateElement.getXSLToken() == 78 && elemTemplateElement.getNextSiblingElem() == null;
        StylesheetRoot.ComposeState composeState = stylesheetRoot.getComposeState();
        composeState.pushStackMark();
    }

    public void endCompose(StylesheetRoot stylesheetRoot) throws TransformerException {
        StylesheetRoot.ComposeState composeState = stylesheetRoot.getComposeState();
        composeState.popStackMark();
    }

    protected boolean isValidNCName(String string) {
        int n2 = string.length();
        char c2 = string.charAt(0);
        if (!Character.isLetter(c2) && c2 != '_') {
            return false;
        }
        if (n2 > 0) {
            int n3 = 1;
            while (n3 < n2) {
                c2 = string.charAt(n3);
                if (!Character.isLetterOrDigit(c2) && c2 != '_' && c2 != '-' && c2 != '.') {
                    return false;
                }
                ++n3;
            }
        }
        return true;
    }

    public void error(int n2, Object[] objectArray) {
        String string = XSLMessages.createMessage(n2, objectArray);
        this.error(XSLMessages.createMessage(19, new Object[]{string}));
    }

    public void error(int n2) {
        this.error(n2, null);
    }

    public void error(String string) {
        throw new RuntimeException(string);
    }

    public Node appendChild(Node node) throws DOMException {
        if (null == node) {
            this.error(20, null);
        }
        ElemTemplateElement elemTemplateElement = (ElemTemplateElement)node;
        if (null == this.m_firstChild) {
            this.m_firstChild = elemTemplateElement;
        } else {
            ElemTemplateElement elemTemplateElement2 = (ElemTemplateElement)this.getLastChild();
            elemTemplateElement2.m_nextSibling = elemTemplateElement;
        }
        elemTemplateElement.m_parentNode = this;
        return node;
    }

    public ElemTemplateElement appendChild(ElemTemplateElement elemTemplateElement) {
        if (null == elemTemplateElement) {
            this.error(20, null);
        }
        if (null == this.m_firstChild) {
            this.m_firstChild = elemTemplateElement;
        } else {
            ElemTemplateElement elemTemplateElement2 = this.getLastChildElem();
            elemTemplateElement2.m_nextSibling = elemTemplateElement;
        }
        elemTemplateElement.setParentElem(this);
        return elemTemplateElement;
    }

    public boolean hasChildNodes() {
        return null != this.m_firstChild;
    }

    public short getNodeType() {
        return 1;
    }

    public NodeList getChildNodes() {
        return this;
    }

    public ElemTemplateElement removeChild(ElemTemplateElement elemTemplateElement) {
        if (elemTemplateElement == null || elemTemplateElement.m_parentNode != this) {
            return null;
        }
        if (elemTemplateElement == this.m_firstChild) {
            this.m_firstChild = elemTemplateElement.m_nextSibling;
        } else {
            ElemTemplateElement elemTemplateElement2 = elemTemplateElement.getPreviousSiblingElem();
            elemTemplateElement2.m_nextSibling = elemTemplateElement.m_nextSibling;
        }
        elemTemplateElement.m_parentNode = null;
        elemTemplateElement.m_nextSibling = null;
        return elemTemplateElement;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        if (node2 == null || node2.getParentNode() != this) {
            return null;
        }
        ElemTemplateElement elemTemplateElement = (ElemTemplateElement)node;
        ElemTemplateElement elemTemplateElement2 = (ElemTemplateElement)node2;
        ElemTemplateElement elemTemplateElement3 = (ElemTemplateElement)elemTemplateElement2.getPreviousSibling();
        if (null != elemTemplateElement3) {
            elemTemplateElement3.m_nextSibling = elemTemplateElement;
        }
        if (this.m_firstChild == elemTemplateElement2) {
            this.m_firstChild = elemTemplateElement;
        }
        elemTemplateElement.m_parentNode = this;
        elemTemplateElement2.m_parentNode = null;
        elemTemplateElement.m_nextSibling = elemTemplateElement2.m_nextSibling;
        elemTemplateElement2.m_nextSibling = null;
        return elemTemplateElement;
    }

    public ElemTemplateElement replaceChild(ElemTemplateElement elemTemplateElement, ElemTemplateElement elemTemplateElement2) {
        if (elemTemplateElement2 == null || elemTemplateElement2.getParentElem() != this) {
            return null;
        }
        ElemTemplateElement elemTemplateElement3 = elemTemplateElement2.getPreviousSiblingElem();
        if (null != elemTemplateElement3) {
            elemTemplateElement3.m_nextSibling = elemTemplateElement;
        }
        if (this.m_firstChild == elemTemplateElement2) {
            this.m_firstChild = elemTemplateElement;
        }
        elemTemplateElement.m_parentNode = this;
        elemTemplateElement2.m_parentNode = null;
        elemTemplateElement.m_nextSibling = elemTemplateElement2.m_nextSibling;
        elemTemplateElement2.m_nextSibling = null;
        return elemTemplateElement;
    }

    public int getLength() {
        int n2 = 0;
        ElemTemplateElement elemTemplateElement = this.m_firstChild;
        while (elemTemplateElement != null) {
            ++n2;
            elemTemplateElement = elemTemplateElement.m_nextSibling;
        }
        return n2;
    }

    public Node item(int n2) {
        ElemTemplateElement elemTemplateElement = this.m_firstChild;
        int n3 = 0;
        while (n3 < n2 && elemTemplateElement != null) {
            elemTemplateElement = elemTemplateElement.m_nextSibling;
            ++n3;
        }
        return elemTemplateElement;
    }

    public Document getOwnerDocument() {
        return this.getStylesheet();
    }

    public String getTagName() {
        return this.getNodeName();
    }

    public boolean hasTextLitOnly() {
        return this.m_hasTextLitOnly;
    }

    public String getBaseIdentifier() {
        return this.getSystemId();
    }

    public int getLineNumber() {
        return this.m_lineNumber;
    }

    public int getColumnNumber() {
        return this.m_columnNumber;
    }

    public String getPublicId() {
        return null != this.m_parentNode ? this.m_parentNode.getPublicId() : null;
    }

    public String getSystemId() {
        return this.getStylesheet().getHref();
    }

    public void setLocaterInfo(SourceLocator sourceLocator) {
        this.m_lineNumber = sourceLocator.getLineNumber();
        this.m_columnNumber = sourceLocator.getColumnNumber();
    }

    public boolean hasVariableDecl() {
        return this.m_hasVariableDecl;
    }

    public void setXmlSpace(int n2) {
        this.m_defaultSpace = 2 == n2;
    }

    public boolean getXmlSpace() {
        return this.m_defaultSpace;
    }

    public Vector getDeclaredPrefixes() {
        return this.m_declaredPrefixes;
    }

    public void setPrefixes(NamespaceSupport namespaceSupport) throws TransformerException {
        this.setPrefixes(namespaceSupport, false);
    }

    public void setPrefixes(NamespaceSupport namespaceSupport, boolean bl2) throws TransformerException {
        Enumeration enumeration = namespaceSupport.getDeclaredPrefixes();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (null == this.m_declaredPrefixes) {
                this.m_declaredPrefixes = new Vector();
            }
            String string2 = namespaceSupport.getURI(string);
            if (bl2 && string2.equals("http://www.w3.org/1999/XSL/Transform")) continue;
            XMLNSDecl xMLNSDecl = new XMLNSDecl(string, string2, false);
            this.m_declaredPrefixes.addElement(xMLNSDecl);
        }
    }

    public String getNamespaceForPrefix(String string, Node node) {
        this.error(16, null);
        return null;
    }

    public String getNamespaceForPrefix(String string) {
        Vector vector = this.m_declaredPrefixes;
        if (null != vector) {
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                XMLNSDecl xMLNSDecl = (XMLNSDecl)vector.elementAt(n3);
                if (string.equals(xMLNSDecl.getPrefix())) {
                    return xMLNSDecl.getURI();
                }
                ++n3;
            }
        }
        if (null != this.m_parentNode) {
            return this.m_parentNode.getNamespaceForPrefix(string);
        }
        return null;
    }

    public Vector getPrefixes() {
        return this.m_prefixTable;
    }

    public boolean containsExcludeResultPrefix(String string, String string2) {
        ElemTemplateElement elemTemplateElement = this.getParentElem();
        if (null != elemTemplateElement) {
            return elemTemplateElement.containsExcludeResultPrefix(string, string2);
        }
        return false;
    }

    private boolean excludeResultNSDecl(String string, String string2) throws TransformerException {
        if (string2 != null) {
            if (string2.equals("http://www.w3.org/1999/XSL/Transform") || this.getStylesheet().containsExtensionElementURI(string2) || string2.equals("http://xml.apache.org/xslt")) {
                return true;
            }
            if (this.containsExcludeResultPrefix(string, string2)) {
                return true;
            }
        }
        return false;
    }

    public void resolvePrefixTables() throws TransformerException {
        Object object;
        int n2;
        ElemTemplateElement elemTemplateElement;
        this.m_prefixTable = null;
        if (null != this.m_declaredPrefixes) {
            elemTemplateElement = this.getStylesheetRoot();
            int n3 = this.m_declaredPrefixes.size();
            n2 = 0;
            while (n2 < n3) {
                NamespaceAlias namespaceAlias;
                XMLNSDecl xMLNSDecl = (XMLNSDecl)this.m_declaredPrefixes.elementAt(n2);
                object = xMLNSDecl.getPrefix();
                String string = xMLNSDecl.getURI();
                if (null == string) {
                    string = "";
                }
                boolean bl2 = this.excludeResultNSDecl((String)object, string);
                if (null == this.m_prefixTable) {
                    this.m_prefixTable = new Vector();
                }
                xMLNSDecl = null != (namespaceAlias = ((StylesheetRoot)elemTemplateElement).getNamespaceAliasComposed(string)) ? new XMLNSDecl(namespaceAlias.getStylesheetPrefix(), namespaceAlias.getResultNamespace(), bl2) : new XMLNSDecl((String)object, string, bl2);
                this.m_prefixTable.addElement(xMLNSDecl);
                ++n2;
            }
        }
        if (null != (elemTemplateElement = this.getParentNodeElem())) {
            Vector vector = elemTemplateElement.m_prefixTable;
            if (null == this.m_prefixTable && !this.needToCheckExclude()) {
                this.m_prefixTable = elemTemplateElement.m_prefixTable;
            } else {
                n2 = vector.size();
                int n4 = 0;
                while (n4 < n2) {
                    object = (XMLNSDecl)vector.elementAt(n4);
                    boolean bl3 = this.excludeResultNSDecl(((XMLNSDecl)object).getPrefix(), ((XMLNSDecl)object).getURI());
                    if (bl3 != ((XMLNSDecl)object).getIsExcluded()) {
                        object = new XMLNSDecl(((XMLNSDecl)object).getPrefix(), ((XMLNSDecl)object).getURI(), bl3);
                    }
                    this.addOrReplaceDecls((XMLNSDecl)object);
                    ++n4;
                }
            }
        } else if (null == this.m_prefixTable) {
            this.m_prefixTable = new Vector();
        }
    }

    void addOrReplaceDecls(XMLNSDecl xMLNSDecl) {
        int n2 = this.m_prefixTable.size();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            XMLNSDecl xMLNSDecl2 = (XMLNSDecl)this.m_prefixTable.elementAt(n3);
            if (xMLNSDecl2.getPrefix().equals(xMLNSDecl.getPrefix())) {
                return;
            }
            --n3;
        }
        this.m_prefixTable.addElement(xMLNSDecl);
    }

    boolean needToCheckExclude() {
        return false;
    }

    void executeNSDecls(TransformerImpl transformerImpl) throws TransformerException {
        try {
            if (null != this.m_prefixTable) {
                ResultTreeHandler resultTreeHandler = transformerImpl.getResultTreeHandler();
                int n2 = this.m_prefixTable.size();
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    XMLNSDecl xMLNSDecl = (XMLNSDecl)this.m_prefixTable.elementAt(n3);
                    if (!xMLNSDecl.getIsExcluded()) {
                        resultTreeHandler.startPrefixMapping(xMLNSDecl.getPrefix(), xMLNSDecl.getURI(), true);
                    }
                    --n3;
                }
            }
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    void unexecuteNSDecls(TransformerImpl transformerImpl) throws TransformerException {
        try {
            if (null != this.m_prefixTable) {
                ResultTreeHandler resultTreeHandler = transformerImpl.getResultTreeHandler();
                int n2 = this.m_prefixTable.size();
                int n3 = 0;
                while (n3 < n2) {
                    XMLNSDecl xMLNSDecl = (XMLNSDecl)this.m_prefixTable.elementAt(n3);
                    if (!xMLNSDecl.getIsExcluded()) {
                        resultTreeHandler.endPrefixMapping(xMLNSDecl.getPrefix());
                    }
                    ++n3;
                }
            }
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    public void setUid(int n2) {
        this.m_docOrderNumber = n2;
    }

    public int getUid() {
        return this.m_docOrderNumber;
    }

    public Node getParentNode() {
        return this.m_parentNode;
    }

    public ElemTemplateElement getParentElem() {
        return this.m_parentNode;
    }

    public void setParentElem(ElemTemplateElement elemTemplateElement) {
        this.m_parentNode = elemTemplateElement;
    }

    public Node getNextSibling() {
        return this.m_nextSibling;
    }

    public Node getPreviousSibling() {
        Node node = this.getParentNode();
        Node node2 = null;
        if (node != null) {
            node = node.getFirstChild();
            while (node != null) {
                if (node == this) {
                    return node2;
                }
                node2 = node;
                node = node.getNextSibling();
            }
        }
        return null;
    }

    public ElemTemplateElement getPreviousSiblingElem() {
        ElemTemplateElement elemTemplateElement = this.getParentNodeElem();
        ElemTemplateElement elemTemplateElement2 = null;
        if (elemTemplateElement != null) {
            elemTemplateElement = elemTemplateElement.getFirstChildElem();
            while (elemTemplateElement != null) {
                if (elemTemplateElement == this) {
                    return elemTemplateElement2;
                }
                elemTemplateElement2 = elemTemplateElement;
                elemTemplateElement = elemTemplateElement.getNextSiblingElem();
            }
        }
        return null;
    }

    public ElemTemplateElement getNextSiblingElem() {
        return this.m_nextSibling;
    }

    public ElemTemplateElement getParentNodeElem() {
        return this.m_parentNode;
    }

    public Node getFirstChild() {
        return this.m_firstChild;
    }

    public ElemTemplateElement getFirstChildElem() {
        return this.m_firstChild;
    }

    public Node getLastChild() {
        ElemTemplateElement elemTemplateElement = null;
        ElemTemplateElement elemTemplateElement2 = this.m_firstChild;
        while (elemTemplateElement2 != null) {
            elemTemplateElement = elemTemplateElement2;
            elemTemplateElement2 = elemTemplateElement2.m_nextSibling;
        }
        return elemTemplateElement;
    }

    public ElemTemplateElement getLastChildElem() {
        ElemTemplateElement elemTemplateElement = null;
        ElemTemplateElement elemTemplateElement2 = this.m_firstChild;
        while (elemTemplateElement2 != null) {
            elemTemplateElement = elemTemplateElement2;
            elemTemplateElement2 = elemTemplateElement2.m_nextSibling;
        }
        return elemTemplateElement;
    }

    public Node getDOMBackPointer() {
        return this.m_DOMBackPointer;
    }

    public void setDOMBackPointer(Node node) {
        this.m_DOMBackPointer = node;
    }

    public int compareTo(Object object) throws ClassCastException {
        ElemTemplateElement elemTemplateElement = (ElemTemplateElement)object;
        int n2 = elemTemplateElement.getStylesheetComposed().getImportCountComposed();
        int n3 = this.getStylesheetComposed().getImportCountComposed();
        if (n3 < n2) {
            return -1;
        }
        if (n3 > n2) {
            return 1;
        }
        return this.getUid() - elemTemplateElement.getUid();
    }

    public boolean shouldStripWhiteSpace(XPathContext xPathContext, Element element) throws TransformerException {
        StylesheetRoot stylesheetRoot = this.getStylesheetRoot();
        return null != stylesheetRoot ? stylesheetRoot.shouldStripWhiteSpace(xPathContext, element) : false;
    }

    public boolean canStripWhiteSpace() {
        StylesheetRoot stylesheetRoot = this.getStylesheetRoot();
        return null != stylesheetRoot ? stylesheetRoot.canStripWhiteSpace() : false;
    }
}

