/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SegmentCache;
import javax.swing.text.StateInvariantError;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class PlainView
extends View
implements TabExpander {
    protected FontMetrics metrics;
    Element longLine;
    Font font;
    Segment lineBuffer;
    int tabSize;
    int tabBase;
    int sel0;
    int sel1;
    Color unselected;
    Color selected;

    public PlainView(Element element) {
        super(element);
    }

    protected int getTabSize() {
        Integer n2 = (Integer)this.getDocument().getProperty("tabSize");
        int n3 = n2 != null ? n2 : 8;
        return n3;
    }

    protected void drawLine(int n2, Graphics graphics, int n3, int n4) {
        Element element = this.getElement().getElement(n2);
        try {
            if (element.isLeaf()) {
                this.drawElement(element, graphics, n3, n4);
            } else {
                int n5 = element.getElementCount();
                int n6 = 0;
                while (n6 < n5) {
                    Element element2 = element.getElement(n6);
                    n3 = this.drawElement(element2, graphics, n3, n4);
                    ++n6;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            throw new StateInvariantError("Can't render line: " + n2);
        }
    }

    private int drawElement(Element element, Graphics graphics, int n2, int n3) throws BadLocationException {
        int n4 = element.getStartOffset();
        int n5 = element.getEndOffset();
        n5 = Math.min(this.getDocument().getLength(), n5);
        AttributeSet attributeSet = element.getAttributes();
        if (Utilities.isComposedTextAttributeDefined(attributeSet)) {
            graphics.setColor(this.unselected);
            n2 = Utilities.drawComposedText(attributeSet, graphics, n2, n3, n4 - element.getStartOffset(), n5 - element.getStartOffset());
        } else if (this.sel0 == this.sel1) {
            n2 = this.drawUnselectedText(graphics, n2, n3, n4, n5);
        } else if (n4 >= this.sel0 && n4 <= this.sel1 && n5 >= this.sel0 && n5 <= this.sel1) {
            n2 = this.drawSelectedText(graphics, n2, n3, n4, n5);
        } else if (this.sel0 >= n4 && this.sel0 <= n5) {
            if (this.sel1 >= n4 && this.sel1 <= n5) {
                n2 = this.drawUnselectedText(graphics, n2, n3, n4, this.sel0);
                n2 = this.drawSelectedText(graphics, n2, n3, this.sel0, this.sel1);
                n2 = this.drawUnselectedText(graphics, n2, n3, this.sel1, n5);
            } else {
                n2 = this.drawUnselectedText(graphics, n2, n3, n4, this.sel0);
                n2 = this.drawSelectedText(graphics, n2, n3, this.sel0, n5);
            }
        } else if (this.sel1 >= n4 && this.sel1 <= n5) {
            n2 = this.drawSelectedText(graphics, n2, n3, n4, this.sel1);
            n2 = this.drawUnselectedText(graphics, n2, n3, this.sel1, n5);
        } else {
            n2 = this.drawUnselectedText(graphics, n2, n3, n4, n5);
        }
        return n2;
    }

    protected int drawUnselectedText(Graphics graphics, int n2, int n3, int n4, int n5) throws BadLocationException {
        graphics.setColor(this.unselected);
        Document document = this.getDocument();
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n4, n5 - n4, segment);
        int n6 = Utilities.drawTabbedText(segment, n2, n3, graphics, this, n4);
        SegmentCache.releaseSharedSegment(segment);
        return n6;
    }

    protected int drawSelectedText(Graphics graphics, int n2, int n3, int n4, int n5) throws BadLocationException {
        graphics.setColor(this.selected);
        Document document = this.getDocument();
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n4, n5 - n4, segment);
        int n6 = Utilities.drawTabbedText(segment, n2, n3, graphics, this, n4);
        SegmentCache.releaseSharedSegment(segment);
        return n6;
    }

    protected final Segment getLineBuffer() {
        if (this.lineBuffer == null) {
            this.lineBuffer = new Segment();
        }
        return this.lineBuffer;
    }

    protected void updateMetrics() {
        Container container = this.getContainer();
        Font font = container.getFont();
        if (this.font != font) {
            this.calculateLongestLine();
            this.tabSize = this.getTabSize() * this.metrics.charWidth('m');
        }
    }

    public float getPreferredSpan(int n2) {
        this.updateMetrics();
        switch (n2) {
            case 0: {
                return this.getLineWidth(this.longLine);
            }
            case 1: {
                return this.getElement().getElementCount() * this.metrics.getHeight();
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n2);
    }

    public void paint(Graphics graphics, Shape shape) {
        Shape shape2 = shape;
        shape = this.adjustPaintRegion(shape);
        Rectangle rectangle = (Rectangle)shape;
        this.tabBase = rectangle.x;
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        graphics.setFont(jTextComponent.getFont());
        this.sel0 = jTextComponent.getSelectionStart();
        this.sel1 = jTextComponent.getSelectionEnd();
        this.unselected = jTextComponent.isEnabled() ? jTextComponent.getForeground() : jTextComponent.getDisabledTextColor();
        Caret caret = jTextComponent.getCaret();
        this.selected = caret.isSelectionVisible() ? jTextComponent.getSelectedTextColor() : this.unselected;
        this.updateMetrics();
        Rectangle rectangle2 = graphics.getClipBounds();
        int n2 = this.metrics.getHeight();
        int n3 = rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height);
        int n4 = Math.max(0, n3 / n2);
        int n5 = rectangle2.y - rectangle.y;
        int n6 = Math.max(0, n5 / n2);
        int n7 = rectangle.height / n2;
        if (rectangle.height % n2 != 0) {
            ++n7;
        }
        Rectangle rectangle3 = this.lineToRect(shape, n6);
        int n8 = rectangle3.y + this.metrics.getAscent();
        int n9 = rectangle3.x;
        Element element = this.getElement();
        int n10 = element.getElementCount();
        int n11 = Math.min(n10, n7 - n4);
        --n10;
        Highlighter highlighter = jTextComponent.getHighlighter();
        LayeredHighlighter layeredHighlighter = highlighter instanceof LayeredHighlighter ? (LayeredHighlighter)highlighter : null;
        int n12 = n6;
        while (n12 < n11) {
            if (layeredHighlighter != null) {
                Element element2 = element.getElement(n12);
                if (n12 == n10) {
                    layeredHighlighter.paintLayeredHighlights(graphics, element2.getStartOffset(), element2.getEndOffset(), shape2, jTextComponent, this);
                } else {
                    layeredHighlighter.paintLayeredHighlights(graphics, element2.getStartOffset(), element2.getEndOffset() - 1, shape2, jTextComponent, this);
                }
            }
            this.drawLine(n12, graphics, n9, n8);
            n8 += n2;
            ++n12;
        }
    }

    Shape adjustPaintRegion(Shape shape) {
        return shape;
    }

    public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
        Document document = this.getDocument();
        Element element = this.getElement();
        int n3 = element.getElementIndex(n2);
        Rectangle rectangle = this.lineToRect(shape, n3);
        this.tabBase = rectangle.x;
        Element element2 = element.getElement(n3);
        int n4 = element2.getStartOffset();
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n4, n2 - n4, segment);
        int n5 = Utilities.getTabbedTextWidth(segment, this.metrics, this.tabBase, this, n4);
        SegmentCache.releaseSharedSegment(segment);
        rectangle.x += n5;
        rectangle.width = 1;
        rectangle.height = this.metrics.getHeight();
        return rectangle;
    }

    public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
        biasArray[0] = Position.Bias.Forward;
        Rectangle rectangle = shape.getBounds();
        Document document = this.getDocument();
        int n2 = (int)f2;
        int n3 = (int)f3;
        if (n3 < rectangle.y) {
            return this.getStartOffset();
        }
        if (n3 > rectangle.y + rectangle.height) {
            return this.getEndOffset() - 1;
        }
        Element element = document.getDefaultRootElement();
        int n4 = Math.abs((n3 - rectangle.y) / this.metrics.getHeight());
        if (n4 >= element.getElementCount()) {
            return this.getEndOffset() - 1;
        }
        Element element2 = element.getElement(n4);
        if (n2 < rectangle.x) {
            return element2.getStartOffset();
        }
        if (n2 > rectangle.x + rectangle.width) {
            return element2.getEndOffset() - 1;
        }
        try {
            int n5 = element2.getStartOffset();
            int n6 = element2.getEndOffset() - 1;
            Segment segment = SegmentCache.getSharedSegment();
            document.getText(n5, n6 - n5, segment);
            this.tabBase = rectangle.x;
            int n7 = n5 + Utilities.getTabbedTextOffset(segment, this.metrics, this.tabBase, n2, this, n5);
            SegmentCache.releaseSharedSegment(segment);
            return n7;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    public void setSize(float f2, float f3) {
        super.setSize(f2, f3);
        this.updateMetrics();
    }

    public float nextTabStop(float f2, int n2) {
        if (this.tabSize == 0) {
            return f2;
        }
        int n3 = ((int)f2 - this.tabBase) / this.tabSize;
        return this.tabBase + (n3 + 1) * this.tabSize;
    }

    protected void updateDamage(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element[] elementArray;
        Container container = this.getContainer();
        this.updateMetrics();
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        Element[] elementArray2 = elementChange != null ? elementChange.getChildrenAdded() : null;
        Element[] elementArray3 = elementArray = elementChange != null ? elementChange.getChildrenRemoved() : null;
        if (elementArray2 != null && elementArray2.length > 0 || elementArray != null && elementArray.length > 0) {
            int n2;
            if (elementArray2 != null) {
                n2 = this.getLineWidth(this.longLine);
                int n3 = 0;
                while (n3 < elementArray2.length) {
                    int n4 = this.getLineWidth(elementArray2[n3]);
                    if (n4 > n2) {
                        n2 = n4;
                        this.longLine = elementArray2[n3];
                    }
                    ++n3;
                }
            }
            if (elementArray != null) {
                n2 = 0;
                while (n2 < elementArray.length) {
                    if (elementArray[n2] == this.longLine) {
                        this.calculateLongestLine();
                        break;
                    }
                    ++n2;
                }
            }
            this.preferenceChanged(null, true, true);
            container.repaint();
        } else {
            Element element2 = this.getElement();
            int n5 = element2.getElementIndex(documentEvent.getOffset());
            this.damageLineRange(n5, n5, shape, container);
            if (documentEvent.getType() == DocumentEvent.EventType.INSERT) {
                int n6 = this.getLineWidth(this.longLine);
                Element element3 = element2.getElement(n5);
                if (element3 == this.longLine) {
                    this.preferenceChanged(null, true, false);
                } else if (this.getLineWidth(element3) > n6) {
                    this.longLine = element3;
                    this.preferenceChanged(null, true, false);
                }
            } else if (documentEvent.getType() == DocumentEvent.EventType.REMOVE && element2.getElement(n5) == this.longLine) {
                this.calculateLongestLine();
                this.preferenceChanged(null, true, false);
            }
        }
    }

    protected void damageLineRange(int n2, int n3, Shape shape, Component component) {
        if (shape != null) {
            Rectangle rectangle = this.lineToRect(shape, n2);
            Rectangle rectangle2 = this.lineToRect(shape, n3);
            if (rectangle != null && rectangle2 != null) {
                Rectangle rectangle3 = rectangle.union(rectangle2);
                component.repaint(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            } else {
                component.repaint();
            }
        }
    }

    protected Rectangle lineToRect(Shape shape, int n2) {
        Rectangle rectangle = null;
        this.updateMetrics();
        if (this.metrics != null) {
            Rectangle rectangle2 = shape.getBounds();
            rectangle = new Rectangle(rectangle2.x, rectangle2.y + n2 * this.metrics.getHeight(), rectangle2.width, this.metrics.getHeight());
        }
        return rectangle;
    }

    private void calculateLongestLine() {
        Container container = this.getContainer();
        this.font = container.getFont();
        this.metrics = container.getFontMetrics(this.font);
        Document document = this.getDocument();
        Element element = this.getElement();
        int n2 = element.getElementCount();
        int n3 = -1;
        int n4 = 0;
        while (n4 < n2) {
            Element element2 = element.getElement(n4);
            int n5 = this.getLineWidth(element2);
            if (n5 > n3) {
                n3 = n5;
                this.longLine = element2;
            }
            ++n4;
        }
    }

    private int getLineWidth(Element element) {
        int n2;
        int n3 = element.getStartOffset();
        int n4 = element.getEndOffset();
        Segment segment = SegmentCache.getSharedSegment();
        try {
            element.getDocument().getText(n3, n4 - n3, segment);
            n2 = Utilities.getTabbedTextWidth(segment, this.metrics, this.tabBase, this, n3);
        }
        catch (BadLocationException badLocationException) {
            n2 = 0;
        }
        SegmentCache.releaseSharedSegment(segment);
        return n2;
    }
}

