/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import javax.swing.KeyboardManager;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SingleSelectionModel;
import javax.swing.UIManager;
import javax.swing.plaf.MenuBarUI;

public class JMenuBar
extends JComponent
implements Accessible,
MenuElement {
    private static final String uiClassID = "MenuBarUI";
    private transient SingleSelectionModel selectionModel;
    private boolean paintBorder = true;
    private Insets margin = null;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;

    public JMenuBar() {
        this.setFocusTraversalKeysEnabled(false);
        this.setSelectionModel(new DefaultSingleSelectionModel());
        this.updateUI();
    }

    public MenuBarUI getUI() {
        return (MenuBarUI)this.ui;
    }

    public void setUI(MenuBarUI menuBarUI) {
        super.setUI(menuBarUI);
    }

    public void updateUI() {
        this.setUI((MenuBarUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public SingleSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(SingleSelectionModel singleSelectionModel) {
        SingleSelectionModel singleSelectionModel2 = this.selectionModel;
        this.selectionModel = singleSelectionModel;
        this.firePropertyChange("selectionModel", singleSelectionModel2, this.selectionModel);
    }

    public JMenu add(JMenu jMenu) {
        super.add(jMenu);
        return jMenu;
    }

    public JMenu getMenu(int n2) {
        Component component = this.getComponentAtIndex(n2);
        if (component instanceof JMenu) {
            return (JMenu)component;
        }
        return null;
    }

    public int getMenuCount() {
        return this.getComponentCount();
    }

    public void setHelpMenu(JMenu jMenu) {
        throw new Error("setHelpMenu() not yet implemented.");
    }

    public JMenu getHelpMenu() {
        throw new Error("getHelpMenu() not yet implemented.");
    }

    public Component getComponentAtIndex(int n2) {
        return this.getComponent(n2);
    }

    public int getComponentIndex(Component component) {
        int n2 = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        int n3 = 0;
        while (n3 < n2) {
            Component component2 = componentArray[n3];
            if (component2 == component) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public void setSelected(Component component) {
        SingleSelectionModel singleSelectionModel = this.getSelectionModel();
        int n2 = this.getComponentIndex(component);
        singleSelectionModel.setSelectedIndex(n2);
    }

    public boolean isSelected() {
        return this.selectionModel.isSelected();
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public void setBorderPainted(boolean bl2) {
        boolean bl3 = this.paintBorder;
        this.paintBorder = bl2;
        this.firePropertyChange("borderPainted", bl3, this.paintBorder);
        if (bl2 != bl3) {
            this.revalidate();
            this.repaint();
        }
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    public void setMargin(Insets insets) {
        Insets insets2 = this.margin;
        this.margin = insets;
        this.firePropertyChange("margin", insets2, insets);
        if (insets2 == null || !insets.equals(insets2)) {
            this.revalidate();
            this.repaint();
        }
    }

    public Insets getMargin() {
        if (this.margin == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.margin;
    }

    public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    public void menuSelectionChanged(boolean bl2) {
    }

    public MenuElement[] getSubElements() {
        Vector vector = new Vector();
        int n2 = this.getComponentCount();
        int n3 = 0;
        while (n3 < n2) {
            Component component = this.getComponent(n3);
            if (component instanceof MenuElement) {
                vector.addElement(component);
            }
            ++n3;
        }
        MenuElement[] menuElementArray = new MenuElement[vector.size()];
        n3 = 0;
        n2 = vector.size();
        while (n3 < n2) {
            menuElementArray[n3] = (MenuElement)vector.elementAt(n3);
            ++n3;
        }
        return menuElementArray;
    }

    public Component getComponent() {
        return this;
    }

    protected String paramString() {
        String string = this.paintBorder ? "true" : "false";
        String string2 = this.margin != null ? this.margin.toString() : "";
        return super.paramString() + ",margin=" + string2 + ",paintBorder=" + string;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenuBar();
        }
        return this.accessibleContext;
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n2, boolean bl2) {
        boolean bl3 = super.processKeyBinding(keyStroke, keyEvent, n2, bl2);
        if (!bl3) {
            MenuElement[] menuElementArray = this.getSubElements();
            int n3 = 0;
            while (n3 < menuElementArray.length) {
                if (JMenuBar.processBindingForKeyStrokeRecursive(menuElementArray[n3], keyStroke, keyEvent, n2, bl2)) {
                    return true;
                }
                ++n3;
            }
        }
        return bl3;
    }

    static boolean processBindingForKeyStrokeRecursive(MenuElement menuElement, KeyStroke keyStroke, KeyEvent keyEvent, int n2, boolean bl2) {
        if (menuElement == null) {
            return false;
        }
        Component component = menuElement.getComponent();
        if (component != null && component instanceof JComponent && ((JComponent)component).processKeyBinding(keyStroke, keyEvent, n2, bl2)) {
            return true;
        }
        MenuElement[] menuElementArray = menuElement.getSubElements();
        int n3 = 0;
        while (n3 < menuElementArray.length) {
            if (JMenuBar.processBindingForKeyStrokeRecursive(menuElementArray[n3], keyStroke, keyEvent, n2, bl2)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public void addNotify() {
        super.addNotify();
        KeyboardManager.getCurrentManager().registerMenuBar(this);
    }

    public void removeNotify() {
        super.removeNotify();
        KeyboardManager.getCurrentManager().unregisterMenuBar(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
        Object[] objectArray = new Object[4];
        int n2 = 0;
        if (this.selectionModel instanceof Serializable) {
            objectArray[n2++] = "selectionModel";
            objectArray[n2++] = this.selectionModel;
        }
        objectOutputStream.writeObject(objectArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object[] objectArray = (Object[])objectInputStream.readObject();
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] == null) break;
            if (objectArray[n2].equals("selectionModel")) {
                this.selectionModel = (SingleSelectionModel)objectArray[n2 + 1];
            }
            n2 += 2;
        }
    }

    protected class AccessibleJMenuBar
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection {
        protected AccessibleJMenuBar() {
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_BAR;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public int getAccessibleSelectionCount() {
            if (JMenuBar.this.isSelected()) {
                return 1;
            }
            return 0;
        }

        public Accessible getAccessibleSelection(int n2) {
            if (JMenuBar.this.isSelected()) {
                if (n2 != 0) {
                    return null;
                }
                int n3 = JMenuBar.this.getSelectionModel().getSelectedIndex();
                if (JMenuBar.this.getComponentAtIndex(n3) instanceof Accessible) {
                    return (Accessible)((Object)JMenuBar.this.getComponentAtIndex(n3));
                }
            }
            return null;
        }

        public boolean isAccessibleChildSelected(int n2) {
            return n2 == JMenuBar.this.getSelectionModel().getSelectedIndex();
        }

        public void addAccessibleSelection(int n2) {
            JMenu jMenu;
            int n3 = JMenuBar.this.getSelectionModel().getSelectedIndex();
            if (n2 == n3) {
                return;
            }
            if (n3 >= 0 && n3 < JMenuBar.this.getMenuCount() && (jMenu = JMenuBar.this.getMenu(n3)) != null) {
                MenuSelectionManager.defaultManager().setSelectedPath(null);
            }
            JMenuBar.this.getSelectionModel().setSelectedIndex(n2);
            jMenu = JMenuBar.this.getMenu(n2);
            if (jMenu != null) {
                MenuElement[] menuElementArray = new MenuElement[]{JMenuBar.this, jMenu, jMenu.getPopupMenu()};
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
            }
        }

        public void removeAccessibleSelection(int n2) {
            if (n2 >= 0 && n2 < JMenuBar.this.getMenuCount()) {
                JMenu jMenu = JMenuBar.this.getMenu(n2);
                if (jMenu != null) {
                    MenuSelectionManager.defaultManager().setSelectedPath(null);
                }
                JMenuBar.this.getSelectionModel().setSelectedIndex(-1);
            }
        }

        public void clearAccessibleSelection() {
            JMenu jMenu;
            int n2 = JMenuBar.this.getSelectionModel().getSelectedIndex();
            if (n2 >= 0 && n2 < JMenuBar.this.getMenuCount() && (jMenu = JMenuBar.this.getMenu(n2)) != null) {
                MenuSelectionManager.defaultManager().setSelectedPath(null);
            }
            JMenuBar.this.getSelectionModel().setSelectedIndex(-1);
        }

        public void selectAllAccessibleSelection() {
        }
    }
}

