/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.directory;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;

public class BasicAttributes
implements Attributes {
    private boolean ignoreCase = false;
    transient Hashtable attrs = new Hashtable(11);
    private static final long serialVersionUID = 4980164073184639448L;

    public BasicAttributes() {
    }

    public BasicAttributes(boolean bl2) {
        this.ignoreCase = bl2;
    }

    public BasicAttributes(String string, Object object) {
        this();
        this.put(new BasicAttribute(string, object));
    }

    public BasicAttributes(String string, Object object, boolean bl2) {
        this(bl2);
        this.put(new BasicAttribute(string, object));
    }

    public Object clone() {
        BasicAttributes basicAttributes;
        try {
            basicAttributes = (BasicAttributes)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            basicAttributes = new BasicAttributes(this.ignoreCase);
        }
        basicAttributes.attrs = (Hashtable)this.attrs.clone();
        return basicAttributes;
    }

    public boolean isCaseIgnored() {
        return this.ignoreCase;
    }

    public int size() {
        return this.attrs.size();
    }

    public Attribute get(String string) {
        Attribute attribute = (Attribute)this.attrs.get(this.ignoreCase ? string.toLowerCase() : string);
        return attribute;
    }

    public NamingEnumeration getAll() {
        return new AttrEnumImpl();
    }

    public NamingEnumeration getIDs() {
        return new IDEnumImpl();
    }

    public Attribute put(String string, Object object) {
        return this.put(new BasicAttribute(string, object));
    }

    public Attribute put(Attribute attribute) {
        String string = attribute.getID();
        if (this.ignoreCase) {
            string = string.toLowerCase();
        }
        return (Attribute)this.attrs.put(string, attribute);
    }

    public Attribute remove(String string) {
        String string2 = this.ignoreCase ? string.toLowerCase() : string;
        return (Attribute)this.attrs.remove(string2);
    }

    public String toString() {
        if (this.attrs.size() == 0) {
            return "No attributes";
        }
        return this.attrs.toString();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Attributes) {
            Attributes attributes = (Attributes)object;
            if (this.ignoreCase != attributes.isCaseIgnored()) {
                return false;
            }
            if (this.size() == attributes.size()) {
                try {
                    NamingEnumeration namingEnumeration = attributes.getAll();
                    while (namingEnumeration.hasMore()) {
                        Attribute attribute;
                        Attribute attribute2 = (Attribute)namingEnumeration.next();
                        if (attribute2.equals(attribute = this.get(attribute2.getID()))) continue;
                        return false;
                    }
                }
                catch (NamingException namingException) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.ignoreCase ? 1 : 0;
        try {
            NamingEnumeration namingEnumeration = this.getAll();
            while (namingEnumeration.hasMore()) {
                n2 += namingEnumeration.next().hashCode();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return n2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.attrs.size());
        Enumeration enumeration = this.attrs.elements();
        while (enumeration.hasMoreElements()) {
            objectOutputStream.writeObject(enumeration.nextElement());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.attrs = n2 >= 1 ? new Hashtable(n2 * 2) : new Hashtable(2);
        while (--n2 >= 0) {
            this.put((Attribute)objectInputStream.readObject());
        }
    }

    class IDEnumImpl
    implements NamingEnumeration {
        Enumeration elements;

        public IDEnumImpl() {
            this.elements = BasicAttributes.this.attrs.elements();
        }

        public boolean hasMoreElements() {
            return this.elements.hasMoreElements();
        }

        public Object nextElement() {
            Attribute attribute = (Attribute)this.elements.nextElement();
            return attribute.getID();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            this.elements = null;
        }
    }

    class AttrEnumImpl
    implements NamingEnumeration {
        Enumeration elements;

        public AttrEnumImpl() {
            this.elements = BasicAttributes.this.attrs.elements();
        }

        public boolean hasMoreElements() {
            return this.elements.hasMoreElements();
        }

        public Object nextElement() {
            return this.elements.nextElement();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            this.elements = null;
        }
    }
}

