/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Extension;
import java.util.Date;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public abstract class X509CRL
extends CRL
implements X509Extension {
    protected X509CRL() {
        super("X.509");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509CRL)) {
            return false;
        }
        try {
            byte[] byArray = this.getEncoded();
            byte[] byArray2 = ((X509CRL)object).getEncoded();
            if (byArray.length != byArray2.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < byArray.length) {
                if (byArray[n2] != byArray2[n2]) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        catch (CRLException cRLException) {
            return false;
        }
    }

    public int hashCode() {
        int n2 = 0;
        try {
            byte[] byArray = this.getEncoded();
            int n3 = 1;
            while (n3 < byArray.length) {
                n2 += byArray[n3] * n3;
                ++n3;
            }
            return n2;
        }
        catch (CRLException cRLException) {
            return n2;
        }
    }

    public abstract byte[] getEncoded() throws CRLException;

    public abstract void verify(PublicKey var1) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract int getVersion();

    public abstract Principal getIssuerDN();

    public X500Principal getIssuerX500Principal() {
        if (this.getIssuerDN() == null) {
            throw new IllegalStateException("issuer may not be null");
        }
        try {
            return new X500Principal(this.getIssuerDN().getName());
        }
        catch (Exception exception) {
            RuntimeException runtimeException = new RuntimeException("unable to instantiate X500Principal");
            runtimeException.initCause(exception);
            throw runtimeException;
        }
    }

    public abstract Date getThisUpdate();

    public abstract Date getNextUpdate();

    public abstract X509CRLEntry getRevokedCertificate(BigInteger var1);

    public abstract Set getRevokedCertificates();

    public abstract byte[] getTBSCertList() throws CRLException;

    public abstract byte[] getSignature();

    public abstract String getSigAlgName();

    public abstract String getSigAlgOID();

    public abstract byte[] getSigAlgParams();
}

