/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTException;
import java.awt.AWTKeyStroke;
import java.awt.BufferCapabilities;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsCallback;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.KeyboardFocusManager;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.PaintEvent;
import java.awt.event.WindowEvent;
import java.awt.im.InputContext;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferStrategy;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import sun.awt.AppContext;
import sun.awt.ConstrainableGraphics;
import sun.awt.DebugHelper;
import sun.awt.SunToolkit;
import sun.awt.WindowClosingListener;
import sun.awt.dnd.SunDropTargetEvent;
import sun.awt.font.NativeFontWrapper;
import sun.awt.im.CompositionArea;
import sun.security.action.GetPropertyAction;

public abstract class Component
implements ImageObserver,
MenuContainer,
Serializable {
    transient ComponentPeer peer;
    transient Container parent;
    transient AppContext appContext;
    int x;
    int y;
    int width;
    int height;
    Color foreground;
    Color background;
    Font font;
    Font peerFont;
    Cursor cursor;
    Locale locale;
    transient GraphicsConfiguration graphicsConfig = null;
    transient BufferStrategy bufferStrategy = null;
    boolean ignoreRepaint = false;
    boolean visible = true;
    boolean enabled = true;
    boolean valid = false;
    DropTarget dropTarget;
    Vector popups;
    private String name;
    private boolean nameExplicitlySet = false;
    private boolean focusable = true;
    private static final int FOCUS_TRAVERSABLE_UNKNOWN = 0;
    private static final int FOCUS_TRAVERSABLE_DEFAULT = 1;
    private static final int FOCUS_TRAVERSABLE_SET = 2;
    private int isFocusTraversableOverridden = 0;
    Set[] focusTraversalKeys;
    private static final String[] focusTraversalKeyPropertyNames;
    private boolean focusTraversalKeysEnabled = true;
    static final Object LOCK;
    Dimension minSize;
    Dimension prefSize;
    transient ComponentOrientation componentOrientation = ComponentOrientation.UNKNOWN;
    boolean newEventsOnly = false;
    transient ComponentListener componentListener;
    transient FocusListener focusListener;
    transient HierarchyListener hierarchyListener;
    transient HierarchyBoundsListener hierarchyBoundsListener;
    transient KeyListener keyListener;
    transient MouseListener mouseListener;
    transient MouseMotionListener mouseMotionListener;
    transient MouseWheelListener mouseWheelListener;
    transient InputMethodListener inputMethodListener;
    transient RuntimeException windowClosingException = null;
    static final String actionListenerK = "actionL";
    static final String adjustmentListenerK = "adjustmentL";
    static final String componentListenerK = "componentL";
    static final String containerListenerK = "containerL";
    static final String focusListenerK = "focusL";
    static final String itemListenerK = "itemL";
    static final String keyListenerK = "keyL";
    static final String mouseListenerK = "mouseL";
    static final String mouseMotionListenerK = "mouseMotionL";
    static final String mouseWheelListenerK = "mouseWheelL";
    static final String textListenerK = "textL";
    static final String ownedWindowK = "ownedL";
    static final String windowListenerK = "windowL";
    static final String inputMethodListenerK = "inputMethodL";
    static final String hierarchyListenerK = "hierarchyL";
    static final String hierarchyBoundsListenerK = "hierarchyBoundsL";
    static final String windowStateListenerK = "windowStateL";
    static final String windowFocusListenerK = "windowFocusL";
    long eventMask = 4096L;
    private static final DebugHelper dbg;
    static boolean isInc;
    static int incRate;
    public static final float TOP_ALIGNMENT = 0.0f;
    public static final float CENTER_ALIGNMENT = 0.5f;
    public static final float BOTTOM_ALIGNMENT = 1.0f;
    public static final float LEFT_ALIGNMENT = 0.0f;
    public static final float RIGHT_ALIGNMENT = 1.0f;
    private static final long serialVersionUID = -7644114512714619750L;
    private PropertyChangeSupport changeSupport;
    boolean isPacked = false;
    private transient Object privateKey = new Object();
    static Hashtable metrics;
    private int componentSerializedDataVersion = 4;
    AccessibleContext accessibleContext = null;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$java$awt$event$ComponentListener;
    static /* synthetic */ Class class$java$awt$event$FocusListener;
    static /* synthetic */ Class class$java$awt$event$HierarchyListener;
    static /* synthetic */ Class class$java$awt$event$HierarchyBoundsListener;
    static /* synthetic */ Class class$java$awt$event$KeyListener;
    static /* synthetic */ Class class$java$awt$event$MouseListener;
    static /* synthetic */ Class class$java$awt$event$MouseMotionListener;
    static /* synthetic */ Class class$java$awt$event$MouseWheelListener;
    static /* synthetic */ Class class$java$awt$event$InputMethodListener;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

    protected Component() {
        this.appContext = AppContext.getAppContext();
        SunToolkit.insertTargetMapping(this, this.appContext);
    }

    void initializeFocusTraversalKeys() {
        this.focusTraversalKeys = new Set[3];
    }

    String constructComponentName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        if (this.name == null && !this.nameExplicitlySet) {
            Component component = this;
            synchronized (component) {
                if (this.name == null && !this.nameExplicitlySet) {
                    this.name = this.constructComponentName();
                }
            }
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) {
        Component component = this;
        synchronized (component) {
            this.name = string;
            this.nameExplicitlySet = true;
        }
    }

    public Container getParent() {
        return this.getParent_NoClientCode();
    }

    final Container getParent_NoClientCode() {
        return this.parent;
    }

    public ComponentPeer getPeer() {
        return this.peer;
    }

    public synchronized void setDropTarget(DropTarget dropTarget) {
        block12: {
            if (dropTarget == this.dropTarget || this.dropTarget != null && this.dropTarget.equals(dropTarget)) {
                return;
            }
            DropTarget dropTarget2 = this.dropTarget;
            if (dropTarget2 != null) {
                if (this.peer != null) {
                    this.dropTarget.removeNotify(this.peer);
                }
                DropTarget dropTarget3 = this.dropTarget;
                this.dropTarget = null;
                try {
                    dropTarget3.setComponent(null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if ((this.dropTarget = dropTarget) != null) {
                try {
                    this.dropTarget.setComponent(this);
                    if (this.peer != null) {
                        this.dropTarget.addNotify(this.peer);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (dropTarget2 == null) break block12;
                    try {
                        dropTarget2.setComponent(this);
                        if (this.peer != null) {
                            this.dropTarget.addNotify(this.peer);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public synchronized DropTarget getDropTarget() {
        return this.dropTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphicsConfiguration getGraphicsConfiguration() {
        Object object = this.getTreeLock();
        synchronized (object) {
            block6: {
                block5: {
                    if (this.graphicsConfig == null) break block5;
                    GraphicsConfiguration graphicsConfiguration = this.graphicsConfig;
                    return graphicsConfiguration;
                }
                if (this.getParent() == null) break block6;
                GraphicsConfiguration graphicsConfiguration = this.getParent().getGraphicsConfiguration();
                return graphicsConfiguration;
            }
            GraphicsConfiguration graphicsConfiguration = null;
            return graphicsConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetGC() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.graphicsConfig = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setGCFromPeer() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.graphicsConfig = this.peer != null ? this.peer.getGraphicsConfiguration() : null;
        }
    }

    void checkGD(String string) {
        if (this.graphicsConfig != null && !this.graphicsConfig.getDevice().getIDstring().equals(string)) {
            throw new IllegalArgumentException("adding a container to a container on a different GraphicsDevice");
        }
    }

    public final Object getTreeLock() {
        return LOCK;
    }

    public Toolkit getToolkit() {
        return this.getToolkitImpl();
    }

    final Toolkit getToolkitImpl() {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null && !(componentPeer instanceof LightweightPeer)) {
            return componentPeer.getToolkit();
        }
        Container container = this.parent;
        if (container != null) {
            return container.getToolkitImpl();
        }
        return Toolkit.getDefaultToolkit();
    }

    public boolean isValid() {
        return this.peer != null && this.valid;
    }

    public boolean isDisplayable() {
        return this.getPeer() != null;
    }

    public boolean isVisible() {
        return this.visible;
    }

    boolean isRecursivelyVisible() {
        return this.visible && (this.parent == null || this.parent.isRecursivelyVisible());
    }

    public boolean isShowing() {
        if (this.visible && this.peer != null) {
            Container container = this.parent;
            return container == null || container.isShowing();
        }
        return false;
    }

    public boolean isEnabled() {
        return this.isEnabledImpl();
    }

    final boolean isEnabledImpl() {
        return this.enabled;
    }

    public void setEnabled(boolean bl2) {
        this.enable(bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() {
        if (!this.enabled) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.enabled = true;
                ComponentPeer componentPeer = this.peer;
                if (componentPeer != null) {
                    componentPeer.enable();
                    if (this.visible) {
                        this.updateCursorImmediately();
                    }
                }
            }
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.ENABLED);
            }
        }
    }

    public void enable(boolean bl2) {
        if (bl2) {
            this.enable();
        } else {
            this.disable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        if (this.enabled) {
            Object object = this.getTreeLock();
            synchronized (object) {
                ComponentPeer componentPeer;
                this.enabled = false;
                if (this.isFocusOwner()) {
                    this.autoTransferFocus(false);
                }
                if ((componentPeer = this.peer) != null) {
                    componentPeer.disable();
                    if (this.visible) {
                        this.updateCursorImmediately();
                    }
                }
            }
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.ENABLED);
            }
        }
    }

    public boolean isDoubleBuffered() {
        return false;
    }

    public void enableInputMethods(boolean bl2) {
        if (bl2) {
            InputContext inputContext;
            if ((this.eventMask & 0x1000L) != 0L) {
                return;
            }
            if (this.isFocusOwner() && (inputContext = this.getInputContext()) != null) {
                FocusEvent focusEvent = new FocusEvent(this, 1004);
                inputContext.dispatchEvent(focusEvent);
            }
            this.eventMask |= 0x1000L;
        } else {
            InputContext inputContext;
            if (this.areInputMethodsEnabled() && (inputContext = this.getInputContext()) != null) {
                inputContext.endComposition();
                inputContext.removeNotify(this);
            }
            this.eventMask &= 0xFFFFFFFFFFFFEFFFL;
        }
    }

    public void setVisible(boolean bl2) {
        this.show(bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        if (!this.visible) {
            Object object;
            Object object2 = this.getTreeLock();
            synchronized (object2) {
                this.visible = true;
                object = this.peer;
                if (object != null) {
                    object.show();
                    this.createHierarchyEvents(1400, this, this.parent, 4L, Toolkit.enabledOnToolkit(32768L));
                    if (object instanceof LightweightPeer) {
                        this.repaint();
                    }
                    this.updateCursorImmediately();
                }
                if (this.componentListener != null || (this.eventMask & 1L) != 0L || Toolkit.enabledOnToolkit(1L)) {
                    ComponentEvent componentEvent = new ComponentEvent(this, 102);
                    Toolkit.getEventQueue().postEvent(componentEvent);
                }
            }
            object = this.parent;
            if (object != null) {
                ((Container)object).invalidate();
            }
        }
    }

    public void show(boolean bl2) {
        if (bl2) {
            this.show();
        } else {
            this.hide();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide() {
        if (this.visible) {
            Object object;
            Object object2 = this.getTreeLock();
            synchronized (object2) {
                this.visible = false;
                if (this.isFocusOwner()) {
                    this.autoTransferFocus(true);
                }
                if ((object = this.peer) != null) {
                    object.hide();
                    this.createHierarchyEvents(1400, this, this.parent, 4L, Toolkit.enabledOnToolkit(32768L));
                    if (object instanceof LightweightPeer) {
                        this.repaint();
                    }
                    this.updateCursorImmediately();
                }
                if (this.componentListener != null || (this.eventMask & 1L) != 0L || Toolkit.enabledOnToolkit(1L)) {
                    ComponentEvent componentEvent = new ComponentEvent(this, 103);
                    Toolkit.getEventQueue().postEvent(componentEvent);
                }
            }
            object = this.parent;
            if (object != null) {
                ((Container)object).invalidate();
            }
        }
    }

    public Color getForeground() {
        Color color = this.foreground;
        if (color != null) {
            return color;
        }
        Container container = this.parent;
        return container != null ? container.getForeground() : null;
    }

    public void setForeground(Color color) {
        Color color2 = this.foreground;
        ComponentPeer componentPeer = this.peer;
        this.foreground = color;
        if (componentPeer != null && (color = this.getForeground()) != null) {
            componentPeer.setForeground(color);
        }
        this.firePropertyChange("foreground", color2, color);
    }

    public boolean isForegroundSet() {
        return this.foreground != null;
    }

    public Color getBackground() {
        Color color = this.background;
        if (color != null) {
            return color;
        }
        Container container = this.parent;
        return container != null ? container.getBackground() : null;
    }

    public void setBackground(Color color) {
        Color color2 = this.background;
        ComponentPeer componentPeer = this.peer;
        this.background = color;
        if (componentPeer != null && (color = this.getBackground()) != null) {
            componentPeer.setBackground(color);
        }
        this.firePropertyChange("background", color2, color);
    }

    public boolean isBackgroundSet() {
        return this.background != null;
    }

    public Font getFont() {
        return this.getFont_NoClientCode();
    }

    final Font getFont_NoClientCode() {
        Font font = this.font;
        if (font != null) {
            return font;
        }
        Container container = this.parent;
        return container != null ? container.getFont_NoClientCode() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFont(Font font) {
        Font font2;
        Font font3;
        Component component = this;
        synchronized (component) {
            font3 = this.font;
            ComponentPeer componentPeer = this.peer;
            font2 = this.font = font;
            if (componentPeer != null && (font = this.getFont()) != null) {
                componentPeer.setFont(font);
                this.peerFont = font;
            }
        }
        this.firePropertyChange("font", font3, font2);
        if (this.valid) {
            this.invalidate();
        }
    }

    public boolean isFontSet() {
        return this.font != null;
    }

    public Locale getLocale() {
        Locale locale = this.locale;
        if (locale != null) {
            return locale;
        }
        Container container = this.parent;
        if (container == null) {
            throw new IllegalComponentStateException("This component must have a parent in order to determine its locale");
        }
        return container.getLocale();
    }

    public void setLocale(Locale locale) {
        Locale locale2 = this.locale;
        this.locale = locale;
        this.firePropertyChange("locale", locale2, locale);
        if (this.valid) {
            this.invalidate();
        }
    }

    public ColorModel getColorModel() {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null && !(componentPeer instanceof LightweightPeer)) {
            return componentPeer.getColorModel();
        }
        if (GraphicsEnvironment.isHeadless()) {
            return ColorModel.getRGBdefault();
        }
        return this.getToolkit().getColorModel();
    }

    public Point getLocation() {
        return this.location();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getLocationOnScreen() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Point point = this.getLocationOnScreen_NoTreeLock();
            return point;
        }
    }

    final Point getLocationOnScreen_NoTreeLock() {
        if (this.peer != null && this.isShowing()) {
            if (this.peer instanceof LightweightPeer) {
                Container container = this.getNativeContainer();
                Point point = container.peer.getLocationOnScreen();
                Component component = this;
                while (component != container) {
                    point.x += component.x;
                    point.y += component.y;
                    component = component.getParent();
                }
                return point;
            }
            Point point = this.peer.getLocationOnScreen();
            return point;
        }
        throw new IllegalComponentStateException("component must be showing on the screen to determine its location");
    }

    public Point location() {
        return new Point(this.x, this.y);
    }

    public void setLocation(int n2, int n3) {
        this.move(n2, n3);
    }

    public void move(int n2, int n3) {
        this.setBounds(n2, n3, this.width, this.height);
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public Dimension getSize() {
        return this.size();
    }

    public Dimension size() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(int n2, int n3) {
        this.resize(n2, n3);
    }

    public void resize(int n2, int n3) {
        this.setBounds(this.x, this.y, n2, n3);
    }

    public void setSize(Dimension dimension) {
        this.resize(dimension);
    }

    public void resize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public Rectangle getBounds() {
        return this.bounds();
    }

    public Rectangle bounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        this.reshape(n2, n3, n4, n5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reshape(int n2, int n3, int n4, int n5) {
        Object object = this.getTreeLock();
        synchronized (object) {
            boolean bl2 = this.width != n4 || this.height != n5;
            boolean bl3 = this.x != n2 || this.y != n3;
            boolean bl4 = this.peer instanceof LightweightPeer;
            boolean bl5 = false;
            int n6 = this.x;
            int n7 = this.y;
            int n8 = this.width;
            int n9 = this.height;
            this.x = n2;
            this.y = n3;
            this.width = n4;
            this.height = n5;
            if (bl2) {
                this.isPacked = false;
            }
            if (bl2 || bl3) {
                if (this.peer != null) {
                    if (bl4) {
                        this.peer.setBounds(n2, n3, n4, n5);
                    } else {
                        int n10 = n2;
                        int n11 = n3;
                        Container container = this.parent;
                        while (container != null && container.peer instanceof LightweightPeer) {
                            n10 += container.x;
                            n11 += container.y;
                            container = container.parent;
                        }
                        this.peer.setBounds(n10, n11, n4, n5);
                    }
                    if (bl2) {
                        this.invalidate();
                    }
                    if (this.parent != null && this.parent.valid) {
                        this.parent.invalidate();
                    }
                }
                if (bl2) {
                    if (this.componentListener != null || (this.eventMask & 1L) != 0L || Toolkit.enabledOnToolkit(1L)) {
                        ComponentEvent componentEvent = new ComponentEvent(this, 101);
                        Toolkit.getEventQueue().postEvent(componentEvent);
                    } else {
                        this.createChildHierarchyEvents(1402, 0L, Toolkit.enabledOnToolkit(65536L));
                    }
                }
                if (bl3) {
                    if (this.componentListener != null || (this.eventMask & 1L) != 0L || Toolkit.enabledOnToolkit(1L)) {
                        ComponentEvent componentEvent = new ComponentEvent(this, 100);
                        Toolkit.getEventQueue().postEvent(componentEvent);
                    } else {
                        this.createChildHierarchyEvents(1401, 0L, Toolkit.enabledOnToolkit(65536L));
                    }
                }
                if (bl4 && this.visible) {
                    Container container = this.parent;
                    while (container != null && container.isLightweight()) {
                        container = container.parent;
                    }
                    ContainerPeer containerPeer = container != null && container.peer instanceof ContainerPeer ? (ContainerPeer)container.peer : null;
                    boolean bl6 = bl5 = containerPeer != null && container.visible && !containerPeer.isPaintPending();
                }
            }
            if (bl5) {
                this.parent.repaint(n6, n7, n8, n9);
                this.repaint();
            }
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Rectangle getBounds(Rectangle rectangle) {
        if (rectangle == null) {
            return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        rectangle.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return rectangle;
    }

    public Dimension getSize(Dimension dimension) {
        if (dimension == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        dimension.setSize(this.getWidth(), this.getHeight());
        return dimension;
    }

    public Point getLocation(Point point) {
        if (point == null) {
            return new Point(this.getX(), this.getY());
        }
        point.setLocation(this.getX(), this.getY());
        return point;
    }

    public boolean isOpaque() {
        if (this.getPeer() == null) {
            return false;
        }
        return !this.isLightweight();
    }

    public boolean isLightweight() {
        return this.getPeer() instanceof LightweightPeer;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredSize() {
        Dimension dimension = this.prefSize;
        if (dimension != null && this.isValid()) {
            return dimension;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension dimension2 = this.prefSize = this.peer != null ? this.peer.preferredSize() : this.getMinimumSize();
            return dimension2;
        }
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumSize() {
        Dimension dimension = this.minSize;
        if (dimension != null && this.isValid()) {
            return dimension;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension dimension2 = this.minSize = this.peer != null ? this.peer.minimumSize() : this.size();
            return dimension2;
        }
    }

    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public float getAlignmentX() {
        return 0.5f;
    }

    public float getAlignmentY() {
        return 0.5f;
    }

    public void doLayout() {
        this.layout();
    }

    public void layout() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        if (!this.valid) {
            Object object = this.getTreeLock();
            synchronized (object) {
                Font font;
                Font font2;
                ComponentPeer componentPeer = this.peer;
                if (!(this.valid || componentPeer == null || (font2 = this.getFont()) == (font = this.peerFont) || font != null && font.equals(font2))) {
                    componentPeer.setFont(font2);
                    this.peerFont = font2;
                }
            }
            this.valid = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.valid = false;
            this.prefSize = null;
            this.minSize = null;
            if (this.parent != null && this.parent.valid) {
                this.parent.invalidate();
            }
        }
    }

    public Graphics getGraphics() {
        if (this.peer instanceof LightweightPeer) {
            if (this.parent == null) {
                return null;
            }
            Graphics graphics = this.parent.getGraphics();
            if (graphics == null) {
                return null;
            }
            if (graphics instanceof ConstrainableGraphics) {
                ((ConstrainableGraphics)((Object)graphics)).constrain(this.x, this.y, this.width, this.height);
            } else {
                graphics.translate(this.x, this.y);
                graphics.setClip(0, 0, this.width, this.height);
            }
            graphics.setFont(this.getFont());
            return graphics;
        }
        ComponentPeer componentPeer = this.peer;
        return componentPeer != null ? componentPeer.getGraphics() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontMetrics getFontMetrics(Font font) {
        Graphics graphics;
        FontMetrics fontMetrics = (FontMetrics)metrics.get(font);
        if (fontMetrics != null) {
            return fontMetrics;
        }
        if (NativeFontWrapper.usePlatformFontMetrics() && this.peer != null && !(this.peer instanceof LightweightPeer)) {
            fontMetrics = this.peer.getFontMetrics(font);
            metrics.put(font, fontMetrics);
            return fontMetrics;
        }
        if (this.parent != null && (graphics = this.parent.getGraphics()) != null) {
            try {
                fontMetrics = graphics.getFontMetrics(font);
                metrics.put(font, fontMetrics);
                FontMetrics fontMetrics2 = fontMetrics;
                Object var6_5 = null;
                graphics.dispose();
                return fontMetrics2;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                graphics.dispose();
                throw throwable;
            }
        }
        fontMetrics = this.getToolkit().getFontMetrics(font);
        metrics.put(font, fontMetrics);
        return fontMetrics;
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
        this.updateCursorImmediately();
    }

    final void updateCursorImmediately() {
        if (this.peer instanceof LightweightPeer) {
            Container container = this.getNativeContainer();
            if (container == null) {
                return;
            }
            ComponentPeer componentPeer = container.getPeer();
            if (componentPeer != null) {
                componentPeer.updateCursorImmediately();
            }
        } else if (this.peer != null) {
            this.peer.updateCursorImmediately();
        }
    }

    public Cursor getCursor() {
        Cursor cursor = this.cursor;
        if (cursor != null) {
            return cursor;
        }
        Container container = this.parent;
        if (container != null) {
            return container.getCursor();
        }
        return Cursor.getPredefinedCursor(0);
    }

    public boolean isCursorSet() {
        return this.cursor != null;
    }

    public void paint(Graphics graphics) {
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paintAll(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PeerPaintCallback.getInstance().runOneComponent(this, new Rectangle(0, 0, this.width, this.height), graphics, graphics.getClip(), 3);
        }
    }

    void lightweightPaint(Graphics graphics) {
        this.paint(graphics);
    }

    void paintHeavyweightComponents(Graphics graphics) {
    }

    public void repaint() {
        this.repaint(0L, 0, 0, this.width, this.height);
    }

    public void repaint(long l2) {
        this.repaint(l2, 0, 0, this.width, this.height);
    }

    public void repaint(int n2, int n3, int n4, int n5) {
        this.repaint(0L, n2, n3, n4, n5);
    }

    public void repaint(long l2, int n2, int n3, int n4, int n5) {
        if (this.peer instanceof LightweightPeer) {
            if (this.parent != null) {
                int n6 = this.x + (n2 < 0 ? 0 : n2);
                int n7 = this.y + (n3 < 0 ? 0 : n3);
                int n8 = n4 > this.width ? this.width : n4;
                int n9 = n5 > this.height ? this.height : n5;
                this.parent.repaint(l2, n6, n7, n8, n9);
            }
        } else if (this.isVisible() && this.peer != null && n4 > 0 && n5 > 0) {
            PaintEvent paintEvent = new PaintEvent(this, 801, new Rectangle(n2, n3, n4, n5));
            Toolkit.getEventQueue().postEvent(paintEvent);
        }
    }

    public void print(Graphics graphics) {
        this.paint(graphics);
    }

    public void printAll(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PeerPrintCallback.getInstance().runOneComponent(this, new Rectangle(0, 0, this.width, this.height), graphics, graphics.getClip(), 3);
        }
    }

    void lightweightPrint(Graphics graphics) {
        this.print(graphics);
    }

    void printHeavyweightComponents(Graphics graphics) {
    }

    public boolean imageUpdate(Image image, int n2, int n3, int n4, int n5, int n6) {
        int n7 = -1;
        if ((n2 & 0x30) != 0) {
            n7 = 0;
        } else if ((n2 & 8) != 0 && isInc && (n7 = incRate) < 0) {
            n7 = 0;
        }
        if (n7 >= 0) {
            this.repaint(n7, 0, 0, this.width, this.height);
        }
        return (n2 & 0xA0) == 0;
    }

    public Image createImage(ImageProducer imageProducer) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null && !(componentPeer instanceof LightweightPeer)) {
            return componentPeer.createImage(imageProducer);
        }
        return this.getToolkit().createImage(imageProducer);
    }

    public Image createImage(int n2, int n3) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer instanceof LightweightPeer) {
            if (this.parent != null) {
                return this.parent.createImage(n2, n3);
            }
            return null;
        }
        return componentPeer != null ? componentPeer.createImage(n2, n3) : null;
    }

    public VolatileImage createVolatileImage(int n2, int n3) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer instanceof LightweightPeer) {
            if (this.parent != null) {
                return this.parent.createVolatileImage(n2, n3);
            }
            return null;
        }
        return componentPeer != null ? componentPeer.createVolatileImage(n2, n3) : null;
    }

    public VolatileImage createVolatileImage(int n2, int n3, ImageCapabilities imageCapabilities) throws AWTException {
        return this.createVolatileImage(n2, n3);
    }

    public boolean prepareImage(Image image, ImageObserver imageObserver) {
        return this.prepareImage(image, -1, -1, imageObserver);
    }

    public boolean prepareImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer instanceof LightweightPeer) {
            return this.parent != null ? this.parent.prepareImage(image, n2, n3, imageObserver) : this.getToolkit().prepareImage(image, n2, n3, imageObserver);
        }
        return componentPeer != null ? componentPeer.prepareImage(image, n2, n3, imageObserver) : this.getToolkit().prepareImage(image, n2, n3, imageObserver);
    }

    public int checkImage(Image image, ImageObserver imageObserver) {
        return this.checkImage(image, -1, -1, imageObserver);
    }

    public int checkImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer instanceof LightweightPeer) {
            return this.parent != null ? this.parent.checkImage(image, n2, n3, imageObserver) : this.getToolkit().checkImage(image, n2, n3, imageObserver);
        }
        return componentPeer != null ? componentPeer.checkImage(image, n2, n3, imageObserver) : this.getToolkit().checkImage(image, n2, n3, imageObserver);
    }

    void createBufferStrategy(int n2) {
        BufferCapabilities bufferCapabilities;
        if (n2 > 1) {
            bufferCapabilities = new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), BufferCapabilities.FlipContents.UNDEFINED);
            try {
                this.createBufferStrategy(n2, bufferCapabilities);
                return;
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
        }
        bufferCapabilities = new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), null);
        try {
            this.createBufferStrategy(n2, bufferCapabilities);
            return;
        }
        catch (AWTException aWTException) {
            bufferCapabilities = new BufferCapabilities(new ImageCapabilities(false), new ImageCapabilities(false), null);
            try {
                this.createBufferStrategy(n2, bufferCapabilities);
                return;
            }
            catch (AWTException aWTException2) {
                throw new InternalError("Could not create a buffer strategy");
            }
        }
    }

    void createBufferStrategy(int n2, BufferCapabilities bufferCapabilities) throws AWTException {
        if (n2 < 1) {
            throw new IllegalArgumentException("Number of buffers must be at least 1");
        }
        if (bufferCapabilities == null) {
            throw new IllegalArgumentException("No capabilities specified");
        }
        if (this.bufferStrategy instanceof FlipBufferStrategy) {
            ((FlipBufferStrategy)this.bufferStrategy).destroyBuffers();
        }
        this.bufferStrategy = n2 == 1 ? new SingleBufferStrategy(bufferCapabilities) : (bufferCapabilities.isPageFlipping() ? new FlipBufferStrategy(n2, bufferCapabilities) : new BltBufferStrategy(n2, bufferCapabilities));
    }

    BufferStrategy getBufferStrategy() {
        if (this.bufferStrategy == null) {
            this.createBufferStrategy(1);
        }
        return this.bufferStrategy;
    }

    public void setIgnoreRepaint(boolean bl2) {
        this.ignoreRepaint = bl2;
    }

    public boolean getIgnoreRepaint() {
        return this.ignoreRepaint;
    }

    public boolean contains(int n2, int n3) {
        return this.inside(n2, n3);
    }

    public boolean inside(int n2, int n3) {
        return n2 >= 0 && n2 < this.width && n3 >= 0 && n3 < this.height;
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public Component getComponentAt(int n2, int n3) {
        return this.locate(n2, n3);
    }

    public Component locate(int n2, int n3) {
        return this.contains(n2, n3) ? this : null;
    }

    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    public void deliverEvent(Event event) {
        this.postEvent(event);
    }

    public final void dispatchEvent(AWTEvent aWTEvent) {
        this.dispatchEventImpl(aWTEvent);
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        ComponentPeer componentPeer;
        Serializable serializable;
        Object object;
        Object object2;
        int n2 = aWTEvent.getID();
        EventQueue.setCurrentEventAndMostRecentTime(aWTEvent);
        if (aWTEvent instanceof SunDropTargetEvent) {
            ((SunDropTargetEvent)aWTEvent).dispatch();
            return;
        }
        if (!aWTEvent.focusManagerIsDispatching) {
            aWTEvent = KeyboardFocusManager.retargetFocusEvent(aWTEvent);
            if (KeyboardFocusManager.getCurrentKeyboardFocusManager().dispatchEvent(aWTEvent)) {
                return;
            }
        }
        if (aWTEvent instanceof KeyEvent && KeyboardFocusManager.isProxyActive((KeyEvent)(object2 = (KeyEvent)aWTEvent))) {
            ComponentPeer componentPeer2;
            Container container = this.getNativeContainer();
            if (container != null && (componentPeer2 = container.getPeer()) != null) {
                componentPeer2.handleEvent(aWTEvent);
            }
            return;
        }
        if (n2 == 507 && !this.eventTypeEnabled(n2) && this.peer != null && !this.peer.handlesWheelScrolling() && this.dispatchMouseWheelToAncestor((MouseWheelEvent)aWTEvent)) {
            return;
        }
        object2 = Toolkit.getDefaultToolkit();
        ((Toolkit)object2).notifyAWTEventListeners(aWTEvent);
        if (!aWTEvent.isConsumed() && aWTEvent instanceof KeyEvent) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().processKeyEvent(this, (KeyEvent)aWTEvent);
            if (aWTEvent.isConsumed()) {
                return;
            }
        }
        if (this.areInputMethodsEnabled() && (aWTEvent instanceof InputMethodEvent && !(this instanceof CompositionArea) || aWTEvent instanceof InputEvent || aWTEvent instanceof FocusEvent) && (object = this.getInputContext()) != null) {
            ((InputContext)object).dispatchEvent(aWTEvent);
            if (aWTEvent.isConsumed()) {
                return;
            }
        }
        switch (n2) {
            case 401: 
            case 402: {
                object = (Container)(this instanceof Container ? this : this.parent);
                if (object == null) break;
                ((Container)object).preProcessKeyEvent((KeyEvent)aWTEvent);
                if (!aWTEvent.isConsumed()) break;
                return;
            }
            case 201: {
                if (!(object2 instanceof WindowClosingListener)) break;
                this.windowClosingException = ((WindowClosingListener)object2).windowClosingNotify((WindowEvent)aWTEvent);
                if (!this.checkWindowClosingException()) break;
                return;
            }
        }
        if (this.newEventsOnly) {
            if (this.eventEnabled(aWTEvent)) {
                this.processEvent(aWTEvent);
            }
        } else if (n2 == 507) {
            this.autoProcessMouseWheel((MouseWheelEvent)aWTEvent);
        } else if ((!(aWTEvent instanceof MouseEvent) || this.postsOldMouseEvents()) && (serializable = aWTEvent.convertToOld()) != null) {
            int n3 = ((Event)serializable).key;
            int n4 = ((Event)serializable).modifiers;
            this.postEvent((Event)serializable);
            if (((Event)serializable).isConsumed()) {
                aWTEvent.consume();
            }
            switch (((Event)serializable).id) {
                case 401: 
                case 402: 
                case 403: 
                case 404: {
                    if (((Event)serializable).key != n3) {
                        ((KeyEvent)aWTEvent).setKeyChar(((Event)serializable).getKeyEventChar());
                    }
                    if (((Event)serializable).modifiers == n4) break;
                    ((KeyEvent)aWTEvent).setModifiers(((Event)serializable).modifiers);
                    break;
                }
            }
        }
        if (n2 == 201 && !aWTEvent.isConsumed() && object2 instanceof WindowClosingListener) {
            this.windowClosingException = ((WindowClosingListener)object2).windowClosingDelivered((WindowEvent)aWTEvent);
            if (this.checkWindowClosingException()) {
                return;
            }
        }
        if (this.peer != null) {
            this.peer.handleEvent(aWTEvent);
        }
        if (aWTEvent instanceof KeyEvent && (this.peer == null || this.peer instanceof LightweightPeer) && (serializable = this.getNativeContainer()) != null && (componentPeer = ((Component)serializable).getPeer()) != null) {
            componentPeer.handleEvent(aWTEvent);
        }
    }

    void autoProcessMouseWheel(MouseWheelEvent mouseWheelEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean dispatchMouseWheelToAncestor(MouseWheelEvent mouseWheelEvent) {
        int n2 = mouseWheelEvent.getX() + this.getX();
        int n3 = mouseWheelEvent.getY() + this.getY();
        Object object = this.getTreeLock();
        synchronized (object) {
            Container container = this.getParent();
            while (container != null && !container.eventEnabled(mouseWheelEvent)) {
                n2 += container.getX();
                n3 += container.getY();
                if (container instanceof Window) break;
                container = container.getParent();
            }
            if (container != null && container.eventEnabled(mouseWheelEvent)) {
                MouseWheelEvent mouseWheelEvent2 = new MouseWheelEvent(container, mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiers(), n2, n3, mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
                mouseWheelEvent.copyPrivateDataInto(mouseWheelEvent2);
                container.dispatchEventImpl(mouseWheelEvent2);
            }
        }
        return true;
    }

    boolean checkWindowClosingException() {
        if (this.windowClosingException != null) {
            if (this instanceof Dialog) {
                ((Dialog)this).interruptBlocking();
            } else {
                this.windowClosingException.fillInStackTrace();
                this.windowClosingException.printStackTrace();
                this.windowClosingException = null;
            }
            return true;
        }
        return false;
    }

    boolean areInputMethodsEnabled() {
        return (this.eventMask & 0x1000L) != 0L && ((this.eventMask & 8L) != 0L || this.keyListener != null);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        return this.eventTypeEnabled(aWTEvent.id);
    }

    boolean eventTypeEnabled(int n2) {
        switch (n2) {
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                if ((this.eventMask & 1L) == 0L && this.componentListener == null) break;
                return true;
            }
            case 1004: 
            case 1005: {
                if ((this.eventMask & 4L) == 0L && this.focusListener == null) break;
                return true;
            }
            case 400: 
            case 401: 
            case 402: {
                if ((this.eventMask & 8L) == 0L && this.keyListener == null) break;
                return true;
            }
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 505: {
                if ((this.eventMask & 0x10L) == 0L && this.mouseListener == null) break;
                return true;
            }
            case 503: 
            case 506: {
                if ((this.eventMask & 0x20L) == 0L && this.mouseMotionListener == null) break;
                return true;
            }
            case 507: {
                if ((this.eventMask & 0x20000L) == 0L && this.mouseWheelListener == null) break;
                return true;
            }
            case 1100: 
            case 1101: {
                if ((this.eventMask & 0x800L) == 0L && this.inputMethodListener == null) break;
                return true;
            }
            case 1400: {
                if ((this.eventMask & 0x8000L) == 0L && this.hierarchyListener == null) break;
                return true;
            }
            case 1401: 
            case 1402: {
                if ((this.eventMask & 0x10000L) == 0L && this.hierarchyBoundsListener == null) break;
                return true;
            }
            case 1001: {
                if ((this.eventMask & 0x80L) == 0L) break;
                return true;
            }
            case 900: {
                if ((this.eventMask & 0x400L) == 0L) break;
                return true;
            }
            case 701: {
                if ((this.eventMask & 0x200L) == 0L) break;
                return true;
            }
            case 601: {
                if ((this.eventMask & 0x100L) == 0L) break;
                return true;
            }
        }
        return n2 > 1999;
    }

    public boolean postEvent(Event event) {
        ComponentPeer componentPeer = this.peer;
        if (this.handleEvent(event)) {
            event.consume();
            return true;
        }
        Container container = this.parent;
        int n2 = event.x;
        int n3 = event.y;
        if (container != null) {
            event.translate(this.x, this.y);
            if (container.postEvent(event)) {
                event.consume();
                return true;
            }
            event.x = n2;
            event.y = n3;
        }
        return false;
    }

    public synchronized void addComponentListener(ComponentListener componentListener) {
        if (componentListener == null) {
            return;
        }
        this.componentListener = AWTEventMulticaster.add(this.componentListener, componentListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeComponentListener(ComponentListener componentListener) {
        if (componentListener == null) {
            return;
        }
        this.componentListener = AWTEventMulticaster.remove(this.componentListener, componentListener);
    }

    public synchronized ComponentListener[] getComponentListeners() {
        return (ComponentListener[])this.getListeners(class$java$awt$event$ComponentListener == null ? (class$java$awt$event$ComponentListener = Component.class$("java.awt.event.ComponentListener")) : class$java$awt$event$ComponentListener);
    }

    public synchronized void addFocusListener(FocusListener focusListener) {
        if (focusListener == null) {
            return;
        }
        this.focusListener = AWTEventMulticaster.add(this.focusListener, focusListener);
        this.newEventsOnly = true;
        if (this.peer instanceof LightweightPeer) {
            this.parent.proxyEnableEvents(4L);
        }
    }

    public synchronized void removeFocusListener(FocusListener focusListener) {
        if (focusListener == null) {
            return;
        }
        this.focusListener = AWTEventMulticaster.remove(this.focusListener, focusListener);
    }

    public synchronized FocusListener[] getFocusListeners() {
        return (FocusListener[])this.getListeners(class$java$awt$event$FocusListener == null ? (class$java$awt$event$FocusListener = Component.class$("java.awt.event.FocusListener")) : class$java$awt$event$FocusListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHierarchyListener(HierarchyListener hierarchyListener) {
        boolean bl2;
        if (hierarchyListener == null) {
            return;
        }
        Component component = this;
        synchronized (component) {
            bl2 = this.hierarchyListener == null && (this.eventMask & 0x8000L) == 0L;
            this.hierarchyListener = AWTEventMulticaster.add(this.hierarchyListener, hierarchyListener);
            bl2 = bl2 && this.hierarchyListener != null;
            this.newEventsOnly = true;
        }
        if (bl2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.adjustListeningChildrenOnParent(32768L, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHierarchyListener(HierarchyListener hierarchyListener) {
        boolean bl2;
        if (hierarchyListener == null) {
            return;
        }
        Component component = this;
        synchronized (component) {
            bl2 = this.hierarchyListener != null && (this.eventMask & 0x8000L) == 0L;
            this.hierarchyListener = AWTEventMulticaster.remove(this.hierarchyListener, hierarchyListener);
            bl2 = bl2 && this.hierarchyListener == null;
        }
        if (bl2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.adjustListeningChildrenOnParent(32768L, -1);
            }
        }
    }

    public synchronized HierarchyListener[] getHierarchyListeners() {
        return (HierarchyListener[])this.getListeners(class$java$awt$event$HierarchyListener == null ? (class$java$awt$event$HierarchyListener = Component.class$("java.awt.event.HierarchyListener")) : class$java$awt$event$HierarchyListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHierarchyBoundsListener(HierarchyBoundsListener hierarchyBoundsListener) {
        boolean bl2;
        if (hierarchyBoundsListener == null) {
            return;
        }
        Component component = this;
        synchronized (component) {
            bl2 = this.hierarchyBoundsListener == null && (this.eventMask & 0x10000L) == 0L;
            this.hierarchyBoundsListener = AWTEventMulticaster.add(this.hierarchyBoundsListener, hierarchyBoundsListener);
            bl2 = bl2 && this.hierarchyBoundsListener != null;
            this.newEventsOnly = true;
        }
        if (bl2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.adjustListeningChildrenOnParent(65536L, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHierarchyBoundsListener(HierarchyBoundsListener hierarchyBoundsListener) {
        boolean bl2;
        if (hierarchyBoundsListener == null) {
            return;
        }
        Component component = this;
        synchronized (component) {
            bl2 = this.hierarchyBoundsListener != null && (this.eventMask & 0x10000L) == 0L;
            this.hierarchyBoundsListener = AWTEventMulticaster.remove(this.hierarchyBoundsListener, hierarchyBoundsListener);
            bl2 = bl2 && this.hierarchyBoundsListener == null;
        }
        if (bl2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.adjustListeningChildrenOnParent(65536L, -1);
            }
        }
    }

    int numListening(long l2) {
        if (l2 == 32768L && (this.hierarchyListener != null || (this.eventMask & 0x8000L) != 0L) || l2 == 65536L && (this.hierarchyBoundsListener != null || (this.eventMask & 0x10000L) != 0L)) {
            return 1;
        }
        return 0;
    }

    int countHierarchyMembers() {
        return 1;
    }

    int createHierarchyEvents(int n2, Component component, Container container, long l2, boolean bl2) {
        switch (n2) {
            case 1400: {
                if (this.hierarchyListener == null && (this.eventMask & 0x8000L) == 0L && !bl2) break;
                HierarchyEvent hierarchyEvent = new HierarchyEvent(this, n2, component, container, l2);
                this.dispatchEvent(hierarchyEvent);
                return 1;
            }
            case 1401: 
            case 1402: {
                if (this.hierarchyBoundsListener == null && (this.eventMask & 0x10000L) == 0L && !bl2) break;
                HierarchyEvent hierarchyEvent = new HierarchyEvent(this, n2, component, container);
                this.dispatchEvent(hierarchyEvent);
                return 1;
            }
        }
        return 0;
    }

    public synchronized HierarchyBoundsListener[] getHierarchyBoundsListeners() {
        return (HierarchyBoundsListener[])this.getListeners(class$java$awt$event$HierarchyBoundsListener == null ? (class$java$awt$event$HierarchyBoundsListener = Component.class$("java.awt.event.HierarchyBoundsListener")) : class$java$awt$event$HierarchyBoundsListener);
    }

    void createChildHierarchyEvents(int n2, long l2, boolean bl2) {
    }

    void adjustListeningChildrenOnParent(long l2, int n2) {
        if (this.parent != null) {
            this.parent.adjustListeningChildren(l2, n2);
        }
    }

    public synchronized void addKeyListener(KeyListener keyListener) {
        if (keyListener == null) {
            return;
        }
        this.keyListener = AWTEventMulticaster.add(this.keyListener, keyListener);
        this.newEventsOnly = true;
        if (this.peer instanceof LightweightPeer) {
            this.parent.proxyEnableEvents(8L);
        }
    }

    public synchronized void removeKeyListener(KeyListener keyListener) {
        if (keyListener == null) {
            return;
        }
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, keyListener);
    }

    public synchronized KeyListener[] getKeyListeners() {
        return (KeyListener[])this.getListeners(class$java$awt$event$KeyListener == null ? (class$java$awt$event$KeyListener = Component.class$("java.awt.event.KeyListener")) : class$java$awt$event$KeyListener);
    }

    public synchronized void addMouseListener(MouseListener mouseListener) {
        if (mouseListener == null) {
            return;
        }
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, mouseListener);
        this.newEventsOnly = true;
        if (this.peer instanceof LightweightPeer) {
            this.parent.proxyEnableEvents(16L);
        }
    }

    public synchronized void removeMouseListener(MouseListener mouseListener) {
        if (mouseListener == null) {
            return;
        }
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, mouseListener);
    }

    public synchronized MouseListener[] getMouseListeners() {
        return (MouseListener[])this.getListeners(class$java$awt$event$MouseListener == null ? (class$java$awt$event$MouseListener = Component.class$("java.awt.event.MouseListener")) : class$java$awt$event$MouseListener);
    }

    public synchronized void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (mouseMotionListener == null) {
            return;
        }
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, mouseMotionListener);
        this.newEventsOnly = true;
        if (this.peer instanceof LightweightPeer) {
            this.parent.proxyEnableEvents(32L);
        }
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (mouseMotionListener == null) {
            return;
        }
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, mouseMotionListener);
    }

    public synchronized MouseMotionListener[] getMouseMotionListeners() {
        return (MouseMotionListener[])this.getListeners(class$java$awt$event$MouseMotionListener == null ? (class$java$awt$event$MouseMotionListener = Component.class$("java.awt.event.MouseMotionListener")) : class$java$awt$event$MouseMotionListener);
    }

    public synchronized void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        if (mouseWheelListener == null) {
            return;
        }
        this.mouseWheelListener = AWTEventMulticaster.add(this.mouseWheelListener, mouseWheelListener);
        this.newEventsOnly = true;
        dbg.println("Component.addMouseWheelListener(): newEventsOnly = " + this.newEventsOnly);
        if (this.peer instanceof LightweightPeer) {
            this.parent.proxyEnableEvents(131072L);
        }
    }

    public synchronized void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        if (mouseWheelListener == null) {
            return;
        }
        this.mouseWheelListener = AWTEventMulticaster.remove(this.mouseWheelListener, mouseWheelListener);
    }

    public synchronized MouseWheelListener[] getMouseWheelListeners() {
        return (MouseWheelListener[])this.getListeners(class$java$awt$event$MouseWheelListener == null ? (class$java$awt$event$MouseWheelListener = Component.class$("java.awt.event.MouseWheelListener")) : class$java$awt$event$MouseWheelListener);
    }

    public synchronized void addInputMethodListener(InputMethodListener inputMethodListener) {
        if (inputMethodListener == null) {
            return;
        }
        this.inputMethodListener = AWTEventMulticaster.add(this.inputMethodListener, inputMethodListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeInputMethodListener(InputMethodListener inputMethodListener) {
        if (inputMethodListener == null) {
            return;
        }
        this.inputMethodListener = AWTEventMulticaster.remove(this.inputMethodListener, inputMethodListener);
    }

    public synchronized InputMethodListener[] getInputMethodListeners() {
        return (InputMethodListener[])this.getListeners(class$java$awt$event$InputMethodListener == null ? (class$java$awt$event$InputMethodListener = Component.class$("java.awt.event.InputMethodListener")) : class$java$awt$event$InputMethodListener);
    }

    public EventListener[] getListeners(Class clazz) {
        EventListener eventListener = null;
        if (clazz == (class$java$awt$event$ComponentListener == null ? (class$java$awt$event$ComponentListener = Component.class$("java.awt.event.ComponentListener")) : class$java$awt$event$ComponentListener)) {
            eventListener = this.componentListener;
        } else if (clazz == (class$java$awt$event$FocusListener == null ? (class$java$awt$event$FocusListener = Component.class$("java.awt.event.FocusListener")) : class$java$awt$event$FocusListener)) {
            eventListener = this.focusListener;
        } else if (clazz == (class$java$awt$event$HierarchyListener == null ? (class$java$awt$event$HierarchyListener = Component.class$("java.awt.event.HierarchyListener")) : class$java$awt$event$HierarchyListener)) {
            eventListener = this.hierarchyListener;
        } else if (clazz == (class$java$awt$event$HierarchyBoundsListener == null ? (class$java$awt$event$HierarchyBoundsListener = Component.class$("java.awt.event.HierarchyBoundsListener")) : class$java$awt$event$HierarchyBoundsListener)) {
            eventListener = this.hierarchyBoundsListener;
        } else if (clazz == (class$java$awt$event$KeyListener == null ? (class$java$awt$event$KeyListener = Component.class$("java.awt.event.KeyListener")) : class$java$awt$event$KeyListener)) {
            eventListener = this.keyListener;
        } else if (clazz == (class$java$awt$event$MouseListener == null ? (class$java$awt$event$MouseListener = Component.class$("java.awt.event.MouseListener")) : class$java$awt$event$MouseListener)) {
            eventListener = this.mouseListener;
        } else if (clazz == (class$java$awt$event$MouseMotionListener == null ? (class$java$awt$event$MouseMotionListener = Component.class$("java.awt.event.MouseMotionListener")) : class$java$awt$event$MouseMotionListener)) {
            eventListener = this.mouseMotionListener;
        } else if (clazz == (class$java$awt$event$MouseWheelListener == null ? (class$java$awt$event$MouseWheelListener = Component.class$("java.awt.event.MouseWheelListener")) : class$java$awt$event$MouseWheelListener)) {
            eventListener = this.mouseWheelListener;
        } else if (clazz == (class$java$awt$event$InputMethodListener == null ? (class$java$awt$event$InputMethodListener = Component.class$("java.awt.event.InputMethodListener")) : class$java$awt$event$InputMethodListener)) {
            eventListener = this.inputMethodListener;
        } else if (clazz == (class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = Component.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener)) {
            return this.getPropertyChangeListeners();
        }
        return AWTEventMulticaster.getListeners(eventListener, clazz);
    }

    public InputMethodRequests getInputMethodRequests() {
        return null;
    }

    public InputContext getInputContext() {
        Container container = this.parent;
        if (container == null) {
            return null;
        }
        return container.getInputContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void enableEvents(long l2) {
        long l3 = 0L;
        Component component = this;
        synchronized (component) {
            if ((l2 & 0x8000L) != 0L && this.hierarchyListener == null && (this.eventMask & 0x8000L) == 0L) {
                l3 |= 0x8000L;
            }
            if ((l2 & 0x10000L) != 0L && this.hierarchyBoundsListener == null && (this.eventMask & 0x10000L) == 0L) {
                l3 |= 0x10000L;
            }
            this.eventMask |= l2;
            this.newEventsOnly = true;
        }
        if (this.peer instanceof LightweightPeer) {
            this.parent.proxyEnableEvents(this.eventMask);
        }
        if (l3 != 0L) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.adjustListeningChildrenOnParent(l3, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void disableEvents(long l2) {
        long l3 = 0L;
        Component component = this;
        synchronized (component) {
            if ((l2 & 0x8000L) != 0L && this.hierarchyListener == null && (this.eventMask & 0x8000L) != 0L) {
                l3 |= 0x8000L;
            }
            if ((l2 & 0x10000L) != 0L && this.hierarchyBoundsListener == null && (this.eventMask & 0x10000L) != 0L) {
                l3 |= 0x10000L;
            }
            this.eventMask &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (l3 != 0L) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.adjustListeningChildrenOnParent(l3, -1);
            }
        }
    }

    protected AWTEvent coalesceEvents(AWTEvent aWTEvent, AWTEvent aWTEvent2) {
        int n2 = aWTEvent.getID();
        switch (n2) {
            case 503: 
            case 506: {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                if (mouseEvent.getModifiers() != ((MouseEvent)aWTEvent2).getModifiers()) break;
                return aWTEvent2;
            }
            case 800: 
            case 801: {
                Rectangle rectangle;
                if (this.peer != null && !(this.peer instanceof LightweightPeer)) {
                    return aWTEvent2;
                }
                PaintEvent paintEvent = (PaintEvent)aWTEvent;
                PaintEvent paintEvent2 = (PaintEvent)aWTEvent2;
                Rectangle rectangle2 = paintEvent.getUpdateRect();
                if (rectangle2.contains(rectangle = paintEvent2.getUpdateRect())) {
                    return aWTEvent;
                }
                if (!rectangle.contains(rectangle2)) break;
                return aWTEvent2;
            }
        }
        return null;
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)aWTEvent);
        } else if (aWTEvent instanceof MouseEvent) {
            switch (aWTEvent.getID()) {
                case 500: 
                case 501: 
                case 502: 
                case 504: 
                case 505: {
                    this.processMouseEvent((MouseEvent)aWTEvent);
                    break;
                }
                case 503: 
                case 506: {
                    this.processMouseMotionEvent((MouseEvent)aWTEvent);
                    break;
                }
                case 507: {
                    this.processMouseWheelEvent((MouseWheelEvent)aWTEvent);
                }
            }
        } else if (aWTEvent instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)aWTEvent);
        } else if (aWTEvent instanceof ComponentEvent) {
            this.processComponentEvent((ComponentEvent)aWTEvent);
        } else if (aWTEvent instanceof InputMethodEvent) {
            this.processInputMethodEvent((InputMethodEvent)aWTEvent);
        } else if (aWTEvent instanceof HierarchyEvent) {
            switch (aWTEvent.getID()) {
                case 1400: {
                    this.processHierarchyEvent((HierarchyEvent)aWTEvent);
                    break;
                }
                case 1401: 
                case 1402: {
                    this.processHierarchyBoundsEvent((HierarchyEvent)aWTEvent);
                }
            }
        }
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        ComponentListener componentListener = this.componentListener;
        if (componentListener != null) {
            int n2 = componentEvent.getID();
            switch (n2) {
                case 101: {
                    componentListener.componentResized(componentEvent);
                    break;
                }
                case 100: {
                    componentListener.componentMoved(componentEvent);
                    break;
                }
                case 102: {
                    componentListener.componentShown(componentEvent);
                    break;
                }
                case 103: {
                    componentListener.componentHidden(componentEvent);
                }
            }
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        FocusListener focusListener = this.focusListener;
        if (focusListener != null) {
            int n2 = focusEvent.getID();
            switch (n2) {
                case 1004: {
                    focusListener.focusGained(focusEvent);
                    break;
                }
                case 1005: {
                    focusListener.focusLost(focusEvent);
                }
            }
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        KeyListener keyListener = this.keyListener;
        if (keyListener != null) {
            int n2 = keyEvent.getID();
            switch (n2) {
                case 400: {
                    keyListener.keyTyped(keyEvent);
                    break;
                }
                case 401: {
                    keyListener.keyPressed(keyEvent);
                    break;
                }
                case 402: {
                    keyListener.keyReleased(keyEvent);
                }
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        MouseListener mouseListener = this.mouseListener;
        if (mouseListener != null) {
            int n2 = mouseEvent.getID();
            switch (n2) {
                case 501: {
                    mouseListener.mousePressed(mouseEvent);
                    break;
                }
                case 502: {
                    mouseListener.mouseReleased(mouseEvent);
                    break;
                }
                case 500: {
                    mouseListener.mouseClicked(mouseEvent);
                    break;
                }
                case 505: {
                    mouseListener.mouseExited(mouseEvent);
                    break;
                }
                case 504: {
                    mouseListener.mouseEntered(mouseEvent);
                }
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        MouseMotionListener mouseMotionListener = this.mouseMotionListener;
        if (mouseMotionListener != null) {
            int n2 = mouseEvent.getID();
            switch (n2) {
                case 503: {
                    mouseMotionListener.mouseMoved(mouseEvent);
                    break;
                }
                case 506: {
                    mouseMotionListener.mouseDragged(mouseEvent);
                }
            }
        }
    }

    protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        MouseWheelListener mouseWheelListener = this.mouseWheelListener;
        if (mouseWheelListener != null) {
            int n2 = mouseWheelEvent.getID();
            switch (n2) {
                case 507: {
                    mouseWheelListener.mouseWheelMoved(mouseWheelEvent);
                }
            }
        }
    }

    boolean postsOldMouseEvents() {
        return false;
    }

    protected void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        InputMethodListener inputMethodListener = this.inputMethodListener;
        if (inputMethodListener != null) {
            int n2 = inputMethodEvent.getID();
            switch (n2) {
                case 1100: {
                    inputMethodListener.inputMethodTextChanged(inputMethodEvent);
                    break;
                }
                case 1101: {
                    inputMethodListener.caretPositionChanged(inputMethodEvent);
                }
            }
        }
    }

    protected void processHierarchyEvent(HierarchyEvent hierarchyEvent) {
        HierarchyListener hierarchyListener = this.hierarchyListener;
        if (hierarchyListener != null) {
            int n2 = hierarchyEvent.getID();
            switch (n2) {
                case 1400: {
                    hierarchyListener.hierarchyChanged(hierarchyEvent);
                }
            }
        }
    }

    protected void processHierarchyBoundsEvent(HierarchyEvent hierarchyEvent) {
        HierarchyBoundsListener hierarchyBoundsListener = this.hierarchyBoundsListener;
        if (hierarchyBoundsListener != null) {
            int n2 = hierarchyEvent.getID();
            switch (n2) {
                case 1401: {
                    hierarchyBoundsListener.ancestorMoved(hierarchyEvent);
                    break;
                }
                case 1402: {
                    hierarchyBoundsListener.ancestorResized(hierarchyEvent);
                }
            }
        }
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 504: {
                return this.mouseEnter(event, event.x, event.y);
            }
            case 505: {
                return this.mouseExit(event, event.x, event.y);
            }
            case 503: {
                return this.mouseMove(event, event.x, event.y);
            }
            case 501: {
                return this.mouseDown(event, event.x, event.y);
            }
            case 506: {
                return this.mouseDrag(event, event.x, event.y);
            }
            case 502: {
                return this.mouseUp(event, event.x, event.y);
            }
            case 401: 
            case 403: {
                return this.keyDown(event, event.key);
            }
            case 402: 
            case 404: {
                return this.keyUp(event, event.key);
            }
            case 1001: {
                return this.action(event, event.arg);
            }
            case 1004: {
                return this.gotFocus(event, event.arg);
            }
            case 1005: {
                return this.lostFocus(event, event.arg);
            }
        }
        return false;
    }

    public boolean mouseDown(Event event, int n2, int n3) {
        return false;
    }

    public boolean mouseDrag(Event event, int n2, int n3) {
        return false;
    }

    public boolean mouseUp(Event event, int n2, int n3) {
        return false;
    }

    public boolean mouseMove(Event event, int n2, int n3) {
        return false;
    }

    public boolean mouseEnter(Event event, int n2, int n3) {
        return false;
    }

    public boolean mouseExit(Event event, int n2, int n3) {
        return false;
    }

    public boolean keyDown(Event event, int n2) {
        return false;
    }

    public boolean keyUp(Event event, int n2) {
        return false;
    }

    public boolean action(Event event, Object object) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Serializable serializable;
            ComponentPeer componentPeer = this.peer;
            if (componentPeer == null || componentPeer instanceof LightweightPeer) {
                if (componentPeer == null) {
                    this.peer = componentPeer = this.getToolkit().createComponent(this);
                }
                if (this.parent != null) {
                    long l2 = 0L;
                    if (this.mouseListener != null || (this.eventMask & 0x10L) != 0L) {
                        l2 |= 0x10L;
                    }
                    if (this.mouseMotionListener != null || (this.eventMask & 0x20L) != 0L) {
                        l2 |= 0x20L;
                    }
                    if (this.mouseWheelListener != null || (this.eventMask & 0x20000L) != 0L) {
                        l2 |= 0x20000L;
                    }
                    if (this.focusListener != null || (this.eventMask & 4L) != 0L) {
                        l2 |= 4L;
                    }
                    if (this.keyListener != null || (this.eventMask & 8L) != 0L) {
                        l2 |= 8L;
                    }
                    if (l2 != 0L) {
                        this.parent.proxyEnableEvents(l2);
                    }
                }
            } else {
                Container container = this.parent;
                if (container != null && container.peer instanceof LightweightPeer) {
                    new NativeInLightFixer();
                }
            }
            this.invalidate();
            int n2 = this.popups != null ? this.popups.size() : 0;
            int n3 = 0;
            while (n3 < n2) {
                serializable = (PopupMenu)this.popups.elementAt(n3);
                serializable.addNotify();
                ++n3;
            }
            if (this.dropTarget != null) {
                this.dropTarget.addNotify(componentPeer);
            }
            this.peerFont = this.getFont();
            if (this.hierarchyListener != null || (this.eventMask & 0x8000L) != 0L || Toolkit.enabledOnToolkit(32768L)) {
                serializable = new HierarchyEvent(this, 1400, this, this.parent, 2 | (this.isRecursivelyVisible() ? 4 : 0));
                this.dispatchEvent((AWTEvent)serializable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Object object2;
            if (this.isFocusOwner() && !this.nextFocusHelper()) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
            }
            KeyboardFocusManager.removeFocusRequest(this);
            int n2 = this.popups != null ? this.popups.size() : 0;
            int n3 = 0;
            while (n3 < n2) {
                object2 = (PopupMenu)this.popups.elementAt(n3);
                ((Menu)object2).removeNotify();
                ++n3;
            }
            if (this.areInputMethodsEnabled() && (object2 = this.getInputContext()) != null) {
                ((InputContext)object2).removeNotify(this);
            }
            if ((object2 = this.peer) != null) {
                if (this.bufferStrategy instanceof FlipBufferStrategy) {
                    ((FlipBufferStrategy)this.bufferStrategy).destroyBuffers();
                }
                if (this.dropTarget != null) {
                    this.dropTarget.removeNotify(this.peer);
                }
                if (this.visible) {
                    object2.hide();
                }
                this.peer = null;
                this.peerFont = null;
                Toolkit.getEventQueue().removeSourceEvents(this);
                KeyboardFocusManager.getCurrentKeyboardFocusManager().discardKeyEvents(this);
                object2.dispose();
            }
            if (this.hierarchyListener != null || (this.eventMask & 0x8000L) != 0L || Toolkit.enabledOnToolkit(32768L)) {
                HierarchyEvent hierarchyEvent = new HierarchyEvent(this, 1400, this, this.parent, 2 | (this.isRecursivelyVisible() ? 4 : 0));
                this.dispatchEvent(hierarchyEvent);
            }
        }
    }

    public boolean gotFocus(Event event, Object object) {
        return false;
    }

    public boolean lostFocus(Event event, Object object) {
        return false;
    }

    public boolean isFocusTraversable() {
        if (this.isFocusTraversableOverridden == 0) {
            this.isFocusTraversableOverridden = 1;
        }
        return this.focusable;
    }

    public boolean isFocusable() {
        return this.isFocusTraversable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFocusable(boolean bl2) {
        boolean bl3;
        Component component = this;
        synchronized (component) {
            bl3 = this.focusable;
            this.focusable = bl2;
        }
        this.isFocusTraversableOverridden = 2;
        this.firePropertyChange("focusable", bl3, bl2);
        if (bl3 && !bl2 && this.isFocusOwner()) {
            this.autoTransferFocus(true);
        }
    }

    final boolean isFocusTraversableOverridden() {
        return this.isFocusTraversableOverridden != 1;
    }

    public void setFocusTraversalKeys(int n2, Set set) {
        if (n2 < 0 || n2 >= 3) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        this.setFocusTraversalKeys_NoIDCheck(n2, set);
    }

    public Set getFocusTraversalKeys(int n2) {
        if (n2 < 0 || n2 >= 3) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        return this.getFocusTraversalKeys_NoIDCheck(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setFocusTraversalKeys_NoIDCheck(int n2, Set set) {
        Set set2;
        Component component = this;
        synchronized (component) {
            if (this.focusTraversalKeys == null) {
                this.initializeFocusTraversalKeys();
            }
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (object == null) {
                        throw new IllegalArgumentException("cannot set null focus traversal key");
                    }
                    AWTKeyStroke aWTKeyStroke = (AWTKeyStroke)object;
                    if (aWTKeyStroke.getKeyChar() != '\uffff') {
                        throw new IllegalArgumentException("focus traversal keys cannot map to KEY_TYPED events");
                    }
                    int n3 = 0;
                    while (n3 < this.focusTraversalKeys.length) {
                        if (n3 != n2 && this.getFocusTraversalKeys_NoIDCheck(n3).contains(aWTKeyStroke)) {
                            throw new IllegalArgumentException("focus traversal keys must be unique for a Component");
                        }
                        ++n3;
                    }
                }
            }
            set2 = this.focusTraversalKeys[n2];
            this.focusTraversalKeys[n2] = set != null ? Collections.unmodifiableSet(new HashSet(set)) : null;
        }
        this.firePropertyChange(focusTraversalKeyPropertyNames[n2], set2, set);
    }

    final Set getFocusTraversalKeys_NoIDCheck(int n2) {
        Set set;
        Set set2 = set = this.focusTraversalKeys != null ? this.focusTraversalKeys[n2] : null;
        if (set != null) {
            return set;
        }
        Container container = this.parent;
        if (container != null) {
            return container.getFocusTraversalKeys(n2);
        }
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(n2);
    }

    public boolean areFocusTraversalKeysSet(int n2) {
        if (n2 < 0 || n2 >= 3) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        return this.focusTraversalKeys != null && this.focusTraversalKeys[n2] != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFocusTraversalKeysEnabled(boolean bl2) {
        boolean bl3;
        Component component = this;
        synchronized (component) {
            bl3 = this.focusTraversalKeysEnabled;
            this.focusTraversalKeysEnabled = bl2;
        }
        this.firePropertyChange("focusTraversalKeysEnabled", bl3, bl2);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return this.focusTraversalKeysEnabled;
    }

    public void requestFocus() {
        this.requestFocusHelper(false, true);
    }

    protected boolean requestFocus(boolean bl2) {
        return this.requestFocusHelper(bl2, true);
    }

    public boolean requestFocusInWindow() {
        return this.requestFocusHelper(false, false);
    }

    protected boolean requestFocusInWindow(boolean bl2) {
        return this.requestFocusHelper(bl2, false);
    }

    final boolean requestFocusHelper(boolean bl2, boolean bl3) {
        ComponentPeer componentPeer;
        if (this.isFocusable() && this.isVisible() && (componentPeer = this.peer) != null) {
            Component component;
            Component component2 = this;
            while (!(component2 instanceof Window)) {
                component2 = component2.parent;
            }
            if (component2 == null || !((Window)component2).isFocusableWindow()) {
                return false;
            }
            KeyboardFocusManager.setMostRecentFocusOwner(this);
            Component component3 = component = componentPeer instanceof LightweightPeer ? this.getNativeContainer() : this;
            if (component == null) {
                return false;
            }
            componentPeer = component.peer;
            if (componentPeer == null) {
                return false;
            }
            long l2 = EventQueue.getMostRecentEventTime();
            boolean bl4 = componentPeer.requestFocus(this, bl2, bl3, l2);
            if (!bl4) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager(SunToolkit.targetToAppContext(this)).dequeueKeyEvents(l2, this);
            }
            return bl4;
        }
        return false;
    }

    final void autoTransferFocus(boolean bl2) {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component != this) {
            if (component != null) {
                component.autoTransferFocus(bl2);
            }
            return;
        }
        if (!(this.isDisplayable() && this.isVisible() && this.isEnabled())) {
            this.doAutoTransfer(bl2);
            return;
        }
        component = this.getParent();
        while (component != null && !(component instanceof Window)) {
            if (!component.isDisplayable() || !component.isVisible() || !component.isEnabled() && !component.isLightweight()) {
                this.doAutoTransfer(bl2);
                return;
            }
            component = component.getParent();
        }
    }

    private void doAutoTransfer(boolean bl2) {
        if (bl2) {
            if (!this.nextFocusHelper()) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
            }
        } else {
            this.transferFocus();
        }
    }

    public void transferFocus() {
        this.nextFocus();
    }

    public Container getFocusCycleRootAncestor() {
        Container container = this.parent;
        while (container != null && !container.isFocusCycleRoot()) {
            container = container.parent;
        }
        return container;
    }

    public boolean isFocusCycleRoot(Container container) {
        Container container2 = this.getFocusCycleRootAncestor();
        return container2 == container;
    }

    public void nextFocus() {
        this.nextFocusHelper();
    }

    boolean nextFocusHelper() {
        Container container = this.getFocusCycleRootAncestor();
        Component component = this;
        while (!(container == null || container.isShowing() && container.isFocusable() && container.isEnabled())) {
            component = container;
            container = component.getFocusCycleRootAncestor();
        }
        if (container != null) {
            FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
            Component component2 = focusTraversalPolicy.getComponentAfter(container, component);
            if (component2 == null) {
                component2 = focusTraversalPolicy.getDefaultComponent(container);
            }
            if (component2 != null) {
                return component2.requestFocus(false);
            }
        }
        return false;
    }

    public void transferFocusBackward() {
        Container container = this.getFocusCycleRootAncestor();
        Component component = this;
        while (!(container == null || container.isShowing() && container.isFocusable() && container.isEnabled())) {
            component = container;
            container = component.getFocusCycleRootAncestor();
        }
        if (container != null) {
            FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
            Component component2 = focusTraversalPolicy.getComponentBefore(container, component);
            if (component2 == null) {
                component2 = focusTraversalPolicy.getDefaultComponent(container);
            }
            if (component2 != null) {
                component2.requestFocus();
            }
        }
    }

    public void transferFocusUpCycle() {
        Container container = this.getFocusCycleRootAncestor();
        while (!(container == null || container.isShowing() && container.isFocusable() && container.isEnabled())) {
            container = container.getFocusCycleRootAncestor();
        }
        if (container != null) {
            Container container2 = container.getFocusCycleRootAncestor();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalCurrentFocusCycleRoot(container2 != null ? container2 : container);
            container.requestFocus();
        } else {
            Component component;
            Container container3 = this instanceof Container ? (Container)this : this.getParent();
            while (container3 != null && !(container3 instanceof Window)) {
                container3 = container3.getParent();
            }
            if (container3 != null && (component = container3.getFocusTraversalPolicy().getDefaultComponent(container3)) != null) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalCurrentFocusCycleRoot(container3);
                component.requestFocus();
            }
        }
    }

    public boolean hasFocus() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == this;
    }

    public boolean isFocusOwner() {
        return this.hasFocus();
    }

    public synchronized void add(PopupMenu popupMenu) {
        if (popupMenu.parent != null) {
            popupMenu.parent.remove(popupMenu);
        }
        if (this.popups == null) {
            this.popups = new Vector();
        }
        this.popups.addElement(popupMenu);
        popupMenu.parent = this;
        if (this.peer != null && popupMenu.peer == null) {
            popupMenu.addNotify();
        }
    }

    public synchronized void remove(MenuComponent menuComponent) {
        int n2;
        if (this.popups != null && (n2 = this.popups.indexOf(menuComponent)) >= 0) {
            PopupMenu popupMenu = (PopupMenu)menuComponent;
            if (popupMenu.peer != null) {
                popupMenu.removeNotify();
            }
            popupMenu.parent = null;
            this.popups.removeElementAt(n2);
            if (this.popups.size() == 0) {
                this.popups = null;
            }
        }
    }

    protected String paramString() {
        String string = this.getName();
        String string2 = (string != null ? string : "") + "," + this.x + "," + this.y + "," + this.width + "x" + this.height;
        if (!this.valid) {
            string2 = string2 + ",invalid";
        }
        if (!this.visible) {
            string2 = string2 + ",hidden";
        }
        if (!this.enabled) {
            string2 = string2 + ",disabled";
        }
        return string2;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }

    public void list() {
        this.list(System.out, 0);
    }

    public void list(PrintStream printStream) {
        this.list(printStream, 0);
    }

    public void list(PrintStream printStream, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            printStream.print("  ");
            ++n3;
        }
        printStream.println(this);
    }

    public void list(PrintWriter printWriter) {
        this.list(printWriter, 0);
    }

    public void list(PrintWriter printWriter, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            printWriter.print("  ");
            ++n3;
        }
        printWriter.println(this);
    }

    Container getNativeContainer() {
        Container container = this.parent;
        while (container != null && container.peer instanceof LightweightPeer) {
            container = container.getParent();
        }
        return container;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners(string);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    protected void firePropertyChange(String string, boolean bl2, boolean bl3) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, bl2, bl3);
    }

    protected void firePropertyChange(String string, int n2, int n3) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, n2, n3);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, componentListenerK, this.componentListener);
        AWTEventMulticaster.save(objectOutputStream, focusListenerK, this.focusListener);
        AWTEventMulticaster.save(objectOutputStream, keyListenerK, this.keyListener);
        AWTEventMulticaster.save(objectOutputStream, mouseListenerK, this.mouseListener);
        AWTEventMulticaster.save(objectOutputStream, mouseMotionListenerK, this.mouseMotionListener);
        AWTEventMulticaster.save(objectOutputStream, inputMethodListenerK, this.inputMethodListener);
        objectOutputStream.writeObject(null);
        objectOutputStream.writeObject(this.componentOrientation);
        AWTEventMulticaster.save(objectOutputStream, hierarchyListenerK, this.hierarchyListener);
        AWTEventMulticaster.save(objectOutputStream, hierarchyBoundsListenerK, this.hierarchyBoundsListener);
        objectOutputStream.writeObject(null);
        AWTEventMulticaster.save(objectOutputStream, mouseWheelListenerK, this.mouseWheelListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        block23: {
            String string;
            Object object;
            block22: {
                Object object2;
                block21: {
                    objectInputStream.defaultReadObject();
                    this.privateKey = new Object();
                    this.appContext = AppContext.getAppContext();
                    SunToolkit.insertTargetMapping(this, this.appContext);
                    if (this.componentSerializedDataVersion < 4) {
                        this.focusable = true;
                        this.isFocusTraversableOverridden = 0;
                        this.initializeFocusTraversalKeys();
                        this.focusTraversalKeysEnabled = true;
                    }
                    while (null != (object = objectInputStream.readObject())) {
                        object2 = ((String)object).intern();
                        if (componentListenerK == object2) {
                            this.addComponentListener((ComponentListener)objectInputStream.readObject());
                            continue;
                        }
                        if (focusListenerK == object2) {
                            this.addFocusListener((FocusListener)objectInputStream.readObject());
                            continue;
                        }
                        if (keyListenerK == object2) {
                            this.addKeyListener((KeyListener)objectInputStream.readObject());
                            continue;
                        }
                        if (mouseListenerK == object2) {
                            this.addMouseListener((MouseListener)objectInputStream.readObject());
                            continue;
                        }
                        if (mouseMotionListenerK == object2) {
                            this.addMouseMotionListener((MouseMotionListener)objectInputStream.readObject());
                            continue;
                        }
                        if (inputMethodListenerK == object2) {
                            this.addInputMethodListener((InputMethodListener)objectInputStream.readObject());
                            continue;
                        }
                        objectInputStream.readObject();
                    }
                    object2 = null;
                    try {
                        object2 = objectInputStream.readObject();
                    }
                    catch (OptionalDataException optionalDataException) {
                        if (optionalDataException.eof) break block21;
                        throw optionalDataException;
                    }
                }
                this.componentOrientation = object2 != null ? (ComponentOrientation)object2 : ComponentOrientation.UNKNOWN;
                try {
                    while (null != (object = objectInputStream.readObject())) {
                        string = ((String)object).intern();
                        if (hierarchyListenerK == string) {
                            this.addHierarchyListener((HierarchyListener)objectInputStream.readObject());
                            continue;
                        }
                        if (hierarchyBoundsListenerK == string) {
                            this.addHierarchyBoundsListener((HierarchyBoundsListener)objectInputStream.readObject());
                            continue;
                        }
                        objectInputStream.readObject();
                    }
                }
                catch (OptionalDataException optionalDataException) {
                    if (optionalDataException.eof) break block22;
                    throw optionalDataException;
                }
            }
            try {
                while (null != (object = objectInputStream.readObject())) {
                    string = ((String)object).intern();
                    if (mouseWheelListenerK == string) {
                        this.addMouseWheelListener((MouseWheelListener)objectInputStream.readObject());
                        continue;
                    }
                    objectInputStream.readObject();
                }
            }
            catch (OptionalDataException optionalDataException) {
                if (optionalDataException.eof) break block23;
                throw optionalDataException;
            }
        }
        if (this.popups != null) {
            int n2 = this.popups.size();
            int n3 = 0;
            while (n3 < n2) {
                PopupMenu popupMenu = (PopupMenu)this.popups.elementAt(n3);
                popupMenu.parent = this;
                ++n3;
            }
        }
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        ComponentOrientation componentOrientation2 = this.componentOrientation;
        this.componentOrientation = componentOrientation;
        this.firePropertyChange("componentOrientation", componentOrientation2, componentOrientation);
        if (this.valid) {
            this.invalidate();
        }
    }

    public ComponentOrientation getComponentOrientation() {
        return this.componentOrientation;
    }

    public void applyComponentOrientation(ComponentOrientation componentOrientation) {
        if (componentOrientation == null) {
            throw new NullPointerException();
        }
        this.setComponentOrientation(componentOrientation);
    }

    private static native void initIDs();

    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int getAccessibleIndexInParent() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n2 = -1;
            Container container = this.getParent();
            if (container == null) return -1;
            if (!(container instanceof Accessible)) return -1;
            Component[] componentArray = container.getComponents();
            int n3 = 0;
            while (n3 < componentArray.length) {
                if (componentArray[n3] instanceof Accessible) {
                    ++n2;
                }
                if (this.equals(componentArray[n3])) {
                    return n2;
                }
                ++n3;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AccessibleStateSet getAccessibleStateSet() {
        Object object = this.getTreeLock();
        synchronized (object) {
            AccessibleSelection accessibleSelection;
            AccessibleContext accessibleContext;
            Accessible accessible;
            Object object2;
            AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
            if (this.isEnabled()) {
                accessibleStateSet.add(AccessibleState.ENABLED);
            }
            if (this.isFocusTraversable()) {
                accessibleStateSet.add(AccessibleState.FOCUSABLE);
            }
            if (this.isVisible()) {
                accessibleStateSet.add(AccessibleState.VISIBLE);
            }
            if (this.isShowing()) {
                accessibleStateSet.add(AccessibleState.SHOWING);
            }
            if (this.isFocusOwner()) {
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
            if (this instanceof Accessible && (object2 = ((Accessible)((Object)this)).getAccessibleContext()) != null && (accessible = ((AccessibleContext)object2).getAccessibleParent()) != null && (accessibleContext = accessible.getAccessibleContext()) != null && (accessibleSelection = accessibleContext.getAccessibleSelection()) != null) {
                accessibleStateSet.add(AccessibleState.SELECTABLE);
                int n2 = ((AccessibleContext)object2).getAccessibleIndexInParent();
                if (n2 >= 0 && accessibleSelection.isAccessibleChildSelected(n2)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                }
            }
            if (this instanceof JComponent && ((JComponent)this).isOpaque()) {
                accessibleStateSet.add(AccessibleState.OPAQUE);
            }
            object2 = accessibleStateSet;
            return object2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string;
        focusTraversalKeyPropertyNames = new String[]{"forwardFocusTraversalKeys", "backwardFocusTraversalKeys", "upCycleFocusTraversalKeys", "downCycleFocusTraversalKeys"};
        LOCK = new AWTTreeLock();
        dbg = DebugHelper.create(class$java$awt$Component == null ? (class$java$awt$Component = Component.class$("java.awt.Component")) : class$java$awt$Component);
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Component.initIDs();
        }
        isInc = (string = (String)AccessController.doPrivileged(new GetPropertyAction("awt.image.incrementaldraw"))) == null || string.equals("true");
        string = (String)AccessController.doPrivileged(new GetPropertyAction("awt.image.redrawrate"));
        incRate = string != null ? Integer.parseInt(string) : 100;
        metrics = new Hashtable();
    }

    protected abstract class AccessibleAWTComponent
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent {
        protected ComponentListener accessibleAWTComponentHandler = null;
        protected FocusListener accessibleAWTFocusHandler = null;

        protected AccessibleAWTComponent() {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.accessibleAWTComponentHandler == null) {
                this.accessibleAWTComponentHandler = new AccessibleAWTComponentHandler();
                Component.this.addComponentListener(this.accessibleAWTComponentHandler);
            }
            if (this.accessibleAWTFocusHandler == null) {
                this.accessibleAWTFocusHandler = new AccessibleAWTFocusHandler();
                Component.this.addFocusListener(this.accessibleAWTFocusHandler);
            }
            super.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.accessibleAWTComponentHandler != null) {
                Component.this.removeComponentListener(this.accessibleAWTComponentHandler);
                this.accessibleAWTComponentHandler = null;
            }
            if (this.accessibleAWTFocusHandler != null) {
                Component.this.removeFocusListener(this.accessibleAWTFocusHandler);
                this.accessibleAWTFocusHandler = null;
            }
            super.removePropertyChangeListener(propertyChangeListener);
        }

        public String getAccessibleName() {
            return this.accessibleName;
        }

        public String getAccessibleDescription() {
            return this.accessibleDescription;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.AWT_COMPONENT;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return Component.this.getAccessibleStateSet();
        }

        public Accessible getAccessibleParent() {
            if (this.accessibleParent != null) {
                return this.accessibleParent;
            }
            Container container = Component.this.getParent();
            if (container instanceof Accessible) {
                return (Accessible)((Object)container);
            }
            return null;
        }

        public int getAccessibleIndexInParent() {
            return Component.this.getAccessibleIndexInParent();
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int n2) {
            return null;
        }

        public Locale getLocale() {
            return Component.this.getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return Component.this.getBackground();
        }

        public void setBackground(Color color) {
            Component.this.setBackground(color);
        }

        public Color getForeground() {
            return Component.this.getForeground();
        }

        public void setForeground(Color color) {
            Component.this.setForeground(color);
        }

        public Cursor getCursor() {
            return Component.this.getCursor();
        }

        public void setCursor(Cursor cursor) {
            Component.this.setCursor(cursor);
        }

        public Font getFont() {
            return Component.this.getFont();
        }

        public void setFont(Font font) {
            Component.this.setFont(font);
        }

        public FontMetrics getFontMetrics(Font font) {
            if (font == null) {
                return null;
            }
            return Component.this.getFontMetrics(font);
        }

        public boolean isEnabled() {
            return Component.this.isEnabled();
        }

        public void setEnabled(boolean bl2) {
            boolean bl3 = Component.this.isEnabled();
            Component.this.setEnabled(bl2);
            if (bl2 != bl3 && Component.this.accessibleContext != null) {
                if (bl2) {
                    Component.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.ENABLED);
                } else {
                    Component.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.ENABLED, null);
                }
            }
        }

        public boolean isVisible() {
            return Component.this.isVisible();
        }

        public void setVisible(boolean bl2) {
            boolean bl3 = Component.this.isVisible();
            Component.this.setVisible(bl2);
            if (bl2 != bl3 && Component.this.accessibleContext != null) {
                if (bl2) {
                    Component.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
                } else {
                    Component.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
                }
            }
        }

        public boolean isShowing() {
            return Component.this.isShowing();
        }

        public boolean contains(Point point) {
            return Component.this.contains(point);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Point getLocationOnScreen() {
            Object object = Component.this.getTreeLock();
            synchronized (object) {
                block4: {
                    if (!Component.this.isShowing()) break block4;
                    Point point = Component.this.getLocationOnScreen();
                    return point;
                }
                Point point = null;
                return point;
            }
        }

        public Point getLocation() {
            return Component.this.getLocation();
        }

        public void setLocation(Point point) {
            Component.this.setLocation(point);
        }

        public Rectangle getBounds() {
            return Component.this.getBounds();
        }

        public void setBounds(Rectangle rectangle) {
            Component.this.setBounds(rectangle);
        }

        public Dimension getSize() {
            return Component.this.getSize();
        }

        public void setSize(Dimension dimension) {
            Component.this.setSize(dimension);
        }

        public Accessible getAccessibleAt(Point point) {
            return null;
        }

        public boolean isFocusTraversable() {
            return Component.this.isFocusTraversable();
        }

        public void requestFocus() {
            Component.this.requestFocus();
        }

        public void addFocusListener(FocusListener focusListener) {
            Component.this.addFocusListener(focusListener);
        }

        public void removeFocusListener(FocusListener focusListener) {
            Component.this.removeFocusListener(focusListener);
        }

        protected class AccessibleAWTFocusHandler
        implements FocusListener {
            protected AccessibleAWTFocusHandler() {
            }

            public void focusGained(FocusEvent focusEvent) {
                if (((AccessibleAWTComponent)AccessibleAWTComponent.this).Component.this.accessibleContext != null) {
                    ((AccessibleAWTComponent)AccessibleAWTComponent.this).Component.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                if (((AccessibleAWTComponent)AccessibleAWTComponent.this).Component.this.accessibleContext != null) {
                    ((AccessibleAWTComponent)AccessibleAWTComponent.this).Component.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
                }
            }
        }

        protected class AccessibleAWTComponentHandler
        implements ComponentListener {
            protected AccessibleAWTComponentHandler() {
            }

            public void componentHidden(ComponentEvent componentEvent) {
                if (((AccessibleAWTComponent)AccessibleAWTComponent.this).Component.this.accessibleContext != null) {
                    ((AccessibleAWTComponent)AccessibleAWTComponent.this).Component.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
                }
            }

            public void componentShown(ComponentEvent componentEvent) {
                if (((AccessibleAWTComponent)AccessibleAWTComponent.this).Component.this.accessibleContext != null) {
                    ((AccessibleAWTComponent)AccessibleAWTComponent.this).Component.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
                }
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
            }
        }
    }

    private final class NativeInLightFixer
    implements ComponentListener,
    ContainerListener {
        Vector lightParents = new Vector();
        Container nativeHost;

        NativeInLightFixer() {
            Container container = Component.this.parent;
            while (container.peer instanceof LightweightPeer) {
                container.addComponentListener(this);
                container.addContainerListener(this);
                this.lightParents.addElement(container);
                container = container.parent;
            }
            this.nativeHost = container;
            container.addContainerListener(this);
            this.componentMoved(null);
        }

        public void componentResized(ComponentEvent componentEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentMoved(ComponentEvent componentEvent) {
            Object object = Component.this.getTreeLock();
            synchronized (object) {
                int n2 = Component.this.x;
                int n3 = Component.this.y;
                Container container = Component.this.parent;
                while (container != null && container.peer instanceof LightweightPeer) {
                    n2 += container.x;
                    n3 += container.y;
                    container = container.parent;
                }
                if (Component.this.peer != null) {
                    Component.this.peer.setBounds(n2, n3, Component.this.width, Component.this.height);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentShown(ComponentEvent componentEvent) {
            if (Component.this.isShowing()) {
                Object object = Component.this.getTreeLock();
                synchronized (object) {
                    if (Component.this.peer != null) {
                        Component.this.peer.show();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentHidden(ComponentEvent componentEvent) {
            if (Component.this.visible) {
                Object object = Component.this.getTreeLock();
                synchronized (object) {
                    if (Component.this.peer != null) {
                        Component.this.peer.hide();
                    }
                }
            }
        }

        public void componentAdded(ContainerEvent containerEvent) {
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component == Component.this) {
                this.removeReferences();
            } else {
                int n2 = this.lightParents.size();
                int n3 = 0;
                while (n3 < n2) {
                    Container container = (Container)this.lightParents.elementAt(n3);
                    if (container == component) {
                        this.removeReferences();
                        break;
                    }
                    ++n3;
                }
            }
        }

        void removeReferences() {
            int n2 = this.lightParents.size();
            int n3 = 0;
            while (n3 < n2) {
                Container container = (Container)this.lightParents.elementAt(n3);
                container.removeComponentListener(this);
                container.removeContainerListener(this);
                ++n3;
            }
            this.nativeHost.removeContainerListener(this);
        }
    }

    private class SingleBufferStrategy
    extends BufferStrategy {
        private BufferCapabilities caps;

        public SingleBufferStrategy(BufferCapabilities bufferCapabilities) {
            this.caps = bufferCapabilities;
        }

        public BufferCapabilities getCapabilities() {
            return this.caps;
        }

        public Graphics getDrawGraphics() {
            return Component.this.getGraphics();
        }

        public boolean contentsLost() {
            return false;
        }

        public boolean contentsRestored() {
            return false;
        }

        public void show() {
        }
    }

    protected class BltBufferStrategy
    extends BufferStrategy {
        protected BufferCapabilities caps;
        protected VolatileImage[] backBuffers;
        protected boolean validatedContents;
        protected int width;
        protected int height;

        protected BltBufferStrategy(int n2, BufferCapabilities bufferCapabilities) {
            this.caps = bufferCapabilities;
            this.createBackBuffers(n2 - 1);
        }

        protected void createBackBuffers(int n2) {
            if (n2 == 0) {
                this.backBuffers = null;
            } else {
                this.width = Component.this.getWidth();
                this.height = Component.this.getHeight();
                this.backBuffers = new VolatileImage[n2];
                int n3 = 0;
                while (n3 < n2) {
                    this.backBuffers[n3] = Component.this.createVolatileImage(this.width, this.height);
                    ++n3;
                }
            }
        }

        public BufferCapabilities getCapabilities() {
            return this.caps;
        }

        public Graphics getDrawGraphics() {
            this.revalidate();
            if (this.backBuffers == null) {
                return Component.this.getGraphics();
            }
            return this.backBuffers[this.backBuffers.length - 1].getGraphics();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void show() {
            if (this.backBuffers == null) {
                return;
            }
            Graphics graphics = Component.this.getGraphics();
            try {
                int n2 = 0;
                while (n2 < this.backBuffers.length) {
                    graphics.drawImage(this.backBuffers[n2], 0, 0, Component.this);
                    graphics.dispose();
                    graphics = null;
                    graphics = this.backBuffers[n2].getGraphics();
                    ++n2;
                }
                Object var4_3 = null;
                if (graphics != null) {
                    graphics.dispose();
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (graphics != null) {
                    graphics.dispose();
                }
                throw throwable;
            }
        }

        protected void revalidate() {
            if (this.backBuffers == null) {
                this.validatedContents = false;
            } else if (Component.this.getWidth() != this.width || Component.this.getHeight() != this.height) {
                this.createBackBuffers(this.backBuffers.length);
                this.validatedContents = true;
            } else {
                this.validatedContents = this.backBuffers[this.backBuffers.length - 1].validate(Component.this.getGraphicsConfiguration()) == 1;
            }
        }

        public boolean contentsLost() {
            if (this.width < Component.this.getWidth() || this.height < Component.this.getHeight()) {
                return true;
            }
            return this.backBuffers[this.backBuffers.length - 1].contentsLost();
        }

        public boolean contentsRestored() {
            return this.validatedContents;
        }
    }

    protected class FlipBufferStrategy
    extends BufferStrategy {
        protected int numBuffers;
        protected BufferCapabilities caps;
        protected Image drawBuffer;
        protected VolatileImage drawVBuffer;
        protected boolean validatedContents;

        protected FlipBufferStrategy(int n2, BufferCapabilities bufferCapabilities) throws AWTException {
            if (!(Component.this instanceof Window) && !(Component.this instanceof Canvas)) {
                throw new ClassCastException("Component must be a Canvas or Window");
            }
            this.numBuffers = n2;
            this.caps = bufferCapabilities;
            this.createBuffers(n2, bufferCapabilities);
        }

        protected void createBuffers(int n2, BufferCapabilities bufferCapabilities) throws AWTException {
            if (n2 < 2) {
                throw new IllegalArgumentException("Number of buffers cannot be less than two");
            }
            if (Component.this.peer == null) {
                throw new IllegalStateException("Component must have a valid peer");
            }
            if (bufferCapabilities == null || !bufferCapabilities.isPageFlipping()) {
                throw new IllegalArgumentException("Page flipping capabilities must be specified");
            }
            Component.this.peer.createBuffers(n2, bufferCapabilities);
        }

        protected Image getBackBuffer() {
            if (Component.this.peer != null) {
                return Component.this.peer.getBackBuffer();
            }
            throw new IllegalStateException("Component must have a valid peer");
        }

        protected void flip(BufferCapabilities.FlipContents flipContents) {
            if (Component.this.peer == null) {
                throw new IllegalStateException("Component must have a valid peer");
            }
            Component.this.peer.flip(flipContents);
        }

        protected void destroyBuffers() {
            if (Component.this.peer == null) {
                throw new IllegalStateException("Component must have a valid peer");
            }
            Component.this.peer.destroyBuffers();
        }

        public BufferCapabilities getCapabilities() {
            return this.caps;
        }

        public Graphics getDrawGraphics() {
            if (this.drawBuffer == null) {
                this.drawBuffer = this.getBackBuffer();
                if (this.drawBuffer instanceof VolatileImage) {
                    this.drawVBuffer = (VolatileImage)this.drawBuffer;
                }
            }
            this.revalidate();
            return this.drawBuffer.getGraphics();
        }

        protected void revalidate() {
            this.validatedContents = this.drawVBuffer != null ? this.drawVBuffer.validate(Component.this.getGraphicsConfiguration()) == 1 : false;
        }

        public boolean contentsLost() {
            if (this.drawVBuffer == null) {
                return false;
            }
            return this.drawVBuffer.contentsLost();
        }

        public boolean contentsRestored() {
            return this.validatedContents;
        }

        public void show() {
            this.flip(this.caps.getFlipContents());
        }
    }

    static class AWTTreeLock {
        AWTTreeLock() {
        }
    }
}

