/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.DnsContext;
import com.sun.jndi.dns.DnsUrl;
import java.net.MalformedURLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.InitialContextFactory;

public class DnsContextFactory
implements InitialContextFactory {
    private static final String DEFAULT_URL = "dns:";

    public Context getInitialContext(Hashtable hashtable) throws NamingException {
        if (hashtable == null) {
            hashtable = new Hashtable(5);
        }
        return DnsContextFactory.UrlToContext(DnsContextFactory.getInitCtxUrl(hashtable), hashtable);
    }

    private static Context UrlToContext(String string, Hashtable hashtable) throws NamingException {
        DnsUrl[] dnsUrlArray;
        try {
            dnsUrlArray = DnsUrl.fromList(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new NoInitialContextException(malformedURLException.getMessage());
        }
        if (dnsUrlArray.length == 0) {
            throw new NoInitialContextException("java.naming.provider.url property does not contain a URL");
        }
        String string2 = dnsUrlArray[0].getDomain();
        int n2 = 1;
        while (n2 < dnsUrlArray.length) {
            if (!string2.equalsIgnoreCase(dnsUrlArray[n2].getDomain())) {
                throw new NoInitialContextException("java.naming.provider.url property contains multiple domains");
            }
            ++n2;
        }
        String[] stringArray = new String[dnsUrlArray.length];
        int n3 = 0;
        while (n3 < dnsUrlArray.length) {
            stringArray[n3] = dnsUrlArray[n3].getHostPort();
            ++n3;
        }
        return new DnsContext(string2, stringArray, hashtable);
    }

    private static String getInitCtxUrl(Hashtable hashtable) {
        String string = (String)hashtable.get("java.naming.provider.url");
        return string != null ? string : DEFAULT_URL;
    }
}

