/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.net.proxy;

import java.net.URL;
import java.util.StringTokenizer;
import sun.plugin.net.proxy.BrowserProxyInfo;
import sun.plugin.net.proxy.ProxyConfigException;
import sun.plugin.net.proxy.ProxyHandler;
import sun.plugin.net.proxy.ProxyInfo;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.usability.Trace;

public class BrowserProxyHandler
implements ProxyHandler {
    public boolean isSupported(int n) {
        return n == 3;
    }

    public boolean isProxyCacheSupported() {
        return false;
    }

    public void init(BrowserProxyInfo browserProxyInfo) throws ProxyConfigException {
        Trace.netPrintln(ResourceHandler.getMessage("net.proxy.loading.browser"));
        if (!this.isSupported(browserProxyInfo.getType())) {
            throw new ProxyConfigException("Unable to support proxy type: " + browserProxyInfo.getType());
        }
        Trace.netPrintln(ResourceHandler.getMessage("net.proxy.loading.done"));
    }

    public ProxyInfo getProxyInfo(URL uRL) {
        String string = this.findProxyForURL(uRL.toString());
        return this.extractAutoProxySetting(string);
    }

    private native String findProxyForURL(String var1);

    private ProxyInfo extractAutoProxySetting(String string) {
        StringTokenizer stringTokenizer;
        if (string != null && (stringTokenizer = new StringTokenizer(string, ";", false)).hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("PROXY");
            if (n != -1) {
                return new ProxyInfo(string2.substring(n + 6));
            }
            n = string2.indexOf("SOCKS");
            if (n != -1) {
                return new ProxyInfo(null, string2.substring(n + 6));
            }
        }
        return new ProxyInfo(null, -1);
    }
}

