#include <errno.h>
#include <signal.h>
#include <stdio.h>

#include "x286emul.h"
#include "ldt.h"
#include "syscall.h"
#include "lcall7.h"

#ifdef DEBUG
# include "debug.h"
#endif


int
emu_i_sas(struct sigcontext_struct *sc)
{
unsigned short *stkladdr;

	if(LDATA){	/* Large Data */
		stkladdr = (unsigned short *)(ldt[sc->ss >> 3].base + (sc->ebx & 0xffff));
		return lcall7( sc->eax & 0xffff, 
			stkladdr[0],
			stkladdr[1] + ldt[stkladdr[2] >>3].base, 
			stkladdr[3]);
	}
	else {
		return lcall7(sc->eax & 0xffff,
			sc->ebx & 0xffff,
			ldt[sc->ds>>3].base + (sc->ecx & 0xffff),
			sc->esi & 0xffff);
	}
}


int
emu_i_ass(struct sigcontext_struct *sc)
{
unsigned short *stkladdr;

	if(LDATA){	/* Large Data */
		stkladdr = (unsigned short *)(ldt[sc->ss >> 3].base + (sc->ebx & 0xffff));
#ifdef DEBUG
		if (__dbf)
			fprintf(__dbf, "x286emul: \"%s\"!\n",
				(char *)ldt[stkladdr[1]>>3].base + stkladdr[0]);
#endif
		return lcall7(sc->eax & 0xffff,
			stkladdr[0] + ldt[stkladdr[1] >>3].base, 
			stkladdr[2],
			stkladdr[3]);
	}
	else {
#ifdef DEBUG
		if (__dbf)
			fprintf(__dbf, "x286emul: \"%s\"!\n",
				(char *)ldt[sc->ds>>3].base + (sc->ebx & 0xffff));
#endif
		return lcall7(sc->eax & 0xffff,
			ldt[sc->ds>>3].base + (sc->ebx & 0xffff),
			(sc->ecx & 0xffff),
			(sc->esi & 0xffff));
	}
}


int
emu_i_s(struct sigcontext_struct *sc)
{
unsigned short *stkladdr;

	if(LDATA){	/* Large Data */
		stkladdr = (unsigned short *)(ldt[sc->ss >> 3].base + (sc->ebx & 0xffff));
		return lcall7(sc->eax & 0xffff,
				stkladdr[0]);
	}
	else {
		return lcall7(sc->eax & 0xffff,
				sc->ebx & 0xffff);
	}
}


int
emu_i_sls(struct sigcontext_struct *sc)
{
unsigned short *stkladdr;

	if(LDATA){	/* Large Data */
		stkladdr = (unsigned short *)(ldt[sc->ss >> 3].base + (sc->ebx & 0xffff));
		return lcall7(sc->eax & 0xffff,
				stkladdr[0],
				(long)stkladdr[1] | ((long)stkladdr[2] << 16),
				stkladdr[3]);
	}
	else {
		return lcall7(sc->eax & 0xffff,
				sc->ebx & 0xffff,
				(sc->ecx & 0xffff) | (sc->esi << 16),
				(sc->edi & 0xffff));
	}
}


int
emu_i_ssl(struct sigcontext_struct *sc)
{
unsigned short *stkladdr;

	if(LDATA){	/* Large Data */
		stkladdr = (unsigned short *)(ldt[sc->ss >> 3].base + (sc->ebx & 0xffff));
		return lcall7(sc->eax & 0xffff,
				stkladdr[0],
				stkladdr[1],
				(long)stkladdr[2] | ((long)stkladdr[3] << 16));
	}
	else {
		return lcall7(sc->eax & 0xffff,
				sc->ebx & 0xffff,
				(sc->ecx & 0xffff),
				(sc->esi & 0xffff) | (sc->edi << 16));
	}
}


int
emu_i_a(struct sigcontext_struct *sc)
{
unsigned short *stkladdr;

	if(LDATA){	/* Large Data */
		stkladdr = (unsigned short *)(ldt[sc->ss >> 3].base + (sc->ebx & 0xffff));
		return lcall7(sc->eax & 0xffff,
				ldt[stkladdr[1]>>3].base + stkladdr[0]);
	}
	else {
		return lcall7(sc->eax & 0xffff,
				ldt[sc->ds>>3].base + (sc->ebx & 0xffff));
	}
}


int
emu_i_aa(struct sigcontext_struct *sc)
{
unsigned short *stkladdr;

	if(LDATA){	/* Large Data */
		stkladdr = (unsigned short *)(ldt[sc->ss >> 3].base + (sc->ebx & 0xffff));
		return lcall7(sc->eax & 0xffff,
				ldt[stkladdr[1]>>3].base + stkladdr[0],
				ldt[stkladdr[3]>>3].base + stkladdr[2]);
	}
	else {
		return lcall7(sc->eax & 0xffff,
				ldt[sc->ds>>3].base + (sc->ebx & 0xffff),
				ldt[sc->ds>>3].base + (sc->ecx & 0xffff));
	}
}


int
emu_i_ssa(struct sigcontext_struct *sc)
{
unsigned short *stkladdr;

	if(LDATA){	/* Large Data */
		stkladdr = (unsigned short *)(ldt[sc->ss >> 3].base + (sc->ebx & 0xffff));
		return lcall7(sc->eax & 0xffff,
			stkladdr[0],
			stkladdr[1],
			ldt[stkladdr[3]>>3].base + stkladdr[2]);
	}
	else {
		return lcall7(sc->eax & 0xffff,
			(sc->ebx & 0xffff),
			(sc->ecx & 0xffff),
			ldt[sc->ds>>3].base + (sc->esi & 0xffff));
	}
}


int
emu_i_l(struct sigcontext_struct *sc)
{
unsigned short *stkladdr;

	if(LDATA){	/* Large Data */
		stkladdr = (unsigned short *)(ldt[sc->ss >> 3].base + (sc->ebx & 0xffff));
		return lcall7(sc->eax & 0xffff,
			stkladdr[0] | ((long)stkladdr[1] << 16));
	}
	else {
		return lcall7(sc->eax & 0xffff,
			(sc->ebx & 0xffff) | ((sc->ecx & 0xffff) << 16));
	}
}


int
emu_i_v(struct sigcontext_struct *sc)
{
	return lcall7(sc->eax & 0xffff);
}
