#    Copyright (C) 1991, 1995, 1996 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of GNU Ghostscript.
# 
# GNU Ghostscript is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility to
# anyone for the consequences of using it or for whether it serves any
# particular purpose or works at all, unless he says so in writing.  Refer to
# the GNU General Public License for full details.
# 
# Everyone is granted permission to copy, modify and redistribute GNU
# Ghostscript, but only under the conditions described in the GNU General
# Public License.  A copy of this license is supposed to have been given to
# you along with GNU Ghostscript so you can know your rights and
# responsibilities.  It should be in a file named COPYING.  Among other
# things, the copyright notice and this notice must be preserved on all
# copies.
# 
# Aladdin Enterprises is not affiliated with the Free Software Foundation or
# the GNU Project.  GNU Ghostscript, as distributed by Aladdin Enterprises,
# does not depend on any other GNU software.

# makefile for MS-DOS / Watcom C/C++ library testing.

libdefault: gslib.exe
	%null

GS_DOCDIR=c:/gs
GS_LIB_DEFAULT=.;c:/gs\;c:/gs/fonts
GS_INIT=gs_init.ps

DEBUG=1
TDEBUG=0
NOPRIVATE=1

GS=gslib
JSRCDIR=jpeg-6a
JVERSION=6
CONFIG=
CFLAGS=

# Allow predefinition of WCVERSION
# when using this makefile from inside another one.
!ifeq WCVERSION
WCVERSION=8.5
!endif
LIBPATHS=LIBPATH $(%WATCOM)\lib386 LIBPATH $(%WATCOM)\lib386\dos
STUB=$(%WATCOM)\binb\wstub.exe

CPU_TYPE=386
FPU_TYPE=0

PLATFORM=watclib_
MAKEFILE=watclib.mak
PLATOPT=

!include wccommon.mak

# Allow predefinition of FEATURE_DEVS and DEVICE_DEVS
# when using this makefile from inside another one.
!ifeq FEATURE_DEVS
FEATURE_DEVS=patlib.dev path1lib.dev hsblib.dev
!endif
!ifeq DEVICE_DEVS
DEVICE_DEVS=vga.dev
!endif
COMPILE_INITS=0

!include wctail.mak
!include devs.mak

watclib__=gp_iwatc.$(OBJ) gp_msdos.$(OBJ) gp_nofb.$(OBJ) gp_dosfs.$(OBJ) gp_dosfe.$(OBJ)
watclib_.dev: $(watclib__)
	$(SETMOD) watclib_ $(watclib__)

gp_iwatc.$(OBJ): gp_iwatc.c $(stat__h) $(string__h) $(gx_h) $(gp_h)

BEGINFILES=*.err
CCBEGIN=for %%f in (gs*.c gx*.c z*.c) do $(CCC) %%f

ll_tr=ll$(CONFIG).tr
$(ll_tr): $(MAKEFILE)
	echo SYSTEM DOS4G >$(ll_tr)
	echo OPTION STUB=$(STUB) >>$(ll_tr)
	echo OPTION STACK=12k >>$(ll_tr)
	echo FILE gconfig.obj >>$(ll_tr)
	echo FILE gscdefs.obj >>$(ll_tr)

gslib.exe: gslib.obj $(LIB_ALL) gconfig.obj gscdefs.obj $(ld_tr) $(ll_tr)
	$(LINK) $(LCT) NAME gslib OPTION MAP=gslib FILE gslib @$(ld_tr) @$(ll_tr)
