/*
headers.h: general header file for selectnews

Copyright (C) 1993 Eugene Eric Kim
All rights reserved.

LAST REVISION: September 4, 1993
*/

#ifdef NCURSES
#include <ncurses.h>
#else
#include <curses.h>
#endif
#include "dllist.h"

/* from 'diskio.c' */
extern void error(char* s);
extern FILE* GetFile();
extern void Backup();
extern void sortfile(FILE* f,dllist *b1,dllist *b2,int *i, int *j);
extern int Write(dllist b1, dllist b2);

/* from 'screenio.c' */
extern void Credits();
extern void Topline();
extern void initwin();
extern void Instructions();
extern short Sure(char str[80]);
extern void cursor(WINDOW* win,int loc,char* str);
extern void delcursor(WINDOW* win,int loc);
extern void showentry(WINDOW* win,int b,char line[LEN]);
extern void showbuffer(WINDOW* win,dllist buffer,int start);
extern node* moveup(WINDOW* win,int* cpos,int* top,node* w,char* cchar);
extern node* movedown(WINDOW* win,int* cpos,int* top,dllist list,node* w,char* cchar);
extern node* scrollup(WINDOW *win, int *cpos, int *top, dllist list, node* w, char* cchar);
extern node* scrolldown(WINDOW *win, int *cpos, int *top, dllist list, node* w, char* cchar);
extern node* homepage(WINDOW *win, int *cpos, int *top, dllist list, char* cchar);
extern node* endpage(WINDOW *win, int *cpos, int *top, dllist list, char* cchar);
extern node* find(WINDOW *win, int *cpos, int *top, dllist list, char* cchar);
extern void sort(WINDOW *win,dllist *list,int top,int cpos,char* cchar);
