#include <sys/types.h>
#include <sys/socket.h>

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#include "global.h"

int main(int argc, char **argv)
{
	unsigned char buf[512];
	int size;
	int s;

	if ((s = socket(AF_INET, SOCK_PACKET, htons(2))) == -1)
	{
		perror("socket");
		return(1);
	}
	
	for (;;)
	{
		if ((size = recv(s, buf, 512, 0)) == -1)
		{
			perror("recv");
			return(1);
		}

		ki_dump(buf, size);

		putc('\n', stdout);

		fflush(stdout);
	}
}

void data_dump(unsigned char *data, int length)
{
	int  i, j;
	char c;

	for (i = 0; length > 0; i += 64)
	{
		fprintf(stdout, "%04X  ", i);
	
		for (j = 0; j < 64 && length > 0; j++)
		{
			c = *data++;
			length--;
			
			if (c >= 0x20 && c < 0x7F)
				putc(c, stdout);
			else
				putc('.', stdout);
		}
		
		putc('\n', stdout);
	}
}

int get16(unsigned char *cp)
{
	int x;
	
	x = *cp++;
	x <<= 8;
	x |= *cp++;
	
	return(x);
}

int get32(unsigned char *cp)
{
	int x;
	
	x = *cp++;
	x <<= 8;
	x |= *cp++;
	x <<= 8;
	x |= *cp++;
	x <<= 8;
	x |= *cp;
	
	return(x);
}
