/*
 *
 *	main.c
 *
 *	HNMS User Interface
 *	HNMS 2.0
 *
 *	February 1994
 *
 *	Leslie Schlecht
 *	Computer Sciences Corporation
 *	Numerical Aerodynamic Simulation Systems Division
 *	NASA Ames Research Center
 *
 *	Copyright (c) 1994 Leslie Schlecht
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 1, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include	<sys/types.h>
#include	<stdio.h>
#include	<signal.h>
#include	<stdlib.h>
#include	<sys/stat.h>

char		hnms_home[BUFSIZ];

main(argc, argv)
int	argc;
char	*argv[];
	{
	char	*hh;
	struct	stat	statbuf;
	char	*default_home = "/usr/local/HNMS";

	if (!get_arg("-f", NULL, argc, argv)) {
		if (fork() > 0)
			exit(0);
		}

	/* initialize */
	hh = getenv("HNMS_HOME");
	if (!hh || !strlen(hh)) {
		hh = default_home;
		printf("HNMS_HOME not set, using /usr/local/HNMS.\n");
		if (stat(hh, &statbuf) < 0) {
			perror("HNMS_HOME:");
			exit(1);
			}
		}
	strcpy(hnms_home, hh);
	InitializeUtilities();
	InitializeHNMP(argv[0]);
	signal(SIGINT, SIG_IGN);
	InitializeVariables();
	if (!InitializeObjects()) exit(1);
	
	if (!CreateMainPanel(argc, argv)) exit(1);

	MainLoop();
	}
