/*\
 *	DISTRIBUTION: HNMS v2.0
 *	FILE: hnmslib/hnmsdefs.h
 *
 *	Definitions for hnms.c.
 *
 *	Jude George
 *	NAS Facility, NASA Ames Research Center
 *
 *	Copyright (c) 1994 Jude George
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 1, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\*/

#ifndef MIN
#define MIN(x,y)		(((x) < (y)) ? (x) : (y))
#endif
#ifndef ABS
#define ABS(x)			(((x) < 0) ? (0 - (x)) : (x))
#endif

#define MAX_OBJECTS		12500
#define STRBUFLEN		384
#define OID_ELEMENTS		64

#define NUM_CLASSES		11
#define OBJ_agent		1
#define OBJ_internet		2
#define OBJ_network		3
#define	OBJ_subnet		4
#define OBJ_ipaddr		5
#define OBJ_site		6
#define	OBJ_processor		7
#define OBJ_interface		8
#define OBJ_equipment		9
#define OBJ_administrator	10
#define OBJ_module		11

/*\
 *  Default values for crucial HNMS parameters.
\*/
#define def_hnmsModuleHnmsHome			"./"
#define def_hnmsModuleHnmsCommunity		"public"
#define def_hnmsModuleServerSyncInterval	300
#define def_hnmsModuleServerCreateInterval	4
#define def_hnmsModuleServerAssignInterval	15
#define def_hnmsModuleRBIPCalcInterval		60
#define def_hnmsModuleIoAgentFilter		"0.0.0.0_0.0.0.0"
#define def_hnmsModuleIoDefSnmpCommunity	"public"
#define def_hnmsModuleIoNonresponsive		90
#define def_hnmsModuleIoUnreachable		105
#define def_hnmsModuleIoReachInterval		30
#define def_hnmsModuleIoDiscoverInterval	21600
#define def_hnmsModuleIoCacheCheckInterval	20
#define def_hnmsModuleIoRampTime		180
#define def_hnmsModuleHnmpWinSize		15000
#define def_hnmsModuleHnmpRetransInterval	150
#define def_hnmsModuleHnmpConnTimeout		180
#define def_hnmsModuleHnmpAckInterval		30

/*\
 *  HNMS module types.
\*/
#define MODULE_SERVER		1
#define MODULE_UI		2
#define MODULE_IO		3
#define MODULE_RBIP		4

/*\
 *  Values for the HNMS errno parameter.
\*/
#define HNMS_err_noerr			0
#define HNMS_err_alloc			1
#define HNMS_err_null_funcall		2
#define HNMS_err_file_not_found		3
#define HNMS_err_var_not_found		10
#define HNMS_err_type_not_found		11
#define HNMS_err_session_not_found	12
#define HNMS_err_bad_msg_type		20
#define HNMS_err_bad_msg_field		21
#define HNMS_err_sock_open		30
#define HNMS_err_sock_nbio		31
#define HNMS_err_sock_reuse		32
#define HNMS_err_sock_bcast		33
#define HNMS_err_sock_bind		34
#define HNMS_err_sock_select		35
#define HNMS_err_conn_exists		40
#define HNMS_err_sendto			41
#define HNMS_err_stream_too_long	42
#define HNMS_err_presentation_stream	43
#define HNMS_err_reuse_msg_id		44
#define HNMS_err_port_in_use		45
#define HNMS_err_conn_timeout		46
#define HNMS_err_msg_timeout		47
#define HNMS_err_window_full		48

/*\
 *  HNMS reachability status values.
\*/
#define STATUS_NOSTATUS		0
#define STATUS_REACHABLE	1
#define STATUS_NONRESPONSIVE	2
#define STATUS_UNREACHABLE	3
#define STATUS_UNKNOWN		4

/*\
 *  DEBUG flags.
\*/
#define DEBUG_ERRORS   	0x01
#define DEBUG_HNMP	0x02
#define DEBUG_SNMP	0x04
#define DEBUG_ICMP	0x08
#define DEBUG_OTHER	0x10
#define DEBUG_STANDARD	DEBUG_HNMP | DEBUG_SNMP | DEBUG_ERRORS | DEBUG_OTHER
#define DEBUG_ALL	DEBUG_STANDARD | DEBUG_ICMP
